/*
 * file.i.0.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <fcntl.h>
#include <unistd.h>

#include <file-defs.h>
#include <file-types.h>

#define file(file) \
    ((struct eifile_type *) (file))

extern const struct sffile_type _libx1f4_file_i_sffile;

int
_libx1f4i0_open_ifile(void *file, const char *path, unsigned bits,
		      unsigned mode)
{
    int fd, status;

    fd = open(path, bits, mode);
    if (fd == -1) {
	status = OPEN_CLASS;
    } else {
	int *ip;

	status = 0;

	ip = (void *) &file(file)->sd;

	*ip = fd;

	file(file)->size = 0;

	file(file)->sf = &_libx1f4_file_i_sffile;

#if 0
	/*
	 * Not really a bright idea, since without selecting the file
	 * descriptor the result will often be EAGAIN.
	 */
	if (1) {
	    int flags;

	    flags = fcntl(fd, F_GETFL);
	    if (flags ^ -1) {
		fcntl(fd, F_SETFL, flags | O_NONBLOCK);
	    }
	}
#endif				/* 0 */
    }

    return status;
}
