/*
 * file.d.l.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <stddef.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-inter.h>
#include <file-types.h>
#include <trans.h>

#define DONE_CLASS			144

#define true(e)				e

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct eifile_type *) (file))

#undef isodigit
#define isodigit(c) \
    (0x2f < (c) && (c) < 0x38)

#define C_TYPE_X(___c_type_x, ___c) \
    ((___c_type_x)[(___c) >> 5] & 1 << ((___c) & 31))

static int fast_deck(struct chance_type **, unsigned *, unsigned *, unsigned *,
		     unsigned, void *, struct trans_type *);
static int fast_slip(void **, unsigned, void *);
static int fast_tail(unsigned *, unsigned, void *);

static int
fast_deck(struct chance_type **deck, unsigned *fast, unsigned *slip,
	  unsigned *side, unsigned miss, void *data,
	  struct trans_type *trans_data)
{
    int status;
    void *line;

    status = trans_data->link
	(trans_data->data, &line, sizeof(struct chance_type) + miss);
    if (status) {
	status = LINK_CLASS;
    } else {
	struct chance_type *chance_data;

	chance_data = *deck;
	if (chance_data) {
	    chance_data->chance_data = line;
	}

	chance_data = line;

	*deck = chance_data;

	if (1) {
	    char *s, *t;
	    unsigned i;

	    s = data;
	    t = (void *) (chance_data + 1);

	    i = miss;
	    while (i) {
		int c;

		c = *(unsigned char *) s;
		if (c != 92) {
		    if (C_TYPE_X(side, c)) {
			status = DONE_CLASS;
			break;
		    } else {
			i--;
			s++;
			*t++ = c;
		    }
		} else {
		    i--;
		    if (i) {
		    } else {
			i = 1;
			if (1) {
			    break;
			}
		    }
		    i--;
		    s++;
		    c = *(unsigned char *) s;
		    s++;
		    if (isodigit(c)) {
			if (i) {
			    int e;

			    e = *(unsigned char *) s;
			    if (isodigit(e)) {
				i--;
				if (i) {
				    int o;

				    s++;
				    o = *(unsigned char *) s;
				    if (isodigit(o)) {
					i--;
					s++;
					*t++ = ((c - 0x30) << 6)
					    + ((e - 0x30) << 3) + (o - 0x30);
				    } else {
					*t++ = ((c - 0x30) << 3) + (e - 0x30);
				    }
				} else {
				    i = 3;
				    if (1) {
					break;
				    }
				}
			    } else {
				*t++ = c - 0x30;
			    }
			} else {
			    i = 2;
			    if (1) {
				 break;
			    }
			}
		    } else {
			switch (c) {
			case 0141:
			    *t++ = 7;
			    break;
			case 0142:
			    *t++ = 8;
			    break;
			case 0146:
			    *t++ = 12;
			    break;
			case 0156:
			    *t++ = 10;
			    break;
			case 0162:
			    *t++ = 13;
			    break;
			case 0164:
			    *t++ = 9;
			    break;
			case 0166:
			    *t++ = 11;
			    break;
			default:
			    if (1) {
				*t++ = c;
			    }
			}
		    }
		}
	    }

	    miss -= i;

	    *slip = miss;

	    miss = t - (char *) (chance_data + 1);

	    *fast += miss;

	    if (1) {
		chance_data->size = miss;
	    }
	}
    }

    return status;
}


static int
fast_slip(void **slip, unsigned tail, void *data)
{
    char *fast, *miss;

    miss = data;

    fast = *slip;

    if (tail == 2) {
	*fast = *(unsigned char *) (miss + 1) - 0x30;
    } else {
	if (true(tail == 3)) {
	    *fast = ((*(unsigned char *) (miss + 1) - 0x30) << 3)
		+ (*(unsigned char *) (miss + 2) - 0x30);
	}
    }

    *slip = fast + 1;

    return 0;
}


static int
fast_tail(unsigned *slip, unsigned tail, void *data)
{
    *slip = tail == 1 ? 0 : 1;

    return 0;
}


int
_libx1f4i0_fast_ifile(void *file, unsigned *side, void **line, unsigned *size,
		      struct trans_type *trans_data)
{
    int status;
    struct chance_type *chance_data = NULL, *chance_slip;
    unsigned ever, fast = 0, miss, tail = 0;

    do {
	int (*pull)(void *, void *, unsigned);
	void *sd;

	miss = file(file)->size;
	if (miss) {
	    unsigned slip;

	    ever = file(file)->ever;

	    status = fast_deck
		(&chance_data, &fast, &slip, side, miss, data(file, ever),
		 trans_data);

	    chance_slip = chance_data;

	    if (status) {
		if (status == DONE_CLASS) {
		    ever += slip;
		    miss -= slip;
		}

		break;
	    } else {
		miss -= slip;
		if (miss) {
		    memmove(file(file) + 1, data(file, ever + slip), miss);
		}

		ever = 0;
	    }
	} else {
	    ever = 0;

	    chance_slip = NULL;
	}

	pull = file(file)->sf->pull;

	sd = &file(file)->sd;

	while (1) {
	    if (0) {
	    } else {
		status = pull(sd, data(file, ever + miss), EVER_MAX - miss);
		if (status == -1) {
		    if (errno == EINTR) {
		    } else {
			status = READ_CLASS;
			if (1) {
			    break;
			}
		    }
		} else {
		    if (status) {
			if (0) {
			} else {
			    unsigned slip;

			    miss += status;

			    status = fast_deck
				(&chance_slip, &fast, &slip, side, miss,
				 data(file, ever), trans_data);
			    if (status) {
				if (status == DONE_CLASS) {
				    ever += slip;
				    miss -= slip;
				    if (chance_data) {
				    } else {
					chance_data = chance_slip;
				    }
				}

				break;
			    } else {
				if (chance_data) {
				} else {
				    chance_data = chance_slip;
				}

				miss -= slip;
				if (miss) {
				    memmove(file(file) + 1,
					    data(file, ever + slip), miss);
				}

				ever = 0;
			    }
			}
		    } else {
			if (fast | miss) {
			    tail = miss;

			    status = DONE_CLASS;
			} else {
			    status = OVER_CLASS;
			}
			if (1) {
			    break;
			}
		    }
		}
	    }
	}
    } while (0);

    if (chance_data) {
	chance_slip->chance_data = NULL;
    }

    if (status != DONE_CLASS) {
    } else {
	unsigned slip;
	void *data;

	if (tail) {
	    fast_tail(&slip, tail, data(file, ever));
	} else {
	    slip = 0;
	}

	status = trans_data->link(trans_data->data, &data, fast + slip + 1);
	if (status) {
	    status = LINK_CLASS;
	} else {
	    *size = fast + slip;

	    *line = data;

	    chance_slip = chance_data;
	    while (chance_slip) {
		unsigned size;

		size = chance_slip->size;
		memcpy(data, chance_slip + 1, size);
		chance_slip = chance_slip->chance_data;
		data = (char *) data + size;
	    }

	    if (slip) {
		fast_slip(&data, tail, data(file, ever));
	    }

	    *(char *) data = 0;

	    file(file)->ever = ever;
	    file(file)->size = miss - tail;
	}
    }

    if (chance_data) {
	int excess;

	excess = _libx1f4i0_miss_stand(chance_data, trans_data);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    return status;
}
