/*
 * file.d.d.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <errno.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>
#include <trans.h>

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct eifile_type *) (file))

#define C_TYPE_X(___c_type_x, ___c) \
    ((___c_type_x)[(___c) >> 5] & 1 << ((___c) & 31))

static int find_line(void *, unsigned, unsigned *, unsigned *);
static int slip_data(void *, unsigned, unsigned, unsigned, unsigned *);

static int
find_line(void *data, unsigned size, unsigned *side, unsigned *fast)
{
    char *line;

    line = data;

    do {
	unsigned c;

	c = *(unsigned char *) line;
	if (C_TYPE_X(side, c)) {
	    line++;
	    size--;
	} else {
	    break;
	}
    } while (size);

    *fast = line - (char *) data;

    return 0;
}


static int
slip_data(void *file, unsigned miss, unsigned ever, unsigned fast,
	  unsigned *size)
{
    if (0) {
    } else {
	*size = fast;

	file(file)->ever = ever + fast;
	file(file)->size = miss - fast;
    }

    return 0;
}


int
_libx1f4i0_side_ifile(void *file, unsigned *side, unsigned *size)
{
    int status;

    do {
	unsigned miss;

	miss = file(file)->size;
	if (miss) {
	    unsigned ever, fast;

	    ever = file(file)->ever;

	    find_line(data(file, ever), miss, side, &fast);
	    if (fast < miss) {
		status = slip_data(file, miss, ever, fast, size);

		break;
	    }
	}

	if (1) {
	    if (0) {
	    } else {
		int (*pull)(void *, void *, unsigned);
		void *sd;

		pull = file(file)->sf->pull;

		sd = &file(file)->sd;

		while (1) {
		    status = pull(sd, file(file) + 1, EVER_MAX);
		    if (status == -1) {
			if (errno == EINTR) {
			} else {
			    status = READ_CLASS;
			    if (1) {
				break;
			    }
			}
		    } else {
			if (status) {
			    unsigned ever, fast;

			    ever = status;

			    find_line(file(file) + 1, ever, side, &fast);
			    if (fast < ever) {
				miss += fast;

				*size = miss;

				ever -= fast;

				file(file)->ever = fast;
				file(file)->size = ever;

				status = 0;

				break;
			    } else {
				miss = miss + ever;
			    }
			} else {
			    *size = miss;

			    file(file)->size = 0;

			    if (miss) {
			    } else {
				status = OVER_CLASS;
			    }

			    break;
			}
		    }
		}
	    }
	}
    } while (0);

    return status;
}
