/*
 * file.d.c.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <errno.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>
#include <trans.h>

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct eifile_type *) (file))

#define C_TYPE_X(___c_type_x, ___c) \
    ((___c_type_x)[(___c) >> 5] & 1 << ((___c) & 31))

static int copy_data(void *, unsigned, unsigned, unsigned, void **, unsigned *,
		     struct trans_type *);
static int ever_data(void *, unsigned, unsigned, unsigned, void **, unsigned *,
		     struct trans_type *);
static int find_line(void *, unsigned, unsigned *);
static int pick_line(void *, unsigned, unsigned *);

static const unsigned c_type_1[] = {
/*
 *                   . .
 *
 * .
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000600, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_2[] = {
/*
 *                   .
 *
 * .
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000200, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

static int
copy_data(void *file, unsigned miss, unsigned ever, unsigned fast, void **line,
	  unsigned *size, struct trans_type *trans_data)
{
    int status;
    void *data;

    status = trans_data->link(trans_data->data, &data, fast + 1);
    if (status) {
	status = LINK_CLASS;
    } else {
	char *text;

	memcpy(data, data(file, ever), fast);
	text = data;
	text[fast] = 0;

	*size = fast;

	file(file)->ever = ever + fast;
	file(file)->size = miss - fast;

	*line = data;
    }

    return status;
}


static int
ever_data(void *file, unsigned miss, unsigned ever, unsigned fast, void **line,
	  unsigned *size, struct trans_type *trans_data)
{
    int status;

    do {
	if (miss) {
	    if (fast) {
	    } else {
		if (*data(file, ever + fast) == 10) {
		    status = HALF_CLASS;

		    fast++;

		    file(file)->ever = ever + fast;
		    file(file)->size = miss - fast;

		    break;
		}
	    }
	}

	status = copy_data(file, miss, ever, fast, line, size, trans_data);
    } while (0);

    return status;
}


static int
find_line(void *data, unsigned size, unsigned *fast)
{
    char *line;

    line = data;

    do {
	unsigned c;

	c = *(unsigned char *) line;
	if (C_TYPE_X(c_type_1, c)) {
	    break;
	} else {
	    line++;
	    size--;
	}
    } while (size);

    *fast = line - (char *) data;

    return 0;
}


static int
pick_line(void *data, unsigned size, unsigned *fast)
{
    char *line;

    line = data;

    do {
	unsigned c;

	c = *(unsigned char *) line;
	if (C_TYPE_X(c_type_2, c)) {
	    line++;
	    size--;
	} else {
	    break;
	}
    } while (size);

    *fast = line - (char *) data;

    return 0;
}


int
_libx1f4i0_word_ifile(void *file, void **line, unsigned *size,
		      struct trans_type *trans_data)
{
    int status;

    do {
	int (*pull)(void *, void *, unsigned);
	unsigned fast, miss;
	void *sd;

	miss = file(file)->size;
	if (miss) {
	    unsigned ever;

	    ever = file(file)->ever;

	    pick_line(data(file, ever), miss, &fast);
	    if (fast) {
		unsigned mind;

		mind = miss - fast;

		file(file)->ever = ever + fast;
		file(file)->size = mind;

		miss = mind;
	    }
	}

	if (miss) {
	    unsigned ever;

	    ever = file(file)->ever;

	    find_line(data(file, ever), miss, &fast);
	    if (fast < miss) {
		status = ever_data
		    (file, miss, ever, fast, line, size, trans_data);

		break;
	    } else {
		if (ever) {
		    memmove(file(file) + 1, data(file, ever), miss);
		}
	    }
	}

	pull = file(file)->sf->pull;

	sd = &file(file)->sd;

	if (miss < EVER_MAX) {
	    while (1) {
		status = pull(sd, data(file, miss), EVER_MAX - miss);
		if (status == -1) {
		    if (errno == EINTR) {
		    } else {
			status = READ_CLASS;
			if (1) {
			    break;
			}
		    }
		} else {
		    if (status) {
			unsigned ever, mind;

			if (miss) {
			} else {
			    pick_line(file(file) + 1, status, &fast);
			    if (1) {
				status -= fast;
				if (2) {
				    /*
				     * dubious solution...
				     */
				    memmove(file(file) + 1, data(file, fast),
					    status);
				}
			    }
			}

			ever = status;

			mind = miss;

			find_line(data(file, miss), ever, &fast);
			miss = miss + status;
			if (miss < EVER_MAX) {
			    if (fast < ever) {
				fast += mind;
				status = 0;
				if (1) {
				    break;
				}
			    }
			} else {
			    fast += mind;
			    status = 0;
			    if (1) {
				break;
			    }
			}
		    } else {
			if (miss) {
			    fast = miss;
			    status = 0;
			    if (1) {
				break;
			    }
			} else {
			    status = OVER_CLASS;
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }

	    if (status) {
		break;
	    }

	    if (fast < miss) {
		status = ever_data
		    (file, miss, 0, fast, line, size, trans_data);

		break;
	    } else {
		if (miss == EVER_MAX) {
		} else {
		    if (miss) {
			status = copy_data
			    (file, miss, 0, miss, line, size, trans_data);
		    } else {
			status = HALF_CLASS;

			file(file)->ever = 0;
			file(file)->size = 0;
		    }

		    break;
		}
	    }
	}

	if (1) {
	    void *data;

	    status = trans_data->link
		(trans_data->data, &data, (EVER_MAX << 1) + 1);
	    if (status) {
		status = LINK_CLASS;
	    } else {
		unsigned slip;

		slip = miss + EVER_MAX;

		while (1) {
		    unsigned call;

		    call = slip - miss;
		    if (EVER_MAX < call) {
			call = EVER_MAX;
		    }

		    status = pull(sd, (char *) data + miss, call);
		    if (status == -1) {
			if (errno == EINTR) {
			} else {
			    trans_data->free(trans_data->data, data);

			    status = READ_CLASS;

			    if (1) {
				break;
			    }
			}
		    } else {
			if (status) {
			    unsigned ever;

			    ever = status;

			    find_line((char *) data + miss, ever, &fast);
			    if (fast < ever) {
				char *text;

				memcpy(data, file(file) + 1, EVER_MAX);

				miss += fast;

				*line = data;
				*size = miss;

				text = (char *) data + miss;
				*text = 0;

				ever -= fast + 1;

				file(file)->ever = 0;
				file(file)->size = ever;

				memcpy(file(file) + 1, text + 1, ever);

				status = 0;

				break;
			    } else {
				miss = miss + ever;
			    }
			} else {
			    char *text;

			    memcpy(data, file(file) + 1, EVER_MAX);

			    *line = data;
			    *size = miss;

			    text = data;
			    text[miss] = 0;

			    file(file)->size = 0;

			    break;
			}
		    }

		    if (miss == slip) {
			slip <<= 1;

			status = trans_data->mode
			    (trans_data->data, &data, slip + 1);
			if (status) {
			    trans_data->free(trans_data->data, data);

			    status = MODE_CLASS;

			    break;
			}
		    }
		}
	    }
	}
    } while (0);

    return status;
}
