/*
 * file.d.b.c
 * Copyright (C) 2008, 2009, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct eifile_type *) (file))

int
_libx1f4i0_peek_ifile(void *file, int *peek)
{
    int status;

    do {
	int (*pull)(void *, void *, unsigned);
	unsigned miss;
	void *sd;

	miss = file(file)->size;
	if (miss) {
	    *peek = (int) *(unsigned char *) data(file, file(file)->ever);

	    status = 0;

	    break;
	}

	pull = file(file)->sf->pull;

	sd = &file(file)->sd;

	while (1) {
	    if (0) {
	    } else {
		status = pull(sd, file(file) + 1, EVER_MAX);
		if (status == -1) {
		    if (errno == EINTR) {
		    } else {
			status = READ_CLASS;
			if (1) {
			    break;
			}
		    }
		} else {
		    if (status) {
			if (0) {
			} else {
			    *peek = (int) *(unsigned char *) (file(file) + 1);

			    file(file)->size = status;

			    file(file)->ever = 0;

			    status = 0;

			    break;
			}
		    } else {
			status = OVER_CLASS;
			if (1) {
			    break;
			}
		    }
		}
	    }
	}
    } while (0);

    return status;
}
