/*
 * er.h
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_er_H__
#define __LIBx1f4_er_H__

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4.h>
#include <e42.h>
#if !defined HAVE_LIBx1f4i0
# include <float.v.h>
# include <integral.v-d.h>
# include <lintegral.v-d.h>
# include <ordinal.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define LINE_EEER(___t) \
    do {								      \
	int (*line) (void *), (*post) (void *),				      \
	    (*push) (void *, const char *, unsigned);			      \
	void *data;							      \
									      \
	data = (___t).data;						      \
									      \
	line = (___t).line;						      \
	if (line) {							      \
	    if (line(data)) {						      \
		break;							      \
	    }								      \
	}								      \
									      \
	post = (___t).post;						      \
									      \
	push = (___t).push;						      \
	if (push) {

#define POST_EEER() \
	}								      \
									      \
	if (post) {							      \
	    if (post(data)) {						      \
		break;							      \
	    }								      \
	}								      \
    } while (0)

#define PUSH_BILL(___c) \
    {									      \
	if (x1f4_vprint_dcardinal(data, push, (___c))) {		      \
	    break;							      \
	}								      \
    }

#define PUSH_BYTE(___b) \
    {									      \
	char ___c;							      \
									      \
	___c = (___b);							      \
	if (push(data, &___c, 1)) {					      \
	    break;							      \
	}								      \
    }

#define PUSH_DATA(___d, ___s) \
    {									      \
	if (push(data, (___d), (___s))) {				      \
	    break;							      \
	}								      \
    }

#define PUSH_LONG(___l) \
    {									      \
	if (x1f4_vprint_dlintegral(data, push, (___l))) {		      \
	    break;							      \
	}								      \
    }

#define PUSH_MODE(___m) \
    {									      \
	if (x1f4_vprint_dintegral(data, push, (___m))) {		      \
	    break;							      \
	}								      \
    }

#define PUSH_RANK(___c) \
    {									      \
	char ___m[2];							      \
									      \
	x1f4_extend_ordinal(___m, (___c));				      \
	if (push(data, ___m, 2)) {					      \
	    break;							      \
	}								      \
    }

#define PUSH_REAL(___p, ___x) \
    {									      \
	if (x1f4_vprint_float(data, push, (___p), (___x))) {		      \
	    break;							      \
	}								      \
    }

#define PUSH_SUB3(___s, ___a, ___b, ___c) \
    {									      \
	if ((___s)(data, push, (___a), (___b), (___c))) {		      \
	    break;							      \
	}								      \
    }

#define PUSH_TEXT(___s) \
    {									      \
	const char *___S;						      \
									      \
	___S = (___s);							      \
	if (push(data, ___S, strlen(___S))) {				      \
	    break;							      \
	}								      \
    }

#define PUSH_TRAP(___t, ___l) \
    PUSH_TYPE((___t), (___l)->trap_e.eelookup_data)

#define PUSH_TYPE(___t, ___e) \
    {									      \
	if (x1f4_dump_type(data, push, (___t), (___e))) {		      \
	    break;							      \
	}								      \
    }

#endif				/* __LIBx1f4_er_H__ */
