/*
 * e4ll-types.h
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4ll_types_H__
#define __LIBx1f4_e4ll_types_H__

#include <e4line.h>

typedef struct e4less_type {
    struct {
	int (*deck) (void **), (*fini) (void **, void *),
	    (*free) (void *, void *), (*init) (void **, void *, int),
	    (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *)),
	    (*swap) (void *, void *);
	void *data;
    } link_a;
    struct {
	void *node;
    } link_c;
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} e4less_type;

typedef struct e4node_type {
    struct e4node_type *e4node_data;
    void *link;
} e4node_type;

typedef struct screen_type {
    struct x1f4_e4line_type link_a;
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} screen_type;

#endif				/* __LIBx1f4_e4ll_types_H__ */
