/*
 * e4less.h
 * Copyright (C) 2010, 2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4less_H__
#define __LIBx1f4_e4less_H__

#include <e4line.h>

/*
 * error definitions
 */
#define X1f4_E4LL_DECK_ERROR		-1
#define X1f4_E4LL_FINI_ERROR		-2
#define X1f4_E4LL_FREE_ERROR		-3
#define X1f4_E4LL_INIT_ERROR		-4
#define X1f4_E4LL_LINK_ERROR		-5
#define X1f4_E4LL_MODE_ERROR		-6
#define X1f4_E4LL_SWAP_ERROR		-7

/*
 * generation flag definitions
 */
#define X1f4_E4LL_MISSLINK		(1L << 0)
#define X1f4_E4LL_RESOURCE		(1L << 1)
#define X1f4_E4LL_TEXTFLAT		(1L << 2)

typedef struct x1f4_e4less_type {
    struct x1f4_e4line_type misslink_set;
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
} x1f4_e4less_type;

#if !defined __x1f4_frame_type_defined__
typedef struct x1f4_frame_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned),
	(*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	(*slip) (void *, void *, void *, int (*) (void *));
    void *data;
} x1f4_frame_type;
#endif				/* !__x1f4_frame_type_defined__ */

#if !defined __x1f4_frame_type_defined__
# define __x1f4_frame_type_defined__
#endif				/* !__x1f4_frame_type_defined__ */

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *data;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

extern int x1f4_copy_e4ll(void *, struct x1f4_frame_type *);
extern int x1f4_deck_e4ll(void *, void **, int (**) (void **));
extern int x1f4_fast_e4ll(void *, void **);
extern int x1f4_fini_e4ll(void **);
extern int x1f4_init_e4ll(void **, unsigned, struct x1f4_e4less_type *);
extern int x1f4_line_e4ll(void *, struct x1f4_trans_type *);
extern int x1f4_link_e4lf(void *, void **, unsigned);
extern int x1f4_lock_e4ll(void *);
extern int x1f4_pick_e4lf
    (void *, void ***, int (*) (void *), unsigned, void **);
extern int x1f4_pipe_e4ll(void *, void *);
extern int x1f4_push_e4ll(void *);

#endif				/* __LIBx1f4_e4less_H__ */
