/*
 * e4jack.u.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4jack-errors.h>
#include <e4jack-types.h>

#define dump_abcdef_error_l_ARGS_0 \
    void *, int (*) (void *, const char *, unsigned), struct ej_back_type *
#define dump_abcdef_error_l_ARGS_1 \
    void *data, int (*this) (void *, const char *, unsigned),		      \
    struct ej_back_type *back_data
#define dump_abcdef_error_l_ARGS_2 \
    data, this, back_data

static int dump_111223_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_111223_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_111223_error_2(dump_abcdef_error_l_ARGS_0);
static int dump_111223_error_3(dump_abcdef_error_l_ARGS_0);
static int dump_111224_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_111224_error_3(dump_abcdef_error_l_ARGS_0);

static int
dump_111223_error_0(dump_abcdef_error_l_ARGS_1)
{
    return this
	(data, "missing `*' after opening parenthesis in assumed function po"
	 "inter declaration", 77);
}


static int
dump_111223_error_1(dump_abcdef_error_l_ARGS_1)
{
    return this
	(data, "missing closing parenthesis (`)') on function pointer", 53);
}


static int
dump_111223_error_2(dump_abcdef_error_l_ARGS_1)
{
    return this
	(data, "missing function pointer parameters list leading parenthesis"
	 " ('(')", 66);
}


static int
dump_111223_error_3(dump_abcdef_error_l_ARGS_1)
{
    return this
	(data, "missing function pointer parameters list closing parenthesis"
	 " (')')", 66);
}


static int
dump_111224_error_1(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this
	(data, "bad parameter type in function pointer declaration (`", 53);
    if (status) {
    } else {
	status = this
	    (data, back_data->data.misstype.name,
	     back_data->data.misstype.size);
	if (status) {
	} else {
	    status = this(data, "')", 2);
	}
    }

    return status;
}


static int
dump_111224_error_3(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "reference declaration", 21);
}


int
x1f4_stat_e4jack(void *data, int (*this) (void *, const char *, unsigned),
		 struct ej_back_type *back_data)
{
    int status;

    switch (back_data->code) {
    case LINKNODE:
	status = dump_111224_error_3(data, this, back_data);
	break;
    case MISSLEAD:
	status = dump_111223_error_2(data, this, back_data);
	break;
    case MISSLINK:
	status = dump_111223_error_3(data, this, back_data);
	break;
    case MISSPAIR:
	status = dump_111223_error_1(data, this, back_data);
	break;
    case MISSSTAR:
	status = dump_111223_error_0(data, this, back_data);
	break;
    default:
	status = dump_111224_error_1(data, this, back_data);
    }

    return status;
}
