/*
 * e4fine.3.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <e4fine-types.h>
#include <tcline.h>

#define e4fine(e4fine)			((struct e4fine_type *) (e4fine))

int
x1f4_pick_e4fine(const void *e4fine, int type,
		 const struct x1f4_linetext_type **linetext)
{
    int status;
    void *data;

    status = x1f4_find_tcfine(e4fine(e4fine)->link_a.fine, type, 0, &data);
    if (status) {
	*linetext = *(void **) ((char *) data + sizeof(unsigned));
    }

    return status;
}
