/*
 * e42nd.z.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-config.h>

#include <stddef.h>

#include <e4-byte.h>
#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-line.h>
#include <e4-slip.h>
#include <e4-types.h>
#include <exerrors.h>

#define SUB_BITS \
    ((1 << LAST) | (1 << LOCK) | (1 << PICK) | (1 << THIS))

#undef break_a2_call

#define break_a2_call(odbx_data, context, output, input, status, i, \
		      __this_break__)					      \
    if (odbx_data == _x1f4_e4_pick) {					      \
	struct e4_post_type *fast_post, *slip_post;			      \
									      \
	fast_post = (void *) (output);					      \
	slip_post = (input)[1];						      \
	fast_post->data = slip_post->data;				      \
    } else {								      \
	break_a2_near((odbx_data), (context), (output), (input), (status),    \
		      (i), __this_break__);				      \
    }

extern const struct e4_odbx_type _x1f4_e4_pick[];

static int deck_last(struct e4_atom_type *, struct e4_post_type *, void **,
		     void **);
static int slip_last(struct e4_atom_type *, struct e4_post_type *, void **,
		     struct e4_call_type *, void **);

static int
deck_last(struct e4_atom_type *atom_data, struct e4_post_type *post_data,
	  void **list, void **used)
{
    int status;

    do {
	const struct e4_last_type *last_data;
	void *text;

	if (atom_data->type == LAST) {
	    struct e4_base_type *base_data;

	    base_data = last_base(atom_data);

	    last_data = base_data->last_data;

	    text = base_data->text;
	} else {
	    const struct e4_line_type *line_data;

	    if (atom_data->type == PICK) {
		line_data = *(void **) &(post_data - 1)->data;
	    } else {
		struct e4_fine_type *fine_data;
		unsigned bits;

		fine_data = lock_fine(atom_data);

		bits = fine_data->ever_data->bits;

		line_data = (void *) fine_data->line;

		if (bits & UNIVERSAL) {
		    line_data = (void *)
			((char *) used + (integral_q) line_data);
		}

		if (bits & REFERENCE) {
		    line_data = *(void **) line_data;
		} else {
		}

		line_data = *(void **) line_data;
	    }

	    last_data = &line_data->last;

	    text = (void *) line_data->text;

	    if (last_data->bits & (SIDE_LIST | SLIP_LIST)) {
		struct e4_last_type *last_text;
		void *near;

		last_text = (void *) last_base(atom_data)->last_data;

		near = used[USED_META];

		status = last_data->last(text, last_text, &near);
		if (status) {
		    break;
		} else {
#if 0
		    last_text->bits &= ~TEXT_LINK;
		    last_text->bits |= last_data->bits & TEXT_LINK;
#endif				/* 0 */
		    text = near;
		    last_data = last_text;
		}
	    }
	}

	status = last_data->last(text, &post_data->data, list);

	if (status) {
	} else {
	    flat_record(post_data);
	}
    } while (0);

    return status;
}


static int
slip_last(struct e4_atom_type *atom_data, struct e4_post_type *post_data,
	  void **list, struct e4_call_type *call_data, void **used)
{
    int status = 0;

    if (atom_data->type == LAST) {
	struct e4_base_type *base_data;
	const struct e4_last_type *last_data;

	base_data = last_base(atom_data);

	last_data = base_data->last_data;

	call_data->input = list;

	call_data->last_data = last_data;

	call_data->output = &post_data->data;

	if (last_data->bits & TEXT_LINK) {
	    call_data->context = base_data->text;
	}
    } else {
	do {
	    const struct e4_last_type *last_data;
	    const struct e4_line_type *line_data;

	    if (atom_data->type == LOCK) {
		struct e4_fine_type *fine_data;
		unsigned bits;

		fine_data = lock_fine(atom_data);

		bits = fine_data->ever_data->bits;

		line_data = (void *) fine_data->line;

		if (bits & UNIVERSAL) {
		    line_data = (void *)
			((char *) used + (integral_q) line_data);
		}

		if (bits & REFERENCE) {
		    line_data = *(void **) line_data;
		} else {
		}

		line_data = *(void **) line_data;
	    } else {
		line_data = *(void **) &(post_data - 1)->data;
	    }

	    last_data = &line_data->last;

	    call_data->input = list;

	    call_data->last_data = last_data;

	    call_data->output = &post_data->data;

	    if (last_data->bits & TEXT_LINK) {
		call_data->context = (void *) line_data->text;
	    }

	    if (last_data->bits & (SIDE_LIST | SLIP_LIST)) {
		struct e4_last_type *last_text;
		void *near;

		last_text = (void *) last_base(atom_data)->last_data;

		near = used[USED_META];

		status = last_data->last
		    ((void *) line_data->text, last_text, &near);
		if (status) {
		} else {
		    call_data->last_data = last_text;
		    call_data->context = near;
		    last_text->bits &= ~TEXT_LINK;
		    last_text->bits |= last_data->bits & TEXT_LINK;
		}
	    }
	} while (0);
    }

    return status;
}


int
x1f4_span_expression(struct e4_expression_type *expression_data,
		     struct e4_slip_type *slip_data, unsigned clear,
		     int *away, void *post, struct e4_call_type *call_data,
		     void **used)
{
    int fast = 0, fine, status = 0;
    struct e4_atom_type *atom_data;
    struct e4_post_type *post_data;
    unsigned count;
    void **list;

    list = slip_data->list;

    count = slip_data->count;

    post_data = slip_data->post_data;

    atom_data = slip_data->atom_data;

    if (slip_data->fast) {
	flat_record(post_data);

	count++;

	fine = 1;
    } else {
	fine = 0;
    }

    while (1) {
	int less, type;

	if (count) {
	    count--;
	} else {
	    struct e4_deck_type *deck_data;

	    deck_data = slip_data->deck_data;
	    if (deck_data) {
		unsigned class;

		class = deck_data->class;
		if (class) {
		    struct e4_hack_type *hack_data;

		    deck_data->class = class - 1;

		    hack_data = deck_data->hack_data;

		    deck_data->hack_data = hack_data + 1;

		    post_data = deck_data->post_data + 1;

		    deck_data->post_data = post_data;

		    atom_data = hack_data->atoms;

		    count = hack_data->count - 1;

		    *list++ = &post_data->data;

		    if (1) {
			int bits, (*load) (x1f4_e4_LOAD_ARGS_0);
			const int *miss;

			load = _x1f4_e4_load_THIS;

			miss = deck_data->miss;
			if (miss) {
			    bits = *miss;
			    deck_data->miss = miss + 1;
			} else {
			    bits = 0;
			}

			_x1f4_e4_fast_miss(hack_data, bits, &load);

			if (load == _x1f4_e4_load_THIS) {
			} else {
			    void *slip;

			    slip = used[USED_LIST];
			    used[USED_LIST] = list;

			    status = load(hack_data, post_data, used);

			    used[USED_LIST] = slip;

			    if (status) {
				break;
			    } else {
				count = 0;
				if (1) {
				    continue;
				}
			    }
			}
		    }
		} else {
		    struct e4_deck_type *post_deck;

		    atom_data = deck_data->atom_data;

		    post_data = deck_data->deck_post;

		    list = deck_data->list;

		    if (deck_data->fine) {
			fine = 1;

			count = deck_data->count + 1;
		    } else {
			if (clear) {
			    clear--;

			    status =
				deck_last(atom_data, post_data, list, used);
			    if (status) {
				break;
			    } else {
				fine = 1;

				count = deck_data->count + 1;
			    }
			} else {
			    fast = 1;

			    status = slip_last
				(atom_data, post_data, list, call_data, used);
			    if (status) {
				break;
			    } else {
				slip_data->fast = 1;

				slip_data->list = list - 1;

				slip_data->post_data = post_data;

				slip_data->count = deck_data->count;

				slip_data->atom_data = atom_data;
			    }
			}
		    }

		    post_deck = deck_data->deck_data;

		    status = expression_data->m.free
			(expression_data->m.data, deck_data);
		    if (status) {
			status = X1f4_EX_CRITICAL;
			if (1) {
			    break;
			}
		    }

		    slip_data->deck_data = post_deck;

		    if (fast) {
			break;
		    } else {
			if (count) {
			    count--;
			} else {
			    if (1) {
				continue;
			    }
			}
		    }
		}
	    } else {
		break;
	    }
	}

	if (fine) {
	    less = 1;
	} else {
	    type = atom_data->type;
	    less = !(1 << type & SUB_BITS);
	}

	if (less) {
	    if (fine) {
		fine = 0;
	    } else {
		status = atom_data->load(atom_data, post_data, used);
		if (status) {
		    break;
		}
	    }

	    break_a1(atom_data, post_data, status, NULL);
	    break_a2(atom_data, post_data, count, status, NULL);

	    atom_data++;

	    post_data++;
	} else {
	    void *deck;

	    status = expression_data->m.link
		(expression_data->m.data, &deck, sizeof(struct e4_deck_type));
	    if (status) {
		status = X1f4_EX_CRITICAL;
		if (1) {
		    break;
		}
	    } else {
		struct e4_deck_type *deck_data;

		deck_data = deck;

		if (1) {
		    deck_data->count = count;

		    deck_data->atom_data = atom_data;

		    deck_data->deck_post = post_data;

		    deck_data->post_data = post_data;

		    deck_data->deck_data = slip_data->deck_data;

		    slip_data->deck_data = deck_data;
		}

		if (type == THIS) {
		    struct e4_hack_type *hack_data;

		    hack_data = atom_data->data.hack.data;

		    atom_data = hack_data->atoms;

		    count = hack_data->count;

		    deck_data->class = 0;

		    deck_data->fine = ~0;

		    deck_data->list = list;
		} else {
		    struct e4_base_type *base_data;
		    const struct e4_last_type *last_data;
		    unsigned class;

		    base_data = last_base(atom_data);

		    last_data = base_data->last_data;

		    class = last_data->count;

		    deck_data->hack_data = atom_data->data.last.base;

		    count = 0;

		    deck_data->fine = 0;

		    *list++ = used;
		    deck_data->list = list;
		    slip_data->list = list;

		    deck_data->class = class;

		    if (last_data->bits & POST_TYPE) {
			deck_data->miss = last_data->args + class;
		    } else {
			deck_data->miss = NULL;
		    }
		}
	    }
	}
    }

    if (status) {
    } else {
	*away = fast;

	if (fast) {
	} else {
#if __COPY_E4_POST__
	    unsigned fast;
#endif				/* __COPY_E4_POST__ */

	    /*
	     * post_data assumed now to indicate the second position
	     */
	    post_data--;

#if __COPY_E4_POST__
	    fast = expression_data->fast;
#endif				/* __COPY_E4_POST__ */

#if __LINE_E4_POST__
	    expression_data->post(post, post_data);
#endif				/* __LINE_E4_POST__ */

#if __COPY_E4_POST__
	    if (fast) {
		C_FAST *source, *target;

		source = text_record(post_data);
		target = post;

		*target = *source;
		fast--;
		while (fast) {
		    target++;
		    source++;
		    *target = *source;
		    fast--;
		}
	    }
#endif				/* __COPY_E4_POST__ */
	}
    }

    return status;
}
