/*
 * e42nd.y.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-inter.h>

static const struct e4_line_type line = {
/* *INDENT-OFF* */
    {
	"",
	NULL,
	VOID,
	NULL,
	0,
	0,
	0
    },
    NULL
/* *INDENT-ON* */
};

int
_x1f4_e4_flat_news(void *subtext, void **address)
{
    int status;

    /*
     * NOTES
     *
     * this isn't doing what other -flat- methods are doing, it should not be
     * called as any -flat- method is called.  it isn't restoring -*address-
     * to a proper value.
     */

    if (0) {
    } else {
	status = _x1f4_e4_side_news
	    (subtext, (char *) *address - offsetof(struct e4_news_type, line));
	if (0) {
	} else {
	    /*
	     * at the very least, _side_news attempted to destroy the object
	     */
	    *address = (void *) &line;
	}
    }

    return status;
}
