/*
 * e42nd.w.c
 * Copyright (C) 2006-2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-byte.h>
#include <e4-defs.h>
#include <e4-line.h>
#include <e4-types.h>

int
x1f4_fast_expression(struct e4_expression_type *expression_data, void *miss,
		     void *post)
{
    if (1) {
#if __COPY_E4_POST__
	unsigned fast;
#endif				/* __COPY_E4_POST__ */

#if __COPY_E4_POST__
	fast = expression_data->fast;
#endif				/* __COPY_E4_POST__ */

#if __LINE_E4_POST__
	expression_data->post(post, miss);
#endif				/* __LINE_E4_POST__ */

#if __COPY_E4_POST__
	if (fast) {
	    C_FAST *source, *target;

	    source = text_record((struct e4_post_type *) miss);
	    target = post;

	    *target = *source;
	    fast--;
	    while (fast) {
		target++;
		source++;
		*target = *source;
		fast--;
	    }
	}
#endif				/* __COPY_E4_POST__ */
    }

    return 0;
}
