/*
 * e42nd.p.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-defs.h>
#include <e4-types.h>
#include <exerrors.h>

int
x1f4_land_expression(struct e4_expression_type *expression_data, void *post,
		     void **slip)
{
    int status;
    void *data;

    status = expression_data->m.link
	(expression_data->m.data, &data, sizeof(struct e4_slip_type));
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	struct e4_slip_type *slip_data;

	*slip = data;

	slip_data = data;

	slip_data->fast = 0;

	slip_data->deck_data = NULL;

	slip_data->list = (void *)
	    ((struct e4_post_type *) post + expression_data->post_size);

	slip_data->post_data = post;

	slip_data->count = expression_data->hack_data.count;

	slip_data->atom_data = expression_data->hack_data.atoms;
    }

    return status;
}
