/*
 * e42nd.0.c
 * Copyright (C) 2006-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>

#define EXPRESSION(expression) \
    ((e4_expression_type *) expression)

#define E_FREE(mcontext, mdata) \
    (EXPRESSION(mcontext)->m.free(EXPRESSION(mcontext)->m.data, (mdata)))

#define M_FREE(mcontext, mdata) \
    (mcontext)->m.free((mcontext)->m.data, (mdata))

#define LOGIC_BITS \
    ((1 << LAST) | (1 << LOCK) | (1 << PICK))

static void free_last(struct e4_hack_type *, unsigned, void *);
static void free_odb1(struct e4_odb1_type *, void *);
static void free_odb2(struct e4_odb2_type *, void *);
static void free_odbx(struct e4_hack_type *, void *);

static void
free_last(struct e4_hack_type *hack_data, unsigned count, void *expression)
{
    for (; count; count--) {
	_x1f4_e4_free_hack(hack_data, expression);
	hack_data++;
    }
}


static void
free_odb1(struct e4_odb1_type *odb1_data, void *expression)
{
    while (odb1_data) {
	struct e4_odb1_type *free_odb1;

	free_odb1 = odb1_data;
	odb1_data = odb1_data->odb1_data;
	E_FREE(expression, free_odb1);
    }
}


static void
free_odb2(struct e4_odb2_type *odb2_data, void *expression)
{
    while (odb2_data) {
	struct e4_odb2_type *free_odb2;

	free_odb2 = odb2_data;
	odb2_data = odb2_data->odb2_data;
	E_FREE(expression, free_odb2);
    }
}


static void
free_odbx(struct e4_hack_type *hack_data, void *expression)
{
    struct e4_atom_type *atom_data;
    unsigned i;

    atom_data = hack_data->atoms;
    i = hack_data->count;
    for (; i; i--) {
	_x1f4_e4_free_odbx(atom_data, expression);
	atom_data++;
    }
}


void
_x1f4_e4_free_atom(struct e4_atom_type *atom_data, void *expression)
{
    int type;

    free_odb1(atom_data->odb1, expression);

    type = atom_data->type;
    if (1 << type & LOGIC_BITS) {
	struct e4_hack_type *hack_data;

	hack_data = atom_data->data.last.base;

	free_last
	    (hack_data, hack_base(hack_data)->last_data->count, expression);

	if (type == LAST) {
	    E_FREE(expression, hack_base(hack_data));
	} else {
	    if (type == LOCK) {
		E_FREE(expression, hack_fine(hack_data));
	    } else {
		E_FREE(expression, hack_near(hack_data));
	    }
	}
    } else {
	if (type == TEXT) {
	    E_FREE(expression, *(C_TEXT *) &atom_data->data.lead.data);
	} else {
	    if (type == THIS) {
		struct e4_hack_type *hack_data;

		hack_data = atom_data->data.hack.data;
		_x1f4_e4_free_hack(hack_data, expression);
		E_FREE(expression, hack_data);
	    }
	}
    }
}


void
_x1f4_e4_free_hack(struct e4_hack_type *hack_data, void *expression)
{
    struct e4_atom_type *atom_data;

    atom_data = hack_data->atoms;
    if (atom_data) {
	unsigned i;

	i = hack_data->count;
	for (; i; i--) {
	    _x1f4_e4_free_atom(atom_data, expression);
	    atom_data++;
	}

	E_FREE(expression, hack_data->atoms);
    }
}


void
_x1f4_e4_free_odbx(struct e4_atom_type *atom_data, void *expression)
{
    int type;

    free_odb2(atom_data->odb2._2nd, expression);

    type = atom_data->type;
    if (1 << type & LOGIC_BITS) {
	struct e4_hack_type *hack_data;
	unsigned j;

	hack_data = atom_data->data.last.base;
	j = hack_base(hack_data)->last_data->count;
	for (; j; j--) {
	    free_odbx(hack_data, expression);
	    hack_data++;
	}
    } else {
	if (type == THIS) {
	    free_odbx(atom_data->data.hack.data, expression);
	}
    }
}


int
x1f4_fini_expression(struct e4_expression_type **expression)
{
    struct e4_expression_type *expression_data;

    expression_data = *expression;

    if (expression_data->state) {
	if (expression_data->bits & EXTERN_STACKS_MESS) {
	} else {
	    if (expression_data->list) {
		M_FREE(expression_data, expression_data->list);
	    }
	    if (expression_data->post_data) {
		M_FREE(expression_data, expression_data->post_data);
	    }
	}

	free_odbx(&expression_data->hack_data, expression_data);
    }

    _x1f4_e4_free_hack(&expression_data->hack_data, expression_data);

    if (1) {
	struct e4_flat_type *flat_text;

	flat_text = expression_data->flat_data;
	while (flat_text) {
	    struct e4_flat_type *flat_data;

	    flat_data = flat_text;
	    flat_text = flat_data->flat_data;
	    do {
		if (flat_data->read == NEWS_FLAT) {
		    struct e4_ever_type *ever_miss;
		    struct e4_news_type *news_data;
		    unsigned call;

		    ever_miss = (void *) (flat_data + 1);
		    news_data = (void *) (ever_miss + 1);
		    call = news_data->call;
		    call--;
		    if (call) {
			news_data->call = call;
			if (1) {
			    break;
			}
		    }
		}

		M_FREE(expression_data, flat_data);
	    } while (0);
	}
    }

    E_FREE(expression_data, expression_data);

    return 0;
}
