/*
 * e4.z.c
 * Copyright (C) 2010-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-inter.h>
#include <e4-line.h>
#include <e4-types.h>
#include <exerrors.h>

int
_x1f4_e4_load_lock(x1f4_e4_LOAD_ARGS_1)
{
    int status = 0;

    do {
	struct e4_atom_type *atom_data;
	struct e4_fine_type *fine_data;
	const struct e4_last_type *last_data;
	const struct e4_line_type *line_data;
	unsigned bits;

	atom_data = level;

	fine_data = lock_fine(atom_data);

	bits = fine_data->ever_data->bits;

	line_data = (void *) fine_data->line;

	if (bits & UNIVERSAL) {
	    line_data = (void *) ((char *) used + (integral_q) line_data);
	}

	if (bits & REFERENCE) {
	    line_data = *(void **) line_data;
	} else {
	}

	line_data = *(void **) line_data;

	last_data = &line_data->last;
	if (last_data->last) {
	    struct e4_hack_type *hack_data;
	    unsigned count;
	    void **list, *text;

	    text = (void *) line_data->text;

	    hack_data = ((struct e4_atom_type *) level)->data.last.base;

	    if (last_data->bits & (SIDE_LIST | SLIP_LIST)) {
		struct e4_last_type *last_text;
		void *near;

		last_text = (void *) hack_base(hack_data)->last_data;

		near = text;
		text = used[USED_META];

		status = last_data->last(near, last_text, &text);
		if (status) {
		    break;
		} else {
#if 0
		    last_text->bits &= ~TEXT_LINK;
		    last_text->bits |= last_data->bits & TEXT_LINK;
#endif				/* 0 */
		    last_data = last_text;
		}
	    }

	    list = used[USED_LIST];

	    *list++ = used;

	    {
		int (**post) (x1f4_e4_LOAD_ARGS_0);
		struct e4_post_type *state_clip;
		unsigned j;

		count = last_data->count;
		post = (int (**) (x1f4_e4_LOAD_ARGS_0)) (hack_data + count);
		state_clip = post_data + 1;
		for (j = count; j; j--) {
		    *list++ = &state_clip->data;
		    used[USED_LIST] = list;
		    status = post[0](hack_data, state_clip, used);
		    if (status) {
			break;
		    } else {
			state_clip++;
			hack_data++;
			post++;
		    }
		}
	    }
	    if (status) {
	    } else {
		list -= count;
		status = last_data->last(text, &post_data->data, list);
		if (status) {
		} else {
		    flat_record(post_data);
		}
	    }

	    used[USED_LIST] = list - 1;
	} else {
	    status = X1f4_EX_CAN_CONTINUE;
	}
    } while (0);

    return status;
}
