/*
 * e4.r.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-byte.h>
#include <e4-defs.h>
#include <e4-line.h>
#include <e4-types.h>

int
x1f4_case_expression(struct e4_expression_type *expression_data, int *post)
{
    int status;
    struct e4_post_type *post_data;
    void *used[USED_SIZE];

    post_data = expression_data->post_data;

    used[USED_LIST] = expression_data->list;

    status = expression_data->load
	(&expression_data->hack_data, post_data, used);
    if (status) {
    } else {
	int type;

	type = expression_data->type;
	if (type == BILL) {
#if __COPY_E4_POST__
	    C_BILL *mode;
#endif				/* __COPY_E4_POST__ */
#if __LINE_E4_POST__
	    C_BILL class;
#endif				/* __LINE_E4_POST__ */

#if __LINE_E4_POST__
	    expression_data->post(&class, post_data);
#endif				/* __LINE_E4_POST__ */

#if __LINE_E4_POST__
	    *post = class ? 1 : 0;
#endif				/* __LINE_E4_POST__ */

#if __COPY_E4_POST__
	    mode = text_record(post_data);
	    if (*mode) {
		*post = 1;
	    } else {
		*post = 0;
	    }
#endif				/* __COPY_E4_POST__ */
	} else {
	    if (type == MODE) {
#if __COPY_E4_POST__
		C_MODE *mode;
#endif				/* __COPY_E4_POST__ */
#if __LINE_E4_POST__
		C_MODE class;
#endif				/* __LINE_E4_POST__ */

#if __LINE_E4_POST__
		expression_data->post(&class, post_data);
#endif				/* __LINE_E4_POST__ */

#if __LINE_E4_POST__
		*post = class ? 1 : 0;
#endif				/* __LINE_E4_POST__ */

#if __COPY_E4_POST__
		mode = text_record(post_data);
		if (*mode) {
		    *post = 1;
		} else {
		    *post = 0;
		}
#endif				/* __COPY_E4_POST__ */
	    } else {
		if (type == REAL) {
#if __COPY_E4_POST__
		    C_REAL *real;
#endif				/* __COPY_E4_POST__ */
#if __LINE_E4_POST__
		    C_REAL class;
#endif				/* __LINE_E4_POST__ */

#if __LINE_E4_POST__
		    expression_data->post(&class, post_data);
#endif				/* __LINE_E4_POST__ */

#if __LINE_E4_POST__
		    *post = class ? 1 : 0;
#endif				/* __LINE_E4_POST__ */

#if __COPY_E4_POST__
		    real = text_record(post_data);
		    if (*real) {
			*post = 1;
		    } else {
			*post = 0;
		    }
#endif				/* __COPY_E4_POST__ */
		} else {
		    *post = 1;
		}
	    }
	}
    }

    return status;
}
