/*
 * e4.o.c
 * Copyright (C) 2006-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-defs.h>
#include <e4-line.h>
#include <e4-types.h>
#include <exerrors.h>

#define state(___l) \
    ((struct e4_atom_type *) (___l))->data.ever.state

int
_x1f4_e4_load_Bill(x1f4_e4_LOAD_ARGS_1)
{
    C_BILL *state;

    state = (C_BILL *) &post_data->data;
    *state = *(C_BILL *) *(void **) state(level);
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_Mode(x1f4_e4_LOAD_ARGS_1)
{
    C_MODE *state;

    state = (C_MODE *) &post_data->data;
    *state = *(C_MODE *) *(void **) state(level);
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_Next(x1f4_e4_LOAD_ARGS_1)
{
    C_TEXT *state;

    state = (C_TEXT *) &post_data->data;
    *state = *(C_TEXT *) *(void **)
	((char *) used + (integral_q) state(level));
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_Node(x1f4_e4_LOAD_ARGS_1)
{
    C_MODE *state;

    state = (C_MODE *) &post_data->data;
    *state = *(C_MODE *) *(void **)
	((char *) used + (integral_q) state(level));
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_Over(x1f4_e4_LOAD_ARGS_1)
{
    C_USER *state;

    state = (C_USER *) &post_data->data;
    *state = *(C_USER *) *(void **)
	((char *) used + (integral_q) state(level));
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_Real(x1f4_e4_LOAD_ARGS_1)
{
    C_REAL *state;

    state = (C_REAL *) &post_data->data;
    *state = *(C_REAL *) *(void **) state(level);
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_Teal(x1f4_e4_LOAD_ARGS_1)
{
    C_REAL *state;

    state = (C_REAL *) &post_data->data;
    *state = *(C_REAL *) *(void **)
	((char *) used + (integral_q) state(level));
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_Text(x1f4_e4_LOAD_ARGS_1)
{
    C_TEXT *state;

    state = (C_TEXT *) &post_data->data;
    *state = *(C_TEXT *) *(void **) state(level);
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_User(x1f4_e4_LOAD_ARGS_1)
{
    C_USER *state;

    state = (C_USER *) &post_data->data;
    *state = *(C_USER *) *(void **) state(level);
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_Will(x1f4_e4_LOAD_ARGS_1)
{
    C_BILL *state;

    state = (C_BILL *) &post_data->data;
    *state = *(C_BILL *) *(void **)
	((char *) used + (integral_q) state(level));
    flat_record(post_data);

    return 0;
}
