/*
 * e4.i.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * RATIONALE
 *
 * the subexpression loaders as set by some routines may be inappropriate for
 * single atom subexpressions, when the atom is a variable one.  The here
 * routine sets the subexpression loaders to proper loaders.
 */
/*
 * faster loaders are also setup, and not only for variable atoms
 */

/*
 * TODO
 *
 * optimize HERE_XSET expressions
 */

#include <e4-config.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-line.h>
#include <e4-types.h>
#include <exerrors.h>

#if __DIRECT_FAST_MISS_LOAD__
#else
# define _x1f4_e4_fast_miss		_x1f4_e4_fast_miss__
#endif				/* __DIRECT_FAST_MISS_LOAD__ */

#define set(a, b) \
    (*(a) = (b))

#define state(___l) \
    ((struct e4_atom_type *) (___l))->data.ever.state

static int ever_last(struct e4_atom_type *);
static int fast_BILL(x1f4_e4_LOAD_ARGS_0);
static int fast_Bill(x1f4_e4_LOAD_ARGS_0);
static int fast_MODE(x1f4_e4_LOAD_ARGS_0);
static int fast_Mode(x1f4_e4_LOAD_ARGS_0);
static int fast_NEXT(x1f4_e4_LOAD_ARGS_0);
static int fast_NODE(x1f4_e4_LOAD_ARGS_0);
static int fast_Next(x1f4_e4_LOAD_ARGS_0);
static int fast_Node(x1f4_e4_LOAD_ARGS_0);
static int fast_OVER(x1f4_e4_LOAD_ARGS_0);
static int fast_Over(x1f4_e4_LOAD_ARGS_0);
static int fast_REAL(x1f4_e4_LOAD_ARGS_0);
static int fast_Real(x1f4_e4_LOAD_ARGS_0);
static int fast_TEAL(x1f4_e4_LOAD_ARGS_0);
static int fast_TEXT(x1f4_e4_LOAD_ARGS_0);
static int fast_Teal(x1f4_e4_LOAD_ARGS_0);
static int fast_Text(x1f4_e4_LOAD_ARGS_0);
static int fast_USER(x1f4_e4_LOAD_ARGS_0);
static int fast_User(x1f4_e4_LOAD_ARGS_0);
static int fast_WILL(x1f4_e4_LOAD_ARGS_0);
static int fast_Will(x1f4_e4_LOAD_ARGS_0);
static int fast_bill(x1f4_e4_LOAD_ARGS_0);
static int fast_mode(x1f4_e4_LOAD_ARGS_0);
static int fast_real(x1f4_e4_LOAD_ARGS_0);
static int fast_text(x1f4_e4_LOAD_ARGS_0);
static int load_bill(x1f4_e4_LOAD_ARGS_0);
static int load_ever(x1f4_e4_LOAD_ARGS_0);
static int load_mode(x1f4_e4_LOAD_ARGS_0);
static int load_real(x1f4_e4_LOAD_ARGS_0);
static int load_text(x1f4_e4_LOAD_ARGS_0);
static int load_user(x1f4_e4_LOAD_ARGS_0);

static int
ever_last(struct e4_atom_type *atom_data)
{
    int delete;

    while (1) {
	int type;

	type = atom_data->type;
	if (type == EVER) {
	    delete = 1;
	    if (1) {
		break;
	    }
	} else {
	    if (type == THIS) {
		struct e4_hack_type *hack_data;

		hack_data = atom_data->data.hack.data;
		if (hack_data->count != 1) {
		    delete = 0;
		    if (1) {
			break;
		    }
		} else {
		    atom_data = hack_data->atoms;
		}
	    } else {
		delete = 0;
		if (1) {
		    break;
		}
	    }
	}
    }

    return delete;
}


int
fast_BILL(x1f4_e4_LOAD_ARGS_1)
{
    C_BILL *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_BILL *) &post_data->data;
    *state = *(C_BILL *) atom_data->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
fast_Bill(x1f4_e4_LOAD_ARGS_1)
{
    C_BILL *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_BILL *) &post_data->data;
    *state = *(C_BILL *) *(void **) atom_data->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
fast_MODE(x1f4_e4_LOAD_ARGS_1)
{
    C_MODE *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_MODE *) &post_data->data;
    *state = *(C_MODE *) atom_data->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
fast_Mode(x1f4_e4_LOAD_ARGS_1)
{
    C_MODE *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_MODE *) &post_data->data;
    *state = *(C_MODE *) *(void **) atom_data->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
fast_NODE(x1f4_e4_LOAD_ARGS_1)
{
    C_MODE *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_MODE *) &post_data->data;
    *state = *(C_MODE *) ((char *) used + (integral_q) state(atom_data));
    flat_record(post_data);

    return 0;
}


int
fast_NEXT(x1f4_e4_LOAD_ARGS_1)
{
    C_TEXT *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_TEXT *) &post_data->data;
    *state = *(C_TEXT *) ((char *) used + (integral_q) state(atom_data));
    flat_record(post_data);

    return 0;
}


int
fast_Node(x1f4_e4_LOAD_ARGS_1)
{
    C_MODE *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_MODE *) &post_data->data;
    *state = *(C_MODE *) *(void **)
	((char *) used + (integral_q) state(atom_data));
    flat_record(post_data);

    return 0;
}


int
fast_Next(x1f4_e4_LOAD_ARGS_1)
{
    C_TEXT *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_TEXT *) &post_data->data;
    *state = *(C_TEXT *) *(void **)
	((char *) used + (integral_q) state(atom_data));
    flat_record(post_data);

    return 0;
}


int
fast_OVER(x1f4_e4_LOAD_ARGS_1)
{
    C_USER *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_USER *) &post_data->data;
    *state = *(C_USER *) ((char *) used + (integral_q) state(atom_data));
    flat_record(post_data);

    return 0;
}


int
fast_Over(x1f4_e4_LOAD_ARGS_1)
{
    C_USER *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_USER *) &post_data->data;
    *state = *(C_USER *) *(void **)
	((char *) used + (integral_q) state(atom_data));
    flat_record(post_data);

    return 0;
}


int
fast_REAL(x1f4_e4_LOAD_ARGS_1)
{
    C_REAL *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_REAL *) &post_data->data;
    *state = *(C_REAL *) atom_data->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
fast_Real(x1f4_e4_LOAD_ARGS_1)
{
    C_REAL *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_REAL *) &post_data->data;
    *state = *(C_REAL *) *(void **) atom_data->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
fast_TEAL(x1f4_e4_LOAD_ARGS_1)
{
    C_REAL *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_REAL *) &post_data->data;
    *state = *(C_REAL *) ((char *) used + (integral_q) state(atom_data));
    flat_record(post_data);

    return 0;
}


int
fast_TEXT(x1f4_e4_LOAD_ARGS_1)
{
    C_TEXT *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_TEXT *) &post_data->data;
    *state = *(C_TEXT *) atom_data->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
fast_Teal(x1f4_e4_LOAD_ARGS_1)
{
    C_REAL *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_REAL *) &post_data->data;
    *state = *(C_REAL *) *(void **)
	((char *) used + (integral_q) state(atom_data));
    flat_record(post_data);

    return 0;
}


int
fast_Text(x1f4_e4_LOAD_ARGS_1)
{
    C_TEXT *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_TEXT *) &post_data->data;
    *state = *(C_TEXT *) *(void **) atom_data->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
fast_USER(x1f4_e4_LOAD_ARGS_1)
{
    C_USER *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_USER *) &post_data->data;
    *state = *(C_USER *) atom_data->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
fast_User(x1f4_e4_LOAD_ARGS_1)
{
    C_USER *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_USER *) &post_data->data;
    *state = *(C_USER *) *(void **) atom_data->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
fast_WILL(x1f4_e4_LOAD_ARGS_1)
{
    C_BILL *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_BILL *) &post_data->data;
    *state = *(C_BILL *) ((char *) used + (integral_q) state(atom_data));
    flat_record(post_data);

    return 0;
}


int
fast_Will(x1f4_e4_LOAD_ARGS_1)
{
    C_BILL *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_BILL *) &post_data->data;
    *state = *(C_BILL *) *(void **)
	((char *) used + (integral_q) state(atom_data));
    flat_record(post_data);

    return 0;
}


static int
fast_bill(x1f4_e4_LOAD_ARGS_1)
{
    C_BILL *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_BILL *) &post_data->data;
    *state = *(C_BILL *) &atom_data->data.lead.data;
    flat_record(post_data);

    return 0;
}


static int
fast_mode(x1f4_e4_LOAD_ARGS_1)
{
    C_MODE *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_MODE *) &post_data->data;
    *state = *(C_MODE *) &atom_data->data.lead.data;
    flat_record(post_data);

    return 0;
}


static int
fast_real(x1f4_e4_LOAD_ARGS_1)
{
    C_REAL *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_REAL *) &post_data->data;
    *state = *(C_REAL *) &atom_data->data.lead.data;
    flat_record(post_data);

    return 0;
}


static int
fast_text(x1f4_e4_LOAD_ARGS_1)
{
    C_TEXT *state;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    state = (C_TEXT *) &post_data->data;
    *state = *(C_TEXT *) &atom_data->data.lead.data;
    flat_record(post_data);

    return 0;
}


static int
load_bill(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, used);
    if (status) {
    } else {
	if (high_record(post_data)) {
	    C_BILL *state;

	    state = (void *) &post_data->data;
	    *state = *(C_BILL *) line_record(post_data);
	}
    }

    return status;
}


static int
load_ever(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, used);
    if (status) {
    } else {
	void **list;

	list = used[USED_LIST];
	list[-1] = line_record(post_data);
    }

    return status;
}


static int
load_mode(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, used);
    if (status) {
    } else {
	if (high_record(post_data)) {
	    C_MODE *state;

	    state = (void *) &post_data->data;
	    *state = *(C_MODE *) line_record(post_data);
	}
    }

    return status;
}


static int
load_real(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, used);
    if (status) {
    } else {
	if (high_record(post_data)) {
	    C_REAL *state;

	    state = (void *) &post_data->data;
	    *state = *(C_REAL *) line_record(post_data);
	}
    }

    return status;
}


static int
load_text(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, used);
    if (status) {
    } else {
	if (high_record(post_data)) {
	    C_TEXT *state;

	    state = (void *) &post_data->data;
	    *state = *(C_TEXT *) line_record(post_data);
	}
    }

    return status;
}


static int
load_user(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, used);
    if (status) {
    } else {
	if (high_record(post_data)) {
	    C_USER *state;

	    state = (void *) &post_data->data;
	    *state = *(C_USER *) line_record(post_data);
	}
    }

    return status;
}


void
_x1f4_e4_fast_miss(struct e4_hack_type *hack_data, unsigned post,
		   int (**load) (x1f4_e4_LOAD_ARGS_0))
{
    if (hack_data->count == 1) {
	struct e4_atom_type *atom_data;

	atom_data = hack_data->atoms;

	if (atom_data->odb1) {
	    *load = _x1f4_e4_load_THIS;
	} else {
	    if (atom_data->type == EVER) {
		if (post & HERE_XSET) {
		    *load = load_ever;
		} else {
		    const struct e4_ever_type *ever_data;
		    int type;

		    ever_data = atom_data->data.ever.ever_data;

		    type = ever_data->type;
		    if (ever_data->bits & UNIVERSAL) {
			if (ever_data->bits & REFERENCE) {
			    if (type == BILL) {
				set(load, fast_Will);
			    } else if (type == MODE) {
				set(load, fast_Node);
			    } else if (type == REAL) {
				set(load, fast_Teal);
			    } else if (type == TEXT) {
				set(load, fast_Next);
			    } else {
				set(load, fast_Over);
			    }
			} else {
			    if (type == BILL) {
				set(load, fast_WILL);
			    } else if (type == MODE) {
				set(load, fast_NODE);
			    } else if (type == REAL) {
				set(load, fast_TEAL);
			    } else if (type == TEXT) {
				set(load, fast_NEXT);
			    } else {
				set(load, fast_OVER);
			    }
			}
		    } else {
			if (ever_data->bits & REFERENCE) {
			    if (type == BILL) {
				set(load, fast_Bill);
			    } else if (type == MODE) {
				set(load, fast_Mode);
			    } else if (type == REAL) {
				set(load, fast_Real);
			    } else if (type == TEXT) {
				set(load, fast_Text);
			    } else {
				set(load, fast_User);
			    }
			} else {
			    if (type == BILL) {
				set(load, fast_BILL);
			    } else if (type == MODE) {
				set(load, fast_MODE);
			    } else if (type == REAL) {
				set(load, fast_REAL);
			    } else if (type == TEXT) {
				set(load, fast_TEXT);
			    } else {
				set(load, fast_USER);
			    }
			}
		    }
		}
	    } else {
		if (post & HERE_XSET) {
		    *load = load_ever;
		} else {
		    if (ever_last(atom_data)) {
			int type;

			type = atom_data->data.ever.ever_data->type;
			if (type == BILL) {
			    *load = load_bill;
			} else {
			    if (type == MODE) {
				*load = load_mode;
			    } else {
				if (type == REAL) {
				    *load = load_real;
				} else {
				    if (type == TEXT) {
					*load = load_text;
				    } else {
					*load = load_user;
				    }
				}
			    }
			}
		    } else {
			int type;

			type = atom_data->type;
			if (type == BILL) {
			    *load = fast_bill;
			} else {
			    if (type == MODE) {
				*load = fast_mode;
			    } else {
				if (type == REAL) {
				    *load = fast_real;
				} else {
				    if (type == TEXT) {
					*load = fast_text;
				    } else {
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
}
