/*
 * e4.e.c
 * Copyright (C) 2007-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-defs.h>
#include <e4-errors.h>
#include <e4-inter.h>
#include <e4-parse.h>
#include <e4-types.h>

#define parser(text) \
    ((struct parser_type *) (text))

static int pick_120712_error_0(struct e4_back_type *, void *, const char *);

static void seek_mind(const char **, const char *, unsigned, const char *);
static void type_mind(struct e4_mind_type *, const struct e4_atom_type *,
		      const char *);

static int
pick_120712_error_0(struct e4_back_type *back_data, void *parser,
		    const char *expression)
{
    int delete = 0;
    struct link_type *link_data;

    link_data = parser(parser)->link_data;
    if (link_data) {
	const struct e4_last_type *last_data;

	last_data = link_data->last_data;
	if (last_data) {
	    if (last_data->count || last_data->bits & SIDE_LIST) {
	    } else {
		back_data->code = NEARVOID;
		delete = PARSE_ERROR;
		type_mind
		    (&back_data->data.nearvoid.mind, link_data->atom_data,
		     expression);
	    }
	}
    }

    return delete;
}


static void
seek_mind(const char **post, const char *name, unsigned size,
	  const char *expression)
{
    unsigned c;

    expression -= size;

    c = *(unsigned char *) name;

    name++;
    size--;

    while (1) {
	if (*(unsigned char *) expression ^ c) {
	    expression--;
	} else {
	    const char *mind, *seek;
	    unsigned i;

	    mind = name;
	    seek = expression + 1;
	    i = size;
	    for (; i; i--) {
		if (*mind ^ *seek) {
		    break;
		} else {
		    mind++;
		    seek++;
		}
	    }

	    if (i) {
		expression--;
	    } else {
		*post = expression;
		if (1) {
		    break;
		}
	    }
	}
    }
}


static void
type_mind(struct e4_mind_type *mind_data, const struct e4_atom_type *atom_data,
	  const char *expression)
{
    if (atom_data) {
	int type;

	type = atom_data->type;

	mind_data->type = type;

	if (type ^ LAST) {
	    if (type ^ PICK) {
		const struct e4_ever_type *ever_data;
		unsigned length;

		ever_data = lock_fine(atom_data)->ever_data;

		length = ever_data->length;

		seek_mind
		    (&mind_data->name, ever_data->name, length, expression);
		mind_data->length = length;
	    }
	} else {
	    const struct e4_last_type *last_data;
	    unsigned length;

	    last_data = last_base(atom_data)->last_data;

	    length = last_data->length;

	    seek_mind
		(&mind_data->name, last_data->name, length, expression);
	    mind_data->length = length;
	}
    } else {
	mind_data->type = VOID;
    }
}


int
_x1f4_e4_080704_error_0(struct e4_back_type *back_data, const char *name,
			unsigned size)
{
    if (back_data) {
	back_data->code = L_LOOKUP;
	back_data->data.l_lookup.name = name;
	back_data->data.l_lookup.size = size;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_1(struct e4_back_type *back_data, const char *name,
			unsigned size)
{
    if (back_data) {
	back_data->code = E_LOOKUP;
	back_data->data.e_lookup.name = name;
	back_data->data.e_lookup.size = size;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_2(struct e4_back_type *back_data, const char *name,
			unsigned size)
{
    if (back_data) {
	back_data->code = USEDVOID;
	back_data->data.usedvoid.name = name;
	back_data->data.usedvoid.size = size;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_3(struct e4_back_type *back_data, const char *byte)
{
    if (back_data) {
	back_data->code = BYTEMISS;
	back_data->data.bytemiss.byte = byte;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_4(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = F_SYNTAX;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_5(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = EXPECTED;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_6(struct e4_back_type *back_data, const char *name,
			unsigned size, int f1st, int f2nd)
{
    if (back_data) {
	back_data->code = BINARY_R;
	back_data->data.binary_r.f1st = f1st;
	back_data->data.binary_r.f2nd = f2nd;
	back_data->data.binary_r.name = name;
	back_data->data.binary_r.size = size;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_7(struct e4_back_type *back_data,
			struct e4_atom_type *atom_data, const char *expression)
{
    if (back_data) {
	const struct e4_ever_type *ever_data;
	unsigned length;

	back_data->code = C_LVALUE;

	ever_data = atom_data->data.ever.ever_data;

	length = ever_data->length;

	seek_mind
	    (&back_data->data.c_lvalue.name, ever_data->name, length,
	     expression);
	back_data->data.c_lvalue.size = ever_data->length;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_8(struct e4_back_type *back_data, const char *name,
			unsigned size)
{
    if (back_data) {
	back_data->code = L_SYNTAX;
	back_data->data.l_syntax.name = name;
	back_data->data.l_syntax.size = size;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_9(struct e4_back_type *back_data, const char *name,
			unsigned size)
{
    if (back_data) {
	back_data->code = E_SYNTAX;
	back_data->data.e_syntax.name = name;
	back_data->data.e_syntax.size = size;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_a(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = 0;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_b(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = I_LVALUE;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_c(struct e4_back_type *back_data,
			struct e4_hack_type *hack_data, const char *expression)
{
    if (back_data) {
	while (hack_data->count == 1) {
	    struct e4_atom_type *atom_data;

	    atom_data = hack_data->atoms;
	    if (atom_data->type != THIS) {
		break;
	    } else {
		hack_data = atom_data->data.hack.data;
	    }
	}
	if (hack_data->count != 1) {
	    _x1f4_e4_080704_error_b(back_data);
	} else {
	    struct e4_atom_type *atom_data;

	    atom_data = hack_data->atoms;
	    if (atom_data->type != EVER) {
		_x1f4_e4_080704_error_b(back_data);
	    } else {
		_x1f4_e4_080704_error_7(back_data, atom_data, expression);
	    }
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_d(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = R_SCALAR;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_e(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = B_SCALAR;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_f(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = C_STRING;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_g(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = U_PREFIX;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_h(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = U_BINARY;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_i(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = P_LOOKUP;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_j(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = B_LOOKUP;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_080704_error_k(struct e4_back_type *back_data, const void *atom,
			unsigned rank, int f1st, int f2nd,
			const char *expression)
{
    if (back_data) {
	back_data->code = MISSTYPE;
	back_data->data.misstype.f1st = f1st;
	back_data->data.misstype.f2nd = f2nd;
	back_data->data.misstype.rank = rank;
	type_mind(&back_data->data.misstype.mind, atom, expression);
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_081014_error_0(struct e4_back_type *back_data, const void *atom,
			unsigned rank, const char *expression)
{
    if (back_data) {
	back_data->code = I_SVALUE;
	back_data->data.i_svalue.rank = rank;
	type_mind(&back_data->data.i_svalue.mind, atom, expression);
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_081014_error_1(struct e4_back_type *back_data,
			struct e4_hack_type *hack_data, const void *atom,
			unsigned rank, int f1st, int f2nd,
			const char *expression)
{
    if (back_data) {
	while (hack_data->count == 1) {
	    struct e4_atom_type *atom_data;

	    atom_data = hack_data->atoms;
	    if (atom_data->type != THIS) {
		break;
	    } else {
		hack_data = atom_data->data.hack.data;
	    }
	}
	if (hack_data->count != 1) {
	    _x1f4_e4_081014_error_0(back_data, atom, rank, expression);
	} else {
	    struct e4_atom_type *atom_data;

	    atom_data = hack_data->atoms;
	    if (atom_data->type != EVER) {
		_x1f4_e4_081014_error_0(back_data, atom, rank, expression);
	    } else {
		back_data->code = T_SVALUE;
		back_data->data.t_svalue.f1st = f1st;
		back_data->data.t_svalue.f2nd = f2nd;
		back_data->data.t_svalue.rank = rank;
		type_mind(&back_data->data.t_svalue.mind, atom, expression);
	    }
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_081014_error_2(struct e4_back_type *back_data,
			struct e4_hack_type *hack_data, const void *atom,
			unsigned rank, const char *expression)
{
    if (back_data) {
	while (hack_data->count == 1) {
	    struct e4_atom_type *atom_data;

	    atom_data = hack_data->atoms;
	    if (atom_data->type != THIS) {
		break;
	    } else {
		hack_data = atom_data->data.hack.data;
	    }
	}
	if (hack_data->count != 1) {
	    _x1f4_e4_081014_error_0(back_data, atom, rank, expression);
	} else {
	    struct e4_atom_type *atom_data;

	    atom_data = hack_data->atoms;
	    if (atom_data->type != EVER) {
		_x1f4_e4_081014_error_0(back_data, atom, rank, expression);
	    } else {
		back_data->code = C_SVALUE;
		back_data->data.c_svalue.rank = rank;
		type_mind(&back_data->data.c_svalue.mind, atom, expression);
	    }
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_081019_error_0(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = C_SYNTAX;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110605_error_0(struct e4_back_type *back_data, const void *atom,
			const char *expression)
{
    if (back_data) {
	back_data->code = SURESTEP;
	type_mind(&back_data->data.surestep.mind, atom, expression);
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110605_error_1(struct e4_back_type *back_data, const void *atom,
			const char *expression)
{
    if (back_data) {
	back_data->code = SURELOSE;
	type_mind(&back_data->data.surelose.mind, atom, expression);
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110608_error_1(void *parser, const char *expression)
{
    struct e4_back_type *back_data;

    back_data = parser(parser)->back_data;
    if (back_data) {
	if (pick_120712_error_0(back_data, parser, expression)) {
	} else {
	    back_data->code = NEARNAME;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110608_error_2(void *parser, const char *expression)
{
    struct e4_back_type *back_data;

    back_data = parser(parser)->back_data;
    if (back_data) {
	if (pick_120712_error_0(back_data, parser, expression)) {
	} else {
	    back_data->code = NEARREAL;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110608_error_3(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = NEARTEXT;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110608_error_4(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = NEARLOSE;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110608_error_5(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = NEARSTEP;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110608_error_6(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = NEAROPEN;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110608_error_7(struct e4_back_type *back_data, int join)
{
    if (back_data) {
	back_data->code = NEARJOIN;
	back_data->data.nearjoin.join = join;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110608_error_9(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = NEARCITE;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_110817_error_0(struct e4_back_type *back_data, const char *name,
			unsigned size)
{
    if (back_data) {
	back_data->code = MISSCALL;
	back_data->data.misscall.name = name;
	back_data->data.misscall.size = size;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_130607_error_0(struct e4_back_type *back_data, int f1st, int f2nd)
{
    if (back_data) {
	back_data->code = MISSTURN;
	back_data->data.missturn.f1st = f1st;
	back_data->data.missturn.f2nd = f2nd;
    }

    return PARSE_ERROR;
}


int
_x1f4_e4_130704_error_0(struct e4_back_type *back_data)
{
    if (back_data) {
	back_data->code = LONGVOID;
    }

    return PARSE_ERROR;
}
