/*
 * e4.7.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TODO
 *
 *.write a non recursive version of _fast_hack so that nodes are not visited
 * one thousand times
 */

#include <config.h>

#include <e4-config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <float.h>
#include <math.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include <ctype.0.h>
#include <e4-byte.h>
#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-parse.h>
#include <e4-types.h>
#include <e4fine-e4.h>
#if !defined HAVE_LIBx1f4i0
# include <lcardinal-x.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define __USE_XLCARDINAL__		1

#if SIZEOF_UNSIGNED_LONG == 8
# define mlay_cardinal			unsigned long
#else
# define mlay_cardinal			double
#endif				/* SIZEOF_UNSIGNED_LONG == 8 */

/*
 * class set only definitions
 */
#define SIDE_CLASS			12

/*
 * expectation definitions
 */
#define DATA_CLASS			13
#define DONE_CLASS			14
#define HACK_CLASS			15
#define JOIN_CLASS			16
#define LIST_CLASS			17
#define NEXT_CLASS			18
#define POST_CLASS			19

#if !defined DBL_MANT_DIG
# if SIZEOF_DOUBLE == 8
#  undef FLT_RADIX
#  define FLT_RADIX			2
#  define DBL_MANT_DIG			53
# endif				/* SIZEOF_DOUBLE == 8 */
#endif				/* DBL_MANT_DIG */

#if defined DBL_MANT_DIG
# if defined FLT_RADIX
#  if FLT_RADIX == 2
#   define __USE_DOUBLE_MANTISSA_DIGITS__
#  endif			/* FLT_RADIX == 2 */
# endif				/* FLT_RADIX */
#endif				/* DBL_MANT_DIG */

#undef double_digits

#if defined __USE_DOUBLE_MANTISSA_DIGITS__
# if DBL_MANT_DIG == 53
#  if FLT_RADIX == 2
#   define double_digits		15
#  endif			/* FLT_RADIX == 2 */
# endif				/* DBL_MANT_DIG == 53 */
#endif				/* __USE_DOUBLE_MANTISSA_DIGITS__ */

#define SET_NEXT__________ARGS_0 \
    struct next_type *, struct parser_type *, int *
#define SET_NEXT__________ARGS_1 \
    struct next_type *next_data, struct parser_type *parser_data, int *expect
#define SET_NEXT__________ARGS_2 \
    next_data, parser_data, expect

#define LOGIC_BITS \
    ((1 << LAST) | (1 << LOCK) | (1 << PICK))
#define SCALAR_BITS \
    ((1 << BILL) | (1 << MODE) | (1 << REAL))

#define EXPRESSION(expression) \
    ((e4_expression_type *) expression)

#define E_FREE(mcontext, mdata) \
    (EXPRESSION(mcontext)->m.free(EXPRESSION(mcontext)->m.data, (mdata)))
#define E_LINK(mcontext, mdata, size) \
    (EXPRESSION(mcontext)->m.link					      \
	(EXPRESSION(mcontext)->m.data, (void *) (mdata), (size)))
#define E_MODE(mcontext, mdata, size) \
    (EXPRESSION(mcontext)->m.mode					      \
	(EXPRESSION(mcontext)->m.data, (void *) (mdata), (size)))

#define M_FREE(mcontext, mdata) \
    (mcontext)->m.free((mcontext)->m.data, (mdata))
#define M_LINK(mcontext, mdata, size) \
    (mcontext)->m.link((mcontext)->m.data, (void *) (mdata), (size))
#define M_MODE(mcontext, mdata, size) \
    (mcontext)->m.mode((mcontext)->m.data, (void *) (mdata), (size))

extern const char _x1f4_e4_tc_reflex[];
extern const struct e4_odbx_type _x1f4_e4_pick[];
extern const unsigned _x1f4_c_type_0[], _x1f4_c_type_1[];

static int case_cc_0(GET_ATOM__________ARGS_0);
static int case_cc_1(GET_ATOM__________ARGS_0);
static int case_cc_2(GET_ATOM__________ARGS_0);
static int case_cc_3(GET_ATOM__________ARGS_0);
static int case_cc_4(GET_ATOM__________ARGS_0);
static int case_cc_5(GET_ATOM__________ARGS_0);
static int case_cc_6(GET_ATOM__________ARGS_0);
static int case_cc_7(GET_ATOM__________ARGS_0);
static int case_cc_8(GET_ATOM__________ARGS_0);
static int case_ce_8(GET_ATOM__________ARGS_0);
static int case_cc_9(GET_ATOM__________ARGS_0);
static int case_ever(struct parser_type *, int, int, const char *, unsigned);
static int case_last(struct parser_type *, int, int, const char *, unsigned);
static int case_side(struct e4_atom_type *, unsigned,
		     const struct e4_last_type *, struct parser_type *);
#if __ALLOW_FUNCTION_POINTERS__
static int ever_last(GET_ATOM__________ARGS_0, const char *, unsigned,
		     const struct e4_last_type *, void *);
#endif				/* __ALLOW_FUNCTION_POINTERS__ */
static int init_data(struct parser_type *);
static int lead_atom(GET_ATOM__________ARGS_0);
static int lead_back(GET_ATOM__________ARGS_0);
static int lead_char(GET_ATOM__________ARGS_0);
static int lead_mlay(GET_ATOM__________ARGS_0);
static int lead_name(GET_ATOM__________ARGS_0);
static int lead_odb1(GET_ATOM__________ARGS_0);
static int lead_odb2(GET_ATOM__________ARGS_0);
static int lead_text(GET_ATOM__________ARGS_0);
static int link_data(struct parser_type *);
static int make_atom(struct e4_hack_type *, struct e4_atom_type **,
		     struct parser_type *);
static int make_hack(struct e4_hack_type **, struct parser_type *);
static int make_list(struct e4_hack_type **, const struct e4_last_type *,
		     struct parser_type *, unsigned);
static int near_side(struct parser_type *);
static int pick_atom(int *, int *, struct e4_atom_type **,
		     struct e4_atom_type *, struct parser_type *);
static int pick_this(int *, int *, struct e4_atom_type **,
		     struct e4_hack_type *, struct parser_type *);
static int push_hack(struct link_type **, struct e4_hack_type *, int,
		     struct parser_type *);
static int set_bill(SET_NEXT__________ARGS_0);
static int set_dana(const struct e4_last_type *, const struct e4_ever_type *,
		    void *, struct parser_type *);
static int set_ever(SET_NEXT__________ARGS_0);
static int set_join(struct next_type *, const struct e4_last_type *,
		    struct parser_type *);
static int set_last(SET_NEXT__________ARGS_0);
static int set_lock(SET_NEXT__________ARGS_0);
static int set_lose(SET_NEXT__________ARGS_0);
static int set_mode(SET_NEXT__________ARGS_0);
static int set_odb1(SET_NEXT__________ARGS_0);
static int set_odb2(SET_NEXT__________ARGS_0);
static int set_open(SET_NEXT__________ARGS_0);
static int set_pick(struct next_type *, const struct e4_last_type *,
		    struct parser_type *);
static int set_real(SET_NEXT__________ARGS_0);
static int set_side(SET_NEXT__________ARGS_0);
static int set_step(SET_NEXT__________ARGS_0);
static int set_text(SET_NEXT__________ARGS_0);

static void ever_slip(struct parser_type *);
static void fill_data(struct parser_type *);
static void fill_type(unsigned char *, const unsigned *, unsigned);
static void free_lock(struct parser_type *);
static void free_odb1(struct e4_odb1_type *, void *);
static void join_hack(struct link_type **, struct e4_hack_type **,
		      struct parser_type *);

static int (*const case_seleCtion[]) (GET_ATOM__________ARGS_0) = {
/* *INDENT-OFF* */
    case_cc_0,
    case_cc_1,
    case_cc_2,
    case_cc_3,
    case_cc_4,
    case_cc_5,
    case_cc_6,
    case_cc_7,
    case_ce_8,
    case_cc_9
/* *INDENT-ON* */
}, (*const case_selection[]) (GET_ATOM__________ARGS_0) = {
/* *INDENT-OFF* */
    case_cc_0,
    case_cc_1,
    case_cc_2,
    case_cc_3,
    case_cc_4,
    case_cc_5,
    case_cc_6,
    case_cc_7,
    case_cc_8,
    case_cc_9
/* *INDENT-ON* */
}, (*const set_class[]) (SET_NEXT__________ARGS_0) = {
/* *INDENT-OFF* */
    set_bill,
    set_odb1,
    set_odb2,
    set_ever,
    set_last,
    set_lock,
    set_lose,
    set_mode,
    set_open,
    set_real,
    set_step,
    set_text,
    set_side
/* *INDENT-ON* */
};
static const unsigned c_type_0[] = {
/*
 *
 *
 *   !   # $ % &       * +   -   /
 *                     :   < = > ?
 * @
 *                             ^
 *
 *                         |   ~
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0xf400ac7a, 0x40000001, 0x50000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_1[] = {
/*
 *                   . .     .
 *
 * .                     +
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00002600, 0x00000801, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_2[] = {
/*
 *
 *
 *
 * 0 1 2 3 4 5 6 7 8 9
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff0000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_3[] = {
/*
 *
 *
 *                             .
 * 0 1 2 3 4 5 6 7 8 9
 *
 *
 *
 *     r
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff4000, 0x00000000, 0x00040000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_4[] = {
/*
 *                   . .     .
 *
 * .
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00002600, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_6[] = {
/*
 *
 *
 *                       +   - .
 * 0 1 2 3 4 5 6 7 8 9
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff6800, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

static int
case_cc_0(GET_ATOM__________ARGS_1)
{
    return _x1f4_e4_080704_error_3
	(parser_data->back_data, parser_data->expression);
}


static int
case_cc_1(GET_ATOM__________ARGS_1)
{
#define ERROR_0				((1 << DONE_CLASS))
#define ERROR_1				(ERROR_0 | (1 << JOIN_CLASS))
#define ERROR_2				(ERROR_1 | (1 << LOSE_CLASS))
#define ERROR_3				(ERROR_2 | (1 << NEXT_CLASS))
#define ERROR_4				(ERROR_3 | (1 << OPEN_CLASS))
#define ERROR_5				(ERROR_4 | (1 << POST_CLASS))
#define ERROR_6				(ERROR_5 | (1 << STEP_CLASS))

    int status;

    if ((1 << expect) & ERROR_6) {
	status = _x1f4_e4_110608_error_1(parser_data, parser_data->expression);
    } else {
	status = lead_name(GET_ATOM__________ARGS_2);
    }

    return status;

#undef ERROR_6
#undef ERROR_5
#undef ERROR_4
#undef ERROR_3
#undef ERROR_2
#undef ERROR_1
#undef ERROR_0
}


static int
case_cc_2(GET_ATOM__________ARGS_1)
{
#define ERROR_0				((1 << DONE_CLASS))
#define ERROR_1				(ERROR_0 | (1 << JOIN_CLASS))
#define ERROR_2				(ERROR_1 | (1 << LIST_CLASS))
#define ERROR_3				(ERROR_2 | (1 << LOSE_CLASS))
#define ERROR_4				(ERROR_3 | (1 << NEXT_CLASS))
#define ERROR_5				(ERROR_4 | (1 << OPEN_CLASS))
#define ERROR_6				(ERROR_5 | (1 << POST_CLASS))
#define ERROR_7				(ERROR_6 | (1 << STEP_CLASS))

    int status;

    if ((1 << expect) & ERROR_7) {
	status = _x1f4_e4_110608_error_2(parser_data, parser_data->expression);
    } else {
	status = lead_mlay(GET_ATOM__________ARGS_2);
    }

    return status;

#undef ERROR_7
#undef ERROR_6
#undef ERROR_5
#undef ERROR_4
#undef ERROR_3
#undef ERROR_2
#undef ERROR_1
#undef ERROR_0
}


static int
case_cc_3(GET_ATOM__________ARGS_1)
{
#define ERROR_0				((1 << DONE_CLASS))
#define ERROR_1				(ERROR_0 | (1 << JOIN_CLASS))
#define ERROR_2				(ERROR_1 | (1 << LIST_CLASS))
#define ERROR_3				(ERROR_2 | (1 << LOSE_CLASS))
#define ERROR_4				(ERROR_3 | (1 << NEXT_CLASS))
#define ERROR_5				(ERROR_4 | (1 << OPEN_CLASS))
#define ERROR_6				(ERROR_5 | (1 << POST_CLASS))
#define ERROR_7				(ERROR_6 | (1 << STEP_CLASS))

    int status;

    if ((1 << expect) & ERROR_7) {
	status = _x1f4_e4_110608_error_3(parser_data->back_data);
    } else {
	status = lead_text(GET_ATOM__________ARGS_2);
    }

    return status;

#undef ERROR_7
#undef ERROR_6
#undef ERROR_5
#undef ERROR_4
#undef ERROR_3
#undef ERROR_2
#undef ERROR_1
#undef ERROR_0
}


static int
case_cc_4(GET_ATOM__________ARGS_1)
{
#define ERROR_0				((1 << DATA_CLASS))
#define ERROR_1				(ERROR_0 | (1 << DONE_CLASS))
#define ERROR_2				(ERROR_1 | (1 << HACK_CLASS))
#define ERROR_3				(ERROR_2 | (1 << LIST_CLASS))
#define ERROR_4				(ERROR_3 | (1 << NEXT_CLASS))
#define ERROR_5				(ERROR_4 | (1 << OPEN_CLASS))
#define ERROR_6				(ERROR_5 | (1 << POST_CLASS))
#define ERROR_7				(ERROR_6 | (1 << STEP_CLASS))

    int status;

    if ((1 << expect) & ERROR_7) {
	struct link_type *link_data;

	link_data = parser_data->link_data;
	if (expect == POST_CLASS) {
	    status = _x1f4_e4_110605_error_1
		(parser_data->back_data,
		 link_data->last_data ? link_data->atom_data : NULL,
		 parser_data->expression);
	} else {
	    do {
		if (link_data) {
		    const struct e4_last_type *last_data;

		    last_data = link_data->last_data;
		    if (last_data) {
			if (last_data->bits & SIDE_LIST) {
			    if (parser_data->hack_data->count) {
			    } else {
				if (parser_data->odb1_data) {
				} else {
				    if (last_data->count) {
				    } else {
					if (link_data->frame ^ 1) {
					} else {
					    parser_data->expression++;
					    next_data->class = LOSE_CLASS;
					    link_data->frame = 0;
					    status = 0;
					    if (1) {
						break;
					    }
					}
				    }
				}
			    }
			}
		    }
		}

		status = _x1f4_e4_110608_error_4(parser_data->back_data);
	    } while (0);
	}
    } else {
	parser_data->expression++;
	next_data->class = LOSE_CLASS;
	status = 0;
    }

    return status;

#undef ERROR_7
#undef ERROR_6
#undef ERROR_5
#undef ERROR_4
#undef ERROR_3
#undef ERROR_2
#undef ERROR_1
#undef ERROR_0
}


static int
case_cc_5(GET_ATOM__________ARGS_1)
{
#define ERROR_0				((1 << DATA_CLASS))
#define ERROR_1				(ERROR_0 | (1 << DONE_CLASS))
#define ERROR_2				(ERROR_1 | (1 << HACK_CLASS))
#define ERROR_3				(ERROR_2 | (1 << JOIN_CLASS))
#define ERROR_4				(ERROR_3 | (1 << LIST_CLASS))
#define ERROR_5				(ERROR_4 | (1 << LOSE_CLASS))
#define ERROR_6				(ERROR_5 | (1 << NEXT_CLASS))
#define ERROR_7				(ERROR_6 | (1 << OPEN_CLASS))

    int status;

    if ((1 << expect) & ERROR_7) {
	if (expect == JOIN_CLASS) {
	    do {
		const struct e4_last_type *last_data;
		struct link_type *link_data;

		link_data = parser_data->link_data;

		last_data = link_data->last_data;
		if (last_data) {
		    if (last_data->bits & SIDE_LIST) {
			parser_data->expression++;
			next_data->class = SIDE_CLASS;
			status = 0;
			if (1) {
			    break;
			}
		    }
		}

		status = _x1f4_e4_110605_error_0
		    (parser_data->back_data,
		     last_data ? link_data->atom_data : NULL,
		     parser_data->expression);
	    } while (0);
	} else {
	    status = _x1f4_e4_110608_error_5(parser_data->back_data);
	}
    } else {
	parser_data->expression++;
	next_data->class = STEP_CLASS;
	status = 0;
    }

    return status;

#undef ERROR_7
#undef ERROR_6
#undef ERROR_5
#undef ERROR_4
#undef ERROR_3
#undef ERROR_2
#undef ERROR_1
#undef ERROR_0
}


static int
case_cc_6(GET_ATOM__________ARGS_1)
{
#define ERROR_0				((1 << DONE_CLASS))
#define ERROR_1				(ERROR_0 | (1 << JOIN_CLASS))
#define ERROR_2				(ERROR_1 | (1 << LOSE_CLASS))
#define ERROR_3				(ERROR_2 | (1 << NEXT_CLASS))
#define ERROR_4				(ERROR_3 | (1 << POST_CLASS))
#define ERROR_5				(ERROR_4 | (1 << STEP_CLASS))

    int status;

    if ((1 << expect) & ERROR_5) {
	do {
	    if (parser_data->e4fine) {
		int miss = 0, type = VOID;
		struct e4_atom_type *atom_data, *atom_text = NULL;

		atom_data = parser_data->atom_data;
		type = atom_data->type;

		status = pick_atom
		    (&type, &miss, &atom_text, atom_data, parser_data);
		if (status) {
		    break;
		}

		if (BASE_LOCK < type) {
		    const void *line;

		    if (atom_text) {
			const struct e4_ever_type *ever_data;

			status = 1;
			ever_data = atom_text->data.ever.ever_data;
			if (ever_data->bits & UNIVERSAL) {
			    status = x1f4_pick_e4fine
				(parser_data->e4fine, ever_data->type, &line);
			} else {
			    line = *(void **) atom_text->data.ever.state;
			    /*
			     * no need to check for the REFERENCE flag, as the
			     * state has been set to a function description
			     * pointer
			     */
			}
		    } else {
			status = x1f4_pick_e4fine
			    (parser_data->e4fine, type, &line);
		    }
		    if (status) {
			const struct e4_last_type *last_data;

			last_data = &((struct e4_line_type *) line)->last;
			if (miss) {
			    status = set_dana
				(last_data, atom_text->data.ever.ever_data,
				 atom_text->data.ever.state, parser_data);
			} else {
			    status = set_join
				(next_data, last_data, parser_data);
			}
			if (status) {
			} else {
			    parser_data->expression++;
			    next_data->class = OPEN_CLASS;
			}

			break;
		    }
		}
	    }

	    status = _x1f4_e4_110608_error_6(parser_data->back_data);
	} while (0);
    } else {
	parser_data->expression++;
	next_data->class = OPEN_CLASS;
	status = 0;
    }

    return status;

#undef ERROR_5
#undef ERROR_4
#undef ERROR_3
#undef ERROR_2
#undef ERROR_1
#undef ERROR_0
}


static int
case_cc_7(GET_ATOM__________ARGS_1)
{
#define ERROR_0				((1 << DONE_CLASS))
#define ERROR_1				(ERROR_0 | (1 << LIST_CLASS))
#define ERROR_2				(ERROR_1 | (1 << LOSE_CLASS))
#define ERROR_3				(ERROR_2 | (1 << OPEN_CLASS))
#define ERROR_4				(ERROR_3 | (1 << STEP_CLASS))

    int status;

    if ((1 << expect) & ERROR_4) {
	status = _x1f4_e4_110608_error_7
	    (parser_data->back_data,
	     *(const unsigned char *) parser_data->expression);
    } else if (expect == HACK_CLASS || expect == DATA_CLASS) {
	status = lead_odb1(GET_ATOM__________ARGS_2);
    } else {
	status = lead_odb2(GET_ATOM__________ARGS_2);
    }

    return status;

#undef ERROR_4
#undef ERROR_3
#undef ERROR_2
#undef ERROR_1
#undef ERROR_0
}


static int
case_cc_8(GET_ATOM__________ARGS_1)
{
#define ERROR_0				((1 << DATA_CLASS))
#define ERROR_1				(ERROR_0 | (1 << HACK_CLASS))
#define ERROR_2				(ERROR_1 | (1 << JOIN_CLASS))
#define ERROR_3				(ERROR_2 | (1 << LIST_CLASS))
#define ERROR_4				(ERROR_3 | (1 << LOSE_CLASS))
#define ERROR_5				(ERROR_4 | (1 << OPEN_CLASS))
#define ERROR_6				(ERROR_5 | (1 << POST_CLASS))
#define ERROR_7				(ERROR_6 | (1 << STEP_CLASS))

    int status;

    if ((1 << expect) & ERROR_7) {
	status = _x1f4_e4_080704_error_5(parser_data->back_data);
    } else {
	next_data->class = DONE_CLASS;
	status = 0;
    }

    return status;

#undef ERROR_7
#undef ERROR_6
#undef ERROR_5
#undef ERROR_4
#undef ERROR_3
#undef ERROR_2
#undef ERROR_1
#undef ERROR_0
}


static int
case_ce_8(GET_ATOM__________ARGS_1)
{
    return _x1f4_e4_080704_error_5(parser_data->back_data);
}


static int
case_cc_9(GET_ATOM__________ARGS_1)
{
#define ERROR_0				((1 << DONE_CLASS))
#define ERROR_1				(ERROR_0 | (1 << JOIN_CLASS))
#define ERROR_2				(ERROR_1 | (1 << LIST_CLASS))
#define ERROR_3				(ERROR_2 | (1 << LOSE_CLASS))
#define ERROR_4				(ERROR_3 | (1 << NEXT_CLASS))
#define ERROR_5				(ERROR_4 | (1 << OPEN_CLASS))
#define ERROR_6				(ERROR_5 | (1 << POST_CLASS))
#define ERROR_7				(ERROR_6 | (1 << STEP_CLASS))

    int status;

    if ((1 << expect) & ERROR_7) {
	status = _x1f4_e4_110608_error_9(parser_data->back_data);
    } else {
	status = lead_char(GET_ATOM__________ARGS_2);
    }

    return status;

#undef ERROR_7
#undef ERROR_6
#undef ERROR_5
#undef ERROR_4
#undef ERROR_3
#undef ERROR_2
#undef ERROR_1
#undef ERROR_0
}


static int
case_ever(struct parser_type *parser_data, int expect, int type, const char *f,
	 unsigned length)
{
    int status = 0;

    if (expect == LIST_CLASS) {
	status = _x1f4_e4_080704_error_9(parser_data->back_data, f, length);
    }

    return status;
}


static int
case_last(struct parser_type *parser_data, int expect, int type, const char *f,
	  unsigned length)
{
    int status = 0;

    if (type == VOID) {
	if (parser_data->expression_data->type != UNDEFINED) {
	    status = _x1f4_e4_080704_error_2
		(parser_data->back_data, f, length);
	}
    } else {
	if (expect == LIST_CLASS) {
	    status = _x1f4_e4_080704_error_8
		(parser_data->back_data, f, length);
	}
    }

    return status;
}


static int
case_side(struct e4_atom_type *atom_data, unsigned frame,
	  const struct e4_last_type *last_data,
	  struct parser_type *parser_data)
{
    int status;
    struct e4_flat_type *flat_data;
    unsigned bits, class, count;

    count = last_data->count;
    bits = last_data->bits;

    if (frame == count && !(bits & SLIP_LIST)) {
	frame = 0;
	class = 0;
    } else {
	class = frame;
	if (bits & (LINK_PASS | POST_TYPE)) {
	    class <<= 1;
	    bits |= POST_TYPE;
	}
    }

    status = M_LINK
	(parser_data, &flat_data,
	 sizeof(struct e4_flat_type) * 3 + sizeof(struct e4_last_type)
	 + class * sizeof(int));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	struct e4_base_type *base_data;
	struct e4_last_type *last_text;

	flat_data->flat_data = parser_data->flat_data;
	flat_data->read = DATA_FLAT;

	parser_data->flat_data = flat_data;

	base_data = hack_base(atom_data->data.last.base);

	flat_data[1].flat_data = (void *) last_data;
	flat_data[2].flat_data = base_data->text;

	last_text = (void *) (flat_data + 3);

	memcpy(last_text, last_data, sizeof(struct e4_last_type));

	if (frame) {
	    int *args;
	    const int *line;

	    args = (void *) (last_text + 1);

	    last_text->count = frame;
	    last_text->args = args;

	    line = last_data->args;

	    memcpy(args, line, count * sizeof(int));

	    args += count;

	    frame -= count;
	    if (bits & POST_TYPE) {
		int *flat;

		flat = args + frame;

		if (last_data->bits & POST_TYPE) {
		    line += count;
		    for (; count; count--) {
			*flat++ = *line++;
		    }
		} else {
		    for (; count; count--) {
			*flat++ = 0;
		    }
		}

		for (; frame; frame--) {
		    *args++ = SIDE;
		    *flat++ = 0;
		}
	    } else {
		for (; frame; frame--) {
		    *args++ = SIDE;
		}
	    }
	}

	base_data->last_data = last_text;

	last_text->bits = (bits | FLAT_LINE) & ~(SIDE_LIST | SLIP_LIST);
    }

    return status;
}


#if __ALLOW_FUNCTION_POINTERS__
static int
ever_last(GET_ATOM__________ARGS_1, const char *f, unsigned length,
	  const struct e4_last_type *last_data, void *state)
{
    int status;
    struct e4_flat_type *flat_data;

    status = M_LINK(parser_data, &flat_data, __news_alloc_size__);
    if (status) {
	status = ALLOC_ERROR;
    } else {
	struct e4_ever_type *ever_miss;
	struct e4_news_type *news_data;
	void **record;

	flat_data->flat_data = parser_data->flat_data;
	flat_data->read = NEWS_FLAT;

	parser_data->flat_data = flat_data;

	ever_miss = (void *) (flat_data + 1);

	news_data = (void *) (ever_miss + 1);

	state = news_data + 1;

	record = state;

	news_data->call = 1;

	news_data->line.last = *last_data;

	news_data->data = parser_data->m.data;
	news_data->free = parser_data->m.free;

	news_data->line.last.bits |= NEWS_LINK;

	if (last_data->bits & NODE_LINK) {
	    *record = (void *)
		((char *) last_data - offsetof(struct e4_line_type, last));
	} else {
	    *record = (void *) &news_data->line;
	}

	ever_miss->name = last_data->name;
	ever_miss->bits = FLAT_LINK | READ_ONLY;
	ever_miss->length = last_data->length;

	status = x1f4_type_e4fine
	    (parser_data->e4fine, &ever_miss->type, &news_data->line);
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	    int type;

	    type = ever_miss->type;
	    next_data->class = EVER_CLASS;
	    next_data->type = type;
	    next_data->data.ever.state = state;
	    next_data->data.ever.ever_data = ever_miss;

	    status = case_ever(parser_data, expect, type, f, length);
	    if (status) {
	    } else {
		if (last_data->bits & TEXT_LINK) {
		    void *text;

		    status = parser_data->attributes_data->last_0.fix
			(parser_data->attributes_data->last_0.context,
			 last_data, &text);
		    if (status) {
		    } else {
			news_data->line.text = text;
		    }
		}
	    }
	}
    }

    return status;
}
#endif				/* __ALLOW_FUNCTION_POINTERS__ */


static int
init_data(struct parser_type *parser_data)
{
    int expect = HACK_CLASS, status;
    struct e4_expression_type *expression_data;
    struct next_type next_data;

    parser_data->argument = 0;
    parser_data->flat_data = NULL;
    parser_data->odb1_data = NULL;
    parser_data->link_class = NEXT_CLASS;
    parser_data->link_data = NULL;

    next_data.class = ~0;

    while (1) {
	status = parser_data->slip(&next_data, parser_data, expect);
	if (status) {
	    break;
	}
	if (next_data.class == DONE_CLASS) {
	    if (parser_data->link_data) {
		/*
		 * unreached?
		 */
		status = _x1f4_e4_080704_error_a(parser_data->back_data);
	    }

	    break;
	}

	status = set_class[next_data.class](&next_data, parser_data, &expect);
	if (status) {
	    break;
	}
    }

    free_lock(parser_data);

    expression_data = parser_data->expression_data;

    free_odb1(parser_data->odb1_data, expression_data);

    expression_data->flat_data = parser_data->flat_data;

    if (status) {
    } else {
	if (parser_data->bits & PACK_ESTORAGE) {
	    struct e4_hack_type *hack_data;

	    hack_data = &expression_data->hack_data;
	    M_MODE(parser_data, &hack_data->atoms,
		   hack_data->count * sizeof(struct e4_atom_type));
	}

	status = link_data(parser_data);
	if (status) {
	} else {
	    int type;

	    type = expression_data->type;
#if __COPY_E4_POST__
	    if (type == BILL) {
		expression_data->fast = C_BILL_COPY;
	    } else if (type == MODE) {
		expression_data->fast = C_MODE_COPY;
	    } else if (type == REAL) {
		expression_data->fast = C_REAL_COPY;
	    } else if (type == TEXT) {
		expression_data->fast = C_TEXT_COPY;
	    } else if (type == VOID) {
		expression_data->fast = 0;
	    } else {
		expression_data->fast = C_USER_COPY;
	    }
#endif				/* __COPY_E4_POST__ */
#if __LINE_E4_POST__
	    if (type == BILL) {
		expression_data->post = _x1f4_e4_post_bill;
	    } else if (type == MODE) {
		expression_data->post = _x1f4_e4_post_mode;
	    } else if (type == REAL) {
		expression_data->post = _x1f4_e4_post_real;
	    } else if (type == TEXT) {
		expression_data->post = _x1f4_e4_post_text;
	    } else if (type == VOID) {
		expression_data->post = _x1f4_e4_post_void;
	    } else {
		expression_data->post = _x1f4_e4_post_user;
	    }
#endif				/* __LINE_E4_POST__ */
	}
    }

    return status;
}


static int
lead_atom(GET_ATOM__________ARGS_1)
{
    int c;

    if (parser_data->bits & SKIP_SCOMMENT) {
	ever_slip(parser_data);

	c = *(const unsigned char *) parser_data->expression;
    } else {
	const char *e;

	e = parser_data->expression;

	c = *(const unsigned char *) e;
	while (C_TYPE_X(c_type_4, c)) {
	    e++;
	    c = *(const unsigned char *) e;
	}

	parser_data->expression = e;
    }

    return case_selection[parser_data->class_select[c]]
	(GET_ATOM__________ARGS_2);
}


static int
lead_back(GET_ATOM__________ARGS_1)
{
    int c, status;

    if (parser_data->bits & SKIP_SCOMMENT) {
	ever_slip(parser_data);

	c = *(const unsigned char *) parser_data->expression;
    } else {
	const char *e;

	e = parser_data->expression;

	c = *(const unsigned char *) e;
	while (C_TYPE_X(c_type_4, c)) {
	    e++;
	    c = *(const unsigned char *) e;
	}

	parser_data->expression = e;
    }

    do {
	if (c == 0x29) {
	    status = case_cc_8(GET_ATOM__________ARGS_2);
	    if (status) {
	    } else {
		if (parser_data->link_data) {
		} else {
		    break;
		}
	    }
	}

	status = case_seleCtion[parser_data->class_select[c]]
	    (GET_ATOM__________ARGS_2);
    } while (0);

    return status;
}


static int
lead_char(GET_ATOM__________ARGS_1)
{
    const char *e;
    int status = 1;

    e = parser_data->expression;

    e++;

    do {
	int c, f;

	c = *(const unsigned char *) e;
	if (c == '\'') {
	    break;
	} else {
	    if (!c) {
		break;
	    } else {
		if (c != '\\') {
		    f = c;
		} else {
		    e++;

		    c = *(const unsigned char *) e;
		    if (!c) {
			break;
		    } else {
			if (c < '0' || '7' < c) {
			    f = _x1f4_e4_tc_reflex[c];
			} else {
			    f = c - '0';
			    c = ((const unsigned char *) e)[1];
			    if (c < '0' || '7' < c) {
			    } else {
				f <<= 3;
				f |= c - '0';
				e++;
				c = ((const unsigned char *) e)[1];
				if (c < '0' || '7' < c) {
				} else {
				    f <<= 3;
				    f |= c - '0';
				    e++;
				}
			    }
			}
		    }
		}
	    }
	}

	e++;

	c = *(const unsigned char *) e;
	if (c != '\'') {
	    break;
	} else {
	    e++;

	    next_data->class = MODE_CLASS;
	    next_data->data.mode = f;
	    next_data->type = MODE;
	}

	status = 0;
    } while (0);

    if (status) {
	status = _x1f4_e4_081019_error_0(parser_data->back_data);
    }

    parser_data->expression = e;

    return status;
}


static int
lead_mlay(GET_ATOM__________ARGS_1)
{
    const char *e;
    int c, sign = 0, status = 0;

    e = parser_data->expression;

    /*
     * reached only for digits and period, the sign parsing below is
     * superfluous.
     */

    c = *(const unsigned char *) e;
    do {
	if (c == '-') {
	    sign ^= 1;
	} else if (C_TYPE_X(c_type_1, c)) {
	} else {
	    if (parser_data->bits & SKIP_SCOMMENT) {
		if (c ^ 35) {
		    break;
		} else {
		    do {
			++e;
			c = *(const unsigned char *) e;
		    } while (c ^ 10);
		}
	    } else {
		break;
	    }
	}
	e++;
	c = *(const unsigned char *) e;
    } while (1);

    if (c == '.') {
	e++;
	c = *(const unsigned char *) e;
	if (!C_TYPE_X(c_type_2, c)) {
	    status = _x1f4_e4_080704_error_d(parser_data->back_data);
	} else {
	    const char *v;
	    double real = 0;
	    unsigned d;
#if defined double_digits
#elif defined __USE_DOUBLE_MANTISSA_DIGITS__
	    unsigned double_digits;
#endif				/* __double_digits */

	    v = e;

	    do {
		real *= 10;
		real += c - '0';
		e++;
		c = *(const unsigned char *) e;
	    } while (C_TYPE_X(c_type_2, c));

#if defined double_digits
#elif defined __USE_DOUBLE_MANTISSA_DIGITS__
	    double_digits = floor(DBL_MANT_DIG * log(2) / log(10));
#endif				/* __double_digits */

	    d = e - v;

	    if (c == 'r') {
		e++;
	    }

#if defined __USE_DOUBLE_MANTISSA_DIGITS__
	    if (d < double_digits + 1) {
		real /= pow(10, d);
	    } else {
#elif 0
	    }
#else
	    {
#endif				/* __USE_DOUBLE_MANTISSA_DIGITS__ */
		double base = 10;

	        while (d) {
		    if (d & 1) {
			real /= base;
		    }

		    d >>= 1;

		    base *= base;
		}
	    }

	    next_data->class = REAL_CLASS;
	    next_data->type = REAL;
	    next_data->data.real = sign ? -real : real;
	}
    } else {
	if (!C_TYPE_X(c_type_2, c)) {
	    /*
	     * unreached?
	     */
	    status = _x1f4_e4_080704_error_e(parser_data->back_data);
	} else {
#if __USE_XLCARDINAL__
	    int o;
#endif				/* __USE_XLCARDINAL__ */
	    mlay_cardinal integral;

#if !__USE_XLCARDINAL__
	    integral = 0;

	    do {
		integral *= 10;
		integral += c - '0';
		e++;
		c = *(const unsigned char *) e;
	    } while (C_TYPE_X(c_type_2, c));
#else
	    o = *(const unsigned char *) (e + 1);
	    if (C_TYPE_X(c_type_2, o)) {
		const char *v;
		unsigned long cardinal;

		x1f4_parse_xlcardinal(&cardinal, e, &v, 0);
		c = *v;
		if (C_TYPE_X(c_type_3, c)) {
		    c = *(const unsigned char *) e;
		    integral = 0;
		    do {
			integral *= 10;
			integral += c - '0';
			e++;
			c = *(const unsigned char *) e;
		    } while (C_TYPE_X(c_type_2, c));
		} else {
		    e = v;
		    integral = cardinal;
		}
	    } else {
		const char *v;
		unsigned long cardinal;

		v = e;
		x1f4_parse_xlcardinal(&cardinal, e, &e, 0);
		integral = cardinal;
		c = *e;
		if (e != v + 1) {
		    if (c ^ 'i') {
			if (c ^ 'z') {
			    c = 0;
			    if (e != v) {
			    } else {
				e++;
				integral = 0;
			    }
			}
		    }
		}
	    }
#endif				/* !__USE_XLCARDINAL__ */
	    if (c != '.') {
		if (c == 'r') {
		    e++;
		    next_data->class = REAL_CLASS;
		    next_data->type = REAL;
		    next_data->data.real = integral;
		    if (sign) {
			next_data->data.real = -next_data->data.real;
		    }
		} else {
		    if (c == 'z') {
			if (sign) {
			    status = _x1f4_e4_080704_error_4
				(parser_data->back_data);
			} else {
			    e++;
			    next_data->class = BILL_CLASS;
			    next_data->type = BILL;
			    next_data->data.bill = integral;
			}
		    } else {
			if (c == 'i') {
			    e++;
			}
			next_data->class = MODE_CLASS;
			next_data->type = MODE;
			next_data->data.mode = integral;
			if (sign) {
			    next_data->data.mode = -next_data->data.mode;
			}
		    }
		}
	    } else {
		e++;
		c = *(const unsigned char *) e;
		if (!C_TYPE_X(c_type_2, c)) {
		    status = _x1f4_e4_080704_error_d(parser_data->back_data);
		} else {
		    const char *v;
		    double real = 0;
		    unsigned d;
#if defined double_digits
#elif defined __USE_DOUBLE_MANTISSA_DIGITS__
		    unsigned double_digits;
#endif				/* __double_digits */

		    v = e;

		    do {
			real *= 10;
			real += c - '0';
			e++;
			c = *(const unsigned char *) e;
		    } while (C_TYPE_X(c_type_2, c));

#if defined double_digits
#elif defined __USE_DOUBLE_MANTISSA_DIGITS__
		    double_digits = floor(DBL_MANT_DIG * log(2) / log(10));
#endif				/* __double_digits */

		    d = e - v;

		    if (c == 'r') {
			e++;
		    }

#if defined __USE_DOUBLE_MANTISSA_DIGITS__
		    if (d < double_digits + 1) {
			real /= pow(10, d);
		    } else {
#elif 0
		    }
#else
		    {
#endif				/* __USE_DOUBLE_MANTISSA_DIGITS__ */
			double base = 10;

		        while (d) {
			    if (d & 1) {
				real /= base;
			    }

			    d >>= 1;

			    base *= base;
			}
		    }

		    next_data->class = REAL_CLASS;
		    next_data->type = REAL;
		    real += integral;
		    next_data->data.real = real;
		    if (sign) {
			next_data->data.real = -next_data->data.real;
		    }
		}
	    }
	}
    }

    if (status) {
    } else {
	parser_data->expression = e;
    }

    return status;
}


static int
lead_name(GET_ATOM__________ARGS_1)
{
    const char *e, *f;
    int c, status = 0;
    const struct e4_attributes_type *attributes_data;
    unsigned length;

    attributes_data = parser_data->attributes_data;

    e = parser_data->expression;

    f = e;
    do {
	e++;
	c = *(const unsigned char *) e;
    } while (C_TYPE_X(_x1f4_c_type_0, c));
    length = e - parser_data->expression;
    if (parser_data->bits & SKIP_SCOMMENT) {
	parser_data->expression = e;
	ever_slip(parser_data);
	e = parser_data->expression;
	c = *(const unsigned char *) e;
    } else {
	while (C_TYPE_X(c_type_4, c)) {
	    e++;
	    c = *(const unsigned char *) e;
	}
    }
    if (c == '(') {
#if __ALLOW_FUNCTION_POINTERS__
	const struct e4_ever_type *ever_data;
#endif				/* __ALLOW_FUNCTION_POINTERS__ */
	const struct e4_last_type *last_data;
#if __ALLOW_FUNCTION_POINTERS__
	void *state;
#endif				/* __ALLOW_FUNCTION_POINTERS__ */

#if __ALLOW_FUNCTION_POINTERS__
	status = attributes_data->ever_0.get
	    (f, length, attributes_data->ever_0.context, &ever_data,
	     &state);
	if (status) {
#endif				/* __ALLOW_FUNCTION_POINTERS__ */
	    status = attributes_data->last_0.get
		(f, length, attributes_data->last_0.context, &last_data);
	    if (status) {
		status = _x1f4_e4_080704_error_0
		    (parser_data->back_data, f, length);
	    } else {
		if (last_data->bits & (SIDE_LIST | SLIP_LIST)) {
#if __ALLOW_FUNCTION_POINTERS__
		    if (parser_data->e4fine) {
			status = ever_last
			    (GET_ATOM__________ARGS_2, f, length, last_data,
			     state);
		    } else {
#endif				/* __ALLOW_FUNCTION_POINTERS__ */
			status = _x1f4_e4_080704_error_1
			    (parser_data->back_data, f, length);
#if __ALLOW_FUNCTION_POINTERS__
		    }
#endif				/* __ALLOW_FUNCTION_POINTERS__ */
		} else {
		    int type;

		    type = last_data->type;
		    next_data->class = LAST_CLASS;
		    next_data->type = type;
		    next_data->data.last.last_data = last_data;

		    status = case_last(parser_data, expect, type, f, length);
		    if (status) {
		    } else {
			if (last_data->bits & TEXT_LINK) {
			    status = attributes_data->last_0.fix
				(attributes_data->last_0.context,
				 last_data, &next_data->data.last.text);
			}
		    }
		}
	    }
#if __ALLOW_FUNCTION_POINTERS__
	} else {
	    do {
		int type;

		if (ever_data->type < BASE_LOCK) {
		    status = _x1f4_e4_110817_error_0
			(parser_data->back_data, f, length);
		    if (1) {
			break;
		    }
		}

		if (ever_data->bits & UNIVERSAL) {
		    if (parser_data->e4fine) {
			const void *line;

			status = x1f4_pick_e4fine
			    (parser_data->e4fine, ever_data->type, &line);
			if (status) {
			    status = 0;
			    if (1) {
				last_data =
				    &((struct e4_line_type *) line)->last;
			    }
			} else {
			    /*
			     * TODO
			     * fix, not the best error report
			     */
			    status = _x1f4_e4_080704_error_0
				(parser_data->back_data, f, length);
			    if (1) {
				break;
			    }
			}
		    } else {
			/*
			 * TODO
			 * fix, not the best error report
			 */
			status = _x1f4_e4_080704_error_0
			    (parser_data->back_data, f, length);
			if (1) {
			    break;
			}
		    }
		} else {
		    if (ever_data->bits & REFERENCE) {
			void *last;

			/*
			 * no need to check for the REFERENCE flag, as the
			 * state has been set to a function description
			 * pointer
			 */

			last = *(void **) state;

			last_data = &((struct e4_line_type *) last)->last;
		    } else {
			last_data =
			    &((struct e4_line_type *) *(void **) state)->last;
		    }
		}

		type = last_data->type;
		next_data->class = LOCK_CLASS;
		next_data->type = type;
		next_data->data.lock.ever_data = ever_data;
		next_data->data.lock.last_data = last_data;
		next_data->data.lock.state = state;

		status = case_last(parser_data, expect, type, f, length);
	    } while (0);
	}
#endif				/* __ALLOW_FUNCTION_POINTERS__ */
    } else {
	const struct e4_ever_type *ever_data;
	void *state;

	status = attributes_data->ever_0.get
	    (f, length, attributes_data->ever_0.context, &ever_data, &state);
	if (status) {
#if __ALLOW_FUNCTION_POINTERS__
	    if (parser_data->e4fine) {
		const struct e4_last_type *last_data;

		status = attributes_data->last_0.get
		    (f, length, attributes_data->last_0.context, &last_data);
		if (status) {
		    status = _x1f4_e4_080704_error_1
			(parser_data->back_data, f, length);
		} else {
		    status = ever_last
			(GET_ATOM__________ARGS_2, f, length, last_data,
			 state);
		}
	    } else {
#endif				/* __ALLOW_FUNCTION_POINTERS__ */
		status = _x1f4_e4_080704_error_1
		    (parser_data->back_data, f, length);
#if __ALLOW_FUNCTION_POINTERS__
	    }
#endif				/* __ALLOW_FUNCTION_POINTERS__ */
	} else {
	    int type;

	    type = ever_data->type;
	    next_data->class = EVER_CLASS;
	    next_data->type = type;
	    next_data->data.ever.state = state;
	    next_data->data.ever.ever_data = ever_data;

	    status = case_ever(parser_data, expect, type, f, length);
	}
    }

    if (status) {
    } else {
	parser_data->expression = e;
    }

    return status;
}


static int
lead_odb1(GET_ATOM__________ARGS_1)
{
    const char *e, *f;
    int c, status = 0;
    unsigned *e_type_0, length;

    e_type_0 = parser_data->c_type_0;

    e = parser_data->expression;

    f = e;
    do {
	e++;
	c = *(const unsigned char *) e;
    } while (C_TYPE_X(e_type_0, c));
    length = e - f;
    f = e;
    if (1) {
	struct e4_odb1_type *odb1_data;

	status = M_LINK
	    (parser_data, &odb1_data,
	     sizeof(struct e4_odb1_type) + sizeof(struct text_type));
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	    struct text_type *text_data;

	    odb1_data->odb1_data = NULL;

	    if (next_data->class != CAD1_CLASS) {
		next_data->class = CAD1_CLASS;
	    } else {
		odb1_data->odb1_data = next_data->data.odb1_data;
	    }

	    next_data->data.odb1_data = odb1_data;

	    text_data = (struct text_type *) (odb1_data + 1);

	    text_data->data = f;
	    text_data->size = length;

	    parser_data->expression = f;
	}
    }

    return status;
}


static int
lead_odb2(GET_ATOM__________ARGS_1)
{
    const char *e, *f;
    int c, status = 0;
    unsigned *e_type_0, length;

    e_type_0 = parser_data->c_type_0;

    e = parser_data->expression;

    f = e;
    do {
	e++;
	c = *(const unsigned char *) e;
    } while (C_TYPE_X(e_type_0, c));
    length = e - parser_data->expression;
    {
	const struct e4_odbx_type *const *list;

	list = parser_data->attributes_data->odb2_data;
	if (!list) {
	    status = _x1f4_e4_080704_error_h(parser_data->back_data);
	} else {
	    const struct e4_odbx_type *odbx_data;

	    odbx_data = *list;
	    while (odbx_data) {
		if (length == odbx_data->length) {
		    if (memcmp((void *) f, odbx_data->name, length)) {
		    } else {
			break;
		    }
		}
		list++;
		odbx_data = *list;
	    }
	    if (odbx_data) {
		next_data->class = CAD2_CLASS;
		next_data->type = odbx_data->type;
		next_data->data.odbx.odbx_data = odbx_data;
	    } else {
		status = _x1f4_e4_080704_error_j(parser_data->back_data);
	    }
	}
    }

    if (status) {
    } else {
	parser_data->expression = f + length;
    }

    return status;
}


static int
lead_text(GET_ATOM__________ARGS_1)
{
    const char *e, *f;
    int status = 0;
    unsigned count = 0, length = 0;

    e = parser_data->expression;

    e++;

    f = e;

    while (1) {
	int c;

	status = x1f4_size_tcstring(f, &f, &length);
	if (status) {
	    break;
	} else {
	    count++;

	    f++;
	    if (parser_data->bits & SKIP_SCOMMENT) {
		parser_data->expression = f;
		ever_slip(parser_data);
		f = parser_data->expression;
		c = *(const unsigned char *) f;
	    } else {
		c = *(const unsigned char *) f;
		while (C_TYPE_X(c_type_4, c)) {
		    f++;
		    c = *(const unsigned char *) f;
		}
	    }

	    if (c ^ '"') {
		break;
	    } else {
		f++;
	    }
	}
    }

    if (status) {
	status = _x1f4_e4_080704_error_f(parser_data->back_data);
    } else {
	char *string;

	status = M_LINK(parser_data, &string, length + 1);
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	    next_data->class = TEXT_CLASS;
	    next_data->type = TEXT;
	    next_data->data.text = string;

	    for (; count;) {
		x1f4_copy_tcstring(&string, &e);
		count--;
		if (count) {
		    if (parser_data->bits & SKIP_SCOMMENT) {
			parser_data->expression = e;
			ever_slip(parser_data);
			e = parser_data->expression;
		    } else {
			int c;

			c = *(const unsigned char *) e;
			while (C_TYPE_X(c_type_4, c)) {
			    e++;
			    c = *(const unsigned char *) e;
			}
		    }

		    e++;
		}
	    }

	    parser_data->expression = e;
	}
    }

    return status;
}


static int
link_data(struct parser_type *parser_data)
{
    int status;
    struct e4_expression_type *expression_data;

    expression_data = parser_data->expression_data;
    status = _x1f4_e4_link_hack
	(&expression_data->hack_data, &expression_data->type,
	 &expression_data->load, parser_data);
    if (status) {
    } else {
	unsigned max_list_length, max_post_length;

	_x1f4_e4_fast_miss
	    (&expression_data->hack_data, 0, &expression_data->load);

	expression_data->state = 1;

	_x1f4_e4_size_expression
	    (expression_data, &max_list_length, &max_post_length);

	if (parser_data->bits & EXTERN_STACKS) {
	    const struct e4_attributes_type *attributes_data;
	    unsigned svth, *sxxx;

	    attributes_data = parser_data->attributes_data;

	    expression_data->post_size = max_post_length;
	    sxxx = attributes_data->link_s.s1st;
	    svth = sizeof(struct e4_post_type) * max_post_length;
	    if (*sxxx < svth) {
		*sxxx = svth;
	    }
	    expression_data->list_size = max_list_length;
	    sxxx = attributes_data->link_s.s2nd;
	    svth = sizeof(void *) * max_list_length;
	    if (*sxxx < svth) {
		*sxxx = svth;
	    }

	    expression_data->bits |= EXTERN_STACKS_MESS;
	} else {
	    status = M_LINK
		(parser_data, &expression_data->post_data,
		 sizeof(struct e4_post_type) * max_post_length);
	    if (status) {
		status = ALLOC_ERROR;
	    } else {
		expression_data->post_size = max_post_length;
		if (!max_list_length) {
		    expression_data->list = NULL;
		    expression_data->list_size = 0;
		} else {
		    status = M_LINK(parser_data, &expression_data->list,
				    sizeof(void *) * max_list_length);
		    if (status) {
			status = ALLOC_ERROR;
		    } else {
			expression_data->list_size = max_list_length;
		    }
		}
	    }
	}
    }

    return status;
}


static int
make_atom(struct e4_hack_type *hack_data, struct e4_atom_type **atom,
	  struct parser_type *parser_data)
{
    int status = 0;
    unsigned count;

    count = hack_data->count;
    if (count & ((count - 1) | 7)) {
	struct e4_atom_type *atom_data;

	atom_data = (struct e4_atom_type *) hack_data->atoms + count;
	*atom = atom_data;
	parser_data->atom_data = atom_data;
	hack_data->count++;
    } else {
	unsigned class;

	class = count ? count << 1 : 8;
	status = M_MODE(parser_data, &hack_data->atoms,
		        class * sizeof(struct e4_atom_type));
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	    struct e4_atom_type *atom_data;
	    unsigned i;

	    atom_data = hack_data->atoms;

	    atom_data += count;
	    hack_data->count++;
	    *atom = atom_data;
	    parser_data->atom_data = atom_data;
	    for (i = class - count; i; i--) {
		atom_data->type = MODE;
		atom_data->odb1 = NULL;
		atom_data++;
	    }
	}
    }

    return status;
}


static int
make_hack(struct e4_hack_type **hack, struct parser_type *parser_data)
{
    int status;
    struct e4_hack_type *hack_data;

    status = M_LINK(parser_data, &hack_data, sizeof(struct e4_hack_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	unsigned i;

	*hack = hack_data;
	for (i = 1; i; i--) {
	    hack_data->count = 0;
	    hack_data->atoms = NULL;
	    hack_data->bits = READ_ONLY;
	    hack_data++;
	}
    }

    return status;
}


static int
make_list(struct e4_hack_type **hack, const struct e4_last_type *last_data,
	  struct parser_type *parser_data, unsigned offset)
{
#define BACK_HACK(count, excess) \
    (offset + (count) * (sizeof(struct e4_hack_type)			      \
			 + sizeof(int (*) (x1f4_e4_LOAD_ARGS_0))))

    int status;
    struct e4_hack_type *hack_data;
    unsigned count;

    count = last_data->count;

    status = M_LINK(parser_data, &hack_data, BACK_HACK(count, excess));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	unsigned i;

	parser_data->offset = offset;

	hack_data = (struct e4_hack_type *) ((char *) hack_data + offset);

	*hack = hack_data;
	for (i = count; i; i--) {
	    hack_data->count = 0;
	    hack_data->atoms = NULL;
	    hack_data->bits = READ_ONLY;
	    hack_data++;
	}
    }

    return status;

#undef BACK_HACK
}


static int
near_side(struct parser_type *parser_data)
{
    int status;
    struct e4_hack_type *hack_data;

    hack_data = parser_data->hack_data;

    do {
	const struct e4_last_type *last_data;
	struct link_type *link_data;
	unsigned class, frame, offset;
	void *hack;

	link_data = parser_data->link_data;
	last_data = link_data->last_data;

	frame = link_data->frame;

	if (frame == last_data->count) {
	} else {
	    if ((frame & (frame - 1)) | (frame < 8)) {
		link_data->frame = frame + 1;

		hack_data->count = 0;
		hack_data->atoms = NULL;
		hack_data->bits = READ_ONLY;

		status = 0;

		break;
	    }
	}

	offset = link_data->offset;

	hack = (char *) (hack_data - frame) - offset;

#define BACK_HACK(count, excess) \
    (offset + (count) * (sizeof(struct e4_hack_type)			      \
			 + sizeof(int (*) (x1f4_e4_LOAD_ARGS_0))))

	if (frame & (frame - 1)) {
	    class = frame | frame >> 001;
	    class = class | class >> 002;
	    class = class | class >> 004;
	    class = class | class >> 010;
	    class = class | class >> 020;
	    class = frame << 1 & ~class;
	} else {
	    class = frame << 1;
	}
	if (class < 8) {
	    class = 8;
	}

	status = M_MODE(parser_data, &hack, BACK_HACK(class, excess));
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	    link_data->frame = frame + 1;

	    hack_data = (struct e4_hack_type *) ((char *) hack + offset);

	    link_data->atom_data->data.last.base = hack_data;

	    hack_data += frame;

	    hack_data->count = 0;
	    hack_data->atoms = NULL;
	    hack_data->bits = READ_ONLY;
	}

#undef BACK_HACK

	parser_data->hack_data = hack_data;
    } while (0);

    return status;
}


static int
pick_atom(int *type, int *miss, struct e4_atom_type **atom,
	  struct e4_atom_type *atom_data, struct parser_type *parser_data)
{
    int status = 0;

#if 0
    if (atom_data->odb1) {
	/*
	 * Not really, no.  Don't want this.  Parentheses should have higher
	 * priority.
	 */
	struct e4_hack_type hack;

	hack.count = 1;
	hack.atoms = atom_data;
	status = pick_this(type, miss, atom, &hack, parser_data);
    } else {
#elif 0
    }
#else
    {
#endif				/* 0 */
	int pick;

	pick = atom_data->type;
	if (1 << pick & LOGIC_BITS) {
	    *atom = NULL;
	    *miss = 0;
	    *type = last_base(atom_data)->last_data->type;
	} else {
	    if (pick == THIS) {
		status = pick_this
		    (type, miss, atom, atom_data->data.hack.data, parser_data);
	    } else {
		if (pick == EVER) {
		    *atom = atom_data;
		    *miss = 1;
		    *type = atom_data->data.ever.ever_data->type;
		} else {
		}
	    }
	}
    }

    return status;
}


static int
pick_this(int *type, int *miss, struct e4_atom_type **atom,
	  struct e4_hack_type *hack_data, struct parser_type *parser_data)
{
    int status;
    struct e4_atom_type *atom_data;
    unsigned count;

    do {
	atom_data = hack_data->atoms;

	count = hack_data->count;
	if (count ^ 1) {
	} else {
	    if (atom_data->odb1) {
	    } else {
		if (atom_data->odb2._1st) {
		} else {
		    status =
			pick_atom(type, miss, atom, atom_data, parser_data);
		    if (1) {
			break;
		    }
		}
	    }
	}

	status = _x1f4_e4_type_hack(hack_data, type, parser_data);
	if (status) {
	} else {
	    *atom = NULL;
	    *miss = 0;
	}
    } while (0);

    return status;
}


static int
push_hack(struct link_type **link, struct e4_hack_type *hack_data, int class,
	  struct parser_type *parser_data)
{
    int status;
    struct link_type *link_data;

    status = M_LINK(parser_data, &link_data, sizeof(struct link_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	link_data->class = class;
	link_data->link_data = *link;
	link_data->data = hack_data;
	*link = link_data;
    }

    return status;
}


static int
set_bill(SET_NEXT__________ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;
    struct e4_hack_type *hack_data;

    hack_data = parser_data->hack_data;
    status = make_atom(hack_data, &atom_data, parser_data);
    if (status) {
    } else {
	C_BILL *slip;

	atom_data->type = BILL;
	slip = (C_BILL *) &atom_data->data.lead.data;
	*slip = next_data->data.bill;

	if (parser_data->odb1_data) {
	    atom_data->odb1 = parser_data->odb1_data;
	    parser_data->odb1_data = NULL;
	}

	if (parser_data->argument) {
	} else {
	    parser_data->expression_data->type = BILL;
	}

	{
	    struct link_type *link_data;

	    link_data = parser_data->link_data;
	    if (link_data) {
		if (parser_data->argument) {
		} else {
		    link_data->class = DATA_CLASS;
		}
	    }
	}

	*expect = parser_data->link_class;
    }

    return status;
}


static int
set_dana(const struct e4_last_type *last_data,
	 const struct e4_ever_type *ever_data, void *state,
	 struct parser_type *parser_data)
{
    int status;
    struct e4_atom_type *atom_data;
    void *odb1;

    atom_data = parser_data->atom_data;

    odb1 = atom_data->odb1;
    atom_data->odb1 = NULL;

    _x1f4_e4_free_atom(atom_data, parser_data->expression_data);

    atom_data->odb1 = odb1;

    if (0) {
    } else {
	struct e4_hack_type *arguments;

	status = make_list
	    (&arguments, last_data, parser_data,
	     sizeof(struct e4_base_type) + sizeof(struct e4_fine_type));
	if (status) {
	    atom_data->type = MODE;
	} else {
	    struct e4_fine_type *fine_data;
	    int type;

	    fine_data = hack_fine(arguments);

	    fine_data->ever_data = ever_data;
	    fine_data->line = state;

	    hack_base(arguments)->last_data = last_data;

	    atom_data->odb2._1st = NULL;
	    atom_data->type = LOCK;
	    atom_data->data.last.base = arguments;

	    if (parser_data->odb1_data) {
		atom_data->odb1 = parser_data->odb1_data;
		parser_data->odb1_data = NULL;
	    }

	    type = last_data->type;

	    if (parser_data->argument) {
	    } else {
		parser_data->expression_data->type = type;
	    }

	    {
		struct link_type *link_data;

		link_data = parser_data->link_data;
		if (link_data) {
		    if (parser_data->argument) {
		    } else {
			if (type == VOID) {
			    /*
			     * VOID_CLASS maybe?
			     */
			    link_data->class = LIST_CLASS;
			} else {
			    link_data->class = DATA_CLASS;
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
set_ever(SET_NEXT__________ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;
    struct e4_hack_type *hack_data;

    hack_data = parser_data->hack_data;
    status = make_atom(hack_data, &atom_data, parser_data);
    if (status) {
	M_FREE(parser_data, next_data->data.text);
    } else {
	atom_data->type = EVER;
	atom_data->data.ever.state = next_data->data.ever.state;
	atom_data->data.ever.ever_data = next_data->data.ever.ever_data;

	if (parser_data->odb1_data) {
	    atom_data->odb1 = parser_data->odb1_data;
	    parser_data->odb1_data = NULL;
	}

	{
	    struct link_type *link_data;

	    link_data = parser_data->link_data;
	    if (link_data) {
		if (parser_data->argument) {
		} else {
		    link_data->class = DATA_CLASS;
		}
	    }
	}

	*expect = parser_data->link_class;
    }

    return status;
}


static int
set_join(struct next_type *next_data, const struct e4_last_type *last_data,
	 struct parser_type *parser_data)
{
    int status;

    do {
	if (last_data->type == VOID) {
	    struct e4_atom_type *atom_data;
	    struct e4_hack_type *hack_data;
	    unsigned count;

	    hack_data = parser_data->hack_data;

	    atom_data = hack_data->atoms;
	    atom_data++;

	    count = hack_data->count - 1;
	    for (; count; count--) {
		if (atom_data->type ^ PICK) {
		    status = _x1f4_e4_130704_error_0(parser_data->back_data);
		    if (1) {
			break;
		    }
		} else {
		    atom_data++;
		}
	    }
	    if (count) {
		break;
	    }
	}

	status = set_pick(next_data, last_data, parser_data);
    } while (0);

    return status;
}


static int
set_last(SET_NEXT__________ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;
    struct e4_hack_type *hack_data;

    hack_data = parser_data->hack_data;
    status = make_atom(hack_data, &atom_data, parser_data);
    if (status) {
    } else {
	struct e4_hack_type *arguments;
	const struct e4_last_type *last_data;

	last_data = next_data->data.last.last_data;

	status = make_list
	    (&arguments, last_data, parser_data, sizeof(struct e4_base_type));
	if (status) {
	} else {
	    int type;

	    atom_data->odb2._1st = NULL;
	    atom_data->type = LAST;
	    atom_data->data.last.base = arguments;
	    hack_base(arguments)->last_data = last_data;

	    if (last_data->bits & TEXT_LINK) {
		hack_base(arguments)->text = next_data->data.last.text;
	    }

	    if (parser_data->odb1_data) {
		atom_data->odb1 = parser_data->odb1_data;
		parser_data->odb1_data = NULL;
	    }

	    type = last_data->type;

	    if (parser_data->argument) {
	    } else {
		parser_data->expression_data->type = type;
	    }

	    {
		struct link_type *link_data;

		link_data = parser_data->link_data;
		if (link_data) {
		    if (parser_data->argument) {
		    } else {
			if (type == VOID) {
			    /*
			     * VOID_CLASS maybe?
			     */
			    link_data->class = LIST_CLASS;
			} else {
			    link_data->class = DATA_CLASS;
			}
		    }
		}
	    }

	    *expect = OPEN_CLASS;
	}
    }

    return status;
}


static int
set_lock(SET_NEXT__________ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;
    struct e4_hack_type *hack_data;

    hack_data = parser_data->hack_data;
    status = make_atom(hack_data, &atom_data, parser_data);
    if (status) {
    } else {
	struct e4_hack_type *arguments;
	const struct e4_last_type *last_data;

	last_data = next_data->data.lock.last_data;

	status = make_list
	    (&arguments, last_data, parser_data,
	     sizeof(struct e4_base_type) + sizeof(struct e4_fine_type));
	if (status) {
	} else {
	    struct e4_fine_type *fine_data;
	    int type;

	    fine_data = hack_fine(arguments);

	    fine_data->ever_data = next_data->data.lock.ever_data;
	    fine_data->line = next_data->data.lock.state;

	    hack_base(arguments)->last_data = last_data;

	    atom_data->odb2._1st = NULL;
	    atom_data->type = LOCK;
	    atom_data->data.last.base = arguments;

	    if (parser_data->odb1_data) {
		atom_data->odb1 = parser_data->odb1_data;
		parser_data->odb1_data = NULL;
	    }

	    type = last_data->type;

	    if (parser_data->argument) {
	    } else {
		parser_data->expression_data->type = type;
	    }

	    {
		struct link_type *link_data;

		link_data = parser_data->link_data;
		if (link_data) {
		    if (parser_data->argument) {
		    } else {
			if (type == VOID) {
			    /*
			     * VOID_CLASS maybe?
			     */
			    link_data->class = LIST_CLASS;
			} else {
			    link_data->class = DATA_CLASS;
			}
		    }
		}
	    }

	    *expect = OPEN_CLASS;
	}
    }

    return status;
}


static int
set_lose(SET_NEXT__________ARGS_1)
{
    int class, status = 0;
    struct e4_atom_type *atom_data;
    struct e4_hack_type *hack_data, *past_hack;
    const struct e4_last_type *last_data;
    struct link_type *link_data;
    unsigned bits, frame;

    hack_data = parser_data->hack_data;
    link_data = parser_data->link_data;

    past_hack = hack_data;

    last_data = link_data->last_data;

    class = link_data->class;

    frame = link_data->frame;

    join_hack(&link_data, &hack_data, parser_data);

    {
	if (last_data) {
	    parser_data->argument--;
	    if (parser_data->bits & PACK_ESTORAGE) {
		if (last_data->count) {
		    M_MODE(parser_data, &past_hack->atoms,
			   past_hack->count * sizeof(struct e4_atom_type));
		}
	    }

	    bits = last_data->bits;
	} else {
	    if (past_hack->count ^ 1) {
	    } else {
		((struct e4_atom_type *) past_hack->atoms)->odb2._1st = NULL;
	    }

	    if (1) {
		if (parser_data->bits & PACK_ESTORAGE) {
		    M_MODE(parser_data, &past_hack->atoms,
			   past_hack->count * sizeof(struct e4_atom_type));
		}
	    }

	    bits = 0;
	}
    }

    if (link_data) {
	if (link_data->last_data) {
	    /*
	     * 0 is allowed for variadic functions with no mandatory arguments
	     */
	    if (link_data->count < 2) {
		link_data->class = class;
		if (class == DATA_CLASS) {
		    *expect = JOIN_CLASS;
		    parser_data->link_class = JOIN_CLASS;
		} else {
		    *expect = LOSE_CLASS;
		}
	    } else {
		parser_data->link_class = POST_CLASS;
		*expect = POST_CLASS;
	    }
	} else {
	    link_data->class = class;
	    if (class == DATA_CLASS) {
		*expect = JOIN_CLASS;
		parser_data->link_class = JOIN_CLASS;
	    } else {
		*expect = LOSE_CLASS;
	    }
	}
    } else {
	int type;

	type = parser_data->expression_data->type;
	if (type == VOID) {
	    *expect = DONE_CLASS;
	} else {
	    parser_data->link_class = NEXT_CLASS;
	    *expect = NEXT_CLASS;
	}
    }

    parser_data->hack_data = hack_data;
    parser_data->link_data = link_data;

    atom_data = hack_data->atoms;
    atom_data += hack_data->count - 1;

    parser_data->atom_data = atom_data;

    if (1) {
	if (bits & (SIDE_LIST | SLIP_LIST)) {
	    status = case_side(atom_data, frame, last_data, parser_data);
	}
    }

    return status;
}


static int
set_mode(SET_NEXT__________ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;
    struct e4_hack_type *hack_data;

    hack_data = parser_data->hack_data;
    status = make_atom(hack_data, &atom_data, parser_data);
    if (status) {
    } else {
	C_MODE *slip;

	atom_data->type = MODE;
	slip = (C_MODE *) &atom_data->data.lead.data;
	*slip = next_data->data.mode;

	if (parser_data->odb1_data) {
	    atom_data->odb1 = parser_data->odb1_data;
	    parser_data->odb1_data = NULL;
	}

	if (parser_data->argument) {
	} else {
	    parser_data->expression_data->type = MODE;
	}

	{
	    struct link_type *link_data;

	    link_data = parser_data->link_data;
	    if (link_data) {
		if (parser_data->argument) {
		} else {
		    link_data->class = DATA_CLASS;
		}
	    }
	}

	*expect = parser_data->link_class;
    }

    return status;
}


static int
set_odb1(SET_NEXT__________ARGS_1)
{
    parser_data->odb1_data = next_data->data.odb1_data;

    *expect = DATA_CLASS;

    if (parser_data->argument) {
    } else {
	parser_data->expression_data->type = REAL;
    }

    {
	struct link_type *link_data;

	link_data = parser_data->link_data;
	if (link_data) {
	    if (parser_data->argument) {
	    } else {
		link_data->class = DATA_CLASS;
	    }
	}
    }

    return 0;
}


static int
set_odb2(SET_NEXT__________ARGS_1)
{
    struct e4_atom_type *atom_data;

    atom_data = parser_data->atom_data;

    atom_data->odb2._1st = next_data->data.odbx.odbx_data;

    *expect = DATA_CLASS;

    return 0;
}


static int
set_open(SET_NEXT__________ARGS_1)
{
    int status;

    do {
	int class;
	struct e4_hack_type *hack_data;
	struct link_type *link_data;
	unsigned count;

	hack_data = parser_data->hack_data;
	link_data = parser_data->link_data;

	if (link_data) {
	    if (link_data->last_data) {
		class = DATA_CLASS;
	    } else {
		class = link_data->class;
	    }
	} else {
	    int type;

	    type = parser_data->expression_data->type;
	    if (type == UNDEFINED) {
		class = HACK_CLASS;
	    } else {
		class = DATA_CLASS;
	    }
	}
	count = hack_data->count;
	if (count) {
	    struct e4_atom_type *atom_data;

	    atom_data = parser_data->atom_data;

	    if (1 << atom_data->type & LOGIC_BITS && !atom_data->odb2._1st) {
		const struct e4_last_type *last_data;

		status = push_hack(&link_data, hack_data, class, parser_data);
		if (status) {
		    break;
		}

		hack_data = atom_data->data.last.base;

		last_data = hack_base(hack_data)->last_data;

		link_data->atom_data = atom_data;
		link_data->last_data = last_data;
		link_data->count = last_data->count;
		link_data->frame = last_data->count;
		link_data->offset = parser_data->offset;

		parser_data->argument++;

		parser_data->hack_data = hack_data;
		parser_data->link_data = link_data;

		atom_data = hack_data->atoms;
		parser_data->atom_data = atom_data + hack_data->count - 1;

		if (!last_data->count) {
		    if (last_data->bits & SIDE_LIST) {
			*expect = DATA_CLASS;
			parser_data->link_class = JOIN_CLASS;
			status = near_side(parser_data);
			if (1) {
			    break;
			}
		    } else {
			*expect = LOSE_CLASS;
		    }
		} else {
		    *expect = DATA_CLASS;
		    if (last_data->count == 1) {
			parser_data->link_class = JOIN_CLASS;
		    } else {
			parser_data->link_class = POST_CLASS;
		    }
		}

		break;
	    }
	}
	*expect = class;
	{
	    struct e4_atom_type *atom_data;
	    struct e4_hack_type *arguments;

	    status = make_atom(hack_data, &atom_data, parser_data);
	    if (status) {
	    } else {
		status = make_hack(&arguments, parser_data);
		if (status) {
		} else {
		    atom_data->data.hack.data = arguments;
		    atom_data->type = THIS;

		    if (parser_data->odb1_data) {
			atom_data->odb1 = parser_data->odb1_data;
			parser_data->odb1_data = NULL;
		    }

		    status = push_hack
			(&link_data, hack_data, class, parser_data);
		    if (status) {
			M_FREE(parser_data, arguments);
			break;
		    }

#if 0
		    link_data->atom_data = NULL;
#endif				/* 0 */
		    link_data->count = 0;
		    link_data->last_data = NULL;

		    hack_data = arguments;

		    parser_data->hack_data = hack_data;
		    parser_data->link_data = link_data;

		    if (class == LIST_CLASS) {
			parser_data->link_class = LOSE_CLASS;
		    } else {
			parser_data->link_class = JOIN_CLASS;
		    }

		    atom_data = hack_data->atoms;
		    parser_data->atom_data = atom_data + hack_data->count - 1;
		}
	    }
	}
    } while (0);

    return status;
}


static int
set_pick(struct next_type *next_data, const struct e4_last_type *last_data,
	 struct parser_type *parser_data)
{
    int status;
    struct e4_atom_type *atom_data;
    struct e4_hack_type *hack_data;

    hack_data = parser_data->hack_data;
    status = make_atom(hack_data, &atom_data, parser_data);
    if (status) {
    } else {
	struct e4_hack_type *arguments;

	status = make_list
	    (&arguments, last_data, parser_data,
	     sizeof(struct e4_base_type) + sizeof(struct e4_near_type));
	if (status) {
	} else {
	    int type;

	    hack_base(arguments)->last_data = last_data;

	    atom_data->odb2._1st = NULL;
	    atom_data->type = PICK;

	    atom_data->data.last.base = arguments;

	    if (parser_data->odb1_data) {
		atom_data->odb1 = parser_data->odb1_data;
		parser_data->odb1_data = NULL;
	    }

	    type = last_data->type;

	    if (parser_data->argument) {
	    } else {
		parser_data->expression_data->type = type;
	    }

	    (atom_data - 1)->odb2._1st = _x1f4_e4_pick;

	    {
		struct link_type *link_data;

		link_data = parser_data->link_data;
		if (link_data) {
		    if (parser_data->argument) {
		    } else {
			if (type == VOID) {
			    /*
			     * VOID_CLASS maybe?
			     */
			    link_data->class = LIST_CLASS;
			} else {
			    link_data->class = DATA_CLASS;
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
set_real(SET_NEXT__________ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;
    struct e4_hack_type *hack_data;

    hack_data = parser_data->hack_data;
    status = make_atom(hack_data, &atom_data, parser_data);
    if (status) {
    } else {
	C_REAL *slip;

	atom_data->type = REAL;
	slip = (C_REAL *) &atom_data->data.lead.data;
	*slip = next_data->data.real;

	if (parser_data->odb1_data) {
	    atom_data->odb1 = parser_data->odb1_data;
	    parser_data->odb1_data = NULL;
	}

	if (parser_data->argument) {
	} else {
	    parser_data->expression_data->type = REAL;
	}

	{
	    struct link_type *link_data;

	    link_data = parser_data->link_data;
	    if (link_data) {
		if (parser_data->argument) {
		} else {
		    link_data->class = DATA_CLASS;
		}
	    }
	}

	*expect = parser_data->link_class;
    }

    return status;
}


static int
set_side(SET_NEXT__________ARGS_1)
{
    struct e4_hack_type *hack_data;

    hack_data = parser_data->hack_data;

    *expect = DATA_CLASS;
    if (1) {
	parser_data->link_class = JOIN_CLASS;
    }

    if (parser_data->bits & PACK_ESTORAGE) {
	M_MODE(parser_data, &hack_data->atoms,
	       hack_data->count * sizeof(struct e4_atom_type));
    }

    hack_data++;

    parser_data->hack_data = hack_data;

    return near_side(parser_data);
}


static int
set_step(SET_NEXT__________ARGS_1)
{
    unsigned count;
    struct e4_hack_type *hack_data;
    struct link_type *link_data;
    hack_data = parser_data->hack_data;

    link_data = parser_data->link_data;
    count = link_data->count;
    count--;
    link_data->count = count;
    *expect = DATA_CLASS;
    if (count == 1) {
	parser_data->link_class = JOIN_CLASS;
    } else {
	parser_data->link_class = POST_CLASS;
    }

    if (parser_data->bits & PACK_ESTORAGE) {
	M_MODE(parser_data, &hack_data->atoms,
	       hack_data->count * sizeof(struct e4_atom_type));
    }

    hack_data++;

    parser_data->hack_data = hack_data;

    return 0;
}


static int
set_text(SET_NEXT__________ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;
    struct e4_hack_type *hack_data;

    hack_data = parser_data->hack_data;
    status = make_atom(hack_data, &atom_data, parser_data);
    if (status) {
	M_FREE(parser_data, next_data->data.text);
    } else {
	C_TEXT *slip;

	atom_data->type = TEXT;
	slip = (C_TEXT *) &atom_data->data.lead.data;
	*slip = next_data->data.text;

	if (parser_data->odb1_data) {
	    atom_data->odb1 = parser_data->odb1_data;
	    parser_data->odb1_data = NULL;
	}

	if (parser_data->argument) {
	} else {
	    parser_data->expression_data->type = TEXT;
	}

	{
	    struct link_type *link_data;

	    link_data = parser_data->link_data;
	    if (link_data) {
		if (parser_data->argument) {
		} else {
		    link_data->class = DATA_CLASS;
		}
	    }
	}

	*expect = parser_data->link_class;
    }

    return status;
}


static void
ever_slip(struct parser_type *parser_data)
{
    const char *e;

    e = parser_data->expression;

    while (1) {
	int c;

	c = *(const unsigned char *) e;
	if (C_TYPE_X(c_type_4, c)) {
	    e++;
	} else {
	    if (c ^ 35) {
		break;
	    } else {
		do {
		    ++e;
		    c = *(const unsigned char *) e;
		} while (c ^ 10);
	    }
	}
    }

    parser_data->expression = e;
}


static void
fill_data(struct parser_type *parser_data)
{
    unsigned *e_type_0;
    unsigned char *selection;

    selection = parser_data->class_select;

    memset(selection, 0, 256);

    fill_type(selection, _x1f4_c_type_1, 1);
    fill_type(selection, c_type_6, 2);

    selection['"'] = 3;
    selection[')'] = 4;
    selection[','] = 5;
    selection['('] = 6;

    selection[047] = 9;

    e_type_0 = parser_data->c_type_0;

    e_type_0[0] = c_type_0[0];
    e_type_0[1] = c_type_0[1];
    e_type_0[2] = c_type_0[2];
    e_type_0[3] = c_type_0[3];
    e_type_0[4] = c_type_0[4];
    e_type_0[5] = c_type_0[5];
    e_type_0[6] = c_type_0[6];
    e_type_0[7] = c_type_0[7];

    if (parser_data->bits & SKIP_SCOMMENT) {
	e_type_0[1] &= ~8;
    }

    fill_type(selection, e_type_0, 7);

    selection[((unsigned) parser_data->terminator) & 255] = 8;

    parser_data->slip = lead_atom;
    if (parser_data->bits & SUIT_SLIPTEST) {
	if (parser_data->completion == BACK_COMPLETION) {
	    parser_data->slip = lead_back;
	}
    }
}


static void
fill_type(unsigned char *selection, const unsigned *c_type_x, unsigned class)
{
    unsigned c = 0;

    for (; c < 256; c++) {
	if (C_TYPE_X(c_type_x, c)) {
	    selection[c] = class;
	}
    }
}


static void
free_lock(struct parser_type *parser_data)
{
    struct e4_expression_type *expression_data;
    struct link_type *link_data;

    expression_data = parser_data->expression_data;

    link_data = parser_data->link_data;
    while (link_data) {
	const struct e4_last_type *last_data;
	struct link_type *free_link;

	last_data = link_data->last_data;
	if (last_data) {
	    unsigned count, frame;

	    count = last_data->count;
	    frame = link_data->frame - count;
	    if (frame) {
		struct e4_hack_type *hack_data;

		hack_data = link_data->atom_data->data.last.base;
		hack_data += count;
		for (; frame; frame--) {
		    _x1f4_e4_free_hack(hack_data, expression_data);
		    hack_data++;
		}
	    }
	}

	free_link = link_data;
	link_data = link_data->link_data;
	M_FREE(parser_data, free_link);
    }
}


static void
free_odb1(struct e4_odb1_type *odb1_data, void *expression)
{
    while (odb1_data) {
	struct e4_odb1_type *free_odb1;

	free_odb1 = odb1_data;
	odb1_data = odb1_data->odb1_data;
	E_FREE(expression, free_odb1);
    }
}


static void
join_hack(struct link_type **link, struct e4_hack_type **hack,
	  struct parser_type *parser_data)
{
    struct link_type *link_data;

    link_data = *link;
    *hack = link_data->data;
    *link = link_data->link_data;

    M_FREE(parser_data, link_data);
}


int
x1f4_inIt_expression(struct e4_expression_type **expression,
		     const char **expressIon, unsigned bits,
		     const struct e4_attributes_type *attributes_data)
{
    int status;
    struct e4_expression_type *expression_data;
    struct parser_type parser_data;

    if (bits & RESOURCE_LINK) {
	parser_data.m.data = attributes_data->link_m.data;
	parser_data.m.free = attributes_data->link_m.free;
	parser_data.m.link = attributes_data->link_m.link;
	parser_data.m.mode = attributes_data->link_m.mode;
    } else {
	parser_data.m.free = _x1f4_e4_free_data;
	parser_data.m.link = _x1f4_e4_link_data;
	parser_data.m.mode = _x1f4_e4_mode_data;
    }

    status = parser_data.m.link
	(parser_data.m.data, (void *) &expression_data,
	 sizeof(struct e4_expression_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	if (bits & DIRECT_ACCESS) {
	    expression_data->bits = DIRECT_DATA_ACCESS;
	} else {
	    expression_data->bits = 0;
	}

	if (bits & ERROR_STORAGE) {
	    parser_data.back_data = attributes_data->link_e.back;
	} else {
	    parser_data.back_data = NULL;
	}

	if (bits & TRANSFER_LINK) {
	    parser_data.e4fine = attributes_data->link_i.fine;
	} else {
	    parser_data.e4fine = NULL;
	}

	expression_data->flat_data = NULL;
	expression_data->hack_data.count = 0;
	expression_data->hack_data.atoms = NULL;
	expression_data->list = NULL;
	expression_data->m.data = parser_data.m.data;
	expression_data->m.free = parser_data.m.free;
	expression_data->m.link = parser_data.m.link;
	expression_data->m.mode = parser_data.m.mode;
	expression_data->state = 0;
	expression_data->post_data = NULL;
	expression_data->type = UNDEFINED;
	parser_data.attributes_data = attributes_data;
	parser_data.completion = attributes_data->completion;
	parser_data.expression = *expressIon;
	parser_data.expression_data = expression_data;
	parser_data.bits = bits;
	parser_data.hack_data = &expression_data->hack_data;
	parser_data.terminator = attributes_data->terminator;
	fill_data(&parser_data);
	status = init_data(&parser_data);
	if (status) {
	    x1f4_fini_expression(&expression_data);
	} else {
	    *expression = expression_data;
	}

	*expressIon = parser_data.expression;
    }

    return status;
}
