/*
 * e4.5.c
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-defs.h>
#include <e4-types.h>

#define I_BILL(i)			(*((C_BILL *) (i)))
#define I_MODE(i)			(*((C_MODE *) (i)))
#define I_REAL(r)			(*((C_REAL *) (r)))

#define l_BILL(e, output) \
    {									      \
	C_BILL *l;							      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }
#define l_MODE(e, output) \
    {									      \
	C_MODE *l;							      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }
#define l_REAL(e, output) \
    {									      \
	C_REAL *l;							      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

static int mbill(x1f4_e4_LINE_ARGS_0);
static int rbill(x1f4_e4_LINE_ARGS_0);
static int bmode(x1f4_e4_LINE_ARGS_0);
static int rmode(x1f4_e4_LINE_ARGS_0);
static int breal(x1f4_e4_LINE_ARGS_0);
static int mreal(x1f4_e4_LINE_ARGS_0);

static const int c_____b__[] = {
/* *INDENT-OFF* */
    BILL
/* *INDENT-ON* */
}, c_____m__[] = {
/* *INDENT-OFF* */
    MODE
/* *INDENT-ON* */
}, c_____r__[] = {
/* *INDENT-OFF* */
    REAL
/* *INDENT-ON* */
};

const struct e4_odbx_type _x1f4_e4_implicit[] = {
/* *INDENT-OFF* */
    {	"(cardinal) ",		mbill,		0000,
	BILL,			c_____m__,	0,
	11,			NULL,		NULL		},
    {	"(cardinal) ",		rbill,		0000,
	BILL,			c_____r__,	0,
	11,			NULL,		NULL		},
    {	"(mode) ",		bmode,		0000,
	MODE,			c_____b__,	0,
	7,			NULL,		NULL		},
    {	"(mode) ",		rmode,		0000,
	MODE,			c_____r__,	0,
	7,			NULL,		NULL		},
    {	"(real) ",		breal,		0000,
	REAL,			c_____b__,	0,
	7,			NULL,		NULL		},
    {	"(real) ",		mreal,		0000,
	REAL,			c_____m__,	0,
	7,			NULL,		NULL		}
/* *INDENT-ON* */
};

static int
mbill(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_MODE(input[0]), output);

    return 0;
}


static int
rbill(x1f4_e4_LINE_ARGS_1)
{
    C_BILL e;
    C_REAL a;

    a = I_REAL(input[0]);

    if (a < 0) {
	e = 0;
    } else {
	if (a < ~(C_BILL) 0) {
	    e = a;
	} else {
	    e = ~(C_BILL) 0;
	}
    }

    l_BILL(e, output);

    return 0;
}


static int
bmode(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]), output);

    return 0;
}


static int
rmode(x1f4_e4_LINE_ARGS_1)
{
    C_MODE e;
    C_REAL a;

    a = I_REAL(input[0]);

    if (a < C_MODE_MIN) {
	e = C_MODE_MIN;
    } else {
	if (a < C_MODE_MAX) {
	    e = a;
	} else {
	    e = C_MODE_MAX;
	}
    }

    l_MODE(e, output);

    return 0;
}


static int
breal(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_BILL(input[0]), output);

    return 0;
}


static int
mreal(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_MODE(input[0]), output);

    return 0;
}
