/*
 * e4.1bc.c
 * Copyright (C) 2006-2009, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-config.h>

#include <stddef.h>

#include <e4-defs.h>
#include <e4-fast.h>
#include <e4-file.h>
#include <e4-flat.h>
#include <e4-line.h>
#include <e4-slip.h>
#include <e4-types.h>

static int load_aaad(x1f4_e4_LOAD_ARGS_0);
static int load_aabl(x1f4_e4_LOAD_ARGS_0);
static int load_aabm(x1f4_e4_LOAD_ARGS_0);
static int load_aabn(x1f4_e4_LOAD_ARGS_0);
static int load_aacl(x1f4_e4_LOAD_ARGS_0);
static int load_aacm(x1f4_e4_LOAD_ARGS_0);
static int load_aacn(x1f4_e4_LOAD_ARGS_0);
static int load_aadl(x1f4_e4_LOAD_ARGS_0);
static int load_aadm(x1f4_e4_LOAD_ARGS_0);
static int load_aadn(x1f4_e4_LOAD_ARGS_0);
static int load_abbo(x1f4_e4_LOAD_ARGS_0);
static int load_abbp(x1f4_e4_LOAD_ARGS_0);
static int load_abbq(x1f4_e4_LOAD_ARGS_0);
static int load_abco(x1f4_e4_LOAD_ARGS_0);
static int load_abcp(x1f4_e4_LOAD_ARGS_0);
static int load_abcq(x1f4_e4_LOAD_ARGS_0);
static int load_abdo(x1f4_e4_LOAD_ARGS_0);
static int load_abdp(x1f4_e4_LOAD_ARGS_0);
static int load_abdq(x1f4_e4_LOAD_ARGS_0);
static int load_abll(x1f4_e4_LOAD_ARGS_0);
static int load_ablm(x1f4_e4_LOAD_ARGS_0);
static int load_abln(x1f4_e4_LOAD_ARGS_0);
static int load_abml(x1f4_e4_LOAD_ARGS_0);
static int load_abmm(x1f4_e4_LOAD_ARGS_0);
static int load_abmn(x1f4_e4_LOAD_ARGS_0);
static int load_abnl(x1f4_e4_LOAD_ARGS_0);
static int load_abnm(x1f4_e4_LOAD_ARGS_0);
static int load_abnn(x1f4_e4_LOAD_ARGS_0);
static int load_acbo(x1f4_e4_LOAD_ARGS_0);
static int load_acbp(x1f4_e4_LOAD_ARGS_0);
static int load_acbq(x1f4_e4_LOAD_ARGS_0);
static int load_acco(x1f4_e4_LOAD_ARGS_0);
static int load_accp(x1f4_e4_LOAD_ARGS_0);
static int load_accq(x1f4_e4_LOAD_ARGS_0);
static int load_acdo(x1f4_e4_LOAD_ARGS_0);
static int load_acdp(x1f4_e4_LOAD_ARGS_0);
static int load_acdq(x1f4_e4_LOAD_ARGS_0);
static int load_acll(x1f4_e4_LOAD_ARGS_0);
static int load_aclm(x1f4_e4_LOAD_ARGS_0);
static int load_acln(x1f4_e4_LOAD_ARGS_0);
static int load_acml(x1f4_e4_LOAD_ARGS_0);
static int load_acmm(x1f4_e4_LOAD_ARGS_0);
static int load_acmn(x1f4_e4_LOAD_ARGS_0);
static int load_acnl(x1f4_e4_LOAD_ARGS_0);
static int load_acnm(x1f4_e4_LOAD_ARGS_0);
static int load_acnn(x1f4_e4_LOAD_ARGS_0);
static int load_adbo(x1f4_e4_LOAD_ARGS_0);
static int load_adbp(x1f4_e4_LOAD_ARGS_0);
static int load_adbq(x1f4_e4_LOAD_ARGS_0);
static int load_adco(x1f4_e4_LOAD_ARGS_0);
static int load_adcp(x1f4_e4_LOAD_ARGS_0);
static int load_adcq(x1f4_e4_LOAD_ARGS_0);
static int load_addo(x1f4_e4_LOAD_ARGS_0);
static int load_addp(x1f4_e4_LOAD_ARGS_0);
static int load_addq(x1f4_e4_LOAD_ARGS_0);
static int load_adll(x1f4_e4_LOAD_ARGS_0);
static int load_adlm(x1f4_e4_LOAD_ARGS_0);
static int load_adln(x1f4_e4_LOAD_ARGS_0);
static int load_adml(x1f4_e4_LOAD_ARGS_0);
static int load_admm(x1f4_e4_LOAD_ARGS_0);
static int load_admn(x1f4_e4_LOAD_ARGS_0);
static int load_adnl(x1f4_e4_LOAD_ARGS_0);
static int load_adnm(x1f4_e4_LOAD_ARGS_0);
static int load_adnn(x1f4_e4_LOAD_ARGS_0);
static int load_bbbs(x1f4_e4_LOAD_ARGS_0);
static int load_bbbu(x1f4_e4_LOAD_ARGS_0);
static int load_bbbv(x1f4_e4_LOAD_ARGS_0);
static int load_bbcs(x1f4_e4_LOAD_ARGS_0);
static int load_bbcu(x1f4_e4_LOAD_ARGS_0);
static int load_bbcv(x1f4_e4_LOAD_ARGS_0);
static int load_bbds(x1f4_e4_LOAD_ARGS_0);
static int load_bbdu(x1f4_e4_LOAD_ARGS_0);
static int load_bbdv(x1f4_e4_LOAD_ARGS_0);
static int load_bblo(x1f4_e4_LOAD_ARGS_0);
static int load_bblp(x1f4_e4_LOAD_ARGS_0);
static int load_bblq(x1f4_e4_LOAD_ARGS_0);
static int load_bbmo(x1f4_e4_LOAD_ARGS_0);
static int load_bbmp(x1f4_e4_LOAD_ARGS_0);
static int load_bbmq(x1f4_e4_LOAD_ARGS_0);
static int load_bbno(x1f4_e4_LOAD_ARGS_0);
static int load_bbnp(x1f4_e4_LOAD_ARGS_0);
static int load_bbnq(x1f4_e4_LOAD_ARGS_0);
static int load_bbol(x1f4_e4_LOAD_ARGS_0);
static int load_bbom(x1f4_e4_LOAD_ARGS_0);
static int load_bbon(x1f4_e4_LOAD_ARGS_0);
static int load_bbpl(x1f4_e4_LOAD_ARGS_0);
static int load_bbpm(x1f4_e4_LOAD_ARGS_0);
static int load_bbpn(x1f4_e4_LOAD_ARGS_0);
static int load_bbql(x1f4_e4_LOAD_ARGS_0);
static int load_bbqm(x1f4_e4_LOAD_ARGS_0);
static int load_bbqn(x1f4_e4_LOAD_ARGS_0);
static int load_bcbs(x1f4_e4_LOAD_ARGS_0);
static int load_bcbu(x1f4_e4_LOAD_ARGS_0);
static int load_bcbv(x1f4_e4_LOAD_ARGS_0);
static int load_bccs(x1f4_e4_LOAD_ARGS_0);
static int load_bccu(x1f4_e4_LOAD_ARGS_0);
static int load_bccv(x1f4_e4_LOAD_ARGS_0);
static int load_bcds(x1f4_e4_LOAD_ARGS_0);
static int load_bcdu(x1f4_e4_LOAD_ARGS_0);
static int load_bcdv(x1f4_e4_LOAD_ARGS_0);
static int load_bclo(x1f4_e4_LOAD_ARGS_0);
static int load_bclp(x1f4_e4_LOAD_ARGS_0);
static int load_bclq(x1f4_e4_LOAD_ARGS_0);
static int load_bcmo(x1f4_e4_LOAD_ARGS_0);
static int load_bcmp(x1f4_e4_LOAD_ARGS_0);
static int load_bcmq(x1f4_e4_LOAD_ARGS_0);
static int load_bcno(x1f4_e4_LOAD_ARGS_0);
static int load_bcnp(x1f4_e4_LOAD_ARGS_0);
static int load_bcnq(x1f4_e4_LOAD_ARGS_0);
static int load_bcol(x1f4_e4_LOAD_ARGS_0);
static int load_bcom(x1f4_e4_LOAD_ARGS_0);
static int load_bcon(x1f4_e4_LOAD_ARGS_0);
static int load_bcpl(x1f4_e4_LOAD_ARGS_0);
static int load_bcpm(x1f4_e4_LOAD_ARGS_0);
static int load_bcpn(x1f4_e4_LOAD_ARGS_0);
static int load_bcql(x1f4_e4_LOAD_ARGS_0);
static int load_bcqm(x1f4_e4_LOAD_ARGS_0);
static int load_bcqn(x1f4_e4_LOAD_ARGS_0);
static int load_bdbs(x1f4_e4_LOAD_ARGS_0);
static int load_bdbu(x1f4_e4_LOAD_ARGS_0);
static int load_bdbv(x1f4_e4_LOAD_ARGS_0);
static int load_bdcs(x1f4_e4_LOAD_ARGS_0);
static int load_bdcu(x1f4_e4_LOAD_ARGS_0);
static int load_bdcv(x1f4_e4_LOAD_ARGS_0);
static int load_bdds(x1f4_e4_LOAD_ARGS_0);
static int load_bddu(x1f4_e4_LOAD_ARGS_0);
static int load_bddv(x1f4_e4_LOAD_ARGS_0);
static int load_bdlo(x1f4_e4_LOAD_ARGS_0);
static int load_bdlp(x1f4_e4_LOAD_ARGS_0);
static int load_bdlq(x1f4_e4_LOAD_ARGS_0);
static int load_bdmo(x1f4_e4_LOAD_ARGS_0);
static int load_bdmp(x1f4_e4_LOAD_ARGS_0);
static int load_bdmq(x1f4_e4_LOAD_ARGS_0);
static int load_bdno(x1f4_e4_LOAD_ARGS_0);
static int load_bdnp(x1f4_e4_LOAD_ARGS_0);
static int load_bdnq(x1f4_e4_LOAD_ARGS_0);
static int load_bdol(x1f4_e4_LOAD_ARGS_0);
static int load_bdom(x1f4_e4_LOAD_ARGS_0);
static int load_bdon(x1f4_e4_LOAD_ARGS_0);
static int load_bdpl(x1f4_e4_LOAD_ARGS_0);
static int load_bdpm(x1f4_e4_LOAD_ARGS_0);
static int load_bdpn(x1f4_e4_LOAD_ARGS_0);
static int load_bdql(x1f4_e4_LOAD_ARGS_0);
static int load_bdqm(x1f4_e4_LOAD_ARGS_0);
static int load_bdqn(x1f4_e4_LOAD_ARGS_0);
static int load_blbo(x1f4_e4_LOAD_ARGS_0);
static int load_blbp(x1f4_e4_LOAD_ARGS_0);
static int load_blbq(x1f4_e4_LOAD_ARGS_0);
static int load_blco(x1f4_e4_LOAD_ARGS_0);
static int load_blcp(x1f4_e4_LOAD_ARGS_0);
static int load_blcq(x1f4_e4_LOAD_ARGS_0);
static int load_bldo(x1f4_e4_LOAD_ARGS_0);
static int load_bldp(x1f4_e4_LOAD_ARGS_0);
static int load_bldq(x1f4_e4_LOAD_ARGS_0);
static int load_blll(x1f4_e4_LOAD_ARGS_0);
static int load_bllm(x1f4_e4_LOAD_ARGS_0);
static int load_blln(x1f4_e4_LOAD_ARGS_0);
static int load_blml(x1f4_e4_LOAD_ARGS_0);
static int load_blmm(x1f4_e4_LOAD_ARGS_0);
static int load_blmn(x1f4_e4_LOAD_ARGS_0);
static int load_blnl(x1f4_e4_LOAD_ARGS_0);
static int load_blnm(x1f4_e4_LOAD_ARGS_0);
static int load_blnn(x1f4_e4_LOAD_ARGS_0);
static int load_bmbo(x1f4_e4_LOAD_ARGS_0);
static int load_bmbp(x1f4_e4_LOAD_ARGS_0);
static int load_bmbq(x1f4_e4_LOAD_ARGS_0);
static int load_bmco(x1f4_e4_LOAD_ARGS_0);
static int load_bmcp(x1f4_e4_LOAD_ARGS_0);
static int load_bmcq(x1f4_e4_LOAD_ARGS_0);
static int load_bmdo(x1f4_e4_LOAD_ARGS_0);
static int load_bmdp(x1f4_e4_LOAD_ARGS_0);
static int load_bmdq(x1f4_e4_LOAD_ARGS_0);
static int load_bmll(x1f4_e4_LOAD_ARGS_0);
static int load_bmlm(x1f4_e4_LOAD_ARGS_0);
static int load_bmln(x1f4_e4_LOAD_ARGS_0);
static int load_bmml(x1f4_e4_LOAD_ARGS_0);
static int load_bmmm(x1f4_e4_LOAD_ARGS_0);
static int load_bmmn(x1f4_e4_LOAD_ARGS_0);
static int load_bmnl(x1f4_e4_LOAD_ARGS_0);
static int load_bmnm(x1f4_e4_LOAD_ARGS_0);
static int load_bmnn(x1f4_e4_LOAD_ARGS_0);
static int load_bnbo(x1f4_e4_LOAD_ARGS_0);
static int load_bnbp(x1f4_e4_LOAD_ARGS_0);
static int load_bnbq(x1f4_e4_LOAD_ARGS_0);
static int load_bnco(x1f4_e4_LOAD_ARGS_0);
static int load_bncp(x1f4_e4_LOAD_ARGS_0);
static int load_bncq(x1f4_e4_LOAD_ARGS_0);
static int load_bndo(x1f4_e4_LOAD_ARGS_0);
static int load_bndp(x1f4_e4_LOAD_ARGS_0);
static int load_bndq(x1f4_e4_LOAD_ARGS_0);
static int load_bnll(x1f4_e4_LOAD_ARGS_0);
static int load_bnlm(x1f4_e4_LOAD_ARGS_0);
static int load_bnln(x1f4_e4_LOAD_ARGS_0);
static int load_bnml(x1f4_e4_LOAD_ARGS_0);
static int load_bnmm(x1f4_e4_LOAD_ARGS_0);
static int load_bnmn(x1f4_e4_LOAD_ARGS_0);
static int load_bnnl(x1f4_e4_LOAD_ARGS_0);
static int load_bnnm(x1f4_e4_LOAD_ARGS_0);
static int load_bnnn(x1f4_e4_LOAD_ARGS_0);
static int load_cbbs(x1f4_e4_LOAD_ARGS_0);
static int load_cbbu(x1f4_e4_LOAD_ARGS_0);
static int load_cbbv(x1f4_e4_LOAD_ARGS_0);
static int load_cbcs(x1f4_e4_LOAD_ARGS_0);
static int load_cbcu(x1f4_e4_LOAD_ARGS_0);
static int load_cbcv(x1f4_e4_LOAD_ARGS_0);
static int load_cbds(x1f4_e4_LOAD_ARGS_0);
static int load_cbdu(x1f4_e4_LOAD_ARGS_0);
static int load_cbdv(x1f4_e4_LOAD_ARGS_0);
static int load_cblo(x1f4_e4_LOAD_ARGS_0);
static int load_cblp(x1f4_e4_LOAD_ARGS_0);
static int load_cblq(x1f4_e4_LOAD_ARGS_0);
static int load_cbmo(x1f4_e4_LOAD_ARGS_0);
static int load_cbmp(x1f4_e4_LOAD_ARGS_0);
static int load_cbmq(x1f4_e4_LOAD_ARGS_0);
static int load_cbno(x1f4_e4_LOAD_ARGS_0);
static int load_cbnp(x1f4_e4_LOAD_ARGS_0);
static int load_cbnq(x1f4_e4_LOAD_ARGS_0);
static int load_cbol(x1f4_e4_LOAD_ARGS_0);
static int load_cbom(x1f4_e4_LOAD_ARGS_0);
static int load_cbon(x1f4_e4_LOAD_ARGS_0);
static int load_cbpl(x1f4_e4_LOAD_ARGS_0);
static int load_cbpm(x1f4_e4_LOAD_ARGS_0);
static int load_cbpn(x1f4_e4_LOAD_ARGS_0);
static int load_cbql(x1f4_e4_LOAD_ARGS_0);
static int load_cbqm(x1f4_e4_LOAD_ARGS_0);
static int load_cbqn(x1f4_e4_LOAD_ARGS_0);
static int load_ccbs(x1f4_e4_LOAD_ARGS_0);
static int load_ccbu(x1f4_e4_LOAD_ARGS_0);
static int load_ccbv(x1f4_e4_LOAD_ARGS_0);
static int load_cccs(x1f4_e4_LOAD_ARGS_0);
static int load_cccu(x1f4_e4_LOAD_ARGS_0);
static int load_cccv(x1f4_e4_LOAD_ARGS_0);
static int load_ccds(x1f4_e4_LOAD_ARGS_0);
static int load_ccdu(x1f4_e4_LOAD_ARGS_0);
static int load_ccdv(x1f4_e4_LOAD_ARGS_0);
static int load_cclo(x1f4_e4_LOAD_ARGS_0);
static int load_cclp(x1f4_e4_LOAD_ARGS_0);
static int load_cclq(x1f4_e4_LOAD_ARGS_0);
static int load_ccmo(x1f4_e4_LOAD_ARGS_0);
static int load_ccmp(x1f4_e4_LOAD_ARGS_0);
static int load_ccmq(x1f4_e4_LOAD_ARGS_0);
static int load_ccno(x1f4_e4_LOAD_ARGS_0);
static int load_ccnp(x1f4_e4_LOAD_ARGS_0);
static int load_ccnq(x1f4_e4_LOAD_ARGS_0);
static int load_ccol(x1f4_e4_LOAD_ARGS_0);
static int load_ccom(x1f4_e4_LOAD_ARGS_0);
static int load_ccon(x1f4_e4_LOAD_ARGS_0);
static int load_ccpl(x1f4_e4_LOAD_ARGS_0);
static int load_ccpm(x1f4_e4_LOAD_ARGS_0);
static int load_ccpn(x1f4_e4_LOAD_ARGS_0);
static int load_ccql(x1f4_e4_LOAD_ARGS_0);
static int load_ccqm(x1f4_e4_LOAD_ARGS_0);
static int load_ccqn(x1f4_e4_LOAD_ARGS_0);
static int load_cdbs(x1f4_e4_LOAD_ARGS_0);
static int load_cdbu(x1f4_e4_LOAD_ARGS_0);
static int load_cdbv(x1f4_e4_LOAD_ARGS_0);
static int load_cdcs(x1f4_e4_LOAD_ARGS_0);
static int load_cdcu(x1f4_e4_LOAD_ARGS_0);
static int load_cdcv(x1f4_e4_LOAD_ARGS_0);
static int load_cdds(x1f4_e4_LOAD_ARGS_0);
static int load_cddu(x1f4_e4_LOAD_ARGS_0);
static int load_cddv(x1f4_e4_LOAD_ARGS_0);
static int load_cdlo(x1f4_e4_LOAD_ARGS_0);
static int load_cdlp(x1f4_e4_LOAD_ARGS_0);
static int load_cdlq(x1f4_e4_LOAD_ARGS_0);
static int load_cdmo(x1f4_e4_LOAD_ARGS_0);
static int load_cdmp(x1f4_e4_LOAD_ARGS_0);
static int load_cdmq(x1f4_e4_LOAD_ARGS_0);
static int load_cdno(x1f4_e4_LOAD_ARGS_0);
static int load_cdnp(x1f4_e4_LOAD_ARGS_0);
static int load_cdnq(x1f4_e4_LOAD_ARGS_0);
static int load_cdol(x1f4_e4_LOAD_ARGS_0);
static int load_cdom(x1f4_e4_LOAD_ARGS_0);
static int load_cdon(x1f4_e4_LOAD_ARGS_0);
static int load_cdpl(x1f4_e4_LOAD_ARGS_0);
static int load_cdpm(x1f4_e4_LOAD_ARGS_0);
static int load_cdpn(x1f4_e4_LOAD_ARGS_0);
static int load_cdql(x1f4_e4_LOAD_ARGS_0);
static int load_cdqm(x1f4_e4_LOAD_ARGS_0);
static int load_cdqn(x1f4_e4_LOAD_ARGS_0);
static int load_clbo(x1f4_e4_LOAD_ARGS_0);
static int load_clbp(x1f4_e4_LOAD_ARGS_0);
static int load_clbq(x1f4_e4_LOAD_ARGS_0);
static int load_clco(x1f4_e4_LOAD_ARGS_0);
static int load_clcp(x1f4_e4_LOAD_ARGS_0);
static int load_clcq(x1f4_e4_LOAD_ARGS_0);
static int load_cldo(x1f4_e4_LOAD_ARGS_0);
static int load_cldp(x1f4_e4_LOAD_ARGS_0);
static int load_cldq(x1f4_e4_LOAD_ARGS_0);
static int load_clll(x1f4_e4_LOAD_ARGS_0);
static int load_cllm(x1f4_e4_LOAD_ARGS_0);
static int load_clln(x1f4_e4_LOAD_ARGS_0);
static int load_clml(x1f4_e4_LOAD_ARGS_0);
static int load_clmm(x1f4_e4_LOAD_ARGS_0);
static int load_clmn(x1f4_e4_LOAD_ARGS_0);
static int load_clnl(x1f4_e4_LOAD_ARGS_0);
static int load_clnm(x1f4_e4_LOAD_ARGS_0);
static int load_clnn(x1f4_e4_LOAD_ARGS_0);
static int load_cmbo(x1f4_e4_LOAD_ARGS_0);
static int load_cmbp(x1f4_e4_LOAD_ARGS_0);
static int load_cmbq(x1f4_e4_LOAD_ARGS_0);
static int load_cmco(x1f4_e4_LOAD_ARGS_0);
static int load_cmcp(x1f4_e4_LOAD_ARGS_0);
static int load_cmcq(x1f4_e4_LOAD_ARGS_0);
static int load_cmdo(x1f4_e4_LOAD_ARGS_0);
static int load_cmdp(x1f4_e4_LOAD_ARGS_0);
static int load_cmdq(x1f4_e4_LOAD_ARGS_0);
static int load_cmll(x1f4_e4_LOAD_ARGS_0);
static int load_cmlm(x1f4_e4_LOAD_ARGS_0);
static int load_cmln(x1f4_e4_LOAD_ARGS_0);
static int load_cmml(x1f4_e4_LOAD_ARGS_0);
static int load_cmmm(x1f4_e4_LOAD_ARGS_0);
static int load_cmmn(x1f4_e4_LOAD_ARGS_0);
static int load_cmnl(x1f4_e4_LOAD_ARGS_0);
static int load_cmnm(x1f4_e4_LOAD_ARGS_0);
static int load_cmnn(x1f4_e4_LOAD_ARGS_0);
static int load_cnbo(x1f4_e4_LOAD_ARGS_0);
static int load_cnbp(x1f4_e4_LOAD_ARGS_0);
static int load_cnbq(x1f4_e4_LOAD_ARGS_0);
static int load_cnco(x1f4_e4_LOAD_ARGS_0);
static int load_cncp(x1f4_e4_LOAD_ARGS_0);
static int load_cncq(x1f4_e4_LOAD_ARGS_0);
static int load_cndo(x1f4_e4_LOAD_ARGS_0);
static int load_cndp(x1f4_e4_LOAD_ARGS_0);
static int load_cndq(x1f4_e4_LOAD_ARGS_0);
static int load_cnll(x1f4_e4_LOAD_ARGS_0);
static int load_cnlm(x1f4_e4_LOAD_ARGS_0);
static int load_cnln(x1f4_e4_LOAD_ARGS_0);
static int load_cnml(x1f4_e4_LOAD_ARGS_0);
static int load_cnmm(x1f4_e4_LOAD_ARGS_0);
static int load_cnmn(x1f4_e4_LOAD_ARGS_0);
static int load_cnnl(x1f4_e4_LOAD_ARGS_0);
static int load_cnnm(x1f4_e4_LOAD_ARGS_0);
static int load_cnnn(x1f4_e4_LOAD_ARGS_0);
static int load_dbbs(x1f4_e4_LOAD_ARGS_0);
static int load_dbbu(x1f4_e4_LOAD_ARGS_0);
static int load_dbbv(x1f4_e4_LOAD_ARGS_0);
static int load_dbcs(x1f4_e4_LOAD_ARGS_0);
static int load_dbcu(x1f4_e4_LOAD_ARGS_0);
static int load_dbcv(x1f4_e4_LOAD_ARGS_0);
static int load_dbds(x1f4_e4_LOAD_ARGS_0);
static int load_dbdu(x1f4_e4_LOAD_ARGS_0);
static int load_dbdv(x1f4_e4_LOAD_ARGS_0);
static int load_dblo(x1f4_e4_LOAD_ARGS_0);
static int load_dblp(x1f4_e4_LOAD_ARGS_0);
static int load_dblq(x1f4_e4_LOAD_ARGS_0);
static int load_dbmo(x1f4_e4_LOAD_ARGS_0);
static int load_dbmp(x1f4_e4_LOAD_ARGS_0);
static int load_dbmq(x1f4_e4_LOAD_ARGS_0);
static int load_dbno(x1f4_e4_LOAD_ARGS_0);
static int load_dbnp(x1f4_e4_LOAD_ARGS_0);
static int load_dbnq(x1f4_e4_LOAD_ARGS_0);
static int load_dbol(x1f4_e4_LOAD_ARGS_0);
static int load_dbom(x1f4_e4_LOAD_ARGS_0);
static int load_dbon(x1f4_e4_LOAD_ARGS_0);
static int load_dbpl(x1f4_e4_LOAD_ARGS_0);
static int load_dbpm(x1f4_e4_LOAD_ARGS_0);
static int load_dbpn(x1f4_e4_LOAD_ARGS_0);
static int load_dbql(x1f4_e4_LOAD_ARGS_0);
static int load_dbqm(x1f4_e4_LOAD_ARGS_0);
static int load_dbqn(x1f4_e4_LOAD_ARGS_0);
static int load_dcbs(x1f4_e4_LOAD_ARGS_0);
static int load_dcbu(x1f4_e4_LOAD_ARGS_0);
static int load_dcbv(x1f4_e4_LOAD_ARGS_0);
static int load_dccs(x1f4_e4_LOAD_ARGS_0);
static int load_dccu(x1f4_e4_LOAD_ARGS_0);
static int load_dccv(x1f4_e4_LOAD_ARGS_0);
static int load_dcds(x1f4_e4_LOAD_ARGS_0);
static int load_dcdu(x1f4_e4_LOAD_ARGS_0);
static int load_dcdv(x1f4_e4_LOAD_ARGS_0);
static int load_dclo(x1f4_e4_LOAD_ARGS_0);
static int load_dclp(x1f4_e4_LOAD_ARGS_0);
static int load_dclq(x1f4_e4_LOAD_ARGS_0);
static int load_dcmo(x1f4_e4_LOAD_ARGS_0);
static int load_dcmp(x1f4_e4_LOAD_ARGS_0);
static int load_dcmq(x1f4_e4_LOAD_ARGS_0);
static int load_dcno(x1f4_e4_LOAD_ARGS_0);
static int load_dcnp(x1f4_e4_LOAD_ARGS_0);
static int load_dcnq(x1f4_e4_LOAD_ARGS_0);
static int load_dcol(x1f4_e4_LOAD_ARGS_0);
static int load_dcom(x1f4_e4_LOAD_ARGS_0);
static int load_dcon(x1f4_e4_LOAD_ARGS_0);
static int load_dcpl(x1f4_e4_LOAD_ARGS_0);
static int load_dcpm(x1f4_e4_LOAD_ARGS_0);
static int load_dcpn(x1f4_e4_LOAD_ARGS_0);
static int load_dcql(x1f4_e4_LOAD_ARGS_0);
static int load_dcqm(x1f4_e4_LOAD_ARGS_0);
static int load_dcqn(x1f4_e4_LOAD_ARGS_0);
static int load_ddbs(x1f4_e4_LOAD_ARGS_0);
static int load_ddbu(x1f4_e4_LOAD_ARGS_0);
static int load_ddbv(x1f4_e4_LOAD_ARGS_0);
static int load_ddcs(x1f4_e4_LOAD_ARGS_0);
static int load_ddcu(x1f4_e4_LOAD_ARGS_0);
static int load_ddcv(x1f4_e4_LOAD_ARGS_0);
static int load_ddds(x1f4_e4_LOAD_ARGS_0);
static int load_dddu(x1f4_e4_LOAD_ARGS_0);
static int load_dddv(x1f4_e4_LOAD_ARGS_0);
static int load_ddlo(x1f4_e4_LOAD_ARGS_0);
static int load_ddlp(x1f4_e4_LOAD_ARGS_0);
static int load_ddlq(x1f4_e4_LOAD_ARGS_0);
static int load_ddmo(x1f4_e4_LOAD_ARGS_0);
static int load_ddmp(x1f4_e4_LOAD_ARGS_0);
static int load_ddmq(x1f4_e4_LOAD_ARGS_0);
static int load_ddno(x1f4_e4_LOAD_ARGS_0);
static int load_ddnp(x1f4_e4_LOAD_ARGS_0);
static int load_ddnq(x1f4_e4_LOAD_ARGS_0);
static int load_ddol(x1f4_e4_LOAD_ARGS_0);
static int load_ddom(x1f4_e4_LOAD_ARGS_0);
static int load_ddon(x1f4_e4_LOAD_ARGS_0);
static int load_ddpl(x1f4_e4_LOAD_ARGS_0);
static int load_ddpm(x1f4_e4_LOAD_ARGS_0);
static int load_ddpn(x1f4_e4_LOAD_ARGS_0);
static int load_ddql(x1f4_e4_LOAD_ARGS_0);
static int load_ddqm(x1f4_e4_LOAD_ARGS_0);
static int load_ddqn(x1f4_e4_LOAD_ARGS_0);
static int load_dlbo(x1f4_e4_LOAD_ARGS_0);
static int load_dlbp(x1f4_e4_LOAD_ARGS_0);
static int load_dlbq(x1f4_e4_LOAD_ARGS_0);
static int load_dlco(x1f4_e4_LOAD_ARGS_0);
static int load_dlcp(x1f4_e4_LOAD_ARGS_0);
static int load_dlcq(x1f4_e4_LOAD_ARGS_0);
static int load_dldo(x1f4_e4_LOAD_ARGS_0);
static int load_dldp(x1f4_e4_LOAD_ARGS_0);
static int load_dldq(x1f4_e4_LOAD_ARGS_0);
static int load_dlll(x1f4_e4_LOAD_ARGS_0);
static int load_dllm(x1f4_e4_LOAD_ARGS_0);
static int load_dlln(x1f4_e4_LOAD_ARGS_0);
static int load_dlml(x1f4_e4_LOAD_ARGS_0);
static int load_dlmm(x1f4_e4_LOAD_ARGS_0);
static int load_dlmn(x1f4_e4_LOAD_ARGS_0);
static int load_dlnl(x1f4_e4_LOAD_ARGS_0);
static int load_dlnm(x1f4_e4_LOAD_ARGS_0);
static int load_dlnn(x1f4_e4_LOAD_ARGS_0);
static int load_dmbo(x1f4_e4_LOAD_ARGS_0);
static int load_dmbp(x1f4_e4_LOAD_ARGS_0);
static int load_dmbq(x1f4_e4_LOAD_ARGS_0);
static int load_dmco(x1f4_e4_LOAD_ARGS_0);
static int load_dmcp(x1f4_e4_LOAD_ARGS_0);
static int load_dmcq(x1f4_e4_LOAD_ARGS_0);
static int load_dmdo(x1f4_e4_LOAD_ARGS_0);
static int load_dmdp(x1f4_e4_LOAD_ARGS_0);
static int load_dmdq(x1f4_e4_LOAD_ARGS_0);
static int load_dmll(x1f4_e4_LOAD_ARGS_0);
static int load_dmlm(x1f4_e4_LOAD_ARGS_0);
static int load_dmln(x1f4_e4_LOAD_ARGS_0);
static int load_dmml(x1f4_e4_LOAD_ARGS_0);
static int load_dmmm(x1f4_e4_LOAD_ARGS_0);
static int load_dmmn(x1f4_e4_LOAD_ARGS_0);
static int load_dmnl(x1f4_e4_LOAD_ARGS_0);
static int load_dmnm(x1f4_e4_LOAD_ARGS_0);
static int load_dmnn(x1f4_e4_LOAD_ARGS_0);
static int load_dnbo(x1f4_e4_LOAD_ARGS_0);
static int load_dnbp(x1f4_e4_LOAD_ARGS_0);
static int load_dnbq(x1f4_e4_LOAD_ARGS_0);
static int load_dnco(x1f4_e4_LOAD_ARGS_0);
static int load_dncp(x1f4_e4_LOAD_ARGS_0);
static int load_dncq(x1f4_e4_LOAD_ARGS_0);
static int load_dndo(x1f4_e4_LOAD_ARGS_0);
static int load_dndp(x1f4_e4_LOAD_ARGS_0);
static int load_dndq(x1f4_e4_LOAD_ARGS_0);
static int load_dnll(x1f4_e4_LOAD_ARGS_0);
static int load_dnlm(x1f4_e4_LOAD_ARGS_0);
static int load_dnln(x1f4_e4_LOAD_ARGS_0);
static int load_dnml(x1f4_e4_LOAD_ARGS_0);
static int load_dnmm(x1f4_e4_LOAD_ARGS_0);
static int load_dnmn(x1f4_e4_LOAD_ARGS_0);
static int load_dnnl(x1f4_e4_LOAD_ARGS_0);
static int load_dnnm(x1f4_e4_LOAD_ARGS_0);
static int load_dnnn(x1f4_e4_LOAD_ARGS_0);
static int load_hack(x1f4_e4_LOAD_ARGS_0);
static int type_flat(unsigned *, struct e4_atom_type *, unsigned);

static int (*flat_2[]) (x1f4_e4_LOAD_ARGS_0) = {
/* *INDENT-OFF* */
    load_aabl,
    load_aabm,
    load_aabn,
    load_aacl,
    load_aacm,
    load_aacn,
    load_aadl,
    load_aadm,
    load_aadn,
/* *INDENT-ON* */
}, (*flat_3[]) (x1f4_e4_LOAD_ARGS_0) = {
/* *INDENT-OFF* */
    load_abbo,
    load_abbp,
    load_abbq,
    load_abco,
    load_abcp,
    load_abcq,
    load_abdo,
    load_abdp,
    load_abdq,
    load_acbo,
    load_acbp,
    load_acbq,
    load_acco,
    load_accp,
    load_accq,
    load_acdo,
    load_acdp,
    load_acdq,
    load_adbo,
    load_adbp,
    load_adbq,
    load_adco,
    load_adcp,
    load_adcq,
    load_addo,
    load_addp,
    load_addq,
    load_abll,
    load_ablm,
    load_abln,
    load_abml,
    load_abmm,
    load_abmn,
    load_abnl,
    load_abnm,
    load_abnn,
    load_acll,
    load_aclm,
    load_acln,
    load_acml,
    load_acmm,
    load_acmn,
    load_acnl,
    load_acnm,
    load_acnn,
    load_adll,
    load_adlm,
    load_adln,
    load_adml,
    load_admm,
    load_admn,
    load_adnl,
    load_adnm,
    load_adnn,
/* *INDENT-ON* */
}, (*flat_4[]) (x1f4_e4_LOAD_ARGS_0) = {
/* *INDENT-OFF* */
    load_bbbs,
    load_bbbu,
    load_bbbv,
    load_bbcs,
    load_bbcu,
    load_bbcv,
    load_bbds,
    load_bbdu,
    load_bbdv,
    load_bcbs,
    load_bcbu,
    load_bcbv,
    load_bccs,
    load_bccu,
    load_bccv,
    load_bcds,
    load_bcdu,
    load_bcdv,
    load_bdbs,
    load_bdbu,
    load_bdbv,
    load_bdcs,
    load_bdcu,
    load_bdcv,
    load_bdds,
    load_bddu,
    load_bddv,
    load_cbbs,
    load_cbbu,
    load_cbbv,
    load_cbcs,
    load_cbcu,
    load_cbcv,
    load_cbds,
    load_cbdu,
    load_cbdv,
    load_ccbs,
    load_ccbu,
    load_ccbv,
    load_cccs,
    load_cccu,
    load_cccv,
    load_ccds,
    load_ccdu,
    load_ccdv,
    load_cdbs,
    load_cdbu,
    load_cdbv,
    load_cdcs,
    load_cdcu,
    load_cdcv,
    load_cdds,
    load_cddu,
    load_cddv,
    load_dbbs,
    load_dbbu,
    load_dbbv,
    load_dbcs,
    load_dbcu,
    load_dbcv,
    load_dbds,
    load_dbdu,
    load_dbdv,
    load_dcbs,
    load_dcbu,
    load_dcbv,
    load_dccs,
    load_dccu,
    load_dccv,
    load_dcds,
    load_dcdu,
    load_dcdv,
    load_ddbs,
    load_ddbu,
    load_ddbv,
    load_ddcs,
    load_ddcu,
    load_ddcv,
    load_ddds,
    load_dddu,
    load_dddv,
    load_bblo,
    load_bblp,
    load_bblq,
    load_bbmo,
    load_bbmp,
    load_bbmq,
    load_bbno,
    load_bbnp,
    load_bbnq,
    load_bclo,
    load_bclp,
    load_bclq,
    load_bcmo,
    load_bcmp,
    load_bcmq,
    load_bcno,
    load_bcnp,
    load_bcnq,
    load_bdlo,
    load_bdlp,
    load_bdlq,
    load_bdmo,
    load_bdmp,
    load_bdmq,
    load_bdno,
    load_bdnp,
    load_bdnq,
    load_cblo,
    load_cblp,
    load_cblq,
    load_cbmo,
    load_cbmp,
    load_cbmq,
    load_cbno,
    load_cbnp,
    load_cbnq,
    load_cclo,
    load_cclp,
    load_cclq,
    load_ccmo,
    load_ccmp,
    load_ccmq,
    load_ccno,
    load_ccnp,
    load_ccnq,
    load_cdlo,
    load_cdlp,
    load_cdlq,
    load_cdmo,
    load_cdmp,
    load_cdmq,
    load_cdno,
    load_cdnp,
    load_cdnq,
    load_dblo,
    load_dblp,
    load_dblq,
    load_dbmo,
    load_dbmp,
    load_dbmq,
    load_dbno,
    load_dbnp,
    load_dbnq,
    load_dclo,
    load_dclp,
    load_dclq,
    load_dcmo,
    load_dcmp,
    load_dcmq,
    load_dcno,
    load_dcnp,
    load_dcnq,
    load_ddlo,
    load_ddlp,
    load_ddlq,
    load_ddmo,
    load_ddmp,
    load_ddmq,
    load_ddno,
    load_ddnp,
    load_ddnq,
    load_bbol,
    load_bbom,
    load_bbon,
    load_bbpl,
    load_bbpm,
    load_bbpn,
    load_bbql,
    load_bbqm,
    load_bbqn,
    load_bcol,
    load_bcom,
    load_bcon,
    load_bcpl,
    load_bcpm,
    load_bcpn,
    load_bcql,
    load_bcqm,
    load_bcqn,
    load_bdol,
    load_bdom,
    load_bdon,
    load_bdpl,
    load_bdpm,
    load_bdpn,
    load_bdql,
    load_bdqm,
    load_bdqn,
    load_cbol,
    load_cbom,
    load_cbon,
    load_cbpl,
    load_cbpm,
    load_cbpn,
    load_cbql,
    load_cbqm,
    load_cbqn,
    load_ccol,
    load_ccom,
    load_ccon,
    load_ccpl,
    load_ccpm,
    load_ccpn,
    load_ccql,
    load_ccqm,
    load_ccqn,
    load_cdol,
    load_cdom,
    load_cdon,
    load_cdpl,
    load_cdpm,
    load_cdpn,
    load_cdql,
    load_cdqm,
    load_cdqn,
    load_dbol,
    load_dbom,
    load_dbon,
    load_dbpl,
    load_dbpm,
    load_dbpn,
    load_dbql,
    load_dbqm,
    load_dbqn,
    load_dcol,
    load_dcom,
    load_dcon,
    load_dcpl,
    load_dcpm,
    load_dcpn,
    load_dcql,
    load_dcqm,
    load_dcqn,
    load_ddol,
    load_ddom,
    load_ddon,
    load_ddpl,
    load_ddpm,
    load_ddpn,
    load_ddql,
    load_ddqm,
    load_ddqn,
    load_blbo,
    load_blbp,
    load_blbq,
    load_blco,
    load_blcp,
    load_blcq,
    load_bldo,
    load_bldp,
    load_bldq,
    load_bmbo,
    load_bmbp,
    load_bmbq,
    load_bmco,
    load_bmcp,
    load_bmcq,
    load_bmdo,
    load_bmdp,
    load_bmdq,
    load_bnbo,
    load_bnbp,
    load_bnbq,
    load_bnco,
    load_bncp,
    load_bncq,
    load_bndo,
    load_bndp,
    load_bndq,
    load_clbo,
    load_clbp,
    load_clbq,
    load_clco,
    load_clcp,
    load_clcq,
    load_cldo,
    load_cldp,
    load_cldq,
    load_cmbo,
    load_cmbp,
    load_cmbq,
    load_cmco,
    load_cmcp,
    load_cmcq,
    load_cmdo,
    load_cmdp,
    load_cmdq,
    load_cnbo,
    load_cnbp,
    load_cnbq,
    load_cnco,
    load_cncp,
    load_cncq,
    load_cndo,
    load_cndp,
    load_cndq,
    load_dlbo,
    load_dlbp,
    load_dlbq,
    load_dlco,
    load_dlcp,
    load_dlcq,
    load_dldo,
    load_dldp,
    load_dldq,
    load_dmbo,
    load_dmbp,
    load_dmbq,
    load_dmco,
    load_dmcp,
    load_dmcq,
    load_dmdo,
    load_dmdp,
    load_dmdq,
    load_dnbo,
    load_dnbp,
    load_dnbq,
    load_dnco,
    load_dncp,
    load_dncq,
    load_dndo,
    load_dndp,
    load_dndq,
    load_blll,
    load_bllm,
    load_blln,
    load_blml,
    load_blmm,
    load_blmn,
    load_blnl,
    load_blnm,
    load_blnn,
    load_bmll,
    load_bmlm,
    load_bmln,
    load_bmml,
    load_bmmm,
    load_bmmn,
    load_bmnl,
    load_bmnm,
    load_bmnn,
    load_bnll,
    load_bnlm,
    load_bnln,
    load_bnml,
    load_bnmm,
    load_bnmn,
    load_bnnl,
    load_bnnm,
    load_bnnn,
    load_clll,
    load_cllm,
    load_clln,
    load_clml,
    load_clmm,
    load_clmn,
    load_clnl,
    load_clnm,
    load_clnn,
    load_cmll,
    load_cmlm,
    load_cmln,
    load_cmml,
    load_cmmm,
    load_cmmn,
    load_cmnl,
    load_cmnm,
    load_cmnn,
    load_cnll,
    load_cnlm,
    load_cnln,
    load_cnml,
    load_cnmm,
    load_cnmn,
    load_cnnl,
    load_cnnm,
    load_cnnn,
    load_dlll,
    load_dllm,
    load_dlln,
    load_dlml,
    load_dlmm,
    load_dlmn,
    load_dlnl,
    load_dlnm,
    load_dlnn,
    load_dmll,
    load_dmlm,
    load_dmln,
    load_dmml,
    load_dmmm,
    load_dmmn,
    load_dmnl,
    load_dmnm,
    load_dmnn,
    load_dnll,
    load_dnlm,
    load_dnln,
    load_dnml,
    load_dnmm,
    load_dnmn,
    load_dnnl,
    load_dnnm,
    load_dnnn,
/* *INDENT-ON* */
};

static int
load_aaad(x1f4_e4_LOAD_ARGS_1)
{
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    return atom_data->load(atom_data, post_data, used);
}


static int
load_aabl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0001(level, post_data, list, context, ever, ever);
}


static int
load_aabm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0001(level, post_data, list, context, ever, data);
}


static int
load_aabn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0001(level, post_data, list, context, ever, case);
}


static int
load_aacl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0001(level, post_data, list, context, data, ever);
}


static int
load_aacm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0001(level, post_data, list, context, data, data);
}


static int
load_aacn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0001(level, post_data, list, context, data, case);
}


static int
load_aadl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0001(level, post_data, list, context, case, ever);
}


static int
load_aadm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0001(level, post_data, list, context, case, data);
}


static int
load_aadn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0001(level, post_data, list, context, case, case);
}


static int
load_abbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, ever, ever, ever);
}


static int
load_abbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, ever, ever, data);
}


static int
load_abbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, ever, ever, case);
}


static int
load_abco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, ever, data, ever);
}


static int
load_abcp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, ever, data, data);
}


static int
load_abcq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, ever, data, case);
}


static int
load_abdo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, ever, case, ever);
}


static int
load_abdp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, ever, case, data);
}


static int
load_abdq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, ever, case, case);
}


static int
load_abll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, ever, ever, ever);
}


static int
load_ablm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, ever, ever, data);
}


static int
load_abln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, ever, ever, case);
}


static int
load_abml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, ever, data, ever);
}


static int
load_abmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, ever, data, data);
}


static int
load_abmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, ever, data, case);
}


static int
load_abnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, ever, case, ever);
}


static int
load_abnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, ever, case, data);
}


static int
load_abnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, ever, case, case);
}


static int
load_acbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, data, ever, ever);
}


static int
load_acbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, data, ever, data);
}


static int
load_acbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, data, ever, case);
}


static int
load_acco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, data, data, ever);
}


static int
load_accp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, data, data, data);
}


static int
load_accq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, data, data, case);
}


static int
load_acdo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, data, case, ever);
}


static int
load_acdp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, data, case, data);
}


static int
load_acdq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, data, case, case);
}


static int
load_acll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, data, ever, ever);
}


static int
load_aclm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, data, ever, data);
}


static int
load_acln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, data, ever, case);
}


static int
load_acml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, data, data, ever);
}


static int
load_acmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, data, data, data);
}


static int
load_acmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, data, data, case);
}


static int
load_acnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, data, case, ever);
}


static int
load_acnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, data, case, data);
}


static int
load_acnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, data, case, case);
}


static int
load_adbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, case, ever, ever);
}


static int
load_adbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, case, ever, data);
}


static int
load_adbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, case, ever, case);
}


static int
load_adco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, case, data, ever);
}


static int
load_adcp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, case, data, data);
}


static int
load_adcq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, case, data, case);
}


static int
load_addo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, case, case, ever);
}


static int
load_addp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, case, case, data);
}


static int
load_addq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0002(level, post_data, list, context, case, case, case);
}


static int
load_adll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, case, ever, ever);
}


static int
load_adlm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, case, ever, data);
}


static int
load_adln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, case, ever, case);
}


static int
load_adml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, case, data, ever);
}


static int
load_admm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, case, data, data);
}


static int
load_admn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, case, data, case);
}


static int
load_adnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, case, case, ever);
}


static int
load_adnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, case, case, data);
}


static int
load_adnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0011(level, post_data, list, context, case, case, case);
}


static int
load_bbbs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, ever, ever, ever);
}


static int
load_bbbu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, ever, ever, data);
}


static int
load_bbbv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, ever, ever, case);
}


static int
load_bbcs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, ever, data, ever);
}


static int
load_bbcu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, ever, data, data);
}


static int
load_bbcv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, ever, data, case);
}


static int
load_bbds(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, ever, case, ever);
}


static int
load_bbdu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, ever, case, data);
}


static int
load_bbdv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, ever, case, case);
}


static int
load_bblo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, ever, ever, ever);
}


static int
load_bblp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, ever, ever, data);
}


static int
load_bblq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, ever, ever, case);
}


static int
load_bbmo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, ever, data, ever);
}


static int
load_bbmp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, ever, data, data);
}


static int
load_bbmq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, ever, data, case);
}


static int
load_bbno(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, ever, case, ever);
}


static int
load_bbnp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, ever, case, data);
}


static int
load_bbnq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, ever, case, case);
}


static int
load_bbol(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, ever, ever, ever);
}


static int
load_bbom(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, ever, ever, data);
}


static int
load_bbon(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, ever, ever, case);
}


static int
load_bbpl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, ever, data, ever);
}


static int
load_bbpm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, ever, data, data);
}


static int
load_bbpn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, ever, data, case);
}


static int
load_bbql(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, ever, case, ever);
}


static int
load_bbqm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, ever, case, data);
}


static int
load_bbqn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, ever, case, case);
}


static int
load_bcbs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, data, ever, ever);
}


static int
load_bcbu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, data, ever, data);
}


static int
load_bcbv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, data, ever, case);
}


static int
load_bccs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, data, data, ever);
}


static int
load_bccu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, data, data, data);
}


static int
load_bccv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, data, data, case);
}


static int
load_bcds(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, data, case, ever);
}


static int
load_bcdu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, data, case, data);
}


static int
load_bcdv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, data, case, case);
}


static int
load_bclo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, data, ever, ever);
}


static int
load_bclp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, data, ever, data);
}


static int
load_bclq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, data, ever, case);
}


static int
load_bcmo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, data, data, ever);
}


static int
load_bcmp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, data, data, data);
}


static int
load_bcmq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, data, data, case);
}


static int
load_bcno(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, data, case, ever);
}


static int
load_bcnp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, data, case, data);
}


static int
load_bcnq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, data, case, case);
}


static int
load_bcol(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, data, ever, ever);
}


static int
load_bcom(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, data, ever, data);
}


static int
load_bcon(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, data, ever, case);
}


static int
load_bcpl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, data, data, ever);
}


static int
load_bcpm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, data, data, data);
}


static int
load_bcpn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, data, data, case);
}


static int
load_bcql(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, data, case, ever);
}


static int
load_bcqm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, data, case, data);
}


static int
load_bcqn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, data, case, case);
}


static int
load_bdbs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, case, ever, ever);
}


static int
load_bdbu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, case, ever, data);
}


static int
load_bdbv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, case, ever, case);
}


static int
load_bdcs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, case, data, ever);
}


static int
load_bdcu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, case, data, data);
}


static int
load_bdcv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, case, data, case);
}


static int
load_bdds(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, case, case, ever);
}


static int
load_bddu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, case, case, data);
}


static int
load_bddv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, ever, case, case, case);
}


static int
load_bdlo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, case, ever, ever);
}


static int
load_bdlp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, case, ever, data);
}


static int
load_bdlq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, case, ever, case);
}


static int
load_bdmo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, case, data, ever);
}


static int
load_bdmp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, case, data, data);
}


static int
load_bdmq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, case, data, case);
}


static int
load_bdno(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, case, case, ever);
}


static int
load_bdnp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, case, case, data);
}


static int
load_bdnq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, ever, case, case, case);
}


static int
load_bdol(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, case, ever, ever);
}


static int
load_bdom(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, case, ever, data);
}


static int
load_bdon(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, case, ever, case);
}


static int
load_bdpl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, case, data, ever);
}


static int
load_bdpm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, case, data, data);
}


static int
load_bdpn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, case, data, case);
}


static int
load_bdql(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, case, case, ever);
}


static int
load_bdqm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, case, case, data);
}


static int
load_bdqn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, ever, case, case, case);
}


static int
load_blbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, ever, ever, ever);
}


static int
load_blbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, ever, ever, data);
}


static int
load_blbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, ever, ever, case);
}


static int
load_blco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, ever, data, ever);
}


static int
load_blcp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, ever, data, data);
}


static int
load_blcq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, ever, data, case);
}


static int
load_bldo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, ever, case, ever);
}


static int
load_bldp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, ever, case, data);
}


static int
load_bldq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, ever, case, case);
}


static int
load_blll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, ever, ever, ever);
}


static int
load_bllm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, ever, ever, data);
}


static int
load_blln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, ever, ever, case);
}


static int
load_blml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, ever, data, ever);
}


static int
load_blmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, ever, data, data);
}


static int
load_blmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, ever, data, case);
}


static int
load_blnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, ever, case, ever);
}


static int
load_blnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, ever, case, data);
}


static int
load_blnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, ever, case, case);
}


static int
load_bmbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, data, ever, ever);
}


static int
load_bmbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, data, ever, data);
}


static int
load_bmbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, data, ever, case);
}


static int
load_bmco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, data, data, ever);
}


static int
load_bmcp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, data, data, data);
}


static int
load_bmcq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, data, data, case);
}


static int
load_bmdo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, data, case, ever);
}


static int
load_bmdp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, data, case, data);
}


static int
load_bmdq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, data, case, case);
}


static int
load_bmll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, data, ever, ever);
}


static int
load_bmlm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, data, ever, data);
}


static int
load_bmln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, data, ever, case);
}


static int
load_bmml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, data, data, ever);
}


static int
load_bmmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, data, data, data);
}


static int
load_bmmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, data, data, case);
}


static int
load_bmnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, data, case, ever);
}


static int
load_bmnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, data, case, data);
}


static int
load_bmnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, data, case, case);
}


static int
load_bnbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, case, ever, ever);
}


static int
load_bnbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, case, ever, data);
}


static int
load_bnbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, case, ever, case);
}


static int
load_bnco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, case, data, ever);
}


static int
load_bncp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, case, data, data);
}


static int
load_bncq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, case, data, case);
}


static int
load_bndo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, case, case, ever);
}


static int
load_bndp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, case, case, data);
}


static int
load_bndq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, ever, case, case, case);
}


static int
load_bnll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, case, ever, ever);
}


static int
load_bnlm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, case, ever, data);
}


static int
load_bnln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, case, ever, case);
}


static int
load_bnml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, case, data, ever);
}


static int
load_bnmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, case, data, data);
}


static int
load_bnmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, case, data, case);
}


static int
load_bnnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, case, case, ever);
}


static int
load_bnnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, case, case, data);
}


static int
load_bnnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, ever, case, case, case);
}


static int
load_cbbs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, ever, ever, ever);
}


static int
load_cbbu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, ever, ever, data);
}


static int
load_cbbv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, ever, ever, case);
}


static int
load_cbcs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, ever, data, ever);
}


static int
load_cbcu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, ever, data, data);
}


static int
load_cbcv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, ever, data, case);
}


static int
load_cbds(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, ever, case, ever);
}


static int
load_cbdu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, ever, case, data);
}


static int
load_cbdv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, ever, case, case);
}


static int
load_cblo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, ever, ever, ever);
}


static int
load_cblp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, ever, ever, data);
}


static int
load_cblq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, ever, ever, case);
}


static int
load_cbmo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, ever, data, ever);
}


static int
load_cbmp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, ever, data, data);
}


static int
load_cbmq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, ever, data, case);
}


static int
load_cbno(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, ever, case, ever);
}


static int
load_cbnp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, ever, case, data);
}


static int
load_cbnq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, ever, case, case);
}


static int
load_cbol(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, ever, ever, ever);
}


static int
load_cbom(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, ever, ever, data);
}


static int
load_cbon(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, ever, ever, case);
}


static int
load_cbpl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, ever, data, ever);
}


static int
load_cbpm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, ever, data, data);
}


static int
load_cbpn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, ever, data, case);
}


static int
load_cbql(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, ever, case, ever);
}


static int
load_cbqm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, ever, case, data);
}


static int
load_cbqn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, ever, case, case);
}


static int
load_ccbs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, data, ever, ever);
}


static int
load_ccbu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, data, ever, data);
}


static int
load_ccbv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, data, ever, case);
}


static int
load_cccs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, data, data, ever);
}


static int
load_cccu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, data, data, data);
}


static int
load_cccv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, data, data, case);
}


static int
load_ccds(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, data, case, ever);
}


static int
load_ccdu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, data, case, data);
}


static int
load_ccdv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, data, case, case);
}


static int
load_cclo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, data, ever, ever);
}


static int
load_cclp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, data, ever, data);
}


static int
load_cclq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, data, ever, case);
}


static int
load_ccmo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, data, data, ever);
}


static int
load_ccmp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, data, data, data);
}


static int
load_ccmq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, data, data, case);
}


static int
load_ccno(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, data, case, ever);
}


static int
load_ccnp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, data, case, data);
}


static int
load_ccnq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, data, case, case);
}


static int
load_ccol(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, data, ever, ever);
}


static int
load_ccom(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, data, ever, data);
}


static int
load_ccon(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, data, ever, case);
}


static int
load_ccpl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, data, data, ever);
}


static int
load_ccpm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, data, data, data);
}


static int
load_ccpn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, data, data, case);
}


static int
load_ccql(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, data, case, ever);
}


static int
load_ccqm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, data, case, data);
}


static int
load_ccqn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, data, case, case);
}


static int
load_cdbs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, case, ever, ever);
}


static int
load_cdbu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, case, ever, data);
}


static int
load_cdbv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, case, ever, case);
}


static int
load_cdcs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, case, data, ever);
}


static int
load_cdcu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, case, data, data);
}


static int
load_cdcv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, case, data, case);
}


static int
load_cdds(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, case, case, ever);
}


static int
load_cddu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, case, case, data);
}


static int
load_cddv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, data, case, case, case);
}


static int
load_cdlo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, case, ever, ever);
}


static int
load_cdlp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, case, ever, data);
}


static int
load_cdlq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, case, ever, case);
}


static int
load_cdmo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, case, data, ever);
}


static int
load_cdmp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, case, data, data);
}


static int
load_cdmq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, case, data, case);
}


static int
load_cdno(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, case, case, ever);
}


static int
load_cdnp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, case, case, data);
}


static int
load_cdnq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, data, case, case, case);
}


static int
load_cdol(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, case, ever, ever);
}


static int
load_cdom(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, case, ever, data);
}


static int
load_cdon(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, case, ever, case);
}


static int
load_cdpl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, case, data, ever);
}


static int
load_cdpm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, case, data, data);
}


static int
load_cdpn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, case, data, case);
}


static int
load_cdql(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, case, case, ever);
}


static int
load_cdqm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, case, case, data);
}


static int
load_cdqn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, data, case, case, case);
}


static int
load_clbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, ever, ever, ever);
}


static int
load_clbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, ever, ever, data);
}


static int
load_clbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, ever, ever, case);
}


static int
load_clco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, ever, data, ever);
}


static int
load_clcp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, ever, data, data);
}


static int
load_clcq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, ever, data, case);
}


static int
load_cldo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, ever, case, ever);
}


static int
load_cldp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, ever, case, data);
}


static int
load_cldq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, ever, case, case);
}


static int
load_clll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, ever, ever, ever);
}


static int
load_cllm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, ever, ever, data);
}


static int
load_clln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, ever, ever, case);
}


static int
load_clml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, ever, data, ever);
}


static int
load_clmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, ever, data, data);
}


static int
load_clmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, ever, data, case);
}


static int
load_clnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, ever, case, ever);
}


static int
load_clnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, ever, case, data);
}


static int
load_clnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, ever, case, case);
}


static int
load_cmbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, data, ever, ever);
}


static int
load_cmbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, data, ever, data);
}


static int
load_cmbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, data, ever, case);
}


static int
load_cmco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, data, data, ever);
}


static int
load_cmcp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, data, data, data);
}


static int
load_cmcq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, data, data, case);
}


static int
load_cmdo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, data, case, ever);
}


static int
load_cmdp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, data, case, data);
}


static int
load_cmdq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, data, case, case);
}


static int
load_cmll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, data, ever, ever);
}


static int
load_cmlm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, data, ever, data);
}


static int
load_cmln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, data, ever, case);
}


static int
load_cmml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, data, data, ever);
}


static int
load_cmmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, data, data, data);
}


static int
load_cmmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, data, data, case);
}


static int
load_cmnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, data, case, ever);
}


static int
load_cmnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, data, case, data);
}


static int
load_cmnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, data, case, case);
}


static int
load_cnbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, case, ever, ever);
}


static int
load_cnbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, case, ever, data);
}


static int
load_cnbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, case, ever, case);
}


static int
load_cnco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, case, data, ever);
}


static int
load_cncp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, case, data, data);
}


static int
load_cncq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, case, data, case);
}


static int
load_cndo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, case, case, ever);
}


static int
load_cndp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, case, case, data);
}


static int
load_cndq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, data, case, case, case);
}


static int
load_cnll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, case, ever, ever);
}


static int
load_cnlm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, case, ever, data);
}


static int
load_cnln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, case, ever, case);
}


static int
load_cnml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, case, data, ever);
}


static int
load_cnmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, case, data, data);
}


static int
load_cnmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, case, data, case);
}


static int
load_cnnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, case, case, ever);
}


static int
load_cnnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, case, case, data);
}


static int
load_cnnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, data, case, case, case);
}


static int
load_dbbs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, ever, ever, ever);
}


static int
load_dbbu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, ever, ever, data);
}


static int
load_dbbv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, ever, ever, case);
}


static int
load_dbcs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, ever, data, ever);
}


static int
load_dbcu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, ever, data, data);
}


static int
load_dbcv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, ever, data, case);
}


static int
load_dbds(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, ever, case, ever);
}


static int
load_dbdu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, ever, case, data);
}


static int
load_dbdv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, ever, case, case);
}


static int
load_dblo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, ever, ever, ever);
}


static int
load_dblp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, ever, ever, data);
}


static int
load_dblq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, ever, ever, case);
}


static int
load_dbmo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, ever, data, ever);
}


static int
load_dbmp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, ever, data, data);
}


static int
load_dbmq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, ever, data, case);
}


static int
load_dbno(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, ever, case, ever);
}


static int
load_dbnp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, ever, case, data);
}


static int
load_dbnq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, ever, case, case);
}


static int
load_dbol(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, ever, ever, ever);
}


static int
load_dbom(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, ever, ever, data);
}


static int
load_dbon(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, ever, ever, case);
}


static int
load_dbpl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, ever, data, ever);
}


static int
load_dbpm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, ever, data, data);
}


static int
load_dbpn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, ever, data, case);
}


static int
load_dbql(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, ever, case, ever);
}


static int
load_dbqm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, ever, case, data);
}


static int
load_dbqn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, ever, case, case);
}


static int
load_dcbs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, data, ever, ever);
}


static int
load_dcbu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, data, ever, data);
}


static int
load_dcbv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, data, ever, case);
}


static int
load_dccs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, data, data, ever);
}


static int
load_dccu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, data, data, data);
}


static int
load_dccv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, data, data, case);
}


static int
load_dcds(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, data, case, ever);
}


static int
load_dcdu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, data, case, data);
}


static int
load_dcdv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, data, case, case);
}


static int
load_dclo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, data, ever, ever);
}


static int
load_dclp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, data, ever, data);
}


static int
load_dclq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, data, ever, case);
}


static int
load_dcmo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, data, data, ever);
}


static int
load_dcmp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, data, data, data);
}


static int
load_dcmq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, data, data, case);
}


static int
load_dcno(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, data, case, ever);
}


static int
load_dcnp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, data, case, data);
}


static int
load_dcnq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, data, case, case);
}


static int
load_dcol(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, data, ever, ever);
}


static int
load_dcom(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, data, ever, data);
}


static int
load_dcon(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, data, ever, case);
}


static int
load_dcpl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, data, data, ever);
}


static int
load_dcpm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, data, data, data);
}


static int
load_dcpn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, data, data, case);
}


static int
load_dcql(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, data, case, ever);
}


static int
load_dcqm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, data, case, data);
}


static int
load_dcqn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, data, case, case);
}


static int
load_ddbs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, case, ever, ever);
}


static int
load_ddbu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, case, ever, data);
}


static int
load_ddbv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, case, ever, case);
}


static int
load_ddcs(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, case, data, ever);
}


static int
load_ddcu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, case, data, data);
}


static int
load_ddcv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, case, data, case);
}


static int
load_ddds(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, case, case, ever);
}


static int
load_dddu(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, case, case, data);
}


static int
load_dddv(x1f4_e4_LOAD_ARGS_1)
{
    flat_0003(level, post_data, list, context, case, case, case, case);
}


static int
load_ddlo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, case, ever, ever);
}


static int
load_ddlp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, case, ever, data);
}


static int
load_ddlq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, case, ever, case);
}


static int
load_ddmo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, case, data, ever);
}


static int
load_ddmp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, case, data, data);
}


static int
load_ddmq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, case, data, case);
}


static int
load_ddno(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, case, case, ever);
}


static int
load_ddnp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, case, case, data);
}


static int
load_ddnq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0012(level, post_data, list, context, case, case, case, case);
}


static int
load_ddol(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, case, ever, ever);
}


static int
load_ddom(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, case, ever, data);
}


static int
load_ddon(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, case, ever, case);
}


static int
load_ddpl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, case, data, ever);
}


static int
load_ddpm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, case, data, data);
}


static int
load_ddpn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, case, data, case);
}


static int
load_ddql(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, case, case, ever);
}


static int
load_ddqm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, case, case, data);
}


static int
load_ddqn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0021(level, post_data, list, context, case, case, case, case);
}


static int
load_dlbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, ever, ever, ever);
}


static int
load_dlbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, ever, ever, data);
}


static int
load_dlbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, ever, ever, case);
}


static int
load_dlco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, ever, data, ever);
}


static int
load_dlcp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, ever, data, data);
}


static int
load_dlcq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, ever, data, case);
}


static int
load_dldo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, ever, case, ever);
}


static int
load_dldp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, ever, case, data);
}


static int
load_dldq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, ever, case, case);
}


static int
load_dlll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, ever, ever, ever);
}


static int
load_dllm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, ever, ever, data);
}


static int
load_dlln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, ever, ever, case);
}


static int
load_dlml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, ever, data, ever);
}


static int
load_dlmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, ever, data, data);
}


static int
load_dlmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, ever, data, case);
}


static int
load_dlnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, ever, case, ever);
}


static int
load_dlnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, ever, case, data);
}


static int
load_dlnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, ever, case, case);
}


static int
load_dmbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, data, ever, ever);
}


static int
load_dmbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, data, ever, data);
}


static int
load_dmbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, data, ever, case);
}


static int
load_dmco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, data, data, ever);
}


static int
load_dmcp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, data, data, data);
}


static int
load_dmcq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, data, data, case);
}


static int
load_dmdo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, data, case, ever);
}


static int
load_dmdp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, data, case, data);
}


static int
load_dmdq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, data, case, case);
}


static int
load_dmll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, data, ever, ever);
}


static int
load_dmlm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, data, ever, data);
}


static int
load_dmln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, data, ever, case);
}


static int
load_dmml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, data, data, ever);
}


static int
load_dmmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, data, data, data);
}


static int
load_dmmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, data, data, case);
}


static int
load_dmnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, data, case, ever);
}


static int
load_dmnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, data, case, data);
}


static int
load_dmnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, data, case, case);
}


static int
load_dnbo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, case, ever, ever);
}


static int
load_dnbp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, case, ever, data);
}


static int
load_dnbq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, case, ever, case);
}


static int
load_dnco(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, case, data, ever);
}


static int
load_dncp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, case, data, data);
}


static int
load_dncq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, case, data, case);
}


static int
load_dndo(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, case, case, ever);
}


static int
load_dndp(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, case, case, data);
}


static int
load_dndq(x1f4_e4_LOAD_ARGS_1)
{
    flat_0102(level, post_data, list, context, case, case, case, case);
}


static int
load_dnll(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, case, ever, ever);
}


static int
load_dnlm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, case, ever, data);
}


static int
load_dnln(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, case, ever, case);
}


static int
load_dnml(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, case, data, ever);
}


static int
load_dnmm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, case, data, data);
}


static int
load_dnmn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, case, data, case);
}


static int
load_dnnl(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, case, case, ever);
}


static int
load_dnnm(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, case, case, data);
}


static int
load_dnnn(x1f4_e4_LOAD_ARGS_1)
{
    flat_0111(level, post_data, list, context, case, case, case, case);
}


static int
load_hack(x1f4_e4_LOAD_ARGS_1)
{
    int status, type;
    struct e4_atom_type *atom_data;
    unsigned count;

    count = ((struct e4_hack_type *) level)->count - 1;
    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, used);
    if (status) {
    } else {
	for (; count; count--) {
	    atom_data++;

	    post_data++;

	    type = atom_data->type;
	    if (type == EVER) {
		unsigned bits;

		bits = atom_data->data.ever.ever_data->bits;
		if (bits & UNIVERSAL) {
		    if (bits & REFERENCE) {
			miss_record(post_data);
			line_record(post_data) =
			    *(void **)
			    ((char *) used
			     + (integral_q) atom_data->data.ever.state);
		    } else {
			fast_record(post_data,
				    (char *) used
				    + (integral_q) atom_data->data.ever.state);
			miss_record(post_data);
		    }
		} else {
		    if (bits & REFERENCE) {
			miss_record(post_data);
			line_record(post_data) =
			    *(void **) atom_data->data.ever.state;
		    } else {
			fast_record(post_data, atom_data->data.ever.state);
			miss_record(post_data);
		    }
		}
	    } else {
		if (type < EVER) {
		    fast_record(post_data, &atom_data->data.lead.data);
		    miss_record(post_data);
		} else {
		    status = atom_data->load(atom_data, post_data, used);
		    if (status) {
			break;
		    }
		}
	    }

	    break_a2(atom_data, post_data, count, status, context);
	}
    }

    return status;
}


static int
type_flat(unsigned *flat, struct e4_atom_type *atom_data, unsigned count)
{
    unsigned slip = 0;

    for (; count; count--) {
	int type;
	unsigned miss;

	type = atom_data->type;
	if (type == EVER) {
	    if ((atom_data->data.ever.ever_data->bits
		 & (REFERENCE | UNIVERSAL)) ^ UNIVERSAL) {
		miss = 2;
	    } else {
		miss = 0;
	    }
	} else {
	    if (type < EVER) {
		miss = 1;
	    } else {
		miss = 2;
	    }
	}

	atom_data++;

	slip *= 3;
	slip += miss;
    }

    *flat = slip;

    return 0;
}


void
_x1f4_e4_bcxx_hack(struct e4_hack_type *hack_data, unsigned bits,
		   int (**load) (x1f4_e4_LOAD_ARGS_0))
{
    unsigned count;

    count = hack_data->count;
    if (count == 1) {
	*load = load_aaad;
    } else {
	struct e4_atom_type *atom_data;

	atom_data = hack_data->atoms;
	if (count == 2) {
	    unsigned flat;

	    type_flat(&flat, atom_data, 2);

	    *load = flat_2[0 * 9 + flat];
	} else {
	    if (count == 3) {
		unsigned flat;

		type_flat(&flat, atom_data, 3);

		if ((atom_data + 1)->odb2._2nd) {
		    *load = flat_3[1 * 27 + flat];
		} else {
		    *load = flat_3[0 * 27 + flat];
		}
	    } else {
		if (count == 4) {
		    unsigned flat;

		    type_flat(&flat, atom_data, 4);

		    if ((atom_data + 1)->odb2._2nd) {
			if ((atom_data + 2)->odb2._2nd) {
			    *load = flat_4[4 * 81 + flat];
			} else {
			    *load = flat_4[3 * 81 + flat];
			}
		    } else {
			struct e4_odb2_type *odb2_data;

			odb2_data = (atom_data + 2)->odb2._2nd;
			if (odb2_data) {
			    if (odb2_data->odb2_data) {
				*load = flat_4[2 * 81 + flat];
			    } else {
				*load = flat_4[1 * 81 + flat];
			    }
			} else {
			    *load = flat_4[0 * 81 + flat];
			}
		    }
		} else {
		    *load = load_hack;
		}
	    }
	}
    }
}
