/*
 * e4-xfs.h
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_XFS_H__
#define __LIBx1f4_e4_XFS_H__

#include <config.h>

#if !defined BITS_MODE
# if SIZEOF_LONG == 4
#  define BITS_MODE			unsigned
# else
#  define BITS_MODE			unsigned long
# endif				/* SIZEOF_LONG == 4 */
#endif				/* !BITS_MODE */

#if SIZEOF_LONG == 4
# if defined x1f4_xfs_32
# else
#  undef e4_xfs
#  define e4_xfs(l4f1_xxfs, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l4f1_c = ~l4f1_c & (l4f1_c - 1);				      \
									      \
	l4f1_c = l4f1_c - ((l4f1_c >> 1) & 0x55555555);			      \
	l4f1_c = (l4f1_c & 0x33333333) + ((l4f1_c >> 2) & 0x33333333);	      \
	l4f1_c = (l4f1_c + (l4f1_c >> 4)) & 0x0f0f0f0f;			      \
	l4f1_c = l4f1_c + (l4f1_c << 8);				      \
	l4f1_c = l4f1_c + (l4f1_c << 16);				      \
									      \
	(l4f1_xxfs) = l4f1_c >> 24;					      \
    }
# endif				/* x1f4_xfs_32 */
#else
# if defined x1f4_xfs_64
# else
#  undef e4_xfs
#  define e4_xfs(l4f1_xxfs, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l4f1_c = ~l4f1_c & (l4f1_c - 1);				      \
									      \
	l4f1_c = l4f1_c - ((l4f1_c >> 1) & 0x5555555555555555ul);	      \
	l4f1_c = (l4f1_c & 0x3333333333333333ul)			      \
	    + ((l4f1_c >> 2) & 0x3333333333333333ul);			      \
	l4f1_c = (l4f1_c + (l4f1_c >> 4)) & 0x0f0f0f0f0f0f0f0ful;	      \
	l4f1_c = l4f1_c + (l4f1_c << 8);				      \
	l4f1_c = l4f1_c + (l4f1_c << 16);				      \
	l4f1_c = l4f1_c + (l4f1_c << 32);				      \
									      \
	(l4f1_xxfs) = l4f1_c >> 56;					      \
    }
# endif				/* x1f4_xfs_64 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_xfs_32
# else
#  undef e4_xfs_n_club
#  define e4_xfs_n_club(___S) \
    unsigned char __e4_xfs_n_club##___S[] = {				      \
	32,  0,  1, 12,  2,  6, 88, 13,					      \
	 3, 88,  7, 88, 88, 88, 88, 14,					      \
	10,  4, 88, 88,  8, 88, 88, 25,					      \
	88, 88, 88, 88, 88, 21, 27, 15,					      \
	31, 11,  5, 88, 88, 88, 88, 88,					      \
	 9, 88, 88, 24, 88, 88, 20, 26,					      \
	30, 88, 88, 88, 88, 23, 88, 19,					      \
	29, 88, 22, 18, 28, 17, 16, 88					      \
    }
# endif				/* x1f4_xfs_32 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_xfs_32
# else
#  undef e4_xfs_n_near
#  define e4_xfs_n_near(l4f1_xxfs, l4f1_mode, ___S) \
    {									      \
	BITS_MODE l4f1_n;						      \
									      \
	l4f1_n = (l4f1_mode);						      \
									      \
	l4f1_n = (l4f1_n & -l4f1_n) * 0x0450FBAF;			      \
									      \
	(l4f1_xxfs) = __e4_xfs_n_club##___S[l4f1_n >> 26];		      \
    }
# endif				/* x1f4_xfs_32 */
#endif				/* SIZEOF_LONG == 4 */

#endif				/* __LIBx1f4_e4_XFS_H__ */
