/*
 * e4-v.1.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdio.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>

extern const char *_x1f4_e4_type_names[];

void
x1f4_print_variables(FILE *file, const struct e4_ever_type *ever_data)
{
    x1f4_print_hvariables(file, ever_data, NULL);
}


void
x1f4_print_hvariables(void *file, const struct e4_ever_type *ever_data,
		      const char *header)
{
    const char *name;

    name = ever_data->name;
    while (name) {
	int type;

	if (header) {
	    fputs(header, file);
	}

	type = ever_data->type;
	{
	    fputs(_x1f4_e4_type_names[type], file);
	    fputc(' ', file);
	}
	fputs(name, file);
	fputs(";\n", file);
	ever_data++;
	name = ever_data->name;
    }
}
