/*
 * e4-u.f.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-types.h>
#include <mxdeck.h>

int
x1f4_get_function(const char *f, unsigned length, const void *context,
		  const struct e4_last_type **last)
{
    int status;
    const void *mind;

    status = x1f4_find_mxpath((void *) context, f, length, &mind);
    if (status) {
	status = 0;

	*last = mind;
    } else {
	status = 1;
    }

    return status;
}
