/*
 * e4-parse.h
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_PARSE_H__
#define __LIBx1f4_e4_PARSE_H__

#include <e4-config.h>

#include <e4-types.h>

/*
 * class set and expectation definitions
 */
#define BILL_CLASS			0
#define CAD1_CLASS			1
#define CAD2_CLASS			2
#define EVER_CLASS			3
#define LAST_CLASS			4
#define LOCK_CLASS			5
#define LOSE_CLASS			6
#define MODE_CLASS			7
#define OPEN_CLASS			8
#define REAL_CLASS			9
#define STEP_CLASS			10
#define TEXT_CLASS			11

#define GET_ATOM__________ARGS_0 \
    struct next_type *, struct parser_type *, int
#define GET_ATOM__________ARGS_1 \
    struct next_type *next_data, struct parser_type *parser_data, int expect
#define GET_ATOM__________ARGS_2 \
    next_data, parser_data, expect

/*
 * FEATURES
 *
 * Uh, these structures were not meant for use outside e4.7.c, hence are not
 * properly prefixed.  keep your fingers crossed!
 */

typedef struct link_type {
    int class;
    struct e4_atom_type *atom_data;
    const struct e4_last_type *last_data;
    struct link_type *link_data;
    unsigned count, frame, offset;
    void *data;
} link_type;

typedef struct next_type {
    int class, type;
    union {
	C_BILL bill;
	C_MODE mode;
	C_REAL real;
	C_TEXT text;
	struct {
	    const struct e4_ever_type *ever_data;
	    void *state;
	} ever;
	struct {
	    const struct e4_last_type *last_data;
	    void *text;
	} last;
	struct {
	    const struct e4_ever_type *ever_data;
	    const struct e4_last_type *last_data;
	    void *state;
	} lock;
	struct {
	    const struct e4_odbx_type *odbx_data;
	} odbx;
	struct e4_odb1_type *odb1_data;
    } data;
} next_type;

typedef struct parser_type {
    const char *expression;
    int argument, completion, link_class, (*slip) (GET_ATOM__________ARGS_0),
	terminator;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } m;
    struct e4_atom_type *atom_data;
    const struct e4_attributes_type *attributes_data;
    struct e4_back_type *back_data;
    struct e4_expression_type *expression_data;
    struct e4_flat_type *flat_data;
    struct e4_hack_type *hack_data;
    struct e4_odb1_type *odb1_data;
    struct link_type *link_data;
    unsigned bits, c_type_0[8], offset;
    unsigned char class_select[256];
#if __ALLOW_FUNCTION_POINTERS__
    void *e4fine;
#endif				/* __ALLOW_FUNCTION_POINTERS__ */
} parser_type;

struct text_type {
    const char *data;
    unsigned size;
} text_type;

#endif				/* __LIBx1f4_e4_PARSE_H__ */
