/*
 * e4-o.1.c
 * Copyright (C) 2007-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <string.h>

#include <e4-types.h>

extern const char *_x1f4_e4_type_names[];

void
x1f4_print_boperators(FILE *file, const struct e4_odbx_type *const *list,
		      int head)
{
    const struct e4_odbx_type *odbx_data;

    if (head) {
	fputs("    Type    Left Operand Type    Symbol    Right Operand Type"
	      "    Precedence\n", file);
    }

    odbx_data = *list;
    while (odbx_data) {
	int type;
	const int *args;
	unsigned i, j;

	fputs("  ", file);
	type = odbx_data->type;
	if (type < SUIT) {
	    j = strlen(_x1f4_e4_type_names[type]);
	    if (j < 8) {
		j = 8 - j;
	    } else {
		j = 0;
	    }
	    i = j >> 1;
	    j -= i;
	    for (; i; i--) {
		fputc(' ', file);
	    }
	    fputs(_x1f4_e4_type_names[type], file);
	    for (; j; j--) {
		fputc(' ', file);
	    }
	} else {
	    fputs(" <user> ", file);
	}
	args = odbx_data->args;
	type = *args;
	if (type < SUIT) {
	    j = strlen(_x1f4_e4_type_names[type]);
	    if (j < 21) {
		j = 21 - j;
	    } else {
		j = 0;
	    }
	    i = j >> 1;
	    j -= i;
	    for (; i; i--) {
		fputc(' ', file);
	    }
	    fputs(_x1f4_e4_type_names[type], file);
	    for (; j; j--) {
		fputc(' ', file);
	    }
	} else {
	    fputs("       <user>        ", file);
	}
	j = 10 - odbx_data->length;
	i = j >> 1;
	j -= i;
	for (; i; i--) {
	    fputc(' ', file);
	}
	fputs(odbx_data->name, file);
	for (; j; j--) {
	    fputc(' ', file);
	}
	args++;
	type = *args;
	if (type < SUIT) {
	    j = strlen(_x1f4_e4_type_names[type]);
	    if (j < 22) {
		j = 22 - j;
	    } else {
		j = 0;
	    }
	    i = j >> 1;
	    j -= i;
	    for (; i; i--) {
		fputc(' ', file);
	    }
	    fputs(_x1f4_e4_type_names[type], file);
	    for (; j; j--) {
		fputc(' ', file);
	    }
	} else {
	    fputs("        <user>        ", file);
	}
	fprintf(file, "     %#4o", odbx_data->priority);
	fputc('\n', file);
	list++;
	odbx_data = *list;
    }
}
