/*
 * e4-o.0.c
 * Copyright (C) 2006-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <string.h>

#include <e4-defs.h>
#include <e4-types.h>

extern const char *_x1f4_e4_type_names[];

void
x1f4_print_operators(FILE *file, const struct e4_odbx_type *const *list,
		     unsigned count)
{
    const struct e4_odbx_type *odbx_data;

    odbx_data = *list;
    while (odbx_data) {
	const char *name;
	int type;
	unsigned bytes = 4 + 2 + 1;

	name = odbx_data->name;
	type = odbx_data->type;
	if (type < SUIT) {
	    fprintf(file, "%-16s", _x1f4_e4_type_names[type]);
	} else {
	    fputs("<user>          ", file);
	}
	fputs(" [", file);
	if (count == 1) {
	    fprintf(file, "%8s", name);
	    type = *odbx_data->args;
	    if (type < SUIT) {
		fprintf(file, "%-16s", _x1f4_e4_type_names[type]);
	    } else {
		fputs("<user>          ", file);
	    }
	} else {
	    const int *args;
	    unsigned i, j;

	    args = odbx_data->args;
	    type = *args;
	    if (type < SUIT) {
		fprintf(file, "%-16s", _x1f4_e4_type_names[type]);
	    } else {
		fputs("<user>          ", file);
	    }
	    args++;
	    j = strlen(name);
	    if (j < 8) {
		j = 8 - j;
	    } else {
		j = 0;
	    }
	    i = j >> 1;
	    j -= i;
	    for (; i; i--) {
		fputc(' ', file);
	    }
	    fputs(name, file);
	    for (; j; j--) {
		fputc(' ', file);
	    }
	    type = *args;
	    if (type < SUIT) {
		fprintf(file, "%16s", _x1f4_e4_type_names[type]);
	    } else {
		fputs("<user>          ", file);
	    }
	    bytes += 4 + 1 + odbx_data->length + 1 + 4;
	}
	fputc(']', file);
	if (count == 1) {
	    fputs("                ", file);
	}
	fprintf(file, " %13o", odbx_data->priority);
	fputc('\n', file);
	list++;
	odbx_data = *list;
    }
}
