/*
 * e4-line.h
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_LINE_H__
#define __LIBx1f4_e4_LINE_H__

#include <e4-config.h>

#include <e4-types.h>

#if __RECORD_POST__
# define fast_record(___post_data, ___address) \
    (___post_data)->flat.address = (___address)
#else
# define fast_record(___post_data, ___address) \
    (___post_data)->data.address = (___address)
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define flat_record(___post_data) \
    (___post_data)->flat.address = &(___post_data)->data
#else
# define flat_record(___post_data) \
    (___post_data)->flat.reference = 0
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define high_record(___post_data) \
    (___post_data)->flat.address != &(___post_data)->data
#else
# define high_record(___post_data) \
    (___post_data)->flat.reference
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define line_record(___post_data) \
    (___post_data)->flat.address
#else
# define line_record(___post_data) \
    (___post_data)->data.address
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define miss_record(___post_data)
#else
# define miss_record(___post_data) \
    (___post_data)->flat.reference = 1
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define text_record(___post_data) \
    (___post_data)->flat.address
#else
# define text_record(___post_data) \
    ((___post_data)->flat.reference					      \
     ? (___post_data)->data.address : (void *) &(___post_data)->data)
#endif				/* __RECORD_POST__ */

#endif				/* __LIBx1f4_e4_LINE_H__ */
