/*
 * e4-l.1.c
 * Copyright (C) 2006-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-inter.h>
#include <e4-line.h>
#include <e4-types.h>

#define count(atom_data) \
    (last_base(atom_data)->last_data->count)

static int load_last_0(x1f4_e4_LOAD_ARGS_0);
static int load_last_1(x1f4_e4_LOAD_ARGS_0);
static int load_last_2(x1f4_e4_LOAD_ARGS_0);
static int load_last_v(x1f4_e4_LOAD_ARGS_0);

static int
load_last_0(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    void **list;

    hack_data = ((struct e4_atom_type *) level)->data.last.base;

    last_data = hack_base(hack_data)->last_data;

    list = used[USED_LIST];

    *list = used;

    if (0) {
    } else {
	status = last_data->last
	    (hack_base(hack_data)->text, &post_data->data, list + 1);
	if (status) {
	} else {
	    flat_record(post_data);
	}
    }

    return status;
}


static int
load_last_1(x1f4_e4_LOAD_ARGS_1)
{
    int status = 0;
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    void **list;

    hack_data = ((struct e4_atom_type *) level)->data.last.base;

    last_data = hack_base(hack_data)->last_data;

    list = used[USED_LIST];

    *list++ = used;

    used[USED_LIST] = list + 1;

    {
	struct e4_post_type *state_clip;

	state_clip = post_data + 1;
	{
	    *list = &state_clip->data;
	    status = ((int (**) (x1f4_e4_LOAD_ARGS_0)) (hack_data + 1))[0]
		(hack_data, state_clip, used);
	}
    }
    if (status) {
    } else {
	status = last_data->last
	    (hack_base(hack_data)->text, &post_data->data, list);
	if (status) {
	} else {
	    flat_record(post_data);
	}
    }

    used[USED_LIST] = list - 1;

    return status;
}


static int
load_last_2(x1f4_e4_LOAD_ARGS_1)
{
    int status = 0;
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    void **list;

    hack_data = ((struct e4_atom_type *) level)->data.last.base;

    last_data = hack_base(hack_data)->last_data;

    list = used[USED_LIST];

    *list++ = used;

    {
	int (**post) (x1f4_e4_LOAD_ARGS_0);
	struct e4_post_type *state_clip;

	post = (int (**) (x1f4_e4_LOAD_ARGS_0)) (hack_data + 2);
	state_clip = post_data + 1;
	{
	    *list++ = &state_clip->data;
	    used[USED_LIST] = list;
	    status = post[0](hack_data + 0, state_clip, used);
	    if (status) {
	    } else {
		state_clip++;

		*list++ = &state_clip->data;
		used[USED_LIST] = list;
		status = post[1](hack_data + 1, state_clip, used);
	    }
	}
    }
    if (status) {
    } else {
	status = last_data->last
	    (hack_base(hack_data)->text, &post_data->data, list - 2);
	if (status) {
	} else {
	    flat_record(post_data);
	}
    }

    used[USED_LIST] = list - 3;

    return status;
}


static int
load_last_v(x1f4_e4_LOAD_ARGS_1)
{
    int status = 0;
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    unsigned count;
    void **list;

    hack_data = ((struct e4_atom_type *) level)->data.last.base;

    last_data = hack_base(hack_data)->last_data;

    list = used[USED_LIST];

    *list++ = used;

    {
	int (**post) (x1f4_e4_LOAD_ARGS_0);
	struct e4_post_type *state_clip;
	unsigned j;

	count = last_data->count;
	post = (int (**) (x1f4_e4_LOAD_ARGS_0)) (hack_data + count);
	state_clip = post_data + 1;
	for (j = count; j; j--) {
	    *list++ = &state_clip->data;
	    used[USED_LIST] = list;
	    status = post[0](hack_data, state_clip, used);
	    if (status) {
		break;
	    } else {
		state_clip++;
		hack_data++;
		post++;
	    }
	}
    }
    if (status) {
    } else {
	list -= count;
	status = last_data->last
	    (hack_base(hack_data - count)->text, &post_data->data, list);
	if (status) {
	} else {
	    flat_record(post_data);
	}
    }

    used[USED_LIST] = list - 1;

    return status;
}


void
_x1f4_e4_link_laSt(struct e4_atom_type *atom_data)
{
    switch (count(atom_data)) {
    case 0:
	atom_data->load = load_last_0;
	break;
    case 1:
	atom_data->load = load_last_1;
	break;
    case 2:
	atom_data->load = load_last_2;
	break;
    default:
	atom_data->load = load_last_v;
    }
}
