/*
 * e4-fast.h
 * Copyright (C) 2006-2009, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_FAST_H__
#define __LIBx1f4_e4_FAST_H__

#include <e4-config.h>

#include <e4-types.h>

#if __RECORD_POST__
# define case_back(post_data) \
    (post_data)--
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define case_load(atom_data, post_data, list, context, status) \
    (status) = (atom_data)->load((atom_data), (post_data), (used))
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define case_miss(post_data) \
    (post_data)++
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define case_post(atom_data, post_data, self, lock) \
    (post_data)->flat.address
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define case_test(status) \
    (status)
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define data_back(post_data)
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define data_load(atom_data, post_data, list, context, status)
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define data_miss(post_data)
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define data_post(atom_data, post_data, self, lock) \
    &((atom_data) - (lock) + (self))->data.lead
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define data_test(status) \
    0
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define ever_back(post_data)
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define ever_load(atom_data, post_data, list, context, status)
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define ever_miss(post_data)
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define ever_post(atom_data, post_data, self, lock) \
    ((void *)								      \
     ((char *) used							      \
      + (integral_q) ((atom_data) - (lock) + (self))->data.ever.state))
#else
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
# define ever_test(status) \
    0
#else
#endif				/* __RECORD_POST__ */

#endif				/* __LIBx1f4_e4_FAST_H__ */
