/*
 * e4-f.b.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>
#include <e4fine-e4.h>

typedef struct line_type {
    int (*call) (void *, const char *, unsigned),
	(*fix) (const void *, int, const char **, unsigned *),
	(*type_name) (void *, const char *, unsigned);
    const struct e4_last_type *last_data;
    void *back;
    const void *context, *e4fine;
    void *line;
} line_type;

static int type_line(void *, const char *, unsigned);
static int type_list(void *, int (*) (void *, const char *, unsigned),
		     const struct e4_last_type *, const void *, const void *,
		     int (*) (const void *, int, const char **, unsigned *));

static int
type_line(void *text, const char *name, unsigned size)
{
    int (*call) (void *, const char *, unsigned), status;
    struct line_type *line_data;
    void *back;

    line_data = text;

    back = line_data->back;
    call = line_data->call;

    status = call(back, "(*", 2);
    if (status) {
    } else {
	status = line_data->type_name(line_data->line, name, size);
	if (status) {
	} else {
	    status = type_list
		(back, call, line_data->last_data, line_data->e4fine,
		 line_data->context, line_data->fix);
	    if (status) {
	    } else {
		status = call(back, ")", 1);
	    }
	}
    }

    return status;
}


static int
type_list(void *back, int (*call) (void *, const char *, unsigned),
	  const struct e4_last_type *last_data, const void *e4fine,
	  const void *context,
	  int (*fix) (const void *, int, const char **, unsigned *))
{
    int status;

    status = call(back, "(", 1);
    if (status) {
    } else {
	unsigned bits, count;

	bits = last_data->bits;

	count = last_data->count;
	if (count) {
	    const int *args;
	    int type;
	    struct e4_long_type fare;
	    unsigned post;

	    args = last_data->args;

	    fare.type_l.context = context;
	    fare.type_l.fix = fix;

	    fare.type_q.e4fine = e4fine;

	    if (bits & POST_TYPE) {
		post = args[count];
	    } else {
		post = 0;
	    }

	    type = *args;

	    status = x1f4_miss_type(back, call, type, post, &fare);
	    if (status) {
	    } else {
		if (post & HERE_XSET) {
		    if (type < BASE_LOCK) {
			if (type ^ SIDE) {
			    status = call(back, " &", 2);
			} else {
			    status = call(back, "&", 1);
			}
		    }
		}
		if (status) {
		} else {
		    unsigned i;

		    i = count - 1;
		    for (; i; i--) {
			args++;

			type = *args;

			if (type ^ SIDE) {
			    status = call(back, ", ", 2);
			} else {
			    status = call(back, ",*", 1);
			}
			if (status) {
			} else {
			    if (bits & POST_TYPE) {
				post = args[count];
			    } else {
				post = 0;
			    }

			    status = x1f4_miss_type
				(back, call, type, post, &fare);
			    if (status) {
				break;
			    } else {
				if (post & HERE_XSET) {
				    if (type < BASE_LOCK) {
					status = call(back, " &", 2);
					if (status) {
					    break;
					}
				    }
				}
			    }
			}
		    }

		    if (status) {
		    } else {
			if (bits & SIDE_LIST) {
			    if (bits & LINK_PASS) {
				status = call(back, ", &...", 6);
			    } else {
				status = call(back, ", ...", 5);
			    }
			}
		    }
		}
	    }
	} else {
	    if (bits & SIDE_LIST) {
		if (bits & LINK_PASS) {
		    status = call(back, "&...", 4);
		} else {
		    status = call(back, "...", 3);
		}
	    } else {
		status = call(back, "void", 4);
	    }
	}

	if (status) {
	} else {
	    status = call(back, ")", 1);
	}
    }

    return status;
}


int
x1f4_vprint_stfunction(void *back,
		       int (*call) (void *, const char *, unsigned),
		       void *line,
		       int (*type_name) (void *, const char *, unsigned),
		       const struct e4_last_type *last_data,
		       const void *e4fine, const void *context,
		       int (*fix) (const void *, int, const char **,
				   unsigned *))
{
    int status, type;

    type = last_data->type;

    if (type < BASE_LOCK) {
	status = type_name(line, last_data->name, last_data->length);
	if (status) {
	} else {
	    status = type_list(back, call, last_data, e4fine, context, fix);
	}
    } else {
	const void *down;

	status = x1f4_pick_e4fine(e4fine, type, &down);
	if (status) {
	    struct line_type blue;

	    blue.last_data = last_data;
	    blue.type_name = type_name;

	    blue.back = back;
	    blue.call = call;
	    blue.line = line;

	    blue.context = context;
	    blue.fix = fix;
	    blue.e4fine = e4fine;

	    status = x1f4_vprint_stfunction
		(back, call, &blue, type_line,
		 &((struct e4_line_type *) down)->last, e4fine, context, fix);
	} else {
	    status = 1;
	}
    }

    return status;
}
