/*
 * e4-f.a.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>

extern const char *_x1f4_e4_type_names[];

static void print_type(void *, int, const void *,
		       int (*) (const void *, int, const char **, unsigned *));

static void
print_type(void *file, int type, const void *context,
	   int (*fix) (const void *, int, const char **, unsigned *))
{
    if (type < SUIT) {
	if (type ^ SIDE) {
	    fputs(_x1f4_e4_type_names[type], file);
	}
    } else {
	if (fix) {
	    const char *name;
	    unsigned size;

	    if (fix(context, type, &name, &size)) {
		fputs("<user>", file);
	    } else {
		fwrite(name, size, 1, file);
	    }
	} else {
	    fputs("<user>", file);
	}
    }
}


void
x1f4_print_htfunction(void *file, const struct e4_last_type *last_data,
		      const char *header, const void *context,
		      int (*fix) (const void *, int, const char **,
				  unsigned *))
{
    int type;
    unsigned bits, count;

    if (header) {
	fputs(header, file);
    }

    type = last_data->type;
    if (type == VOID) {
	fputs("void ", file);
    } else {
	print_type(file, type, context, fix);
	fputc(' ', file);
    }

    bits = last_data->bits;

    fputs(last_data->name, file);
    fputc('(', file);
    count = last_data->count;
    if (count) {
	const int *args;
	unsigned i;

	args = last_data->args;

	{
	    print_type(file, *args, context, fix);
	    if (bits & POST_TYPE) {
		if (args[count] & HERE_XSET) {
		    if (*args ^ SIDE) {
			fputs(" &", file);
		    } else {
			fputs("&", file);
		    }
		}
	    }
	}
	i = count - 1;
	for (; i; i--) {
	    args++;

	    if (*args ^ SIDE) {
		fputs(", ", file);
	    } else {
		fputs(",", file);
	    }

	    print_type(file, *args, context, fix);
	    if (bits & POST_TYPE) {
		if (args[count] & HERE_XSET) {
		    fputs(" &", file);
		}
	    }
	}

	if (bits & SIDE_LIST) {
	    if (bits & LINK_PASS) {
		fputs(", &...", file);
	    } else {
		fputs(", ...", file);
	    }
	}
    } else {
	if (bits & SIDE_LIST) {
	    if (bits & LINK_PASS) {
		fputs("&...", file);
	    } else {
		fputs("...", file);
	    }
	} else {
	    fputs("void", file);
	}
    }

    fputs(");\n", file);
}
