/*
 * e4-e.a.c
 * Copyright (C) 2006-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-defs.h>
#include <e4-types.h>

#define LOGIC_BITS \
    ((1 << LAST) | (1 << LOCK) | (1 << PICK))

static int ever_hack(void *, struct e4_hack_type *, void *,
		     int (*) (void *, const struct e4_last_type *));
static int ever_last(void *, struct e4_hack_type *, unsigned, void *,
		     int (*) (void *, const struct e4_last_type *));

static int
ever_hack(void *expression, struct e4_hack_type *hack_data, void *data,
	  int (*this) (void *, const struct e4_last_type *))
{
    int delete = 0;
    struct e4_atom_type *atom_data;
    unsigned i;

    atom_data = hack_data->atoms;

    i = hack_data->count;
    for (; i; i--) {
	int type;

	type = atom_data->type;
	if (1 << type & LOGIC_BITS) {
	    const struct e4_last_type *last_data;
	    struct e4_hack_type *hack_data;

	    hack_data = atom_data->data.last.base;
	    last_data = hack_base(hack_data)->last_data;
	    if (type == LAST) {
		delete = this(data, last_data);
		if (delete) {
		    break;
		}
	    }
	    if (1) {
		delete = ever_last
		    (expression, hack_data, last_data->count, data, this);
		if (delete) {
		    break;
		}
	    }
	} else {
	    if (type == THIS) {
		delete = ever_hack
		    (expression, atom_data->data.hack.data, data, this);
		if (delete) {
		    break;
		}
	    }
	}

	atom_data++;
    }

    return delete;
}


static int
ever_last(void *expression, struct e4_hack_type *hack_data, unsigned count,
	  void *data, int (*this) (void *, const struct e4_last_type *))
{
    int delete;

    if (count) {
	do {
	    delete = ever_hack(expression, hack_data, data, this);
	    if (delete) {
		break;
	    }

	    count--;

	    hack_data++;
	} while (count);
    } else {
	delete = 0;
    }

    return delete;
}


int
x1f4_peek_expression(struct e4_expression_type *expression_data, void *data,
		     int (*this) (void *, const struct e4_last_type *))
{
    return ever_hack(expression_data, &expression_data->hack_data, data, this);
}
