/*
 * e4-e.6.c
 * Copyright (C) 2006-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-defs.h>
#include <e4-types.h>

#define LOGIC_BITS \
    ((1 << LAST) | (1 << LOCK) | (1 << PICK))

static void ever_hack(void *, struct e4_hack_type *, void *,
		      void (*) (void *, const struct e4_ever_type *));
static void ever_last(void *, struct e4_atom_type *, void *,
		      void (*) (void *, const struct e4_ever_type *));

static void
ever_hack(void *expression, struct e4_hack_type *hack_data, void *data,
	  void (*this) (void *, const struct e4_ever_type *))
{
    struct e4_atom_type *atom_data;
    unsigned i;

    atom_data = hack_data->atoms;

    i = hack_data->count;
    for (; i; i--) {
	int type;

	type = atom_data->type;
	if (type == EVER) {
	    this(data, atom_data->data.ever.ever_data);
	} else {
	    if (1 << type & LOGIC_BITS) {
		if (type == LOCK) {
		    this(data, lock_fine(atom_data)->ever_data);
		}

		ever_last(expression, atom_data, data, this);
	    } else {
		if (type == THIS) {
		    ever_hack
			(expression, atom_data->data.hack.data, data, this);
		}
	    }
	}

	atom_data++;
    }
}


static void
ever_last(void *expression, struct e4_atom_type *atom_data, void *data,
	  void (*this) (void *, const struct e4_ever_type *))
{
    struct e4_hack_type *hack_data;
    unsigned i;

    hack_data = atom_data->data.last.base;

    i = hack_base(hack_data)->last_data->count;
    for (; i; i--) {
	ever_hack(expression, hack_data, data, this);

	hack_data++;
    }
}


void
x1f4_list_expression(struct e4_expression_type *expression_data, void *data,
		     void (*this) (void *, const struct e4_ever_type *))
{
    ever_hack(expression_data, &expression_data->hack_data, data, this);
}
