/*
 * e4-e.5.c
 * Copyright (C) 2006-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>

#define EXPRESSION(expression) \
    ((e4_expression_type *) expression)

#define E_LINK(mcontext, mdata, size) \
    (EXPRESSION(mcontext)->m.link					      \
	(EXPRESSION(mcontext)->m.data, (void *) (mdata), (size)))

#define LOGIC_BITS \
    ((1 << LAST) | (1 << LOCK) | (1 << PICK))

static int ever_pack(void *, struct e4_hack_type *, struct e4_ever_type *,
		     void *);
static int ever_last(void *, struct e4_atom_type *, struct e4_ever_type *,
		     void *);
static int ever_miss(void *, struct e4_atom_type *, void *);

static int
ever_pack(void *expression, struct e4_hack_type *hack_data,
	  struct e4_ever_type *ever_data, void *miss)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned i;

    atom_data = hack_data->atoms;

    i = hack_data->count;
    for (; i; i--) {
	int type;

	type = atom_data->type;
	if (type == EVER) {
	    if (atom_data->data.ever.ever_data == ever_data) {
		status = ever_miss(expression, atom_data, miss);
	    }
	} else if (1 << type & LOGIC_BITS) {
	    status = ever_last(expression, atom_data, ever_data, miss);
	} else if (type == THIS) {
	    status = ever_pack
		(expression, atom_data->data.hack.data, ever_data, miss);
	    if (status) {
		break;
	    }
	}

	atom_data++;
    }

    return status;
}


static int
ever_last(void *expression, struct e4_atom_type *atom_data,
	  struct e4_ever_type *ever_data, void *miss)
{
    int status = 0;
    struct e4_hack_type *hack_data;
    unsigned i;

    hack_data = atom_data->data.last.base;

    i = hack_base(hack_data)->last_data->count;
    for (; i; i--) {
	status = ever_pack(expression, hack_data, ever_data, miss);
	if (status) {
	    break;
	} else {
	    hack_data++;
	}
    }

    return status;
}


static int
ever_miss(void *expression, struct e4_atom_type *atom_data, void *miss)
{
    int status = 0, type;
    const struct e4_ever_type *ever_data;

    ever_data = atom_data->data.ever.ever_data;
    type = ever_data->type;
    if (type == BILL) {
	C_BILL *mode, *slip;

	slip = (C_BILL *) &atom_data->data.lead.data;
	mode = miss;
	*slip = *mode;
	atom_data->load = _x1f4_e4_load_bill;
	atom_data->type = BILL;
    } else if (type == MODE) {
	C_MODE *mode, *slip;

	slip = (C_MODE *) &atom_data->data.lead.data;
	mode = miss;
	*slip = *mode;
	atom_data->load = _x1f4_e4_load_mode;
	atom_data->type = MODE;
    } else if (type == REAL) {
	C_REAL *real, *slip;

	slip = (C_REAL *) &atom_data->data.lead.data;
	real = miss;
	*slip = *real;
	atom_data->load = _x1f4_e4_load_real;
	atom_data->type = REAL;
    } else {
	e4_text_type deck, flow, *text;
	unsigned length;

	text = miss;
	deck = *text;
	length = strlen(deck);
	status = E_LINK(expression, &flow, length + 1);
	if (status) {
	} else {
	    C_TEXT *slip;

	    memcpy(flow, deck, length + 1);
	    slip = (C_TEXT *) &atom_data->data.lead.data;
	    *slip = flow;
	    atom_data->load = _x1f4_e4_load_text;
	    atom_data->type = TEXT;
	}
    }

    return status;
}


int
x1f4_pack_expression(struct e4_expression_type *expression_data,
		     struct e4_ever_type *ever_data, void *miss)
{
    return ever_pack
	(expression_data, &expression_data->hack_data, ever_data, miss);
}
