/*
 * e4-e.4.c
 * Copyright (C) 2006-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TODO
 *
 * replace variables in LOCK typed atoms
 */

#include <stddef.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>

#define LOGIC_BITS \
    ((1 << LAST) | (1 << LOCK) | (1 << PICK))

#define EXPRESSION(expression) \
    ((e4_expression_type *) expression)

#define E_FREE(mcontext, mdata) \
    (EXPRESSION(mcontext)->m.free(EXPRESSION(mcontext)->m.data, (mdata)))
#define E_LINK(mcontext, mdata, size) \
    (EXPRESSION(mcontext)->m.link					      \
	(EXPRESSION(mcontext)->m.data, (void *) (mdata), (size)))
#define E_MODE(mcontext, mdata, size) \
    (EXPRESSION(mcontext)->m.mode					      \
	(EXPRESSION(mcontext)->m.data, (void *) (mdata), (size)))

static int ever_hack(void *, struct e4_hack_type *, struct e4_ever_type *,
		     void *, int (**) (x1f4_e4_LOAD_ARGS_0));
static int ever_last(void *, struct e4_atom_type *, struct e4_ever_type *,
		     void *);
static int ever_link(struct e4_expression_type *);
static int ever_miss(void *, struct e4_atom_type *, void *);

static int
ever_hack(void *expression, struct e4_hack_type *hack_data,
	  struct e4_ever_type *ever_data, void *expressiOn,
	  int (**load) (x1f4_e4_LOAD_ARGS_0))
{
    int fast = 0, status = 0;
    struct e4_atom_type *atom_data;
    unsigned i;

    atom_data = hack_data->atoms;

    i = hack_data->count;
    for (; i; i--) {
	int type;

	type = atom_data->type;
	if (type == EVER) {
	    if (atom_data->data.ever.ever_data == ever_data) {
		status = ever_miss(expression, atom_data, expressiOn);
		if (status) {
		} else {
		    fast = 1;
		}
	    }
	} else {
	    if (1 << type & LOGIC_BITS) {
		status = ever_last
		    (expression, atom_data, ever_data, expressiOn);
	    } else {
		if (type == THIS) {
		    status = ever_hack
			(expression, atom_data->data.hack.data, ever_data,
			 expressiOn, &atom_data->data.hack.load);
		    if (status) {
			break;
		    }
		}
	    }
	}

	atom_data++;
    }

    if (status) {
    } else {
	if (fast) {
	    if (load) {
		_x1f4_e4_fast_hack
		    (hack_data, EXPRESSION(expression)->bits, load);
	    }
	}
    }

    return status;
}


static int
ever_last(void *expression, struct e4_atom_type *atom_data,
	  struct e4_ever_type *ever_data, void *expressiOn)
{
    int (**post) (x1f4_e4_LOAD_ARGS_0), status = 0;
    const int *args;
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    unsigned bits, count;

    hack_data = atom_data->data.last.base;
    last_data = hack_base(hack_data)->last_data;
    bits = last_data->bits;
    count = last_data->count;
    args = last_data->args + count;
    post = (int (**) (x1f4_e4_LOAD_ARGS_0)) (hack_data + count);
    for (; count; count--) {
	status = ever_hack(expression, hack_data, ever_data, expressiOn, post);
	if (status) {
	    break;
	} else {
	    unsigned class;

	    if (bits & POST_TYPE) {
		class = *args++;
	    } else {
		class = 0;
	    }

	    _x1f4_e4_fast_miss(hack_data, class, post);

	    hack_data++;

	    post++;
	}
    }

    return status;
}


static int
ever_link(struct e4_expression_type *expression_data)
{
    int status = 0;
    unsigned list, post;

    _x1f4_e4_size_expression(expression_data, &list, &post);
    if (expression_data->bits & EXTERN_STACKS_MESS) {
	expression_data->list_size = list;
	expression_data->post_size = post;
    } else {
	if (expression_data->list_size != list) {
	    if (list) {
		status = E_MODE
		    (expression_data, &expression_data->list,
		     sizeof(void *) * list);
		if (status) {
		} else {
		    expression_data->list_size = list;
		}
	    } else {
		E_FREE(expression_data, expression_data->list);
		expression_data->list = NULL;
		expression_data->list_size = 0;
	    }
	}
	if (status) {
	} else {
	    if (expression_data->post_size != post) {
		if (post) {
		    status = E_MODE
			(expression_data, &expression_data->post_data,
			 sizeof(struct e4_post_type) * post);
		    if (status) {
		    } else {
			expression_data->post_size = post;
		    }
		} else {
		    E_FREE(expression_data, expression_data->post_data);
		    expression_data->post_data = NULL;
		    expression_data->post_size = 0;
		}
	    }
	}
    }

    return status;
}


static int
ever_miss(void *expression, struct e4_atom_type *atom_data, void *expressiOn)
{
    int status;
    struct e4_hack_type *hack_data;

    status = E_LINK(expression, &hack_data, sizeof(struct e4_hack_type));
    if (status) {
    } else {
	struct e4_expression_type *expression_data;

	status = x1f4_copy_expression(&expression_data, expressiOn);
	if (status) {
	    E_FREE(expression, hack_data);
	} else {
	    atom_data->load = _x1f4_e4_load_this;
	    atom_data->type = THIS;
	    atom_data->data.hack.data = hack_data;

	    *hack_data = expression_data->hack_data;

	    expression_data->hack_data.atoms = NULL;
	    expression_data->hack_data.count = 0;

	    x1f4_fini_expression(&expression_data);

	    _x1f4_e4_fast_hack
		(hack_data, EXPRESSION(expression)->bits,
		 &atom_data->data.hack.load);
	}
    }

    return status;
}


int
x1f4_hack_expression(struct e4_expression_type *expression_data,
		     struct e4_ever_type *ever_data,
		     struct e4_expression_type *expression_text)
{
    int status;

    if (ever_data->type != expression_text->type) {
	status = 1;
    } else {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;

	data = expression_text->m.data;
	free = expression_text->m.free;
	link = expression_text->m.link;
	mode = expression_text->m.mode;

	expression_text->m = expression_data->m;

	status = ever_hack
	    (expression_data, &expression_data->hack_data, ever_data,
	     expression_text, &expression_data->load);
	if (status) {
	} else {
	    status = ever_link(expression_data);
	}

	expression_text->m.data = data;
	expression_text->m.free = free;
	expression_text->m.link = link;
	expression_text->m.mode = mode;
    }

    return status;
}
