/*
 * e4-e.3.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-defs.h>
#include <e4-types.h>

#define LOGIC_BITS \
    ((1 << LAST) | (1 << LOCK) | (1 << PICK))

typedef struct is_type {
    unsigned list_length, max_list_length, max_post_length, post_length;
} is_type;

static void size_hack(struct e4_hack_type *, struct is_type *);

static void
size_hack(struct e4_hack_type *hack_data, struct is_type *is_data)
{
    struct e4_atom_type *atom_data;
    unsigned count, i, max_post_length, post_length;

    post_length = is_data->post_length;
    max_post_length = post_length;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    for (i = count; i; i--) {
	int type;

	type = atom_data->type;
	if (1 << type & LOGIC_BITS) {
	    struct e4_hack_type *hack_data;
	    const struct e4_last_type *last_data;
	    unsigned count, j, this_length;

	    hack_data = atom_data->data.last.base;
	    last_data = hack_base(hack_data)->last_data;

	    count = last_data->count;

	    this_length = post_length + 1;

	    is_data->post_length = this_length;
	    if (max_post_length < this_length) {
		max_post_length = this_length;
	    }

	    is_data->list_length++;

	    j = count;
	    while (j) {
		is_data->post_length = this_length;
		is_data->list_length++;
		size_hack(hack_data, is_data);
		this_length++;
		hack_data++;
		--j;
	    }

	    if (max_post_length < this_length) {
		max_post_length = this_length;
	    }

	    if (is_data->max_list_length < is_data->list_length) {
		is_data->max_list_length = is_data->list_length;
	    }

	    is_data->list_length -= count + 1;
	} else {
	    if (type == THIS) {
		is_data->post_length = post_length;
		size_hack(atom_data->data.hack.data, is_data);
	    }
	}

	post_length++;
	if (max_post_length < post_length) {
	    max_post_length = post_length;
	}

	{
	    struct e4_odb2_type *odb2_data;

	    odb2_data = atom_data->odb2._2nd;
	    while (odb2_data) {
		post_length--;
		odb2_data = odb2_data->odb2_data;
	    }
	}

	atom_data++;
    }

    if (is_data->max_post_length < max_post_length) {
	is_data->max_post_length = max_post_length;
    }
}


void
_x1f4_e4_size_expression(struct e4_expression_type *expression_data,
			 unsigned *list, unsigned *post)
{
    struct is_type is;

    is.list_length = 0;
    is.max_list_length = 0;
    is.max_post_length = 0;
    is.post_length = 0;

    size_hack(&expression_data->hack_data, &is);

    *list = is.max_list_length;
    *post = is.max_post_length;
}
