/*
 * e4-defs.h
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_DEFS_H__
#define __LIBx1f4_e4_DEFS_H__

#include <config.h>

#include <limits.h>

#include <c-types.h>

/*
 * error definitions
 */
#define ALLOC_ERROR			1
#define PARSE_ERROR			2

/*
 * type definitions
 */
#define BILL				0
#define MODE				1
#define REAL				2
#define TEXT				3

/*
 * type definitions (continued)
 */
#define EVER				4
#define LAST				5
#define LOCK				6
#define PICK				7
#define THIS				8

/*
 * type definitions (continued)
 */
#define UNDEFINED			9

/*
 * type definitions (continued)
 */
#define SIDE				4095

/*
 * type definitions (continued)
 */
#define VOID				4096

/*
 * type definitions (continued)
 */
#define SUIT				6144

/*
 * type definitions (continued)
 */
#define CASE				7168

/*
 * type definitions (continued)
 */
#define USER				8192

/*
 * type definitions (concluded)
 */
#define BASE_LOCK			131072

/*
 * completion definitions
 */
#define BACK_COMPLETION			0
#define BYTE_COMPLETION			1

/*
 * flat definitions
 */
#define DATA_FLAT			0
#define NEWS_FLAT			1

/*
 * function flag definitions
 * 0x01 not currently used
 */
#define LINK_PASS			(1L << 0x02)
#define POST_TYPE			(1L << 0x03)
#define SIDE_LIST			(1L << 0x04)
#define SLIP_LIST			(1L << 0x05)
#define TEXT_LINK			(1L << 0x06)
#define WALK_LINK			(1L << 0x07)
/*
 * continued (see below)
 */

/*
 * function flag definitions (continued)
 */
#define NEWS_LINK			(1L << 0x08)
#define NODE_LINK			(1L << 0x09)
/*
 * continued (see below)
 */

/*
 * function internal use flag definitions
 */
#define FLAT_LINE			(1L << 0x0a)

/*
 * function argument flag definitions
 */
#define HERE_XSET			(1L << 0x00)

/*
 * infix bynary operator flag definitions
 */
#define BACK_LINK			(1L << 0x03)
#define CALL_LOCK			(1L << 0x04)

/*
 * infix bynary operator flag definitions (continued)
 */
#if __ALLOW_RIGHT_FIRST__
# define LEFT_LAST			(1L << 0x05)
#endif				/* __ALLOW_RIGHT_FIRST__ */

/*
 * infix bynary operator flag definitions (concluded)
 */
#define LEFT_XSET			(1L << 0x06)

/*
 * operator 1st entension flag definitions
 */
#define LEFT_FILL			(1L << 0x04)
#define LEFT_KILL			(1L << 0x05)
#define LEFT_SKIP			(1L << 0x06)
#define MXAA_LIST			(1L << 0x08)
#define MXAC_LIST			(1L << 0x09)
#define MXAS_LIST			(1L << 0x0a)
#define MXCA_LIST			(1L << 0x0b)
#define MXCC_LIST			(1L << 0x0c)
#define MXCS_LIST			(1L << 0x0d)
#define NXAA_LIST			(1L << 0x0e)
#define NXAC_LIST			(1L << 0x0f)
#define NXCA_LIST			(1L << 0x10)
#define NXCC_LIST			(1L << 0x11)
#define POST_FLOW			(1L << 0x12)
#define POST_KILL			(1L << 0x13)
#define POST_SKIP			(1L << 0x14)

/*
 * operator 2nd entension flag definitions
 */
#define CALL_LINK			(1L << 0x00)
#define RANK_LIST			(1L << 0x01)
#define RANK_NONE			(1L << 0x02)

/*
 * operator and function flag definitions
 */
#define KEEP_CALL			(1L << 0x00)

/*
 * operator flag definitions
 */
#define E1ST_LINK			(1L << 0x01)
#define E2ND_LINK			(1L << 0x02)

/*
 * prefix unary operator flag definitions
 */
#define KILL_PAIR			(1L << 0x03)
#define LOSE_DATA			(1L << 0x04)
#define MISS_PAIR			(1L << 0x05)

/*
 * variable and sequence flag definitions
 */
/*
 * sequence READ_ONLY is sequence non assignable,
 * a non READ_ONLY sequence is an one non READ_ONLY variable atom sequence
 */
#define READ_ONLY			(1L << 0)

/*
 * variable flag definitions
 */
#define REFERENCE			(1L << 1)
#define UNIVERSAL			(1L << 2)

/*
 * variable internal use flag definitions
 */
#define FLAT_LINK			(1L << 3)

/*
 * printing flag definitions
 */
#define DETAIL_CONSTANTS		(1L << 0)
#define DETAIL_IMPLICITS		(1L << 1)
#define DETAIL_OPERATORS		(1L << 2)

/*
 *
 */
#define TRANSFORM_LINKAGE		(1L << 0)
#define TRANSFORM_PRIMARY		(1L << 1)

/*
 *
 */
#define SIGN_TRANSFORM			(1L << 0)

/*
 *
 */
#define DATA_TRANSFORM			0
#define PAIR_TRANSFORM			1

/*
 * zero element promotion flag definitions
 */
#define RDBX_LESS_NONE			(1L << 0)
#define RDBX_MISS_TYPE			(1L << 1)

/*
 *
 */
#define SDBL_TRANSFORM_LINKAGE		(1L << 0)

/*
 *
 */
#define SDBL_HEAD_TRANSFORM		0

/*
 *
 */
#define SDBX_MISS_TYPE			(1L << 0)

/*
 * generation flag definitions
 */
#define COMPOSER_LINK			(1L << 0x1)
#define DIRECT_ACCESS			(1L << 0x2)
#define ERROR_STORAGE			(1L << 0x0)
#define EXTERN_STACKS			(1L << 0x5)
#define IMPLICIT_LINK			(1L << 0x4)
#define PACK_ESTORAGE			(1L << 0x3)
#define RESOURCE_LINK			(1L << 0x6)
#define SEQUENCE_LINK			(1L << 0x8)
#define SKIP_SCOMMENT			(1L << 0x7)
#define SUIT_SLIPTEST			(1L << 0x9)
#define TRANSFER_LINK			(1L << 0xa)
/*
 * FRAGMENT_LINK?
 */

/*
 * expression flag definitions
 */
#define DIRECT_DATA_ACCESS		(1L << 0)
#define EXTERN_STACKS_MESS		(1L << 1)

#endif				/* __LIBx1f4_e4_DEFS_H__ */
