/*
 * e4-byte.h
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_BYTE_H__
#define __LIBx1f4_e4_BYTE_H__

#include <c-types.h>

#define C_BILL_SIZE			C_BILL_SIZEOF

#if C_BILL_SIZEOF == 4
# define __C_BILL_is_4__		1
# define __C_BILL_is_8__		0
#elif C_BILL_SIZE == 8
# define __C_BILL_is_4__		0
# define __C_BILL_is_8__		1
#else
# define __C_BILL_is_4__		0
# define __C_BILL_is_8__		0
#endif				/* C_BILL_SIZEOF == 4 */

#define ___C_BILL_is_4__		__C_BILL_is_4__

#define ____C_BILL_is_4__		__C_BILL_is_4__

#define _____C_BILL_is_4__		__C_BILL_is_4__

#define _____C_BILL_is_8__		__C_BILL_is_8__

#define ____C_BILL_is_8__		__C_BILL_is_8__

#define ___C_BILL_is_8__		__C_BILL_is_8__

#if ____C_BILL_is_4__
# define __C_BILL_is_alien__		0
#elif __C_BILL_is_8__
# define __C_BILL_is_alien__		0
#else
# define __C_BILL_is_alien__		1
#endif				/* ____C_BILL_is_4__ */

#define ____C_BILL_is_alien__		__C_BILL_is_alien__

#define C_MODE_SIZE			C_MODE_SIZEOF

#if C_MODE_SIZEOF == 4
# define __C_MODE_is_4__		1
# define __C_MODE_is_8__		0
#elif C_MODE_SIZE == 8
# define __C_MODE_is_4__		0
# define __C_MODE_is_8__		1
#else
# define __C_MODE_is_4__		0
# define __C_MODE_is_8__		0
#endif				/* C_MODE_SIZEOF == 4 */

#define ___C_MODE_is_4__		__C_MODE_is_4__

#define ____C_MODE_is_4__		__C_MODE_is_4__

#define _____C_MODE_is_4__		__C_MODE_is_4__

#define _____C_MODE_is_8__		__C_MODE_is_8__

#define ____C_MODE_is_8__		__C_MODE_is_8__

#define ___C_MODE_is_8__		__C_MODE_is_8__

#if ____C_MODE_is_4__
# define __C_MODE_is_alien__		0
#elif __C_MODE_is_8__
# define __C_MODE_is_alien__		0
#else
# define __C_MODE_is_alien__		1
#endif				/* ____C_MODE_is_4__ */

#define ____C_MODE_is_alien__		__C_MODE_is_alien__

#define C_REAL_SIZE			C_REAL_SIZEOF

#if C_REAL_SIZEOF == 4
# define __C_REAL_is_4__		1
# define __C_REAL_is_8__		0
#elif C_REAL_SIZE == 8
# define __C_REAL_is_4__		0
# define __C_REAL_is_8__		1
#else
# define __C_REAL_is_4__		0
# define __C_REAL_is_8__		0
#endif				/* C_REAL_SIZEOF == 4 */

#define ___C_REAL_is_4__		__C_REAL_is_4__

#define ____C_REAL_is_4__		__C_REAL_is_4__

#define _____C_REAL_is_4__		__C_REAL_is_4__

#define _____C_REAL_is_8__		__C_REAL_is_8__

#define ____C_REAL_is_8__		__C_REAL_is_8__

#define ___C_REAL_is_8__		__C_REAL_is_8__

#if ____C_REAL_is_4__
# define __C_REAL_is_alien__		0
#elif __C_REAL_is_8__
# define __C_REAL_is_alien__		0
#else
# define __C_REAL_is_alien__		1
#endif				/* ____C_REAL_is_4__ */

#define C_TEXT_SIZE			C_TEXT_SIZEOF

#if C_TEXT_SIZEOF == 4
# define __C_TEXT_is_4__		1
# define __C_TEXT_is_8__		0
#elif C_TEXT_SIZE == 8
# define __C_TEXT_is_4__		0
# define __C_TEXT_is_8__		1
#else
# define __C_TEXT_is_4__		0
# define __C_TEXT_is_8__		0
#endif				/* C_TEXT_SIZEOF == 4 */

#define ___C_TEXT_is_4__		__C_TEXT_is_4__

#define ____C_TEXT_is_4__		__C_TEXT_is_4__

#define _____C_TEXT_is_4__		__C_TEXT_is_4__

#define _____C_TEXT_is_8__		__C_TEXT_is_8__

#define ____C_TEXT_is_8__		__C_TEXT_is_8__

#define ___C_TEXT_is_8__		__C_TEXT_is_8__

#if ____C_TEXT_is_4__
# define __C_TEXT_is_alien__		0
#elif __C_TEXT_is_8__
# define __C_TEXT_is_alien__		0
#else
# define __C_TEXT_is_alien__		1
#endif				/* ____C_TEXT_is_4__ */

#define C_USER_SIZE			C_USER_SIZEOF

#if C_USER_SIZEOF == 4
# define __C_USER_is_4__		1
# define __C_USER_is_8__		0
#elif C_USER_SIZE == 8
# define __C_USER_is_4__		0
# define __C_USER_is_8__		1
#else
# define __C_USER_is_4__		0
# define __C_USER_is_8__		0
#endif				/* C_USER_SIZEOF == 4 */

#define ___C_USER_is_4__		__C_USER_is_4__

#define ____C_USER_is_4__		__C_USER_is_4__

#define _____C_USER_is_4__		__C_USER_is_4__

#define _____C_USER_is_8__		__C_USER_is_8__

#define ____C_USER_is_8__		__C_USER_is_8__

#define ___C_USER_is_8__		__C_USER_is_8__

#if ____C_USER_is_4__
# define __C_USER_is_alien__		0
#elif __C_USER_is_8__
# define __C_USER_is_alien__		0
#else
# define __C_USER_is_alien__		1
#endif				/* ____C_USER_is_4__ */

#if ____C_BILL_is_alien__
# define __C_SIZE_is_alien__		1
#elif __C_MODE_is_alien__
# define __C_SIZE_is_alien__		1
#elif __C_REAL_is_alien__
# define __C_SIZE_is_alien__		1
#elif __C_TEXT_is_alien__
# define __C_SIZE_is_alien__		1
#elif __C_USER_is_alien__
# define __C_SIZE_is_alien__		1
#else
# define __C_SIZE_is_alien__		0
#endif				/* ____C_MODE_is_alien__ */

#define ____C_SIZE_is_alien__		__C_SIZE_is_alien__

#if ____C_SIZE_is_alien__
#else
# if ____C_BILL_is_4__
#  define __C_FAST_is_4__		1
#  define __C_FAST_is_8__		0
# elif __C_MODE_is_4__
#  define __C_FAST_is_4__		1
#  define __C_FAST_is_8__		0
# elif __C_REAL_is_4__
#  define __C_FAST_is_4__		1
#  define __C_FAST_is_8__		0
# elif __C_TEXT_is_4__
#  define __C_FAST_is_4__		1
#  define __C_FAST_is_8__		0
# elif __C_USER_is_4__
#  define __C_FAST_is_4__		1
#  define __C_FAST_is_8__		0
# else
#  define __C_FAST_is_4__		0
#  define __C_FAST_is_8__		1
# endif				/* ____C_MODE_is_4__ */
#endif				/* ____C_SIZE_is_alien__ */

#if ____C_SIZE_is_alien__
# define __COPY_E4_POST__		0
# define __LINE_E4_POST__		1
#else
# define __COPY_E4_POST__		1
# define __LINE_E4_POST__		0
#endif				/* ____C_SIZE_is_alien__ */

#if ____C_SIZE_is_alien__
#else
# define ____C_FAST_is_4__		__C_FAST_is_4__
#endif				/* ____C_SIZE_is_alien__ */

#if ____C_SIZE_is_alien__
#else
# define _____C_FAST_is_4__		__C_FAST_is_4__
#endif				/* ____C_SIZE_is_alien__ */

#if ____C_SIZE_is_alien__
#else
# define ______C_FAST_is_4__		__C_FAST_is_4__
#endif				/* ____C_SIZE_is_alien__ */

#if ____C_SIZE_is_alien__
#else
# define ____C_FAST_is_8__		__C_FAST_is_8__
#endif				/* ____C_SIZE_is_alien__ */

#if ____C_SIZE_is_alien__
#else
# define ___C_FAST_is_8__		__C_FAST_is_8__
#endif				/* ____C_SIZE_is_alien__ */

#if ____C_SIZE_is_alien__
#else
# if ______C_FAST_is_4__
#  if _____C_BILL_is_4__
#   define C_FAST			C_BILL
#  elif ___C_MODE_is_4__
#   define C_FAST			C_MODE
#  elif ___C_REAL_is_4__
#   define C_FAST			C_REAL
#  elif ___C_TEXT_is_4__
#   define C_FAST			C_TEXT
#  elif ___C_USER_is_4__
#   define C_FAST			C_USER
#  endif			/* ____C_MODE_is_4__ */
# elif ____C_FAST_is_8__
#  if _____C_BILL_is_8__
#   define C_FAST			C_BILL
#  elif ___C_MODE_is_8__
#   define C_FAST			C_MODE
#  elif ___C_REAL_is_8__
#   define C_FAST			C_REAL
#  elif ___C_TEXT_is_8__
#   define C_FAST			C_TEXT
#  elif ___C_USER_is_8__
#   define C_FAST			C_USER
#  endif			/* ____C_MODE_is_8__ */
# endif				/* ____C_FAST_is_4__ */
#endif				/* ____C_SIZE_is_alien__ */

#if ____C_SIZE_is_alien__
#else
# if ______C_FAST_is_4__
#  if _____C_BILL_is_4__
#   define C_BILL_COPY			1
#  elif ___C_BILL_is_8__
#   define C_BILL_COPY			2
#  endif			/* ____C_BILL_is_4__ */
#  if _____C_MODE_is_4__
#   define C_MODE_COPY			1
#  elif ___C_MODE_is_8__
#   define C_MODE_COPY			2
#  endif			/* ____C_MODE_is_4__ */
#  if _____C_REAL_is_4__
#   define C_REAL_COPY			1
#  elif ___C_REAL_is_8__
#   define C_REAL_COPY			2
#  endif			/* ____C_REAL_is_4__ */
#  if _____C_TEXT_is_4__
#   define C_TEXT_COPY			1
#  elif ___C_TEXT_is_8__
#   define C_TEXT_COPY			2
#  endif			/* ____C_TEXT_is_4__ */
#  if _____C_USER_is_4__
#   define C_USER_COPY			1
#  elif ___C_USER_is_8__
#   define C_USER_COPY			2
#  endif			/* ____C_USER_is_4__ */
# elif ____C_FAST_is_8__
#  if _____C_BILL_is_8__
#   define C_BILL_COPY			1
#  endif			/* ____C_BILL_is_8__ */
#  if _____C_MODE_is_8__
#   define C_MODE_COPY			1
#  endif			/* ____C_MODE_is_8__ */
#  if _____C_REAL_is_8__
#   define C_REAL_COPY			1
#  endif			/* ____C_REAL_is_8__ */
#  if _____C_TEXT_is_8__
#   define C_TEXT_COPY			1
#  endif			/* ____C_TEXT_is_8__ */
#  if _____C_USER_is_8__
#   define C_USER_COPY			1
#  endif			/* ____C_USER_is_8__ */
# endif				/* ____C_FAST_is_4__ */
#endif				/* ____C_SIZE_is_alien__ */

#endif				/* __LIBx1f4_e4_BYTE_H__ */
