/*
 * e4-bits3.h
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_BITS3_H__
#define __LIBx1f4_e4_BITS3_H__

#include <config.h>

#if !defined BITS_MODE
# if SIZEOF_LONG == 4
#  define BITS_MODE			unsigned
# else
#  define BITS_MODE			unsigned long
# endif				/* SIZEOF_LONG == 4 */
#endif				/* !BITS_MODE */

#if SIZEOF_LONG == 4
# undef e4_base2
# define e4_base2(l4f1_base, l4f1_mode) \
    {									      \
	BITS_MODE a;							      \
									      \
	a = (l4f1_mode);						      \
									      \
	a |= a >> 001;							      \
	a |= a >> 002;							      \
	a |= a >> 004;							      \
	a |= a >> 010;							      \
	a |= a >> 020;							      \
									      \
	(l4f1_base) = a - (a >> 1);					      \
    }
#else
# undef e4_base2
# define e4_base2(l4f1_base, l4f1_mode) \
    {									      \
	BITS_MODE a;							      \
									      \
	a = (l4f1_mode);						      \
									      \
	a |= a >> 001;							      \
	a |= a >> 002;							      \
	a |= a >> 004;							      \
	a |= a >> 010;							      \
	a |= a >> 020;							      \
	a |= a >> 040;							      \
									      \
	(l4f1_base) = a - (a >> 1);					      \
    }
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# undef e4_deck2
# define e4_deck2(l4f1_base, l4f1_mode) \
    {									      \
	BITS_MODE a;							      \
									      \
	a = (l4f1_mode);						      \
									      \
	if (a & (a - 1)) {						      \
	    a |= a >> 001;						      \
	    a |= a >> 002;						      \
	    a |= a >> 004;						      \
	    a |= a >> 010;						      \
	    a |= a >> 020;						      \
									      \
	    a++;							      \
	} else {							      \
	    if (a) {							      \
	    } else {							      \
		a = 1;							      \
	    }								      \
	}								      \
									      \
	(l4f1_base) = a;						      \
    }
#else
# undef e4_deck2
# define e4_deck2(l4f1_base, l4f1_mode) \
    {									      \
	BITS_MODE a;							      \
									      \
	a = (l4f1_mode);						      \
									      \
	if (a & (a - 1)) {						      \
	    a |= a >> 001;						      \
	    a |= a >> 002;						      \
	    a |= a >> 004;						      \
	    a |= a >> 010;						      \
	    a |= a >> 020;						      \
	    a |= a >> 040;						      \
									      \
	    a++;							      \
	} else {							      \
	    if (a) {							      \
	    } else {							      \
		a = 1;							      \
	    }								      \
	}								      \
									      \
	(l4f1_base) = a;						      \
    }
#endif				/* SIZEOF_LONG == 4 */

#endif				/* __LIBx1f4_e4_BITS3_H__ */
