/*
 * e4-arithmetics.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TODO
 *
 * .cross types MISS-PAIR (`!' operator)
 * .additions/subtractions merging
 * .left fill?
 * .left skip for cardinal `-'
 * .-1 * a -> -a <-- replace binary by unary on special constant value
 *     .0 - a -> -a
 *     .~0 ^ a -> ~a
 * .-e * -a -> --e * a <-- accumulate unaries
 * .-(a * a) -> a * -a <--
 * .a = a + 2 -> a += 2
 * .a = 2 + a -> a += 2
 */

#include <stddef.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>
#include <exerrors.h>

#define I_BILL(i)			(*((C_BILL *) (i)))
#define I_MODE(i)			(*((C_MODE *) (i)))
#define I_REAL(r)			(*((C_REAL *) (r)))
#define I_TEXT(t)			(*((C_TEXT *) (t)))

#define A_MISS_FLAG			0

#define l_BILL(e, output) \
    {									      \
	C_BILL *l;							      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }
#define l_MODE(e, output) \
    {									      \
	C_MODE *l;							      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }
#define l_REAL(e, output) \
    {									      \
	C_REAL *l;							      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define MAKE_DOUBLE(a, b)		a b
#define MAKE_SINGLE(a, b)		a

#define MAKE_VIOLET(a, b)		MAKE_DOUBLE(MAKE_DOUBLE(a, b), "=")

/*
 * +--------+------+-------+-------------------+-------+
 * | ()	    |	   |	   |		       |       |
 * | []	    |	   |	   |		       |       |
 * | .	    |	   |	   |		       |       |
 * | ->	    |	   |	   |		       |       |
 * +--------+------+-------+-------------------+-------+
 * | ++	    |	   |	   |		       |       |
 * | --	    |	   |	   |		       |       |
 * | +	    | 0210 | c61xx |		       |       |
 * | -	    | 0210 | c73xx |		       |       |
 * | !	    | 0210 | c6exx |		       |       |
 * | ~	    | 0210 | c6fxx |		       |       |
 * | (type) |	   |	   |		       |       |
 * | *	    |	   |	   |		       |       |
 * | &	    |	   |	   |		       |       |
 * | sizeof |	   |	   |		       |       |
 * +--------+------+-------+-------------------+-------+
 * | *	    | 0220 | c6dxx |		       | KE-SE |
 * | /	    | 0220 | c64xx |		       | KE-SE |
 * | %	    | 0220 | c72xx |		       |       |
 * +--------+------+-------+-------------------+-------+
 * | +	    | 0230 | c61xx |		       | ---SE |
 * | -	    | 0230 | c73xx |		       | ---SE |
 * +--------+------+-------+-------------------+-------+
 * | <<	    | 0240 | c6bxx | ------AS-------CS | KE-SE |
 * | >>	    | 0240 | c74xx | ------AS-------CS | KE-SE |
 * +--------+------+-------+-------------------+-------+
 * | <	    | 0250 | c6cxx |		       |       |
 * | <=	    | 0250 | c7bxx |		       |       |
 * | >	    | 0250 | c67xx |		       |       |
 * | >=	    | 0250 | c7cxx |		       |       |
 * +--------+------+-------+-------------------+-------+
 * | ==	    | 0260 | c65xx |		       |       |
 * | !=	    | 0260 | c76xx |		       |       |
 * +--------+------+-------+-------------------+-------+
 * | &	    | 0270 | c77xx | AA-AC----CA-CC--- | KE-SE |
 * +--------+------+-------+-------------------+-------+
 * | ^	    | 0300 | c78xx | AA-AC----CA-CC--- | ---SE |
 * +--------+------+-------+-------------------+-------+
 * | |	    | 0310 | c79xx | AA-AC----CA-CC--- | KE-SE |
 * +--------+------+-------+-------------------+-------+
 * | &&	    | 0320 | c62xx | AA-AC----CA-CC--- | KE    |
 * +--------+------+-------+-------------------+-------+
 * | ||	    | 0330 | c63xx | AA-AC----CA-CC--- | KE    |
 * +--------+------+-------+-------------------+-------+
 * | ?:	    |	   |	   |		       |       |
 * +--------+------+-------+-------------------+-------+
 * | =	    | 0400 | c7axx |		       |       |
 * | +=	    | 0400 | c70xx |		       | ---SE |
 * | -=	    | 0400 | c71xx |		       | ---SE |
 * | *=	    | 0400 | c2exx |		       | ---SE |
 * | /=	    | 0400 | c2cxx |		       | ---SE |
 * | %=	    | 0400 | c5fxx |		       |       |
 * | &=	    | 0400 | c68xx |		       | ---SE |
 * | ^=	    | 0400 | c69xx |		       | ---SE |
 * | |=	    | 0400 | c6axx |		       | ---SE |
 * | <<=    | 0400 | c66xx |		       | ---SE |
 * | >>=    | 0400 | c75xx |		       | ---SE |
 * +--------+------+-------+-------------------+-------+
 * | ,	    |	   |	   |		       |       |
 * +--------+------+-------+-------------------+-------+
 */

static int c2cxx_b_b(x1f4_e4_LINE_ARGS_0);
static int c2cxx_b_m(x1f4_e4_LINE_ARGS_0);
static int c2cxx_b_r(x1f4_e4_LINE_ARGS_0);
static int c2cxx_m_b(x1f4_e4_LINE_ARGS_0);
static int c2cxx_m_m(x1f4_e4_LINE_ARGS_0);
static int c2cxx_m_r(x1f4_e4_LINE_ARGS_0);
static int c2cxx_r_b(x1f4_e4_LINE_ARGS_0);
static int c2cxx_r_m(x1f4_e4_LINE_ARGS_0);
static int c2cxx_r_r(x1f4_e4_LINE_ARGS_0);
static int c2exx_b_b(x1f4_e4_LINE_ARGS_0);
static int c2exx_b_m(x1f4_e4_LINE_ARGS_0);
static int c2exx_b_r(x1f4_e4_LINE_ARGS_0);
static int c2exx_m_b(x1f4_e4_LINE_ARGS_0);
static int c2exx_m_m(x1f4_e4_LINE_ARGS_0);
static int c2exx_m_r(x1f4_e4_LINE_ARGS_0);
static int c2exx_r_b(x1f4_e4_LINE_ARGS_0);
static int c2exx_r_m(x1f4_e4_LINE_ARGS_0);
static int c2exx_r_r(x1f4_e4_LINE_ARGS_0);
static int c5fxx_b_b(x1f4_e4_LINE_ARGS_0);
static int c5fxx_b_m(x1f4_e4_LINE_ARGS_0);
static int c5fxx_m_b(x1f4_e4_LINE_ARGS_0);
static int c5fxx_m_m(x1f4_e4_LINE_ARGS_0);
static int c61xx_b__(x1f4_e4_LINE_ARGS_0);
static int c61xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c61xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c61xx_b_r(x1f4_e4_LINE_ARGS_0);
static int c61xx_m__(x1f4_e4_LINE_ARGS_0);
static int c61xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c61xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c61xx_m_r(x1f4_e4_LINE_ARGS_0);
static int c61xx_r__(x1f4_e4_LINE_ARGS_0);
static int c61xx_r_b(x1f4_e4_LINE_ARGS_0);
static int c61xx_r_m(x1f4_e4_LINE_ARGS_0);
static int c61xx_r_r(x1f4_e4_LINE_ARGS_0);
static int c62xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c62xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c62xx_b_r(x1f4_e4_LINE_ARGS_0);
static int c62xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c62xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c62xx_m_r(x1f4_e4_LINE_ARGS_0);
static int c62xx_r_b(x1f4_e4_LINE_ARGS_0);
static int c62xx_r_m(x1f4_e4_LINE_ARGS_0);
static int c62xx_r_r(x1f4_e4_LINE_ARGS_0);
static int c63xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c63xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c63xx_b_r(x1f4_e4_LINE_ARGS_0);
static int c63xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c63xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c63xx_m_r(x1f4_e4_LINE_ARGS_0);
static int c63xx_r_b(x1f4_e4_LINE_ARGS_0);
static int c63xx_r_m(x1f4_e4_LINE_ARGS_0);
static int c63xx_r_r(x1f4_e4_LINE_ARGS_0);
static int c64xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c64xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c64xx_b_r(x1f4_e4_LINE_ARGS_0);
static int c64xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c64xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c64xx_m_r(x1f4_e4_LINE_ARGS_0);
static int c64xx_r_b(x1f4_e4_LINE_ARGS_0);
static int c64xx_r_m(x1f4_e4_LINE_ARGS_0);
static int c64xx_r_r(x1f4_e4_LINE_ARGS_0);
static int c65xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c65xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c65xx_b_r(x1f4_e4_LINE_ARGS_0);
static int c65xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c65xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c65xx_m_r(x1f4_e4_LINE_ARGS_0);
static int c65xx_r_b(x1f4_e4_LINE_ARGS_0);
static int c65xx_r_m(x1f4_e4_LINE_ARGS_0);
static int c65xx_r_r(x1f4_e4_LINE_ARGS_0);
static int c65xx_t_t(x1f4_e4_LINE_ARGS_0);
static int c66xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c66xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c66xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c66xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c67xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c67xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c67xx_b_r(x1f4_e4_LINE_ARGS_0);
static int c67xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c67xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c67xx_m_r(x1f4_e4_LINE_ARGS_0);
static int c67xx_r_b(x1f4_e4_LINE_ARGS_0);
static int c67xx_r_m(x1f4_e4_LINE_ARGS_0);
static int c67xx_r_r(x1f4_e4_LINE_ARGS_0);
static int c67xx_t_t(x1f4_e4_LINE_ARGS_0);
static int c68xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c68xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c68xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c68xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c69xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c69xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c69xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c69xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c6axx_b_b(x1f4_e4_LINE_ARGS_0);
static int c6axx_b_m(x1f4_e4_LINE_ARGS_0);
static int c6axx_m_b(x1f4_e4_LINE_ARGS_0);
static int c6axx_m_m(x1f4_e4_LINE_ARGS_0);
static int c6bxx_b_b(x1f4_e4_LINE_ARGS_0);
static int c6bxx_b_m(x1f4_e4_LINE_ARGS_0);
static int c6bxx_m_b(x1f4_e4_LINE_ARGS_0);
static int c6bxx_m_m(x1f4_e4_LINE_ARGS_0);
static int c6cxx_b_b(x1f4_e4_LINE_ARGS_0);
static int c6cxx_b_m(x1f4_e4_LINE_ARGS_0);
static int c6cxx_b_r(x1f4_e4_LINE_ARGS_0);
static int c6cxx_m_b(x1f4_e4_LINE_ARGS_0);
static int c6cxx_m_m(x1f4_e4_LINE_ARGS_0);
static int c6cxx_m_r(x1f4_e4_LINE_ARGS_0);
static int c6cxx_r_b(x1f4_e4_LINE_ARGS_0);
static int c6cxx_r_m(x1f4_e4_LINE_ARGS_0);
static int c6cxx_r_r(x1f4_e4_LINE_ARGS_0);
static int c6cxx_t_t(x1f4_e4_LINE_ARGS_0);
static int c6dxx_b_b(x1f4_e4_LINE_ARGS_0);
static int c6dxx_b_m(x1f4_e4_LINE_ARGS_0);
static int c6dxx_b_r(x1f4_e4_LINE_ARGS_0);
static int c6dxx_m_b(x1f4_e4_LINE_ARGS_0);
static int c6dxx_m_m(x1f4_e4_LINE_ARGS_0);
static int c6dxx_m_r(x1f4_e4_LINE_ARGS_0);
static int c6dxx_r_b(x1f4_e4_LINE_ARGS_0);
static int c6dxx_r_r(x1f4_e4_LINE_ARGS_0);
static int c6dxx_r_m(x1f4_e4_LINE_ARGS_0);
static int c6dxx_r_r(x1f4_e4_LINE_ARGS_0);
static int c6exx_b__(x1f4_e4_LINE_ARGS_0);
static int c6exx_m__(x1f4_e4_LINE_ARGS_0);
static int c6exx_r__(x1f4_e4_LINE_ARGS_0);
static int c6fxx_b__(x1f4_e4_LINE_ARGS_0);
static int c6fxx_m__(x1f4_e4_LINE_ARGS_0);
static int c70xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c70xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c70xx_b_r(x1f4_e4_LINE_ARGS_0);
static int c70xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c70xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c70xx_m_r(x1f4_e4_LINE_ARGS_0);
static int c70xx_r_b(x1f4_e4_LINE_ARGS_0);
static int c70xx_r_m(x1f4_e4_LINE_ARGS_0);
static int c70xx_r_r(x1f4_e4_LINE_ARGS_0);
static int c71xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c71xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c71xx_b_r(x1f4_e4_LINE_ARGS_0);
static int c71xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c71xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c71xx_m_r(x1f4_e4_LINE_ARGS_0);
static int c71xx_r_b(x1f4_e4_LINE_ARGS_0);
static int c71xx_r_m(x1f4_e4_LINE_ARGS_0);
static int c71xx_r_r(x1f4_e4_LINE_ARGS_0);
static int c72xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c72xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c72xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c72xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c73xx_b__(x1f4_e4_LINE_ARGS_0);
static int c73xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c73xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c73xx_b_r(x1f4_e4_LINE_ARGS_0);
static int c73xx_m__(x1f4_e4_LINE_ARGS_0);
static int c73xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c73xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c73xx_m_r(x1f4_e4_LINE_ARGS_0);
static int c73xx_r__(x1f4_e4_LINE_ARGS_0);
static int c73xx_r_b(x1f4_e4_LINE_ARGS_0);
static int c73xx_r_m(x1f4_e4_LINE_ARGS_0);
static int c73xx_r_r(x1f4_e4_LINE_ARGS_0);
static int c74xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c74xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c74xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c74xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c75xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c75xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c75xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c75xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c76xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c76xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c76xx_b_r(x1f4_e4_LINE_ARGS_0);
static int c76xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c76xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c76xx_m_r(x1f4_e4_LINE_ARGS_0);
static int c76xx_r_b(x1f4_e4_LINE_ARGS_0);
static int c76xx_r_m(x1f4_e4_LINE_ARGS_0);
static int c76xx_r_r(x1f4_e4_LINE_ARGS_0);
static int c76xx_t_t(x1f4_e4_LINE_ARGS_0);
static int c77xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c77xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c77xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c77xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c78xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c78xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c78xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c78xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c79xx_b_b(x1f4_e4_LINE_ARGS_0);
static int c79xx_b_m(x1f4_e4_LINE_ARGS_0);
static int c79xx_m_b(x1f4_e4_LINE_ARGS_0);
static int c79xx_m_m(x1f4_e4_LINE_ARGS_0);
static int c7axx_b_b(x1f4_e4_LINE_ARGS_0);
static int c7axx_b_m(x1f4_e4_LINE_ARGS_0);
static int c7axx_b_r(x1f4_e4_LINE_ARGS_0);
static int c7axx_m_b(x1f4_e4_LINE_ARGS_0);
static int c7axx_m_m(x1f4_e4_LINE_ARGS_0);
static int c7axx_m_r(x1f4_e4_LINE_ARGS_0);
static int c7axx_r_b(x1f4_e4_LINE_ARGS_0);
static int c7axx_r_m(x1f4_e4_LINE_ARGS_0);
static int c7axx_r_r(x1f4_e4_LINE_ARGS_0);
static int c7bxx_b_b(x1f4_e4_LINE_ARGS_0);
static int c7bxx_b_m(x1f4_e4_LINE_ARGS_0);
static int c7bxx_b_r(x1f4_e4_LINE_ARGS_0);
static int c7bxx_m_b(x1f4_e4_LINE_ARGS_0);
static int c7bxx_m_m(x1f4_e4_LINE_ARGS_0);
static int c7bxx_m_r(x1f4_e4_LINE_ARGS_0);
static int c7bxx_r_b(x1f4_e4_LINE_ARGS_0);
static int c7bxx_r_m(x1f4_e4_LINE_ARGS_0);
static int c7bxx_r_r(x1f4_e4_LINE_ARGS_0);
static int c7bxx_t_t(x1f4_e4_LINE_ARGS_0);
static int c7cxx_b_b(x1f4_e4_LINE_ARGS_0);
static int c7cxx_b_m(x1f4_e4_LINE_ARGS_0);
static int c7cxx_b_r(x1f4_e4_LINE_ARGS_0);
static int c7cxx_m_b(x1f4_e4_LINE_ARGS_0);
static int c7cxx_m_m(x1f4_e4_LINE_ARGS_0);
static int c7cxx_m_r(x1f4_e4_LINE_ARGS_0);
static int c7cxx_r_b(x1f4_e4_LINE_ARGS_0);
static int c7cxx_r_m(x1f4_e4_LINE_ARGS_0);
static int c7cxx_r_r(x1f4_e4_LINE_ARGS_0);
static int c7cxx_t_t(x1f4_e4_LINE_ARGS_0);

static int link_1 = 1, link_2 = 1;
static const int c_____b__[] = {
/* *INDENT-OFF* */
    BILL
/* *INDENT-ON* */
}, c_____b_b[] = {
/* *INDENT-OFF* */
    BILL,
    BILL
/* *INDENT-ON* */
}, c_____b_m[] = {
/* *INDENT-OFF* */
    BILL,
    MODE
/* *INDENT-ON* */
}, c_____b_r[] = {
/* *INDENT-OFF* */
    BILL,
    REAL
/* *INDENT-ON* */
}, c_____m__[] = {
/* *INDENT-OFF* */
    MODE
/* *INDENT-ON* */
}, c_____m_b[] = {
/* *INDENT-OFF* */
    MODE,
    BILL
/* *INDENT-ON* */
}, c_____m_m[] = {
/* *INDENT-OFF* */
    MODE,
    MODE
/* *INDENT-ON* */
}, c_____m_r[] = {
/* *INDENT-OFF* */
    MODE,
    REAL
/* *INDENT-ON* */
}, c_____r__[] = {
/* *INDENT-OFF* */
    REAL
/* *INDENT-ON* */
}, c_____r_b[] = {
/* *INDENT-OFF* */
    REAL,
    BILL
/* *INDENT-ON* */
}, c_____r_m[] = {
/* *INDENT-OFF* */
    REAL,
    MODE
/* *INDENT-ON* */
}, c_____r_r[] = {
/* *INDENT-OFF* */
    REAL,
    REAL
/* *INDENT-ON* */
}, c_____t_t[] = {
/* *INDENT-OFF* */
    TEXT,
    TEXT
/* *INDENT-ON* */
};
static const C_BILL mone_bill[] = {
/* *INDENT-OFF* */
    ~0
/* *INDENT-ON* */
}, pone_bill[] = {
/* *INDENT-OFF* */
    1
/* *INDENT-ON* */
}, zero_bill[] = {
/* *INDENT-OFF* */
    0
/* *INDENT-ON* */
};
static const C_MODE mone_mode[] = {
/* *INDENT-OFF* */
    ~0
/* *INDENT-ON* */
}, pone_mode[] = {
/* *INDENT-OFF* */
    1
/* *INDENT-ON* */
}, zero_mode[] = {
/* *INDENT-OFF* */
    0
/* *INDENT-ON* */
};
static const C_REAL real_pone[] = {
/* *INDENT-OFF* */
    1
/* *INDENT-ON* */
}, real_zero[] = {
/* *INDENT-OFF* */
    0
/* *INDENT-ON* */
};
static struct e4_odbx_type e2cxx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("/", "="),  c2cxx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2cxx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("/", "="),  c2cxx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2cxx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("/", "="),  c2cxx_b_r,	0400,
	BILL,			c_____b_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2cxx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("/", "="),  c2cxx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2cxx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("/", "="),  c2cxx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2cxx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("/", "="),  c2cxx_m_r,	0400,
	MODE,			c_____m_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2cxx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("/", "="),  c2cxx_r_b,	0400,
	REAL,			c_____r_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2cxx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("/", "="),  c2cxx_r_m,	0400,
	REAL,			c_____r_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2cxx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("/", "="),	c2cxx_r_r,	0400,
	REAL,			c_____r_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2exx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("*", "="),  c2exx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2exx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("*", "="),  c2exx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2exx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("*", "="),  c2exx_b_r,	0400,
	BILL,			c_____b_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2exx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("*", "="),  c2exx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2exx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("*", "="),  c2exx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2exx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("*", "="),  c2exx_m_r,	0400,
	MODE,			c_____m_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2exx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("*", "="),  c2exx_r_b,	0400,
	REAL,			c_____r_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2exx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("*", "="),  c2exx_r_m,	0400,
	REAL,			c_____r_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e2exx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("*", "="),	c2exx_r_r,	0400,
	REAL,			c_____r_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e5fxx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("%", "="),  c5fxx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | LEFT_XSET,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e5fxx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("%", "="),  c5fxx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | LEFT_XSET,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e5fxx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("%", "="),  c5fxx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | LEFT_XSET,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e5fxx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("%", "="),  c5fxx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | LEFT_XSET,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_b__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_b__,	0210,
	BILL,			c_____b__,
	LOSE_DATA,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_b_b,	0230,
	BILL,			c_____b_b,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_b_m,	0230,
	BILL,			c_____b_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_b_r,	0230,
	REAL,			c_____b_r,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_m__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_m__,	0210,
	MODE,			c_____m__,
	LOSE_DATA,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_m_b,	0230,
	BILL,			c_____m_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_m_m,	0230,
	MODE,			c_____m_m,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_m_r,	0230,
	REAL,			c_____m_r,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_r__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_r__,	0210,
	REAL,			c_____r__,
	LOSE_DATA,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_r_b,	0230,
	REAL,			c_____r_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_r_m,	0230,
	REAL,			c_____r_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e61xx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c61xx_r_r,	0230,
	REAL,			c_____r_r,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e62xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "&"),  c62xx_b_b,	0320,
	MODE,			c_____b_b,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e62xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "&"),  c62xx_b_m,	0320,
	MODE,			c_____b_m,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e62xx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "&"),  c62xx_b_r,	0320,
	MODE,			c_____b_r,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e62xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "&"),  c62xx_m_b,	0320,
	MODE,			c_____m_b,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e62xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "&"),  c62xx_m_m,	0320,
	MODE,			c_____m_m,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e62xx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "&"),  c62xx_m_r,	0320,
	MODE,			c_____m_r,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e62xx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "&"),  c62xx_r_b,	0320,
	MODE,			c_____r_b,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e62xx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "&"),  c62xx_r_m,	0320,
	MODE,			c_____r_m,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e62xx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "&"),  c62xx_r_r,	0320,
	MODE,			c_____r_r,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, *e62xx____[] = {
/* *INDENT-OFF* */
    e62xx_b_b,
    e62xx_b_m,
    e62xx_b_r,
    e62xx_m_b,
    e62xx_m_m,
    e62xx_m_r,
    e62xx_r_b,
    e62xx_r_m,
    e62xx_r_r,
    NULL
/* *INDENT-ON* */
}, e63xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "|"),  c63xx_b_b,	0330,
	MODE,			c_____b_b,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e63xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "|"),  c63xx_b_m,	0330,
	MODE,			c_____b_m,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e63xx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "|"),  c63xx_b_r,	0330,
	MODE,			c_____b_r,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e63xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "|"),  c63xx_m_b,	0330,
	MODE,			c_____m_b,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e63xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "|"),  c63xx_m_m,	0330,
	MODE,			c_____m_m,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e63xx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "|"),  c63xx_m_r,	0330,
	MODE,			c_____m_r,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e63xx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "|"),  c63xx_r_b,	0330,
	MODE,			c_____r_b,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e63xx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "|"),  c63xx_r_m,	0330,
	MODE,			c_____r_m,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e63xx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "|"),  c63xx_r_r,	0330,
	MODE,			c_____r_r,
	E1ST_LINK | E2ND_LINK,			2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, *e63xx____[] = {
/* *INDENT-OFF* */
    e63xx_b_b,
    e63xx_b_m,
    e63xx_b_r,
    e63xx_m_b,
    e63xx_m_m,
    e63xx_m_r,
    e63xx_r_b,
    e63xx_r_m,
    e63xx_r_r,
    NULL
/* *INDENT-ON* */
}, e64xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("/", " "),  c64xx_b_b,	0220,
	BILL,			c_____b_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e64xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("/", " "),  c64xx_b_m,	0220,
	BILL,			c_____b_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e64xx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("/", " "),  c64xx_b_r,	0220,
	REAL,			c_____b_r,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e64xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("/", " "),  c64xx_m_b,	0220,
	BILL,			c_____m_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e64xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("/", " "),  c64xx_m_m,	0220,
	MODE,			c_____m_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e64xx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("/", " "),  c64xx_m_r,	0220,
	REAL,			c_____m_r,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e64xx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("/", " "),  c64xx_r_b,	0220,
	REAL,			c_____r_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e64xx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("/", " "),  c64xx_r_m,	0220,
	REAL,			c_____r_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e64xx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("/", " "),  c64xx_r_r,	0220,
	REAL,			c_____r_r,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e65xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("=", "="),	c65xx_b_b,	0260,
	MODE,			c_____b_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e65xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("=", "="),	c65xx_b_m,	0260,
	MODE,			c_____b_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e65xx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("=", "="),	c65xx_b_r,	0260,
	MODE,			c_____b_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e65xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("=", "="),	c65xx_m_b,	0260,
	MODE,			c_____m_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e65xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("=", "="),	c65xx_m_m,	0260,
	MODE,			c_____m_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e65xx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("=", "="),	c65xx_m_r,	0260,
	MODE,			c_____m_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e65xx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("=", "="),	c65xx_r_b,	0260,
	MODE,			c_____r_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e65xx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("=", "="),	c65xx_r_m,	0260,
	MODE,			c_____r_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e65xx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("=", "="),	c65xx_r_r,	0260,
	MODE,			c_____r_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e65xx_t_t[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("=", "="),	c65xx_t_t,	0260,
	MODE,			c_____t_t,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e66xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_VIOLET("<", "<"),  c66xx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	3,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e66xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_VIOLET("<", "<"),  c66xx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	3,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e66xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_VIOLET("<", "<"),  c66xx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	3,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e66xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_VIOLET("<", "<"),  c66xx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	3,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e67xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE(">", " "),  c67xx_b_b,	0250,
	MODE,			c_____b_b,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e67xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE(">", " "),  c67xx_b_m,	0250,
	MODE,			c_____b_m,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e67xx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE(">", " "),  c67xx_b_r,	0250,
	MODE,			c_____b_r,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e67xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE(">", " "),  c67xx_m_b,	0250,
	MODE,			c_____m_b,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e67xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE(">", " "),  c67xx_m_m,	0250,
	MODE,			c_____m_m,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e67xx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE(">", " "),  c67xx_m_r,	0250,
	MODE,			c_____m_r,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e67xx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE(">", " "),  c67xx_r_b,	0250,
	MODE,			c_____r_b,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e67xx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE(">", " "),  c67xx_r_m,	0250,
	MODE,			c_____r_m,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e67xx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE(">", " "),  c67xx_r_r,	0250,
	MODE,			c_____r_r,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e67xx_t_t[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE(">", " "),  c67xx_t_t,	0250,
	MODE,			c_____t_t,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e68xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "="),  c68xx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e68xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "="),  c68xx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e68xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "="),  c68xx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e68xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("&", "="),  c68xx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e69xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("^", "="),  c69xx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e69xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("^", "="),  c69xx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e69xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("^", "="),  c69xx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e69xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("^", "="),  c69xx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6axx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "="),  c6axx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6axx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "="),  c6axx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6axx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "="),  c6axx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6axx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("|", "="),  c6axx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6bxx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "<"),  c6bxx_b_b,	0240,
	BILL,			c_____b_b,
	E1ST_LINK,				2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6bxx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "<"),  c6bxx_b_m,	0240,
	BILL,			c_____b_m,
	E1ST_LINK,				2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6bxx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "<"),  c6bxx_m_b,	0240,
	MODE,			c_____m_b,
	E1ST_LINK,				2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6bxx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "<"),  c6bxx_m_m,	0240,
	MODE,			c_____m_m,
	E1ST_LINK,				2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6cxx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("<", " "),  c6cxx_b_b,	0250,
	MODE,			c_____b_b,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6cxx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("<", " "),  c6cxx_b_m,	0250,
	MODE,			c_____b_m,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6cxx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("<", " "),  c6cxx_b_r,	0250,
	MODE,			c_____b_r,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6cxx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("<", " "),  c6cxx_m_b,	0250,
	MODE,			c_____m_b,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6cxx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("<", " "),  c6cxx_m_m,	0250,
	MODE,			c_____m_m,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6cxx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("<", " "),  c6cxx_m_r,	0250,
	MODE,			c_____m_r,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6cxx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("<", " "),  c6cxx_r_b,	0250,
	MODE,			c_____r_b,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6cxx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("<", " "),  c6cxx_r_m,	0250,
	MODE,			c_____r_m,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6cxx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("<", " "),  c6cxx_r_r,	0250,
	MODE,			c_____r_r,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6cxx_t_t[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("<", " "),  c6cxx_t_t,	0250,
	MODE,			c_____t_t,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6dxx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("*", " "),  c6dxx_b_b,	0220,
	BILL,			c_____b_b,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6dxx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("*", " "),  c6dxx_b_m,	0220,
	BILL,			c_____b_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6dxx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("*", " "),  c6dxx_b_r,	0220,
	REAL,			c_____b_r,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6dxx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("*", " "),  c6dxx_m_b,	0220,
	BILL,			c_____m_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6dxx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("*", " "),  c6dxx_m_m,	0220,
	MODE,			c_____m_m,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6dxx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("*", " "),  c6dxx_m_r,	0220,
	REAL,			c_____m_r,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6dxx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("*", " "),  c6dxx_r_b,	0220,
	REAL,			c_____r_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6dxx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("*", " "),  c6dxx_r_m,	0220,
	REAL,			c_____r_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6dxx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("*", " "),  c6dxx_r_r,	0220,
	REAL,			c_____r_r,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6exx_b__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("!", " "),  c6exx_b__,	0210,
	MODE,			c_____b__,
	MISS_PAIR,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6exx_m__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("!", " "),  c6exx_m__,	0210,
	MODE,			c_____m__,
	MISS_PAIR,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6exx_r__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("!", " "),  c6exx_r__,	0210,
	MODE,			c_____r__,
	MISS_PAIR,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6fxx_b__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("~", " "),  c6fxx_b__,	0210,
	BILL,			c_____b__,
	KILL_PAIR,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e6fxx_m__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("~", " "),  c6fxx_m__,	0210,
	MODE,			c_____m__,
	KILL_PAIR,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e70xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("+", "="),  c70xx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e70xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("+", "="),  c70xx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e70xx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("+", "="),  c70xx_b_r,	0400,
	BILL,			c_____b_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e70xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("+", "="),  c70xx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e70xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("+", "="),  c70xx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e70xx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("+", "="),  c70xx_m_r,	0400,
	MODE,			c_____m_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e70xx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("+", "="),  c70xx_r_b,	0400,
	REAL,			c_____r_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e70xx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("+", "="),  c70xx_r_m,	0400,
	REAL,			c_____r_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e70xx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("+", "="),	c70xx_r_r,	0400,
	REAL,			c_____r_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e71xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("-", "="),  c71xx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e71xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("-", "="),  c71xx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e71xx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("-", "="),  c71xx_b_r,	0400,
	BILL,			c_____b_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e71xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("-", "="),  c71xx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e71xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("-", "="),  c71xx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e71xx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("-", "="),  c71xx_m_r,	0400,
	MODE,			c_____m_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e71xx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("-", "="),  c71xx_r_b,	0400,
	REAL,			c_____r_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e71xx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("-", "="),  c71xx_r_m,	0400,
	REAL,			c_____r_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e71xx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("-", "="),	c71xx_r_r,	0400,
	REAL,			c_____r_r,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e72xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("%", " "),  c72xx_b_b,	0220,
	BILL,			c_____b_b,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e72xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("%", " "),  c72xx_b_m,	0220,
	BILL,			c_____b_m,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e72xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("%", " "),  c72xx_m_b,	0220,
	BILL,			c_____m_b,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e72xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("%", " "),  c72xx_m_m,	0220,
	MODE,			c_____m_m,
	0,					1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_b__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_b__,	0210,
	BILL,			c_____b__,
	KILL_PAIR,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_b_b,	0230,
	BILL,			c_____b_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_b_m,	0230,
	BILL,			c_____b_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_b_r,	0230,
	REAL,			c_____b_r,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_m__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_m__,	0210,
	MODE,			c_____m__,
	KILL_PAIR,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_m_b,	0230,
	BILL,			c_____m_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_m_m,	0230,
	MODE,			c_____m_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_m_r,	0230,
	REAL,			c_____m_r,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_r__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_r__,	0210,
	REAL,			c_____r__,
	KILL_PAIR,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_r_b,	0230,
	REAL,			c_____r_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_r_m,	0230,
	REAL,			c_____r_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e73xx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c73xx_r_r,	0230,
	REAL,			c_____r_r,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e74xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", ">"),  c74xx_b_b,	0240,
	BILL,			c_____b_b,
	E1ST_LINK,				2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e74xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", ">"),  c74xx_b_m,	0240,
	BILL,			c_____b_m,
	E1ST_LINK,				2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e74xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", ">"),  c74xx_m_b,	0240,
	MODE,			c_____m_b,
	E1ST_LINK,				2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e74xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", ">"),  c74xx_m_m,	0240,
	MODE,			c_____m_m,
	E1ST_LINK,				2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e75xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_VIOLET(">", ">"),  c75xx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	3,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e75xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_VIOLET(">", ">"),  c75xx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	3,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e75xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_VIOLET(">", ">"),  c75xx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	3,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e75xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_VIOLET(">", ">"),  c75xx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | E1ST_LINK | LEFT_XSET,	3,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e76xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("!", "="),	c76xx_b_b,	0260,
	MODE,			c_____b_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e76xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("!", "="),	c76xx_b_m,	0260,
	MODE,			c_____b_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e76xx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("!", "="),	c76xx_b_r,	0260,
	MODE,			c_____b_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e76xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("!", "="),	c76xx_m_b,	0260,
	MODE,			c_____m_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e76xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("!", "="),	c76xx_m_m,	0260,
	MODE,			c_____m_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e76xx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("!", "="),	c76xx_m_r,	0260,
	MODE,			c_____m_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e76xx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("!", "="),	c76xx_r_b,	0260,
	MODE,			c_____r_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e76xx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("!", "="),	c76xx_r_m,	0260,
	MODE,			c_____r_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e76xx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("!", "="),	c76xx_r_r,	0260,
	MODE,			c_____r_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e76xx_t_t[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("!", "="),	c76xx_t_t,	0260,
	MODE,			c_____t_t,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e77xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("&", " "),  c77xx_b_b,	0270,
	BILL,			c_____b_b,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e77xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("&", " "),  c77xx_b_m,	0270,
	BILL,			c_____b_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e77xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("&", " "),  c77xx_m_b,	0270,
	BILL,			c_____m_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e77xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("&", " "),  c77xx_m_m,	0270,
	MODE,			c_____m_m,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e78xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("^", " "),  c78xx_b_b,	0300,
	BILL,			c_____b_b,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e78xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("^", " "),  c78xx_b_m,	0300,
	BILL,			c_____b_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e78xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("^", " "),  c78xx_m_b,	0300,
	BILL,			c_____m_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e78xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("^", " "),  c78xx_m_m,	0300,
	MODE,			c_____m_m,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e79xx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("|", " "),  c79xx_b_b,	0310,
	BILL,			c_____b_b,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e79xx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("|", " "),  c79xx_b_m,	0310,
	BILL,			c_____b_m,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e79xx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("|", " "),  c79xx_m_b,	0310,
	BILL,			c_____m_b,
	E1ST_LINK,				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e79xx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("|", " "),  c79xx_m_m,	0310,
	MODE,			c_____m_m,
	E1ST_LINK | E2ND_LINK,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7axx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c7axx_b_b,	0400,
	BILL,			c_____b_b,
	BACK_LINK | LEFT_XSET,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7axx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c7axx_b_m,	0400,
	BILL,			c_____b_m,
	BACK_LINK | LEFT_XSET,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7axx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c7axx_b_r,	0400,
	BILL,			c_____b_r,
	BACK_LINK | LEFT_XSET,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7axx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c7axx_m_b,	0400,
	MODE,			c_____m_b,
	BACK_LINK | LEFT_XSET,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7axx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c7axx_m_m,	0400,
	MODE,			c_____m_m,
	BACK_LINK | LEFT_XSET,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7axx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c7axx_m_r,	0400,
	MODE,			c_____m_r,
	BACK_LINK | LEFT_XSET,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7axx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c7axx_r_b,	0400,
	REAL,			c_____r_b,
	BACK_LINK | LEFT_XSET,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7axx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c7axx_r_m,	0400,
	REAL,			c_____r_m,
	BACK_LINK | LEFT_XSET,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7axx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),	c7axx_r_r,	0400,
	REAL,			c_____r_r,
	BACK_LINK | LEFT_XSET,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7bxx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "="),  c7bxx_b_b,	0250,
	MODE,			c_____b_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7bxx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "="),  c7bxx_b_m,	0250,
	MODE,			c_____b_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7bxx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "="),  c7bxx_b_r,	0250,
	MODE,			c_____b_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7bxx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "="),  c7bxx_m_b,	0250,
	MODE,			c_____m_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7bxx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "="),  c7bxx_m_m,	0250,
	MODE,			c_____m_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7bxx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "="),  c7bxx_m_r,	0250,
	MODE,			c_____m_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7bxx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "="),  c7bxx_r_b,	0250,
	MODE,			c_____r_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7bxx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "="),  c7bxx_r_m,	0250,
	MODE,			c_____r_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7bxx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "="),  c7bxx_r_r,	0250,
	MODE,			c_____r_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7bxx_t_t[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE("<", "="),  c7bxx_t_t,	0250,
	MODE,			c_____t_t,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7cxx_b_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", "="),  c7cxx_b_b,	0250,
	MODE,			c_____b_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7cxx_b_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", "="),  c7cxx_b_m,	0250,
	MODE,			c_____b_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7cxx_b_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", "="),  c7cxx_b_r,	0250,
	MODE,			c_____b_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7cxx_m_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", "="),  c7cxx_m_b,	0250,
	MODE,			c_____m_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7cxx_m_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", "="),  c7cxx_m_m,	0250,
	MODE,			c_____m_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7cxx_m_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", "="),  c7cxx_m_r,	0250,
	MODE,			c_____m_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7cxx_r_b[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", "="),  c7cxx_r_b,	0250,
	MODE,			c_____r_b,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7cxx_r_m[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", "="),  c7cxx_r_m,	0250,
	MODE,			c_____r_m,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7cxx_r_r[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", "="),  c7cxx_r_r,	0250,
	MODE,			c_____r_r,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e7cxx_t_t[] = {
/* *INDENT-OFF* */
    {	MAKE_DOUBLE(">", "="),  c7cxx_t_t,	0250,
	MODE,			c_____t_t,
	0,					2,
	NULL,			NULL				}
/* *INDENT-ON* */
};
static const struct e4_2nde_type e62xx_2nd[] = {
    {	RANK_LIST | RANK_NONE,
	NULL,			e62xx____			}
}, e63xx_2nd[] = {
    {	RANK_LIST | RANK_NONE,
	NULL,			e63xx____			}
}, rank_none[] = {
    {	RANK_NONE,
	NULL,			NULL				}
};
static const struct e4_cdbl_type c61cp_b_B[] = {
/* *INDENT-OFF* */
    {	e61xx_b_b,		e61xx_b_b			},
    {	e73xx_b_b,		e73xx_b_b			}
/* *INDENT-ON* */
}, c61cp_m_M[] = {
/* *INDENT-OFF* */
    {	e61xx_m_m,		e61xx_m_m			},
    {	e73xx_m_m,		e73xx_m_m			}
/* *INDENT-ON* */
}, c61cs_b_B[] = {
/* *INDENT-OFF* */
    {	e61xx_b_b,		e61xx_b_b			},
    {	e73xx_b_b,		e73xx_b_b			}
/* *INDENT-ON* */
}, c61cs_m_M[] = {
/* *INDENT-OFF* */
    {	e61xx_m_m,		e61xx_m_m			},
    {	e73xx_m_m,		e73xx_m_m			}
/* *INDENT-ON* */
}, c62cp___B[] = {
/* *INDENT-OFF* */
    {	e62xx_m_b,		e62xx_b_b			},
    {	e62xx_m_m,		e62xx_b_m			},
    {	e62xx_m_r,		e62xx_b_r			}
/* *INDENT-ON* */
}, c62cp___R[] = {
/* *INDENT-OFF* */
    {	e62xx_m_b,		e62xx_r_b			},
    {	e62xx_m_m,		e62xx_r_m			},
    {	e62xx_m_r,		e62xx_r_r			}
/* *INDENT-ON* */
}, c62cs___B[] = {
/* *INDENT-OFF* */
    {	e62xx_b_m,		e62xx_b_b			},
    {	e62xx_m_m,		e62xx_m_b			},
    {	e62xx_r_m,		e62xx_r_b			}
/* *INDENT-ON* */
}, c62cs___R[] = {
/* *INDENT-OFF* */
    {	e62xx_b_m,		e62xx_b_r			},
    {	e62xx_m_m,		e62xx_m_r			},
    {	e62xx_r_m,		e62xx_r_r			}
/* *INDENT-ON* */
}, c63cp___B[] = {
/* *INDENT-OFF* */
    {	e63xx_m_b,		e63xx_b_b			},
    {	e63xx_m_m,		e63xx_b_m			},
    {	e63xx_m_r,		e63xx_b_r			}
/* *INDENT-ON* */
}, c63cp___R[] = {
/* *INDENT-OFF* */
    {	e63xx_m_b,		e63xx_r_b			},
    {	e63xx_m_m,		e63xx_r_m			},
    {	e63xx_m_r,		e63xx_r_r			}
/* *INDENT-ON* */
}, c63cs___B[] = {
/* *INDENT-OFF* */
    {	e63xx_b_m,		e63xx_b_b			},
    {	e63xx_m_m,		e63xx_m_b			},
    {	e63xx_r_m,		e63xx_r_b			}
/* *INDENT-ON* */
}, c63cs___R[] = {
/* *INDENT-OFF* */
    {	e63xx_b_m,		e63xx_b_r			},
    {	e63xx_m_m,		e63xx_m_r			},
    {	e63xx_r_m,		e63xx_r_r			}
/* *INDENT-ON* */
}, c73cp_b_B[] = {
/* *INDENT-OFF* */
    {	e61xx_b_b,		e73xx_b_b			},
    {	e73xx_b_b,		e61xx_b_b			}
/* *INDENT-ON* */
}, c73cp_m_M[] = {
/* *INDENT-OFF* */
    {	e61xx_m_m,		e73xx_m_m			},
    {	e73xx_m_m,		e61xx_m_m			}
/* *INDENT-ON* */
}, c73cs_b_B[] = {
/* *INDENT-OFF* */
    {	e61xx_b_b,		e73xx_b_b			},
    {	e73xx_b_b,		e61xx_b_b			}
/* *INDENT-ON* */
}, c73cs_m_M[] = {
/* *INDENT-OFF* */
    {	e61xx_m_m,		e73xx_m_m			},
    {	e73xx_m_m,		e61xx_m_m			}
/* *INDENT-ON* */
};
static const struct e4_cdbp_type c61cz_b_B[] = {
/* *INDENT-OFF* */
    {	c61cp_b_B,		c61cs_b_B			}
/* *INDENT-ON* */
}, c61cz_m_M[] = {
/* *INDENT-OFF* */
    {	c61cp_m_M,		c61cs_m_M			}
/* *INDENT-ON* */
}, c62cz___B[] = {
/* *INDENT-OFF* */
    {	c62cp___B,		c62cs___B			}
/* *INDENT-ON* */
}, c62cz___R[] = {
/* *INDENT-OFF* */
    {	c62cp___R,		c62cs___R			}
/* *INDENT-ON* */
}, c63cz___B[] = {
/* *INDENT-OFF* */
    {	c63cp___B,		c63cs___B			}
/* *INDENT-ON* */
}, c63cz___R[] = {
/* *INDENT-OFF* */
    {	c63cp___R,		c63cs___R			}
/* *INDENT-ON* */
}, c73cz_b_B[] = {
/* *INDENT-OFF* */
    {	c73cp_b_B,		c73cs_b_B			}
/* *INDENT-ON* */
}, c73cz_m_M[] = {
/* *INDENT-OFF* */
    {	c73cp_m_M,		c73cs_m_M			}
/* *INDENT-ON* */
};
static const struct e4_cdbx_type c61cx_b_B[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		c61cz_b_B			}
/* *INDENT-ON* */
}, c61cx_m_M[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		c61cz_m_M			}
/* *INDENT-ON* */
}, c62cx___B[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		c62cz___B			}
/* *INDENT-ON* */
}, c62cx___R[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		c62cz___R			}
/* *INDENT-ON* */
}, c62CX_b_m[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		e62xx_b_m			}
/* *INDENT-ON* */
}, c62CX_m_b[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		e62xx_m_b			}
/* *INDENT-ON* */
}, c62CX_m_m[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		e62xx_m_m			}
/* *INDENT-ON* */
}, c62CX_m_r[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		e62xx_m_r			}
/* *INDENT-ON* */
}, c62CX_r_m[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		e62xx_r_m			}
/* *INDENT-ON* */
}, c63cx___B[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		c63cz___B			}
/* *INDENT-ON* */
}, c63cx___R[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		c63cz___R			}
/* *INDENT-ON* */
}, c63CX_b_m[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		e63xx_b_m			}
/* *INDENT-ON* */
}, c63CX_m_b[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		e63xx_m_b			}
/* *INDENT-ON* */
}, c63CX_m_m[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		e63xx_m_m			}
/* *INDENT-ON* */
}, c63CX_m_r[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		e63xx_m_r			}
/* *INDENT-ON* */
}, c63CX_r_m[] = {
/* *INDENT-OFF* */
    {	DATA_TRANSFORM,		e63xx_r_m			}
/* *INDENT-ON* */
}, c73cx_b_B[] = {
/* *INDENT-OFF* */
    {	PAIR_TRANSFORM,		c73cz_b_B			}
/* *INDENT-ON* */
}, c73cx_m_M[] = {
/* *INDENT-OFF* */
    {	PAIR_TRANSFORM,		c73cz_m_M			}
/* *INDENT-ON* */
};
static const struct e4_ndbl_type d64xx_b_b[] = {
/* *INDENT-OFF* */
    {	e64xx_b_b						},
    {	e6dxx_b_b						},
    {	NULL							}
/* *INDENT-ON* */
}, d64xx_m_m[] = {
/* *INDENT-OFF* */
    {	e64xx_m_m						},
    {	e6dxx_m_m						},
    {	NULL							}
/* *INDENT-ON* */
}, d6dxx_b_b[] = {
/* *INDENT-OFF* */
    {	e64xx_b_b						},
    {	e6dxx_b_b						},
    {	NULL							}
/* *INDENT-ON* */
}, d6dxx_m_m[] = {
/* *INDENT-OFF* */
    {	e64xx_m_m						},
    {	e6dxx_m_m						},
    {	NULL							}
/* *INDENT-ON* */
}, d78xx_b_b[] = {
/* *INDENT-OFF* */
    {	e78xx_b_b						},
    {	NULL							}
/* *INDENT-ON* */
}, d78xx_m_m[] = {
/* *INDENT-OFF* */
    {	e78xx_m_m						},
    {	NULL							}
/* *INDENT-ON* */
};
static const struct e4_ndbv_type n64xx_b_b[] = {
/* *INDENT-OFF* */
    {	d64xx_b_b,		e61xx_b__			},
    {	d64xx_b_b,		e73xx_b__			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, n64xx_m_m[] = {
/* *INDENT-OFF* */
    {	d64xx_m_m,		e61xx_m__			},
    {	d64xx_m_m,		e73xx_m__			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, n6dxx_b_b[] = {
/* *INDENT-OFF* */
    {	d6dxx_b_b,		e61xx_b__			},
    {	d6dxx_b_b,		e73xx_b__			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, n6dxx_m_m[] = {
/* *INDENT-OFF* */
    {	d6dxx_m_m,		e61xx_m__			},
    {	d6dxx_m_m,		e73xx_m__			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, n78xx_b_b[] = {
/* *INDENT-OFF* */
    {	d78xx_b_b,		e6fxx_b__			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, n78xx_m_m[] = {
/* *INDENT-OFF* */
    {	d78xx_m_m,		e6fxx_m__			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
};
static const struct e4_ndbA_type i64CA_b_b[] = {
/* *INDENT-OFF* */
    {	n64xx_b_b						}
/* *INDENT-ON* */
}, i64CA_m_m[] = {
/* *INDENT-OFF* */
    {	n64xx_m_m						}
/* *INDENT-ON* */
}, i6dCA_b_b[] = {
/* *INDENT-OFF* */
    {	n6dxx_b_b						}
/* *INDENT-ON* */
}, i6dCA_m_m[] = {
/* *INDENT-OFF* */
    {	n6dxx_m_m						}
/* *INDENT-ON* */
}, i78CA_b_b[] = {
/* *INDENT-OFF* */
    {	n78xx_b_b						}
/* *INDENT-ON* */
}, i78CA_m_m[] = {
/* *INDENT-OFF* */
    {	n78xx_m_m						}
/* *INDENT-ON* */
};
static const struct e4_ndbC_type i64CC_b_b[] = {
/* *INDENT-OFF* */
    {	n64xx_b_b						}
/* *INDENT-ON* */
}, i64CC_m_m[] = {
/* *INDENT-OFF* */
    {	n64xx_m_m						}
/* *INDENT-ON* */
}, i6dCC_b_b[] = {
/* *INDENT-OFF* */
    {	n6dxx_b_b						}
/* *INDENT-ON* */
}, i6dCC_m_m[] = {
/* *INDENT-OFF* */
    {	n6dxx_m_m						}
/* *INDENT-ON* */
}, i78CC_b_b[] = {
/* *INDENT-OFF* */
    {	n78xx_b_b						}
/* *INDENT-ON* */
}, i78CC_m_m[] = {
/* *INDENT-OFF* */
    {	n78xx_m_m						}
/* *INDENT-ON* */
};
static const struct e4_ndba_type i64ca_b_b[] = {
/* *INDENT-OFF* */
    {	n64xx_b_b						}
/* *INDENT-ON* */
}, i64ca_m_m[] = {
/* *INDENT-OFF* */
    {	n64xx_m_m						}
/* *INDENT-ON* */
}, i6dca_b_b[] = {
/* *INDENT-OFF* */
    {	n6dxx_b_b						}
/* *INDENT-ON* */
}, i6dca_m_m[] = {
/* *INDENT-OFF* */
    {	n6dxx_m_m						}
/* *INDENT-ON* */
}, i78ca_b_b[] = {
/* *INDENT-OFF* */
    {	n78xx_b_b						}
/* *INDENT-ON* */
}, i78ca_m_m[] = {
/* *INDENT-OFF* */
    {	n78xx_m_m						}
/* *INDENT-ON* */
};
static const struct e4_ndbc_type i64cc_b_b[] = {
/* *INDENT-OFF* */
    {	n64xx_b_b						}
/* *INDENT-ON* */
}, i64cc_m_m[] = {
/* *INDENT-OFF* */
    {	n64xx_m_m						}
/* *INDENT-ON* */
}, i6dcc_b_b[] = {
/* *INDENT-OFF* */
    {	n6dxx_b_b						}
/* *INDENT-ON* */
}, i6dcc_m_m[] = {
/* *INDENT-OFF* */
    {	n6dxx_m_m						}
/* *INDENT-ON* */
}, i78cc_b_b[] = {
/* *INDENT-OFF* */
    {	n78xx_b_b						}
/* *INDENT-ON* */
}, i78cc_m_m[] = {
/* *INDENT-OFF* */
    {	n78xx_m_m						}
/* *INDENT-ON* */
};
static const struct e4_odbl_type c61CA_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e61xx_b_b,		e61xx_b_b,
	NULL,			NULL				},
    {	0,
	e73xx_b_b,		e73xx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c61CA_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e61xx_m_m,		e61xx_m_m,
	NULL,			NULL				},
    {	0,
	e73xx_m_m,		e73xx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c61CC_b_b[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e61xx_b_b,		e61xx_b_b,
	c61cx_b_B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e73xx_b_b,		e73xx_b_b,
	c73cx_b_B,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c61CC_m_m[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e61xx_m_m,		e61xx_m_m,
	c61cx_m_M,		NULL				},
    {	TRANSFORM_LINKAGE,
	e73xx_m_m,		e73xx_m_m,
	c73cx_m_M,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c61ca_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e61xx_b_b,		e61xx_b_b,
	NULL,			NULL				},
    {	0,
	e73xx_b_b,		e73xx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c61ca_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e61xx_m_m,		e61xx_m_m,
	NULL,			NULL				},
    {	0,
	e73xx_m_m,		e73xx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c61cc_b_b[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e61xx_b_b,		e61xx_b_b,
	c61cx_b_B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e73xx_b_b,		e73xx_b_b,
	c73cx_b_B,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c61cc_m_m[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e61xx_m_m,		e61xx_m_m,
	c61cx_m_M,		NULL				},
    {	TRANSFORM_LINKAGE,
	e73xx_m_m,		e73xx_m_m,
	c73cx_m_M,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62CA_b__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_b,		e62xx_b_b,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_m,		e62xx_b_m,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_r,		e62xx_b_r,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_b,		e62xx_b_b,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_m,		e62xx_b_m,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_r,		e62xx_b_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_b,		e62xx_b_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_m,		e62xx_b_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_r,		e62xx_b_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62CA_m__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e62xx_b_b,		e62xx_m_b,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_b_m,		e62xx_m_m,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_b_r,		e62xx_m_r,
	c62cx___B,		NULL				},
    {	0,
	e62xx_m_b,		e62xx_m_b,
	NULL,			NULL				},
    {	0,
	e62xx_m_m,		e62xx_m_m,
	NULL,			NULL				},
    {	0,
	e62xx_m_r,		e62xx_m_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_r_b,		e62xx_m_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_r_m,		e62xx_m_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_r_r,		e62xx_m_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62CA_r__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_b,		e62xx_r_b,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_m,		e62xx_r_m,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_r,		e62xx_r_r,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_b,		e62xx_r_b,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_m,		e62xx_r_m,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_r,		e62xx_r_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_b,		e62xx_r_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_m,		e62xx_r_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_r,		e62xx_r_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62CC_b__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_b,		e62xx_b_b,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_b_m,		e62xx_b_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_r,		e62xx_b_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_m_b,		e62xx_b_m,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_m,		e62xx_b_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_m_r,		e62xx_b_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_b,		e62xx_b_r,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_r_m,		e62xx_b_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_r,		e62xx_b_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62CC_m__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e62xx_b_b,		e62xx_m_b,
	c62cx___B,		NULL				},
    {	0,
	e62xx_b_m,		e62xx_m_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_b_r,		e62xx_m_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_m_b,		e62xx_m_m,
	c62cx___B,		NULL				},
    {	0,
	e62xx_m_m,		e62xx_m_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_m_r,		e62xx_m_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_r_b,		e62xx_m_r,
	c62cx___B,		NULL				},
    {	0,
	e62xx_r_m,		e62xx_m_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_r_r,		e62xx_m_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62CC_r__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_b,		e62xx_r_b,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_b_m,		e62xx_r_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_r,		e62xx_r_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_m_b,		e62xx_r_m,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_m,		e62xx_r_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_m_r,		e62xx_r_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_b,		e62xx_r_r,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_r_m,		e62xx_r_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_r,		e62xx_r_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62ca___b[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_b,		e62xx_b_b,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_m,		e62xx_b_m,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_r,		e62xx_b_r,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_b,		e62xx_b_b,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_m,		e62xx_b_m,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_r,		e62xx_b_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_b,		e62xx_b_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_m,		e62xx_b_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_r,		e62xx_b_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62ca___m[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e62xx_b_b,		e62xx_m_b,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_b_m,		e62xx_m_m,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_b_r,		e62xx_m_r,
	c62cx___B,		NULL				},
    {	0,
	e62xx_m_b,		e62xx_m_b,
	NULL,			NULL				},
    {	0,
	e62xx_m_m,		e62xx_m_m,
	NULL,			NULL				},
    {	0,
	e62xx_m_r,		e62xx_m_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_r_b,		e62xx_m_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_r_m,		e62xx_m_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_r_r,		e62xx_m_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62ca___r[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_b,		e62xx_r_b,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_m,		e62xx_r_m,
	c62cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_r,		e62xx_r_r,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_b,		e62xx_r_b,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_m,		e62xx_r_m,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_r,		e62xx_r_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_b,		e62xx_r_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_m,		e62xx_r_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_r,		e62xx_r_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62cc___b[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_b,		e62xx_b_b,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_b_m,		e62xx_b_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_r,		e62xx_b_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_m_b,		e62xx_b_m,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_m,		e62xx_b_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_m_r,		e62xx_b_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_b,		e62xx_b_r,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_r_m,		e62xx_b_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_r,		e62xx_b_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62cc___m[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e62xx_b_b,		e62xx_m_b,
	c62cx___B,		NULL				},
    {	0,
	e62xx_b_m,		e62xx_m_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_b_r,		e62xx_m_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_m_b,		e62xx_m_m,
	c62cx___B,		NULL				},
    {	0,
	e62xx_m_m,		e62xx_m_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_m_r,		e62xx_m_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_r_b,		e62xx_m_r,
	c62cx___B,		NULL				},
    {	0,
	e62xx_r_m,		e62xx_m_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e62xx_r_r,		e62xx_m_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c62cc___r[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_b,		e62xx_r_b,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_b_m,		e62xx_r_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_b_r,		e62xx_r_b,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_m_b,		e62xx_r_m,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_m_m,		e62xx_r_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_m_r,		e62xx_r_m,
	c62cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_b,		e62xx_r_r,
	c62cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e62xx_r_m,		e62xx_r_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e62xx_r_r,		e62xx_r_r,
	c62cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63CA_b__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_b,		e63xx_b_b,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_m,		e63xx_b_m,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_r,		e63xx_b_r,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_b,		e63xx_b_b,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_m,		e63xx_b_m,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_r,		e63xx_b_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_b,		e63xx_b_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_m,		e63xx_b_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_r,		e63xx_b_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63CA_m__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e63xx_b_b,		e63xx_m_b,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_b_m,		e63xx_m_m,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_b_r,		e63xx_m_r,
	c63cx___B,		NULL				},
    {	0,
	e63xx_m_b,		e63xx_m_b,
	NULL,			NULL				},
    {	0,
	e63xx_m_m,		e63xx_m_m,
	NULL,			NULL				},
    {	0,
	e63xx_m_r,		e63xx_m_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_r_b,		e63xx_m_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_r_m,		e63xx_m_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_r_r,		e63xx_m_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63CA_r__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_b,		e63xx_r_b,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_m,		e63xx_r_m,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_r,		e63xx_r_r,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_b,		e63xx_r_b,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_m,		e63xx_r_m,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_r,		e63xx_r_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_b,		e63xx_r_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_m,		e63xx_r_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_r,		e63xx_r_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63CC_b__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_b,		e63xx_b_b,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_b_m,		e63xx_b_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_r,		e63xx_b_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_m_b,		e63xx_b_m,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_m,		e63xx_b_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_m_r,		e63xx_b_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_b,		e63xx_b_r,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_r_m,		e63xx_b_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_r,		e63xx_b_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63CC_m__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e63xx_b_b,		e63xx_m_b,
	c63cx___B,		NULL				},
    {	0,
	e63xx_b_m,		e63xx_m_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_b_r,		e63xx_m_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_m_b,		e63xx_m_m,
	c63cx___B,		NULL				},
    {	0,
	e63xx_m_m,		e63xx_m_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_m_r,		e63xx_m_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_r_b,		e63xx_m_r,
	c63cx___B,		NULL				},
    {	0,
	e63xx_r_m,		e63xx_m_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_r_r,		e63xx_m_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63CC_r__[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_b,		e63xx_r_b,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_b_m,		e63xx_r_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_r,		e63xx_r_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_m_b,		e63xx_r_m,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_m,		e63xx_r_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_m_r,		e63xx_r_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_b,		e63xx_r_r,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_r_m,		e63xx_r_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_r,		e63xx_r_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63ca___b[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_b,		e63xx_b_b,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_m,		e63xx_b_m,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_r,		e63xx_b_r,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_b,		e63xx_b_b,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_m,		e63xx_b_m,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_r,		e63xx_b_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_b,		e63xx_b_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_m,		e63xx_b_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_r,		e63xx_b_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63ca___m[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e63xx_b_b,		e63xx_m_b,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_b_m,		e63xx_m_m,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_b_r,		e63xx_m_r,
	c63cx___B,		NULL				},
    {	0,
	e63xx_m_b,		e63xx_m_b,
	NULL,			NULL				},
    {	0,
	e63xx_m_m,		e63xx_m_m,
	NULL,			NULL				},
    {	0,
	e63xx_m_r,		e63xx_m_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_r_b,		e63xx_m_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_r_m,		e63xx_m_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_r_r,		e63xx_m_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63ca___r[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_b,		e63xx_r_b,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_m,		e63xx_r_m,
	c63cx___B,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_r,		e63xx_r_r,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_b,		e63xx_r_b,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_m,		e63xx_r_m,
	NULL,			NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_r,		e63xx_r_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_b,		e63xx_r_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_m,		e63xx_r_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_r,		e63xx_r_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63cc___b[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_b,		e63xx_b_b,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_b_m,		e63xx_b_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_r,		e63xx_b_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_m_b,		e63xx_b_m,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_m,		e63xx_b_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_m_r,		e63xx_b_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_b,		e63xx_b_r,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_r_m,		e63xx_b_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_r,		e63xx_b_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63cc___m[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e63xx_b_b,		e63xx_m_b,
	c63cx___B,		NULL				},
    {	0,
	e63xx_b_m,		e63xx_m_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_b_r,		e63xx_m_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_m_b,		e63xx_m_m,
	c63cx___B,		NULL				},
    {	0,
	e63xx_m_m,		e63xx_m_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_m_r,		e63xx_m_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_r_b,		e63xx_m_r,
	c63cx___B,		NULL				},
    {	0,
	e63xx_r_m,		e63xx_m_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE,
	e63xx_r_r,		e63xx_m_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c63cc___r[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_b,		e63xx_r_b,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_b_m,		e63xx_r_b,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_b_r,		e63xx_r_b,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_m_b,		e63xx_r_m,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_m_m,		e63xx_r_m,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_m_r,		e63xx_r_m,
	c63cx___R,		NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_b,		e63xx_r_r,
	c63cx___B,		NULL				},
    {	TRANSFORM_PRIMARY,
	e63xx_r_m,		e63xx_r_r,
	NULL,			NULL				},
    {	TRANSFORM_LINKAGE | TRANSFORM_PRIMARY,
	e63xx_r_r,		e63xx_r_r,
	c63cx___R,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c6bCS_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e6bxx_b_b,		e6bxx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c6bCS_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e6bxx_m_m,		e6bxx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c6bcs_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e6bxx_b_b,		e61xx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c6bcs_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e6bxx_m_m,		e61xx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c73CA_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e61xx_b_b,		e61xx_b_b,
	NULL,			NULL				},
    {	0,
	e73xx_b_b,		e73xx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c73CA_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e61xx_m_m,		e61xx_m_m,
	NULL,			NULL				},
    {	0,
	e73xx_m_m,		e73xx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c73CC_b_b[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e61xx_b_b,		e61xx_b_b,
	c61cx_b_B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e73xx_b_b,		e73xx_b_b,
	c73cx_b_B,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c73CC_m_m[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e61xx_m_m,		e61xx_m_m,
	c61cx_m_M,		NULL				},
    {	TRANSFORM_LINKAGE,
	e73xx_m_m,		e73xx_m_m,
	c73cx_m_M,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c73ca_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e61xx_b_b,		e61xx_b_b,
	NULL,			NULL				},
    {	0,
	e73xx_b_b,		e73xx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c73ca_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e61xx_m_m,		e61xx_m_m,
	NULL,			NULL				},
    {	0,
	e73xx_m_m,		e73xx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c73cc_b_b[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e61xx_b_b,		e61xx_b_b,
	c61cx_b_B,		NULL				},
    {	TRANSFORM_LINKAGE,
	e73xx_b_b,		e73xx_b_b,
	c73cx_b_B,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c73cc_m_m[] = {
/* *INDENT-OFF* */
    {	TRANSFORM_LINKAGE,
	e61xx_m_m,		e61xx_m_m,
	c61cx_m_M,		NULL				},
    {	TRANSFORM_LINKAGE,
	e73xx_m_m,		e73xx_m_m,
	c73cx_m_M,		NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c74CS_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e74xx_b_b,		e74xx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c74CS_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e74xx_m_m,		e74xx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c74cs_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e74xx_b_b,		e61xx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, c74cs_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e74xx_m_m,		e61xx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e77xl_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e77xx_b_b,		e77xx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e77xl_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e77xx_m_m,		e77xx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e78xl_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e78xx_b_b,		e78xx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e78xl_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e78xx_m_m,		e78xx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e79xl_b_b[] = {
/* *INDENT-OFF* */
    {	0,
	e79xx_b_b,		e79xx_b_b,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e79xl_m_m[] = {
/* *INDENT-OFF* */
    {	0,
	e79xx_m_m,		e79xx_m_m,
	NULL,			NULL				},
    {	0,
	NULL,			NULL,
	NULL,			NULL				}
/* *INDENT-ON* */
};
static const struct e4_odbv_type e61vA_b_b[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_b_b			},
    {	1,			e73xx_b_b			},
    {	-1,			e73xx_b_b			},
    {	0,			e61xx_b_b			}
/* *INDENT-ON* */
}, e61vA_m_m[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_m_m			},
    {	1,			e73xx_m_m			},
    {	-1,			e73xx_m_m			},
    {	0,			e61xx_m_m			}
/* *INDENT-ON* */
}, e73vA_b_b[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_b_b			},
    {	1,			e73xx_b_b			},
    {	-1,			e73xx_b_b			},
    {	0,			e61xx_b_b			}
/* *INDENT-ON* */
}, e73vA_m_m[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_m_m			},
    {	1,			e73xx_m_m			},
    {	-1,			e73xx_m_m			},
    {	0,			e61xx_m_m			}
/* *INDENT-ON* */
};
static const struct e4_odbt_type e61tA_b_b[] = {
/* *INDENT-OFF* */
    {	c61CA_b_b + 0,		e61vA_b_b + 0,
	e61xx_b_b						},
    {	c61CA_b_b + 1,		e61vA_b_b + 2,
	e73xx_b_b						}
/* *INDENT-ON* */
}, e61tA_m_m[] = {
/* *INDENT-OFF* */
    {	c61CA_m_m + 0,		e61vA_m_m + 0,
	e61xx_m_m						},
    {	c61CA_m_m + 1,		e61vA_m_m + 2,
	e73xx_m_m						}
/* *INDENT-ON* */
}, e73tA_b_b[] = {
/* *INDENT-OFF* */
    {	c73CA_b_b + 0,		e73vA_b_b + 0,
	e61xx_b_b						},
    {	c73CA_b_b + 1,		e73vA_b_b + 2,
	e73xx_b_b						}
/* *INDENT-ON* */
}, e73tA_m_m[] = {
/* *INDENT-OFF* */
    {	c73CA_m_m + 0,		e73vA_m_m + 0,
	e61xx_m_m						},
    {	c73CA_m_m + 1,		e73vA_m_m + 2,
	e73xx_m_m						}
/* *INDENT-ON* */
};
static const struct e4_odbz_type e61zA_b_b[] = {
/* *INDENT-OFF* */
    {	e61tA_b_b						}
/* *INDENT-ON* */
}, e61zA_m_m[] = {
/* *INDENT-OFF* */
    {	e61tA_m_m						}
/* *INDENT-ON* */
}, e73zA_b_b[] = {
/* *INDENT-OFF* */
    {	e73tA_b_b						}
/* *INDENT-ON* */
}, e73zA_m_m[] = {
/* *INDENT-OFF* */
    {	e73tA_m_m						}
/* *INDENT-ON* */
};
static const struct e4_odbA_type e61CA_b_b[] = {
/* *INDENT-OFF* */
    {	c61CA_b_b,		c61CA_b_b + 0,
	e61zA_b_b,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e61CA_m_m[] = {
/* *INDENT-OFF* */
    {	c61CA_m_m,		c61CA_m_m + 0,
	e61zA_m_m,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e62CA_b_b[] = {
/* *INDENT-OFF* */
    {	c62CA_b__,		c62CA_b__ + 0,
	NULL,			c62CX_m_b,
	0							}
/* *INDENT-ON* */
}, e62CA_b_m[] = {
/* *INDENT-OFF* */
    {	c62CA_b__,		c62CA_b__ + 1,
	NULL,			c62CX_m_m,
	0							}
/* *INDENT-ON* */
}, e62CA_b_r[] = {
/* *INDENT-OFF* */
    {	c62CA_b__,		c62CA_b__ + 2,
	NULL,			c62CX_m_r,
	0							}
/* *INDENT-ON* */
}, e62CA_m_b[] = {
/* *INDENT-OFF* */
    {	c62CA_m__,		c62CA_m__ + 3,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62CA_m_m[] = {
/* *INDENT-OFF* */
    {	c62CA_m__,		c62CA_m__ + 4,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62CA_m_r[] = {
/* *INDENT-OFF* */
    {	c62CA_m__,		c62CA_m__ + 5,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62CA_r_b[] = {
/* *INDENT-OFF* */
    {	c62CA_r__,		c62CA_r__ + 6,
	NULL,			c62CX_m_b,
	0							}
/* *INDENT-ON* */
}, e62CA_r_m[] = {
/* *INDENT-OFF* */
    {	c62CA_r__,		c62CA_r__ + 7,
	NULL,			c62CX_m_m,
	0							}
/* *INDENT-ON* */
}, e62CA_r_r[] = {
/* *INDENT-OFF* */
    {	c62CA_r__,		c62CA_r__ + 8,
	NULL,			c62CX_m_r,
	0							}
/* *INDENT-ON* */
}, e63CA_b_b[] = {
/* *INDENT-OFF* */
    {	c63CA_b__,		c63CA_b__ + 0,
	NULL,			c63CX_m_b,
	0							}
/* *INDENT-ON* */
}, e63CA_b_m[] = {
/* *INDENT-OFF* */
    {	c63CA_b__,		c63CA_b__ + 1,
	NULL,			c63CX_m_m,
	0							}
/* *INDENT-ON* */
}, e63CA_b_r[] = {
/* *INDENT-OFF* */
    {	c63CA_b__,		c63CA_b__ + 2,
	NULL,			c63CX_m_r,
	0							}
/* *INDENT-ON* */
}, e63CA_m_b[] = {
/* *INDENT-OFF* */
    {	c63CA_m__,		c63CA_m__ + 3,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63CA_m_m[] = {
/* *INDENT-OFF* */
    {	c63CA_m__,		c63CA_m__ + 4,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63CA_m_r[] = {
/* *INDENT-OFF* */
    {	c63CA_m__,		c63CA_m__ + 5,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63CA_r_b[] = {
/* *INDENT-OFF* */
    {	c63CA_r__,		c63CA_r__ + 6,
	NULL,			c63CX_m_b,
	0							}
/* *INDENT-ON* */
}, e63CA_r_m[] = {
/* *INDENT-OFF* */
    {	c63CA_r__,		c63CA_r__ + 7,
	NULL,			c63CX_m_m,
	0							}
/* *INDENT-ON* */
}, e63CA_r_r[] = {
/* *INDENT-OFF* */
    {	c63CA_r__,		c63CA_r__ + 8,
	NULL,			c63CX_m_r,
	0							}
/* *INDENT-ON* */
}, e73CA_b_b[] = {
/* *INDENT-OFF* */
    {	c73CA_b_b,		c73CA_b_b + 0,
	e73zA_b_b,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e73CA_m_m[] = {
/* *INDENT-OFF* */
    {	c73CA_m_m,		c73CA_m_m + 0,
	e73zA_m_m,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e77CA_b_b[] = {
/* *INDENT-OFF* */
    {	e77xl_b_b,		e77xl_b_b + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e77CA_m_m[] = {
/* *INDENT-OFF* */
    {	e77xl_m_m,		e77xl_m_m + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e78CA_m_m[] = {
/* *INDENT-OFF* */
    {	e78xl_m_m,		e78xl_m_m + 0,
	NULL,			0				}
/* *INDENT-ON* */
}, e78CA_b_b[] = {
/* *INDENT-OFF* */
    {	e78xl_b_b,		e78xl_b_b + 0,
	NULL,			0				}
/* *INDENT-ON* */
}, e79CA_b_b[] = {
/* *INDENT-OFF* */
    {	e79xl_b_b,		e79xl_b_b + 0,
	NULL,			0				}
/* *INDENT-ON* */
}, e79CA_m_m[] = {
/* *INDENT-OFF* */
    {	e79xl_m_m,		e79xl_m_m + 0,
	NULL,			0				}
/* *INDENT-ON* */
};
static const struct e4_odbv_type e61vC_b_b[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_b_b			},
    {	1,			e73xx_b_b			},
    {	-1,			e73xx_b_b			},
    {	0,			e61xx_b_b			}
/* *INDENT-ON* */
}, e61vC_m_m[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_m_m			},
    {	1,			e73xx_m_m			},
    {	-1,			e73xx_m_m			},
    {	0,			e61xx_m_m			}
/* *INDENT-ON* */
}, e73vC_b_b[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_b_b			},
    {	1,			e73xx_b_b			},
    {	-1,			e73xx_b_b			},
    {	0,			e61xx_b_b			}
/* *INDENT-ON* */
}, e73vC_m_m[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_m_m			},
    {	1,			e73xx_m_m			},
    {	-1,			e73xx_m_m			},
    {	0,			e61xx_m_m			}
/* *INDENT-ON* */
};
static const struct e4_odbt_type e61tC_b_b[] = {
/* *INDENT-OFF* */
    {	c61CC_b_b + 0,		e61vC_b_b + 0,
	e61xx_b_b						},
    {	c61CC_b_b + 1,		e61vC_b_b + 2,
	e73xx_b_b						}
/* *INDENT-ON* */
}, e61tC_m_m[] = {
/* *INDENT-OFF* */
    {	c61CC_m_m + 0,		e61vC_m_m + 0,
	e61xx_m_m						},
    {	c61CC_m_m + 1,		e61vC_m_m + 2,
	e73xx_m_m						}
/* *INDENT-ON* */
}, e73tC_b_b[] = {
/* *INDENT-OFF* */
    {	c61CC_b_b + 0,		e73vC_b_b + 0,
	e61xx_b_b						},
    {	c61CC_b_b + 1,		e73vC_b_b + 2,
	e73xx_b_b						}
/* *INDENT-ON* */
}, e73tC_m_m[] = {
/* *INDENT-OFF* */
    {	c61CC_m_m + 0,		e73vC_m_m + 0,
	e61xx_m_m						},
    {	c61CC_m_m + 1,		e73vC_m_m + 2,
	e73xx_m_m						}
/* *INDENT-ON* */
};
static const struct e4_odbz_type e61zC_b_b[] = {
/* *INDENT-OFF* */
    {	e61tC_b_b						}
/* *INDENT-ON* */
}, e61zC_m_m[] = {
/* *INDENT-OFF* */
    {	e61tC_m_m						}
/* *INDENT-ON* */
}, e73zC_b_b[] = {
/* *INDENT-OFF* */
    {	e73tC_b_b						}
/* *INDENT-ON* */
}, e73zC_m_m[] = {
/* *INDENT-OFF* */
    {	e73tC_m_m						}
/* *INDENT-ON* */
};
static const struct e4_odbC_type e61CC_b_b[] = {
/* *INDENT-OFF* */
    {	c61CC_b_b,		c61CC_b_b + 0,
	e61zC_b_b,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e61CC_m_m[] = {
/* *INDENT-OFF* */
    {	c61CC_m_m,		c61CC_m_m + 0,
	e61zC_m_m,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e62CC_b_b[] = {
/* *INDENT-OFF* */
    {	c62CC_b__,		c62CC_b__ + 0,
	NULL,			c62CX_m_b,
	0							}
/* *INDENT-ON* */
}, e62CC_b_m[] = {
/* *INDENT-OFF* */
    {	c62CC_b__,		c62CC_b__ + 1,
	NULL,			c62CX_m_m,
	0							}
/* *INDENT-ON* */
}, e62CC_b_r[] = {
/* *INDENT-OFF* */
    {	c62CC_b__,		c62CC_b__ + 2,
	NULL,			c62CX_m_r,
	0							}
/* *INDENT-ON* */
}, e62CC_m_b[] = {
/* *INDENT-OFF* */
    {	c62CC_m__,		c62CC_m__ + 3,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62CC_m_m[] = {
/* *INDENT-OFF* */
    {	c62CC_m__,		c62CC_m__ + 4,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62CC_m_r[] = {
/* *INDENT-OFF* */
    {	c62CC_m__,		c62CC_m__ + 5,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62CC_r_b[] = {
/* *INDENT-OFF* */
    {	c62CC_r__,		c62CC_r__ + 6,
	NULL,			c62CX_m_b,
	0							}
/* *INDENT-ON* */
}, e62CC_r_m[] = {
/* *INDENT-OFF* */
    {	c62CC_r__,		c62CC_r__ + 7,
	NULL,			c62CX_m_m,
	0							}
/* *INDENT-ON* */
}, e62CC_r_r[] = {
/* *INDENT-OFF* */
    {	c62CC_r__,		c62CC_r__ + 8,
	NULL,			c62CX_m_r,
	0							}
/* *INDENT-ON* */
}, e63CC_b_b[] = {
/* *INDENT-OFF* */
    {	c63CC_b__,		c63CC_b__ + 0,
	NULL,			c63CX_m_b,
	0							}
/* *INDENT-ON* */
}, e63CC_b_m[] = {
/* *INDENT-OFF* */
    {	c63CC_b__,		c63CC_b__ + 1,
	NULL,			c63CX_m_m,
	0							}
/* *INDENT-ON* */
}, e63CC_b_r[] = {
/* *INDENT-OFF* */
    {	c63CC_b__,		c63CC_b__ + 2,
	NULL,			c63CX_m_r,
	0							}
/* *INDENT-ON* */
}, e63CC_m_b[] = {
/* *INDENT-OFF* */
    {	c63CC_m__,		c63CC_m__ + 3,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63CC_m_m[] = {
/* *INDENT-OFF* */
    {	c63CC_m__,		c63CC_m__ + 4,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63CC_m_r[] = {
/* *INDENT-OFF* */
    {	c63CC_m__,		c63CC_m__ + 5,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63CC_r_b[] = {
/* *INDENT-OFF* */
    {	c63CC_r__,		c63CC_r__ + 6,
	NULL,			c63CX_m_b,
	0							}
/* *INDENT-ON* */
}, e63CC_r_m[] = {
/* *INDENT-OFF* */
    {	c63CC_r__,		c63CC_r__ + 7,
	NULL,			c63CX_m_m,
	0							}
/* *INDENT-ON* */
}, e63CC_r_r[] = {
/* *INDENT-OFF* */
    {	c63CC_r__,		c63CC_r__ + 8,
	NULL,			c63CX_m_r,
	0							}
/* *INDENT-ON* */
}, e73CC_b_b[] = {
/* *INDENT-OFF* */
    {	c73CC_b_b,		c73CC_b_b + 0,
	e73zC_b_b,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e73CC_m_m[] = {
/* *INDENT-OFF* */
    {	c73CC_m_m,		c73CC_m_m + 0,
	e73zC_m_m,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e77CC_b_b[] = {
/* *INDENT-OFF* */
    {	e77xl_b_b,		e77xl_b_b + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e77CC_m_m[] = {
/* *INDENT-OFF* */
    {	e77xl_m_m,		e77xl_m_m + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e78CC_b_b[] = {
/* *INDENT-OFF* */
    {	e78xl_b_b,		e78xl_b_b + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e78CC_m_m[] = {
/* *INDENT-OFF* */
    {	e78xl_m_m,		e78xl_m_m + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e79CC_b_b[] = {
/* *INDENT-OFF* */
    {	e79xl_b_b,		e79xl_b_b + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e79CC_m_m[] = {
/* *INDENT-OFF* */
    {	e79xl_m_m,		e79xl_m_m + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
};
static const struct e4_odbS_type e6bCS_b_b[] = {
/* *INDENT-OFF* */
    {	c6bCS_b_b,		c6bCS_b_b + 0			}
/* *INDENT-ON* */
}, e6bCS_m_m[] = {
/* *INDENT-OFF* */
    {	c6bCS_m_m,		c6bCS_m_m + 0			}
/* *INDENT-ON* */
}, e74CS_b_b[] = {
/* *INDENT-OFF* */
    {	c74CS_b_b,		c74CS_b_b + 0			}
/* *INDENT-ON* */
}, e74CS_m_m[] = {
/* *INDENT-OFF* */
    {	c74CS_m_m,		c74CS_m_m + 0			}
/* *INDENT-ON* */
};
static const struct e4_odbv_type e61va_b_b[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_b_b			},
    {	1,			e73xx_b_b			},
    {	-1,			e73xx_b_b			},
    {	0,			e61xx_b_b			}
/* *INDENT-ON* */
}, e61va_m_m[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_m_m			},
    {	1,			e73xx_m_m			},
    {	-1,			e73xx_m_m			},
    {	0,			e61xx_m_m			}
/* *INDENT-ON* */
}, e73va_b_b[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_b_b			},
    {	1,			e73xx_b_b			},
    {	-1,			e73xx_b_b			},
    {	0,			e61xx_b_b			}
/* *INDENT-ON* */
}, e73va_m_m[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_m_m			},
    {	1,			e73xx_m_m			},
    {	-1,			e73xx_m_m			},
    {	0,			e61xx_m_m			}
/* *INDENT-ON* */
};
static const struct e4_odbt_type e61ta_b_b[] = {
/* *INDENT-OFF* */
    {	c61ca_b_b + 0,		e61va_b_b + 0,
	e61xx_b_b						},
    {	c61ca_b_b + 1,		e61va_b_b + 2,
	e73xx_b_b						}
/* *INDENT-ON* */
}, e61ta_m_m[] = {
/* *INDENT-OFF* */
    {	c61ca_m_m + 0,		e61va_m_m + 0,
	e61xx_m_m						},
    {	c61ca_m_m + 1,		e61va_m_m + 2,
	e73xx_m_m						}
/* *INDENT-ON* */
}, e73ta_b_b[] = {
/* *INDENT-OFF* */
    {	c73ca_b_b + 1,		e73va_b_b + 0,
	e61xx_b_b						},
    {	c73ca_b_b + 0,		e73va_b_b + 2,
	e73xx_b_b						},
/* *INDENT-ON* */
}, e73ta_m_m[] = {
/* *INDENT-OFF* */
    {	c73ca_m_m + 1,		e73va_m_m + 0,
	e61xx_m_m						},
    {	c73ca_m_m + 0,		e73va_m_m + 2,
	e73xx_m_m						},
/* *INDENT-ON* */
};
static const struct e4_odbz_type e61za_b_b[] = {
/* *INDENT-OFF* */
    {	e61ta_b_b						}
/* *INDENT-ON* */
}, e61za_m_m[] = {
/* *INDENT-OFF* */
    {	e61ta_m_m						}
/* *INDENT-ON* */
}, e73za_b_b[] = {
/* *INDENT-OFF* */
    {	e73ta_b_b						}
/* *INDENT-ON* */
}, e73za_m_m[] = {
/* *INDENT-OFF* */
    {	e73ta_m_m						}
/* *INDENT-ON* */
};
static const struct e4_odba_type e61ca_b_b[] = {
/* *INDENT-OFF* */
    {	c61ca_b_b,		c61ca_b_b + 0,
	e61za_b_b,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e61ca_m_m[] = {
/* *INDENT-OFF* */
    {	c61ca_m_m,		c61ca_m_m + 0,
	e61za_m_m,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e62ca_b_b[] = {
/* *INDENT-OFF* */
    {	c62ca___b,		c62ca___b + 0,
	NULL,			c62CX_b_m,
	0							}
/* *INDENT-ON* */
}, e62ca_b_m[] = {
/* *INDENT-OFF* */
    {	c62ca___m,		c62ca___m + 1,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62ca_b_r[] = {
/* *INDENT-OFF* */
    {	c62ca___r,		c62ca___r + 2,
	NULL,			c62CX_b_m,
	0							}
/* *INDENT-ON* */
}, e62ca_m_b[] = {
/* *INDENT-OFF* */
    {	c62ca___b,		c62ca___b + 3,
	NULL,			c62CX_m_m,
	0							}
/* *INDENT-ON* */
}, e62ca_m_m[] = {
/* *INDENT-OFF* */
    {	c62ca___m,		c62ca___m + 4,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62ca_m_r[] = {
/* *INDENT-OFF* */
    {	c62ca___r,		c62ca___r + 5,
	NULL,			c62CX_m_m,
	0							}
/* *INDENT-ON* */
}, e62ca_r_b[] = {
/* *INDENT-OFF* */
    {	c62ca___b,		c62ca___b + 6,
	NULL,			c62CX_r_m,
	0							}
/* *INDENT-ON* */
}, e62ca_r_m[] = {
/* *INDENT-OFF* */
    {	c62ca___m,		c62ca___m + 7,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62ca_r_r[] = {
/* *INDENT-OFF* */
    {	c62ca___r,		c62ca___r + 8,
	NULL,			c62CX_r_m,
	0							}
/* *INDENT-ON* */
}, e63ca_b_b[] = {
/* *INDENT-OFF* */
    {	c63ca___b,		c63ca___b + 0,
	NULL,			c63CX_b_m,
	0							}
/* *INDENT-ON* */
}, e63ca_b_m[] = {
/* *INDENT-OFF* */
    {	c63ca___m,		c63ca___m + 1,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63ca_b_r[] = {
/* *INDENT-OFF* */
    {	c63ca___r,		c63ca___r + 2,
	NULL,			c63CX_b_m,
	0							}
/* *INDENT-ON* */
}, e63ca_m_b[] = {
/* *INDENT-OFF* */
    {	c63ca___b,		c63ca___b + 3,
	NULL,			c63CX_m_m,
	0							}
/* *INDENT-ON* */
}, e63ca_m_m[] = {
/* *INDENT-OFF* */
    {	c63ca___m,		c63ca___m + 4,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63ca_m_r[] = {
/* *INDENT-OFF* */
    {	c63ca___r,		c63ca___r + 5,
	NULL,			c63CX_m_m,
	0							}
/* *INDENT-ON* */
}, e63ca_r_b[] = {
/* *INDENT-OFF* */
    {	c63ca___b,		c63ca___b + 6,
	NULL,			c63CX_r_m,
	0							}
/* *INDENT-ON* */
}, e63ca_r_m[] = {
/* *INDENT-OFF* */
    {	c63ca___m,		c63ca___m + 7,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63ca_r_r[] = {
/* *INDENT-OFF* */
    {	c63ca___r,		c63ca___r + 8,
	NULL,			c63CX_r_m,
	0							}
/* *INDENT-ON* */
}, e73ca_b_b[] = {
/* *INDENT-OFF* */
    {	c73ca_b_b,		c73ca_b_b + 0,
	e73za_b_b,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e73ca_m_m[] = {
/* *INDENT-OFF* */
    {	c73ca_m_m,		c73ca_m_m + 0,
	e73za_m_m,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e77ca_b_b[] = {
/* *INDENT-OFF* */
    {	e77xl_b_b,		e77xl_b_b + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e77ca_m_m[] = {
/* *INDENT-OFF* */
    {	e77xl_m_m,		e77xl_m_m + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e78ca_b_b[] = {
/* *INDENT-OFF* */
    {	e78xl_b_b,		e78xl_b_b + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e78ca_m_m[] = {
/* *INDENT-OFF* */
    {	e78xl_m_m,		e78xl_m_m + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e79ca_b_b[] = {
/* *INDENT-OFF* */
    {	e79xl_b_b,		e79xl_b_b + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e79ca_m_m[] = {
/* *INDENT-OFF* */
    {	e79xl_m_m,		e79xl_m_m + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
};
static const struct e4_odbv_type e61vc_b_b[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_b_b			},
    {	1,			e73xx_b_b			},
    {	-1,			e73xx_b_b			},
    {	0,			e61xx_b_b			}
/* *INDENT-ON* */
}, e61vc_m_m[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_m_m			},
    {	1,			e73xx_m_m			},
    {	-1,			e73xx_m_m			},
    {	0,			e61xx_m_m			}
/* *INDENT-ON* */
}, e73vc_b_b[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_b_b			},
    {	1,			e73xx_b_b			},
    {	-1,			e73xx_b_b			},
    {	0,			e61xx_b_b			}
/* *INDENT-ON* */
}, e73vc_m_m[] = {
/* *INDENT-OFF* */
    {	0,			e61xx_m_m			},
    {	1,			e73xx_m_m			},
    {	-1,			e73xx_m_m			},
    {	0,			e61xx_m_m			}
/* *INDENT-ON* */
};
static const struct e4_odbt_type e61tc_b_b[] = {
/* *INDENT-OFF* */
    {	c61cc_b_b + 0,		e61vc_b_b + 0,
	e61xx_b_b						},
    {	c61cc_b_b + 1,		e61vc_b_b + 2,
	e73xx_b_b						}
/* *INDENT-ON* */
}, e61tc_m_m[] = {
/* *INDENT-OFF* */
    {	c61cc_m_m + 0,		e61vc_m_m + 0,
	e61xx_m_m						},
    {	c61cc_m_m + 1,		e61vc_m_m + 2,
	e73xx_m_m						}
/* *INDENT-ON* */
}, e73tc_b_b[] = {
/* *INDENT-OFF* */
    {	c73cc_b_b + 0,		e73vc_b_b + 0,
	e73xx_b_b						},
    {	c73cc_b_b + 1,		e73vc_b_b + 2,
	e61xx_b_b						}
/* *INDENT-ON* */
}, e73tc_m_m[] = {
/* *INDENT-OFF* */
    {	c73cc_m_m + 0,		e73vc_m_m + 0,
	e73xx_m_m						},
    {	c73cc_m_m + 1,		e73vc_m_m + 2,
	e61xx_m_m						}
/* *INDENT-ON* */
};
static const struct e4_odbz_type e61zc_b_b[] = {
/* *INDENT-OFF* */
    {	e61tc_b_b						}
/* *INDENT-ON* */
}, e61zc_m_m[] = {
/* *INDENT-OFF* */
    {	e61tc_m_m						}
/* *INDENT-ON* */
}, e73zc_b_b[] = {
/* *INDENT-OFF* */
    {	e73tc_b_b						}
/* *INDENT-ON* */
}, e73zc_m_m[] = {
/* *INDENT-OFF* */
    {	e73tc_m_m						}
/* *INDENT-ON* */
};
static const struct e4_odbc_type e61cc_b_b[] = {
/* *INDENT-OFF* */
    {	c61cc_b_b,		c61cc_b_b + 0,
	e61zc_b_b,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e61cc_m_m[] = {
/* *INDENT-OFF* */
    {	c61cc_m_m,		c61cc_m_m + 0,
	e61zc_m_m,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e62cc_b_b[] = {
/* *INDENT-OFF* */
    {	c62cc___b,		c62cc___b + 0,
	NULL,			c62CX_b_m,
	0							}
/* *INDENT-ON* */
}, e62cc_b_m[] = {
/* *INDENT-OFF* */
    {	c62cc___m,		c62cc___m + 1,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62cc_b_r[] = {
/* *INDENT-OFF* */
    {	c62cc___r,		c62cc___r + 2,
	NULL,			c62CX_b_m,
	0							}
/* *INDENT-ON* */
}, e62cc_m_b[] = {
/* *INDENT-OFF* */
    {	c62cc___b,		c62cc___b + 3,
	NULL,			c62CX_m_m,
	0							}
/* *INDENT-ON* */
}, e62cc_m_m[] = {
/* *INDENT-OFF* */
    {	c62cc___m,		c62cc___m + 4,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62cc_m_r[] = {
/* *INDENT-OFF* */
    {	c62cc___r,		c62cc___r + 5,
	NULL,			c62CX_m_m,
	0							}
/* *INDENT-ON* */
}, e62cc_r_b[] = {
/* *INDENT-OFF* */
    {	c62cc___b,		c62cc___b + 6,
	NULL,			c62CX_r_m,
	0							}
/* *INDENT-ON* */
}, e62cc_r_m[] = {
/* *INDENT-OFF* */
    {	c62cc___m,		c62cc___m + 7,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e62cc_r_r[] = {
/* *INDENT-OFF* */
    {	c62cc___r,		c62cc___r + 8,
	NULL,			c62CX_r_m,
	0							}
/* *INDENT-ON* */
}, e63cc_b_b[] = {
/* *INDENT-OFF* */
    {	c63cc___b,		c63cc___b + 0,
	NULL,			c63CX_b_m,
	0							}
/* *INDENT-ON* */
}, e63cc_b_m[] = {
/* *INDENT-OFF* */
    {	c63cc___m,		c63cc___m + 1,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63cc_b_r[] = {
/* *INDENT-OFF* */
    {	c63cc___r,		c63cc___r + 2,
	NULL,			c63CX_b_m,
	0							}
/* *INDENT-ON* */
}, e63cc_m_b[] = {
/* *INDENT-OFF* */
    {	c63cc___b,		c63cc___b + 3,
	NULL,			c63CX_m_m,
	0							}
/* *INDENT-ON* */
}, e63cc_m_m[] = {
/* *INDENT-OFF* */
    {	c63cc___m,		c63cc___m + 4,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63cc_m_r[] = {
/* *INDENT-OFF* */
    {	c63cc___r,		c63cc___r + 5,
	NULL,			c63CX_m_m,
	0							}
/* *INDENT-ON* */
}, e63cc_r_b[] = {
/* *INDENT-OFF* */
    {	c63cc___b,		c63cc___b + 6,
	NULL,			c63CX_r_m,
	0							}
/* *INDENT-ON* */
}, e63cc_r_m[] = {
/* *INDENT-OFF* */
    {	c63cc___m,		c63cc___m + 7,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e63cc_r_r[] = {
/* *INDENT-OFF* */
    {	c63cc___r,		c63cc___r + 8,
	NULL,			c63CX_r_m,
	0							}
/* *INDENT-ON* */
}, e73cc_b_b[] = {
/* *INDENT-OFF* */
    {	c73cc_b_b,		c73cc_b_b + 0,
	e73zc_b_b,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e73cc_m_m[] = {
/* *INDENT-OFF* */
    {	c73cc_m_m,		c73cc_m_m + 0,
	e73zc_m_m,		NULL,
	SIGN_TRANSFORM						}
/* *INDENT-ON* */
}, e77cc_b_b[] = {
/* *INDENT-OFF* */
    {	e77xl_b_b,		e77xl_b_b + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e77cc_m_m[] = {
/* *INDENT-OFF* */
    {	e77xl_m_m,		e77xl_m_m + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e78cc_b_b[] = {
/* *INDENT-OFF* */
    {	e78xl_b_b,		e78xl_b_b + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e78cc_m_m[] = {
/* *INDENT-OFF* */
    {	e78xl_m_m,		e78xl_m_m + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e79cc_b_b[] = {
/* *INDENT-OFF* */
    {	e79xl_b_b,		e79xl_b_b + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
}, e79cc_m_m[] = {
/* *INDENT-OFF* */
    {	e79xl_m_m,		e79xl_m_m + 0,
	NULL,			NULL,
	0							}
/* *INDENT-ON* */
};
static const struct e4_odbs_type e6bcs_b_b[] = {
/* *INDENT-OFF* */
    {	c6bcs_b_b,		c6bcs_b_b + 0			}
/* *INDENT-ON* */
}, e6bcs_m_m[] = {
/* *INDENT-OFF* */
    {	c6bcs_m_m,		c6bcs_m_m + 0			}
/* *INDENT-ON* */
}, e74cs_b_b[] = {
/* *INDENT-OFF* */
    {	c74cs_b_b,		c74cs_b_b + 0			}
/* *INDENT-ON* */
}, e74cs_m_m[] = {
/* *INDENT-OFF* */
    {	c74cs_m_m,		c74cs_m_m + 0			}
/* *INDENT-ON* */
};
static const struct e4_rdbl_type rvvle_b_x_zero_m_pone[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_LESS_NONE | RDBX_MISS_TYPE,
	zero_bill,		pone_mode			}
/* *INDENT-ON* */
}, rvvle_m_x_zero_m_pone[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_LESS_NONE | RDBX_MISS_TYPE,
	zero_mode,		pone_mode			}
/* *INDENT-ON* */
}, rvvle_r_x_zero_m_pone[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_LESS_NONE | RDBX_MISS_TYPE,
	real_zero,		pone_mode			}
/* *INDENT-ON* */
}, rxxle_b_x_mone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	mone_bill,		NULL				}
/* *INDENT-ON* */
}, rxxle_b_x_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	zero_bill,		NULL				}
/* *INDENT-ON* */
}, rxxle_b_x_zero_m_zero[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	zero_bill,		zero_mode			}
/* *INDENT-ON* */
}, rxxle_b_x_zero_r_zero[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	zero_bill,		real_zero			}
/* *INDENT-ON* */
}, rxxle_m_x_mone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	mone_mode,		NULL				}
/* *INDENT-ON* */
}, rxxle_m_x_mone_b_mone[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	mone_mode,		mone_bill			}
/* *INDENT-ON* */
}, rxxle_m_x_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	zero_mode,		NULL				}
/* *INDENT-ON* */
}, rxxle_m_x_zero_b_zero[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	zero_mode,		zero_bill			}
/* *INDENT-ON* */
}, rxxle_m_x_zero_r_zero[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	zero_mode,		real_zero			}
/* *INDENT-ON* */
}, rxxle_r_x_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	real_zero,		NULL				}
/* *INDENT-ON* */
}, rxxle_r_x_zero_m_zero[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	real_zero,		zero_mode			}
/* *INDENT-ON* */
};
static const struct e4_rdbo_type rvvoe_x_b_zero_m_pone[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_LESS_NONE | RDBX_MISS_TYPE,
	zero_bill,		pone_mode			}
/* *INDENT-ON* */
}, rvvoe_x_m_zero_m_pone[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_LESS_NONE | RDBX_MISS_TYPE,
	zero_mode,		pone_mode			}
/* *INDENT-ON* */
}, rvvoe_x_r_zero_m_pone[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_LESS_NONE | RDBX_MISS_TYPE,
	real_zero,		pone_mode			}
/* *INDENT-ON* */
}, rxxoe_x_b_mone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	mone_bill,		NULL				}
/* *INDENT-ON* */
}, rxxoe_x_b_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	zero_bill,		NULL				}
/* *INDENT-ON* */
}, rxxoe_x_b_zero_r_zero[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	zero_bill,		real_zero			}
/* *INDENT-ON* */
}, rxxoe_x_b_zero_m_zero[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	zero_bill,		zero_mode			}
/* *INDENT-ON* */
}, rxxoe_x_m_mone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	mone_mode,		NULL				}
/* *INDENT-ON* */
}, rxxoe_x_m_mone_b_mone[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	mone_mode,		mone_bill			}
/* *INDENT-ON* */
}, rxxoe_x_m_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	zero_mode,		NULL				}
/* *INDENT-ON* */
}, rxxoe_x_m_zero_b_zero[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	zero_mode,		zero_bill			}
/* *INDENT-ON* */
}, rxxoe_x_m_zero_r_zero[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	zero_mode,		real_zero			}
/* *INDENT-ON* */
}, rxxoe_x_r_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	real_zero,		NULL				}
/* *INDENT-ON* */
}, rxxoe_x_r_zero_m_zero[] = {
/* *INDENT-OFF* */
    {	0,			RDBX_MISS_TYPE,
	real_zero,		zero_mode			}
/* *INDENT-ON* */
};
static const struct e4_edbl_type s73Le_X_X[] = {
/* *INDENT-OFF* */
    {	e61xx_b_b,		e73xx_b_b			},
    {	e61xx_b_m,		e73xx_b_m			},
    {	e61xx_b_r,		e73xx_b_r			},
    {	e61xx_m_b,		e73xx_m_b			},
    {	e61xx_m_m,		e73xx_m_m			},
    {	e61xx_m_r,		e73xx_m_r			},
    {	e61xx_r_b,		e73xx_r_b			},
    {	e61xx_r_m,		e73xx_r_m			},
    {	e61xx_r_r,		e73xx_r_r			},
    {	e73xx_b_b,		e61xx_b_b			},
    {	e73xx_b_m,		e61xx_b_m			},
    {	e73xx_b_r,		e61xx_b_r			},
    {	e73xx_m_b,		e61xx_m_b			},
    {	e73xx_m_m,		e61xx_m_m			},
    {	e73xx_m_r,		e61xx_m_r			},
    {	e73xx_r_b,		e61xx_r_b			},
    {	e73xx_r_m,		e61xx_r_m			},
    {	e73xx_r_r,		e61xx_r_r			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
};
static const struct e4_edbp_type s73Le_x_X[] = {
/* *INDENT-OFF* */
    {	s73Le_X_X						}
/* *INDENT-ON* */
};
static const struct e4_edbx_type s73Le_x_x[] = {
/* *INDENT-OFF* */
    {	SDBL_HEAD_TRANSFORM,	s73Le_x_X			}
/* *INDENT-ON* */
};
static const struct e4_sdbl_type s73le_b_x[] = {
/* *INDENT-OFF* */
    {	0,			SDBL_TRANSFORM_LINKAGE,
	zero_bill,		s73Le_x_x			}
/* *INDENT-ON* */
}, s73le_m_x[] = {
/* *INDENT-OFF* */
    {	0,			SDBL_TRANSFORM_LINKAGE,
	zero_mode,		s73Le_x_x			}
/* *INDENT-ON* */
}, s73le_r_x[] = {
/* *INDENT-OFF* */
    {	0,			SDBL_TRANSFORM_LINKAGE,
	real_zero,		s73Le_x_x			}
/* *INDENT-ON* */
}, sxxle_b_x_mone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	mone_bill,		NULL				}
/* *INDENT-ON* */
}, sxxle_b_x_pone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	pone_bill,		NULL				}
/* *INDENT-ON* */
}, sxxle_b_x_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	zero_bill,		NULL				}
/* *INDENT-ON* */
}, sxxle_m_x_mone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	mone_mode,		NULL				}
/* *INDENT-ON* */
}, sxxle_m_x_pone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	pone_mode,		NULL				}
/* *INDENT-ON* */
}, sxxle_m_x_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	zero_mode,		NULL				}
/* *INDENT-ON* */
}, sxxle_r_x_pone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	real_pone,		NULL				}
/* *INDENT-ON* */
}, sxxle_r_x_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	real_zero,		NULL				}
/* *INDENT-ON* */
};
static const struct e4_sdbo_type sxxoe_x_b_mone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	mone_bill						}
/* *INDENT-ON* */
}, sxxoe_x_b_pone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	pone_bill						}
/* *INDENT-ON* */
}, sxxoe_x_b_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	zero_bill						}
/* *INDENT-ON* */
}, sxxoe_x_m_mone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	mone_mode						}
/* *INDENT-ON* */
}, sxxoe_x_m_pone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	pone_mode						}
/* *INDENT-ON* */
}, sxxoe_x_m_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	zero_mode						}
/* *INDENT-ON* */
}, sxxoe_x_r_pone[] = {
/* *INDENT-OFF* */
    {	0,			0,
	real_pone						}
/* *INDENT-ON* */
}, sxxoe_x_r_zero[] = {
/* *INDENT-OFF* */
    {	0,			0,
	real_zero						}
/* *INDENT-ON* */
};
static const struct e4_tdbe_type t61Oe_b_b[] = {
/* *INDENT-OFF* */
    {	e73xx_b__,		e73xx_b_b			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t61Oe_b_m[] = {
/* *INDENT-OFF* */
    {	e73xx_m__,		e73xx_b_m			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t61Oe_b_r[] = {
/* *INDENT-OFF* */
    {	e73xx_r__,		e73xx_b_r			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t61Oe_m_b[] = {
/* *INDENT-OFF* */
    {	e73xx_b__,		e73xx_m_b			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t61Oe_m_m[] = {
/* *INDENT-OFF* */
    {	e73xx_m__,		e73xx_m_m			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t61Oe_m_r[] = {
/* *INDENT-OFF* */
    {	e73xx_r__,		e73xx_m_r			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t61Oe_r_b[] = {
/* *INDENT-OFF* */
    {	e73xx_b__,		e73xx_r_b			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t61Oe_r_m[] = {
/* *INDENT-OFF* */
    {	e73xx_m__,		e73xx_r_m			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t61Oe_r_r[] = {
/* *INDENT-OFF* */
    {	e73xx_r__,		e73xx_r_r			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t73Oe_b_b[] = {
/* *INDENT-OFF* */
    {	e73xx_b__,		e61xx_b_b			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t73Oe_b_m[] = {
/* *INDENT-OFF* */
    {	e73xx_m__,		e61xx_b_m			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t73Oe_b_r[] = {
/* *INDENT-OFF* */
    {	e73xx_r__,		e61xx_b_r			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t73Oe_m_b[] = {
/* *INDENT-OFF* */
    {	e73xx_b__,		e61xx_m_b			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t73Oe_m_m[] = {
/* *INDENT-OFF* */
    {	e73xx_m__,		e61xx_m_m			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t73Oe_m_r[] = {
/* *INDENT-OFF* */
    {	e73xx_r__,		e61xx_m_r			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t73Oe_r_b[] = {
/* *INDENT-OFF* */
    {	e73xx_b__,		e61xx_r_b			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t73Oe_r_m[] = {
/* *INDENT-OFF* */
    {	e73xx_m__,		e61xx_r_m			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
}, t73Oe_r_r[] = {
/* *INDENT-OFF* */
    {	e73xx_r__,		e61xx_r_r			},
    {	NULL,			NULL				}
/* *INDENT-ON* */
};
static const struct e4_tdbo_type t61oe_b_b[] = {
/* *INDENT-OFF* */
    {	t61Oe_b_b						}
/* *INDENT-ON* */
}, t61oe_b_m[] = {
/* *INDENT-OFF* */
    {	t61Oe_b_m						}
/* *INDENT-ON* */
}, t61oe_b_r[] = {
/* *INDENT-OFF* */
    {	t61Oe_b_r						}
/* *INDENT-ON* */
}, t61oe_m_b[] = {
/* *INDENT-OFF* */
    {	t61Oe_m_b						}
/* *INDENT-ON* */
}, t61oe_m_m[] = {
/* *INDENT-OFF* */
    {	t61Oe_m_m						}
/* *INDENT-ON* */
}, t61oe_m_r[] = {
/* *INDENT-OFF* */
    {	t61Oe_m_r						}
/* *INDENT-ON* */
}, t61oe_r_b[] = {
/* *INDENT-OFF* */
    {	t61Oe_r_b						}
/* *INDENT-ON* */
}, t61oe_r_m[] = {
/* *INDENT-OFF* */
    {	t61Oe_r_m						}
/* *INDENT-ON* */
}, t61oe_r_r[] = {
/* *INDENT-OFF* */
    {	t61Oe_r_r						}
/* *INDENT-ON* */
}, t73oe_b_b[] = {
/* *INDENT-OFF* */
    {	t73Oe_b_b						}
/* *INDENT-ON* */
}, t73oe_b_m[] = {
/* *INDENT-OFF* */
    {	t73Oe_b_m						}
/* *INDENT-ON* */
}, t73oe_b_r[] = {
/* *INDENT-OFF* */
    {	t73Oe_b_r						}
/* *INDENT-ON* */
}, t73oe_m_b[] = {
/* *INDENT-OFF* */
    {	t73Oe_m_b						}
/* *INDENT-ON* */
}, t73oe_m_m[] = {
/* *INDENT-OFF* */
    {	t73Oe_m_m						}
/* *INDENT-ON* */
}, t73oe_m_r[] = {
/* *INDENT-OFF* */
    {	t73Oe_m_r						}
/* *INDENT-ON* */
}, t73oe_r_b[] = {
/* *INDENT-OFF* */
    {	t73Oe_r_b						}
/* *INDENT-ON* */
}, t73oe_r_m[] = {
/* *INDENT-OFF* */
    {	t73Oe_r_m						}
/* *INDENT-ON* */
}, t73oe_r_r[] = {
/* *INDENT-OFF* */
    {	t73Oe_r_r						}
/* *INDENT-ON* */
};
static const struct e4_odbf_type e2cxe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2cxe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2cxe_b_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2cxe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2cxe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2cxe_m_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2cxe_r_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2cxe_r_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2cxe_r_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2exe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2exe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2exe_b_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2exe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2exe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2exe_m_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2exe_r_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2exe_r_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e2exe_r_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_pone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e61xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e61CA_b_b,		e61CC_b_b,
	NULL,			e61ca_b_b,
	e61cc_b_b,		NULL,
	NULL,			NULL,
	sxxle_b_x_zero,		sxxoe_x_b_zero,
	NULL,			t61oe_b_b,
	A_MISS_FLAG | LEFT_SKIP | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_FLOW | POST_SKIP		}
/* *INDENT-ON* */
}, e61xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			t61oe_b_m,
	A_MISS_FLAG | POST_FLOW | POST_SKIP			}
/* *INDENT-ON* */
}, e61xe_b_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	sxxle_b_x_zero,		NULL,
	NULL,			t61oe_b_r,
	LEFT_SKIP | POST_FLOW					}
/* *INDENT-ON* */
}, e61xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	sxxle_m_x_zero,		NULL,
	NULL,			t61oe_m_b,
	A_MISS_FLAG | LEFT_SKIP | POST_FLOW			}
/* *INDENT-ON* */
}, e61xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e61CA_m_m,		e61CC_m_m,
	NULL,			e61ca_m_m,
	e61cc_m_m,		NULL,
	NULL,			NULL,
	sxxle_m_x_zero,		sxxoe_x_m_zero,
	NULL,			t61oe_m_m,
	A_MISS_FLAG | LEFT_SKIP | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_FLOW | POST_SKIP		}
/* *INDENT-ON* */
}, e61xe_m_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	sxxle_m_x_zero,		NULL,
	NULL,			t61oe_m_r,
	LEFT_SKIP | POST_FLOW					}
/* *INDENT-ON* */
}, e61xe_r_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			t61oe_r_b,
	A_MISS_FLAG | POST_FLOW | POST_SKIP			}
/* *INDENT-ON* */
}, e61xe_r_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			t61oe_r_m,
	POST_FLOW | POST_SKIP					}
/* *INDENT-ON* */
}, e61xe_r_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	sxxle_r_x_zero,		sxxoe_x_r_zero,
	NULL,			t61oe_r_r,
	LEFT_SKIP | POST_FLOW | POST_SKIP			}
/* *INDENT-ON* */
}, e62xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e62CA_b_b,		e62CC_b_b,
	NULL,			e62ca_b_b,
	e62cc_b_b,		NULL,
	rxxle_b_x_zero_m_zero,	rxxoe_x_b_zero_m_zero,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e62xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e62CA_b_m,		e62CC_b_m,
	NULL,			e62ca_b_m,
	e62cc_b_m,		NULL,
	rxxle_b_x_zero_m_zero,	rxxoe_x_m_zero,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e62xe_b_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e62CA_b_r,		e62CC_b_r,
	NULL,			e62ca_b_r,
	e62cc_b_r,		NULL,
	rxxle_b_x_zero_m_zero,	rxxoe_x_r_zero_m_zero,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e62xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e62CA_m_b,		e62CC_m_b,
	NULL,			e62ca_m_b,
	e62cc_m_b,		NULL,
	rxxle_m_x_zero,		rxxoe_x_b_zero_m_zero,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e62xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e62CA_m_m,		e62CC_m_m,
	NULL,			e62ca_m_m,
	e62cc_m_m,		NULL,
	rxxle_m_x_zero,		rxxoe_x_m_zero,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e62xe_m_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e62CA_m_r,		e62CC_m_r,
	NULL,			e62ca_m_r,
	e62cc_m_r,		NULL,
	rxxle_m_x_zero,		rxxoe_x_r_zero_m_zero,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e62xe_r_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e62CA_r_b,		e62CC_r_b,
	NULL,			e62ca_r_b,
	e62cc_r_b,		NULL,
	rxxle_r_x_zero_m_zero,	rxxoe_x_b_zero_m_zero,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e62xe_r_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e62CA_r_m,		e62CC_r_m,
	NULL,			e62ca_r_m,
	e62cc_r_m,		NULL,
	rxxle_r_x_zero_m_zero,	rxxoe_x_m_zero,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e62xe_r_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e62CA_r_r,		e62CC_r_r,
	NULL,			e62ca_r_r,
	e62cc_r_r,		NULL,
	rxxle_r_x_zero_m_zero,	rxxoe_x_r_zero_m_zero,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e63xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e63CA_b_b,		e63CC_b_b,
	NULL,			e63ca_b_b,
	e63cc_b_b,		NULL,
	rvvle_b_x_zero_m_pone,	rvvoe_x_b_zero_m_pone,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e63xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e63CA_b_m,		e63CC_b_m,
	NULL,			e63ca_b_m,
	e63cc_b_m,		NULL,
	rvvle_b_x_zero_m_pone,	rvvoe_x_m_zero_m_pone,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e63xe_b_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e63CA_b_r,		e63CC_b_r,
	NULL,			e63ca_b_r,
	e63cc_b_r,		NULL,
	rvvle_b_x_zero_m_pone,	rvvoe_x_r_zero_m_pone,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e63xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e63CA_m_b,		e63CC_m_b,
	NULL,			e63ca_m_b,
	e63cc_m_b,		NULL,
	rvvle_m_x_zero_m_pone,	rvvoe_x_b_zero_m_pone,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e63xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e63CA_m_m,		e63CC_m_m,
	NULL,			e63ca_m_m,
	e63cc_m_m,		NULL,
	rvvle_m_x_zero_m_pone,	rvvoe_x_m_zero_m_pone,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e63xe_m_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e63CA_m_r,		e63CC_m_r,
	NULL,			e63ca_m_r,
	e63cc_m_r,		NULL,
	rvvle_m_x_zero_m_pone,	rvvoe_x_r_zero_m_pone,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e63xe_r_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e63CA_r_b,		e63CC_r_b,
	NULL,			e63ca_r_b,
	e63cc_r_b,		NULL,
	rvvle_r_x_zero_m_pone,	rvvoe_x_b_zero_m_pone,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e63xe_r_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e63CA_r_m,		e63CC_r_m,
	NULL,			e63ca_r_m,
	e63cc_r_m,		NULL,
	rvvle_r_x_zero_m_pone,	rvvoe_x_m_zero_m_pone,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e63xe_r_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e63CA_r_r,		e63CC_r_r,
	NULL,			e63ca_r_r,
	e63cc_r_r,		NULL,
	rvvle_r_x_zero_m_pone,	rvvoe_x_r_zero_m_pone,
	NULL,			NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_KILL			}
/* *INDENT-ON* */
}, e64xe_b_b[] = {
/* *INDENT-OFF* */
    {	i64CA_b_b,		i64CC_b_b,
	i64ca_b_b,		i64cc_b_b,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_b_x_zero,		NULL,
	NULL,			sxxoe_x_b_pone,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | NXAA_LIST | NXAC_LIST
	| NXCA_LIST | NXCC_LIST | POST_SKIP			}
/* *INDENT-ON* */
}, e64xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_b_x_zero,		NULL,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	LEFT_KILL | POST_SKIP					}
/* *INDENT-ON* */
}, e64xe_b_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_b_x_zero_r_zero,	NULL,
	NULL,			NULL,
	NULL,			NULL,
	LEFT_KILL						}
/* *INDENT-ON* */
}, e64xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_m_x_zero_b_zero,	NULL,
	NULL,			NULL,
	NULL,			NULL,
	LEFT_KILL						}
/* *INDENT-ON* */
}, e64xe_m_m[] = {
/* *INDENT-OFF* */
    {	i64CA_m_m,		i64CC_m_m,
	i64ca_m_m,		i64cc_m_m,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_m_x_zero,		NULL,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | NXAA_LIST | NXAC_LIST
	| NXCA_LIST | NXCC_LIST | POST_SKIP			}
/* *INDENT-ON* */
}, e64xe_m_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_m_x_zero_r_zero,	NULL,
	NULL,			NULL,
	NULL,			NULL,
	LEFT_KILL						}
/* *INDENT-ON* */
}, e64xe_r_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_r_x_zero,		NULL,
	NULL,			sxxoe_x_b_pone,
	NULL,			NULL,
	LEFT_KILL | POST_SKIP					}
/* *INDENT-ON* */
}, e64xe_r_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_r_x_zero,		NULL,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	LEFT_KILL | POST_SKIP					}
/* *INDENT-ON* */
}, e64xe_r_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_r_x_zero,		NULL,
	NULL,			sxxoe_x_r_pone,
	NULL,			NULL,
	LEFT_KILL | POST_SKIP					}
/* *INDENT-ON* */
}, e66xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e66xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e66xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e66xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e68xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_mone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e68xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_mone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e68xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_mone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e68xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_mone,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e69xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e69xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e69xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e69xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e6axe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e6axe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e6axe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e6axe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e6bxe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	e6bCS_b_b,		NULL,
	NULL,			e6bcs_b_b,
	rxxle_b_x_zero,		NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	LEFT_KILL | MXAS_LIST | MXCS_LIST | POST_SKIP		}
/* *INDENT-ON* */
}, e6bxe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_b_x_zero,		NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	LEFT_KILL | POST_SKIP					}
/* *INDENT-ON* */
}, e6bxe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_m_x_zero,		NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	LEFT_KILL | POST_SKIP					}
/* *INDENT-ON* */
}, e6bxe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	e6bCS_m_m,		NULL,
	NULL,			e6bcs_m_m,
	rxxle_m_x_zero,		NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	LEFT_KILL | MXAS_LIST | MXCS_LIST | POST_SKIP		}
/* *INDENT-ON* */
}, e6dxe_b_b[] = {
/* *INDENT-OFF* */
    {	i6dCA_b_b,		i6dCC_b_b,
	i6dca_b_b,		i6dcc_b_b,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_b_x_zero,		rxxoe_x_b_zero,
	sxxle_b_x_pone,		sxxoe_x_b_pone,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | NXAA_LIST
	| NXAC_LIST | NXCA_LIST | NXCC_LIST | POST_KILL
	| POST_SKIP						}
/* *INDENT-ON* */
}, e6dxe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_b_x_zero,		rxxoe_x_m_zero_b_zero,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | POST_KILL | POST_SKIP		}
/* *INDENT-ON* */
}, e6dxe_b_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_b_x_zero_r_zero,	rxxoe_x_r_zero,
	sxxle_b_x_pone,		NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | POST_KILL		}
/* *INDENT-ON* */
}, e6dxe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_m_x_zero_b_zero,	rxxoe_x_b_zero,
	sxxle_m_x_pone,		NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | POST_KILL		}
/* *INDENT-ON* */
}, e6dxe_m_m[] = {
/* *INDENT-OFF* */
    {	i6dCA_m_m,		i6dCC_m_m,
	i6dca_m_m,		i6dcc_m_m,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_m_x_zero,		rxxoe_x_m_zero,
	sxxle_m_x_pone,		sxxoe_x_m_pone,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | NXAA_LIST
	| NXAC_LIST | NXCA_LIST | NXCC_LIST | POST_KILL
	| POST_SKIP						}
/* *INDENT-ON* */
}, e6dxe_m_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_m_x_zero_r_zero,	rxxoe_x_r_zero,
	sxxle_m_x_pone,		NULL,
	NULL,			NULL,
	LEFT_KILL | LEFT_SKIP | POST_KILL			}
/* *INDENT-ON* */
}, e6dxe_r_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_r_x_zero,		rxxoe_x_b_zero_r_zero,
	NULL,			sxxoe_x_b_pone,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | POST_KILL | POST_SKIP		}
/* *INDENT-ON* */
}, e6dxe_r_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_r_x_zero,		rxxoe_x_m_zero_r_zero,
	NULL,			sxxoe_x_m_pone,
	NULL,			NULL,
	LEFT_KILL | POST_KILL | POST_SKIP			}
/* *INDENT-ON* */
}, e6dxe_r_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_r_x_zero,		rxxoe_x_r_zero,
	sxxle_r_x_pone,		sxxoe_x_r_pone,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | POST_KILL
	| POST_SKIP						}
/* *INDENT-ON* */
}, e70xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e70xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e70xe_b_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e70xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e70xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e70xe_m_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e70xe_r_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e70xe_r_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e70xe_r_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e71xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e71xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e71xe_b_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e71xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e71xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e71xe_m_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e71xe_r_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e71xe_r_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e71xe_r_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_r_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e73xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e73CA_b_b,		e73CC_b_b,
	NULL,			e73ca_b_b,
	e73cc_b_b,		NULL,
	NULL,			NULL,
	s73le_b_x,		sxxoe_x_b_zero,
	NULL,			t73oe_b_b,
	A_MISS_FLAG | LEFT_SKIP | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_FLOW | POST_SKIP		}
/* *INDENT-ON* */
}, e73xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			t73oe_b_m,
	A_MISS_FLAG | POST_FLOW | POST_SKIP			}
/* *INDENT-ON* */
}, e73xe_b_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	s73le_b_x,		NULL,
	NULL,			t73oe_b_r,
	A_MISS_FLAG | LEFT_SKIP | POST_FLOW			}
/* *INDENT-ON* */
}, e73xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	s73le_m_x,		NULL,
	NULL,			t73oe_m_b,
	A_MISS_FLAG | LEFT_SKIP | POST_FLOW			}
/* *INDENT-ON* */
}, e73xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e73CA_m_m,		e73CC_m_m,
	NULL,			e73ca_m_m,
	e73cc_m_m,		NULL,
	NULL,			NULL,
	s73le_m_x,		sxxoe_x_m_zero,
	NULL,			t73oe_m_m,
	A_MISS_FLAG | LEFT_SKIP | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | POST_FLOW | POST_SKIP		}
/* *INDENT-ON* */
}, e73xe_m_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	s73le_m_x,		NULL,
	NULL,			t73oe_m_r,
	LEFT_SKIP | POST_FLOW					}
/* *INDENT-ON* */
}, e73xe_r_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			t73oe_r_b,
	A_MISS_FLAG | POST_FLOW | POST_SKIP			}
/* *INDENT-ON* */
}, e73xe_r_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			t73oe_r_m,
	POST_FLOW | POST_SKIP					}
/* *INDENT-ON* */
}, e73xe_r_r[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	s73le_r_x,		sxxoe_x_r_zero,
	NULL,			t73oe_r_r,
	LEFT_SKIP | POST_FLOW | POST_SKIP			}
/* *INDENT-ON* */
}, e74xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	e74CS_b_b,		NULL,
	NULL,			e74cs_b_b,
	rxxle_b_x_zero,		NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	LEFT_KILL | MXAS_LIST | MXCS_LIST | POST_SKIP		}
/* *INDENT-ON* */
}, e74xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_b_x_zero,		NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	LEFT_KILL | POST_SKIP					}
/* *INDENT-ON* */
}, e74xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_m_x_zero,		NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	LEFT_KILL | POST_SKIP					}
/* *INDENT-ON* */
}, e74xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	e74CS_m_m,		NULL,
	NULL,			e74cs_m_m,
	rxxle_m_x_zero,		NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	LEFT_KILL | MXAS_LIST | MXCS_LIST | POST_SKIP		}
/* *INDENT-ON* */
}, e75xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e75xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e75xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_b_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e75xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	POST_SKIP						}
/* *INDENT-ON* */
}, e77xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e77CA_b_b,		e77CC_b_b,
	NULL,			e77ca_b_b,
	e77cc_b_b,		NULL,
	rxxle_b_x_zero,		rxxoe_x_b_zero,
	sxxle_b_x_mone,		sxxoe_x_b_mone,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | MXAA_LIST
	| MXAC_LIST | MXCA_LIST | MXCC_LIST | POST_KILL
	| POST_SKIP						}
/* *INDENT-ON* */
}, e77xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_b_x_zero,		rxxoe_x_m_zero_b_zero,
	NULL,			sxxoe_x_m_mone,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | POST_KILL | POST_SKIP		}
/* *INDENT-ON* */
}, e77xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_m_x_zero_b_zero,	rxxoe_x_b_zero,
	sxxle_m_x_mone,		NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | POST_KILL		}
/* *INDENT-ON* */
}, e77xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e77CA_m_m,		e77CC_m_m,
	NULL,			e77ca_m_m,
	e77cc_m_m,		NULL,
	rxxle_m_x_zero,		rxxoe_x_m_zero,
	sxxle_m_x_mone,		sxxoe_x_m_mone,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | MXAA_LIST
	| MXAC_LIST | MXCA_LIST | MXCC_LIST | POST_KILL
	| POST_SKIP						}
/* *INDENT-ON* */
}, e78xe_b_b[] = {
/* *INDENT-OFF* */
    {	i78CA_b_b,		i78CC_b_b,
	i78ca_b_b,		i78cc_b_b,
	e78CA_b_b,		e78CC_b_b,
	NULL,			e78ca_b_b,
	e78cc_b_b,		NULL,
	NULL,			NULL,
	sxxle_b_x_zero,		sxxoe_x_b_zero,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_SKIP | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | NXAA_LIST | NXAC_LIST
	| NXCA_LIST | NXCC_LIST | POST_SKIP			}
/* *INDENT-ON* */
}, e78xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	A_MISS_FLAG | POST_SKIP					}
/* *INDENT-ON* */
}, e78xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	sxxle_b_x_zero,		NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_SKIP					}
/* *INDENT-ON* */
}, e78xe_m_m[] = {
/* *INDENT-OFF* */
    {	i78CA_m_m,		i78CC_m_m,
	i78ca_m_m,		i78cc_m_m,
	e78CA_m_m,		e78CC_m_m,
	NULL,			e78ca_m_m,
	e78cc_m_m,		NULL,
	NULL,			NULL,
	sxxle_m_x_zero,		sxxoe_x_m_zero,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_SKIP | MXAA_LIST | MXAC_LIST
	| MXCA_LIST | MXCC_LIST | NXAA_LIST | NXAC_LIST
	| NXCA_LIST | NXCC_LIST | POST_SKIP			}
/* *INDENT-ON* */
}, e79xe_b_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e79CA_b_b,		e79CC_b_b,
	NULL,			e79ca_b_b,
	e79cc_b_b,		NULL,
	rxxle_b_x_mone,		rxxoe_x_b_mone,
	sxxle_b_x_zero,		sxxoe_x_b_zero,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | MXAA_LIST
	| MXAC_LIST | MXCA_LIST | MXCC_LIST | POST_KILL
	| POST_SKIP						}
/* *INDENT-ON* */
}, e79xe_b_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_b_x_mone,		rxxoe_x_m_mone_b_mone,
	NULL,			sxxoe_x_m_zero,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | POST_KILL | POST_SKIP		}
/* *INDENT-ON* */
}, e79xe_m_b[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	NULL,			NULL,
	rxxle_m_x_mone_b_mone,	rxxoe_x_b_mone,
	sxxle_b_x_zero,		NULL,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | POST_KILL		}
/* *INDENT-ON* */
}, e79xe_m_m[] = {
/* *INDENT-OFF* */
    {	NULL,			NULL,
	NULL,			NULL,
	e79CA_m_m,		e79CC_m_m,
	NULL,			e79ca_m_m,
	e79cc_m_m,		NULL,
	rxxle_m_x_mone,		rxxoe_x_m_mone,
	sxxle_m_x_zero,		sxxoe_x_m_zero,
	NULL,			NULL,
	A_MISS_FLAG | LEFT_KILL | LEFT_SKIP | MXAA_LIST
	| MXAC_LIST | MXCA_LIST | MXCC_LIST | POST_KILL
	| POST_SKIP						}
/* *INDENT-ON* */
};
static const struct e4_odbx_type *_x1f4_e4_1_arithmetics[] = {
/* *INDENT-OFF* */
    e61xx_b__,
    e61xx_m__,
    e61xx_r__,
    e6exx_b__,
    e6exx_m__,
    e6exx_r__,
    e6fxx_b__,
    e6fxx_m__,
    e73xx_b__,
    e73xx_m__,
    e73xx_r__,
    NULL
/* *INDENT-ON* */
}, *_x1f4_e4_2_arithmetics[] = {
/* *INDENT-OFF* */
    e2cxx_b_b,
    e2cxx_b_m,
    e2cxx_b_r,
    e2cxx_m_b,
    e2cxx_m_m,
    e2cxx_m_r,
    e2cxx_r_b,
    e2cxx_r_m,
    e2cxx_r_r,
    e5fxx_b_b,
    e5fxx_b_m,
    e5fxx_m_b,
    e5fxx_m_m,
    e64xx_b_b,
    e64xx_b_m,
    e64xx_b_r,
    e64xx_m_b,
    e64xx_m_m,
    e64xx_m_r,
    e64xx_r_b,
    e64xx_r_m,
    e64xx_r_r,
    e72xx_b_b,
    e72xx_b_m,
    e72xx_m_b,
    e72xx_m_m,
    /* always computable operators */
    e2exx_b_b,
    e2exx_b_m,
    e2exx_b_r,
    e2exx_m_b,
    e2exx_m_m,
    e2exx_m_r,
    e2exx_r_b,
    e2exx_r_m,
    e2exx_r_r,
    e61xx_b_b,
    e61xx_b_m,
    e61xx_b_r,
    e61xx_m_b,
    e61xx_m_m,
    e61xx_m_r,
    e61xx_r_b,
    e61xx_r_m,
    e61xx_r_r,
    e62xx_b_b,
    e62xx_b_m,
    e62xx_b_r,
    e62xx_m_b,
    e62xx_m_m,
    e62xx_m_r,
    e62xx_r_b,
    e62xx_r_m,
    e62xx_r_r,
    e63xx_b_b,
    e63xx_b_m,
    e63xx_b_r,
    e63xx_m_b,
    e63xx_m_m,
    e63xx_m_r,
    e63xx_r_b,
    e63xx_r_m,
    e63xx_r_r,
    e65xx_b_b,
    e65xx_b_m,
    e65xx_b_r,
    e65xx_m_b,
    e65xx_m_m,
    e65xx_m_r,
    e65xx_r_b,
    e65xx_r_m,
    e65xx_r_r,
    e65xx_t_t,
    e66xx_b_b,
    e66xx_b_m,
    e66xx_m_b,
    e66xx_m_m,
    e67xx_b_b,
    e67xx_b_m,
    e67xx_b_r,
    e67xx_m_b,
    e67xx_m_m,
    e67xx_m_r,
    e67xx_r_b,
    e67xx_r_m,
    e67xx_r_r,
    e67xx_t_t,
    e68xx_b_b,
    e68xx_b_m,
    e68xx_m_b,
    e68xx_m_m,
    e69xx_b_b,
    e69xx_b_m,
    e69xx_m_b,
    e69xx_m_m,
    e6axx_b_b,
    e6axx_b_m,
    e6axx_m_b,
    e6axx_m_m,
    e6bxx_b_b,
    e6bxx_b_m,
    e6bxx_m_b,
    e6bxx_m_m,
    e6cxx_b_b,
    e6cxx_b_m,
    e6cxx_b_r,
    e6cxx_m_b,
    e6cxx_m_m,
    e6cxx_m_r,
    e6cxx_r_b,
    e6cxx_r_m,
    e6cxx_r_r,
    e6cxx_t_t,
    e6dxx_b_b,
    e6dxx_b_m,
    e6dxx_b_r,
    e6dxx_m_b,
    e6dxx_m_m,
    e6dxx_m_r,
    e6dxx_r_b,
    e6dxx_r_m,
    e6dxx_r_r,
    e70xx_b_b,
    e70xx_b_m,
    e70xx_b_r,
    e70xx_m_b,
    e70xx_m_m,
    e70xx_m_r,
    e70xx_r_b,
    e70xx_r_m,
    e70xx_r_r,
    e71xx_b_b,
    e71xx_b_m,
    e71xx_b_r,
    e71xx_m_b,
    e71xx_m_m,
    e71xx_m_r,
    e71xx_r_b,
    e71xx_r_m,
    e71xx_r_r,
    e73xx_b_b,
    e73xx_b_m,
    e73xx_b_r,
    e73xx_m_b,
    e73xx_m_m,
    e73xx_m_r,
    e73xx_r_b,
    e73xx_r_m,
    e73xx_r_r,
    e74xx_b_b,
    e74xx_b_m,
    e74xx_m_b,
    e74xx_m_m,
    e75xx_b_b,
    e75xx_b_m,
    e75xx_m_b,
    e75xx_m_m,
    e76xx_b_b,
    e76xx_b_m,
    e76xx_b_r,
    e76xx_m_b,
    e76xx_m_m,
    e76xx_m_r,
    e76xx_r_b,
    e76xx_r_m,
    e76xx_r_r,
    e76xx_t_t,
    e77xx_b_b,
    e77xx_b_m,
    e77xx_m_b,
    e77xx_m_m,
    e78xx_b_b,
    e78xx_b_m,
    e78xx_m_b,
    e78xx_m_m,
    e79xx_b_b,
    e79xx_b_m,
    e79xx_m_b,
    e79xx_m_m,
    e7axx_b_b,
    e7axx_b_m,
    e7axx_b_r,
    e7axx_m_b,
    e7axx_m_m,
    e7axx_m_r,
    e7axx_r_b,
    e7axx_r_m,
    e7axx_r_r,
    e7bxx_b_b,
    e7bxx_b_m,
    e7bxx_b_r,
    e7bxx_m_b,
    e7bxx_m_m,
    e7bxx_m_r,
    e7bxx_r_b,
    e7bxx_r_m,
    e7bxx_r_r,
    e7bxx_t_t,
    e7cxx_b_b,
    e7cxx_b_m,
    e7cxx_b_r,
    e7cxx_m_b,
    e7cxx_m_m,
    e7cxx_m_r,
    e7cxx_r_b,
    e7cxx_r_m,
    e7cxx_r_r,
    e7cxx_t_t,
    NULL
/* *INDENT-ON* */
};

static int
c2cxx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;
    int status = 0;

    side = I_BILL(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_BILL left;

	left = I_BILL(input[0]) / side;

	l_BILL(left, output);
	l_BILL(left, input[0]);
    }

    return status;
}


static int
c2cxx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;
    int status = 0;

    side = I_MODE(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_BILL left;

	left = I_BILL(input[0]) / side;

	l_BILL(left, output);
	l_BILL(left, input[0]);
    }

    return status;
}


static int
c2cxx_b_r(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;
    int status = 0;

    side = I_REAL(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_BILL left;

	left = I_BILL(input[0]) / side;

	l_BILL(left, output);
	l_BILL(left, input[0]);
    }

    return status;
}


static int
c2cxx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;
    int status = 0;

    side = I_BILL(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_MODE left;

	left = I_MODE(input[0]) / side;

	l_MODE(left, output);
	l_MODE(left, input[0]);
    }

    return status;
}


static int
c2cxx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;
    int status = 0;

    side = I_MODE(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_MODE left;

	left = I_MODE(input[0]) / side;

	l_MODE(left, output);
	l_MODE(left, input[0]);
    }

    return status;
}


static int
c2cxx_m_r(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;
    int status = 0;

    side = I_REAL(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_MODE left;

	left = I_MODE(input[0]) / side;

	l_MODE(left, output);
	l_MODE(left, input[0]);
    }

    return status;
}


static int
c2cxx_r_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;
    int status = 0;

    side = I_BILL(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_REAL left;

	left = I_REAL(input[0]) / side;

	l_REAL(left, output);
	l_REAL(left, input[0]);
    }

    return status;
}


static int
c2cxx_r_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;
    int status = 0;

    side = I_MODE(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_REAL left;

	left = I_REAL(input[0]) / side;

	l_REAL(left, output);
	l_REAL(left, input[0]);
    }

    return status;
}


static int
c2cxx_r_r(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;
    int status = 0;

    side = I_REAL(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_REAL left;

	left = I_REAL(input[0]) / side;

	l_REAL(left, output);
	l_REAL(left, input[0]);
    }

    return status;
}


static int
c2exx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) * I_BILL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c2exx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) * I_MODE(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c2exx_b_r(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) * I_REAL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c2exx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) * I_BILL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c2exx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) * I_MODE(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c2exx_m_r(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) * I_REAL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c2exx_r_b(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_REAL(input[0]) * I_BILL(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c2exx_r_m(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_REAL(input[0]) * I_MODE(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c2exx_r_r(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_REAL(input[0]) * I_REAL(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c5fxx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;
    int status = 0;

    side = I_BILL(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_BILL left;

	left = I_BILL(input[0]) % side;

	l_BILL(left, output);
	l_BILL(left, input[0]);
    }

    return status;
}


static int
c5fxx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;
    int status = 0;

    side = I_MODE(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_BILL left;

	left = I_BILL(input[0]) % side;

	l_BILL(left, output);
	l_BILL(left, input[0]);
    }

    return status;
}


static int
c5fxx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;
    int status = 0;

    side = I_BILL(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_MODE left;

	left = I_MODE(input[0]) % side;

	l_MODE(left, output);
	l_MODE(left, input[0]);
    }

    return status;
}


static int
c5fxx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;
    int status = 0;

    side = I_MODE(input[1]);

    if (!side) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	C_MODE left;

	left = I_MODE(input[0]) % side;

	l_MODE(left, output);
	l_MODE(left, input[0]);
    }

    return status;
}


static int
c61xx_b__(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]), output);

    return 0;
}


static int
c61xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) + I_BILL(input[1]), output);

    return 0;
}


static int
c61xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) + I_MODE(input[1]), output);

    return 0;
}


static int
c61xx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_BILL(input[0]) + I_REAL(input[1]), output);

    return 0;
}


static int
c61xx_m__(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]), output);

    return 0;
}


static int
c61xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_MODE(input[0]) + I_BILL(input[1]), output);

    return 0;
}


static int
c61xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) + I_MODE(input[1]), output);

    return 0;
}


static int
c61xx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_MODE(input[0]) + I_REAL(input[1]), output);

    return 0;
}


static int
c61xx_r__(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_REAL(input[0]), output);

    return 0;
}


static int
c61xx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_REAL(input[0]) + I_BILL(input[1]), output);

    return 0;
}


static int
c61xx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_REAL(input[0]) + I_MODE(input[1]), output);

    return 0;
}


static int
c61xx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_REAL(input[0]) + I_REAL(input[1]), output);

    return 0;
}


static int
c62xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) && I_BILL(input[1]), output);

    return 0;
}


static int
c62xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) && I_MODE(input[1]), output);

    return 0;
}


static int
c62xx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) && I_REAL(input[1]), output);

    return 0;
}


static int
c62xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) && I_BILL(input[1]), output);

    return 0;
}


static int
c62xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) && I_MODE(input[1]), output);

    return 0;
}


static int
c62xx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) && I_REAL(input[1]), output);

    return 0;
}


static int
c62xx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) && I_BILL(input[1]), output);

    return 0;
}


static int
c62xx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) && I_MODE(input[1]), output);

    return 0;
}


static int
c62xx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) && I_REAL(input[1]), output);

    return 0;
}


static int
c63xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) || I_BILL(input[1]), output);

    return 0;
}


static int
c63xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) || I_MODE(input[1]), output);

    return 0;
}


static int
c63xx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) || I_REAL(input[1]), output);

    return 0;
}


static int
c63xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) || I_BILL(input[1]), output);

    return 0;
}


static int
c63xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) || I_MODE(input[1]), output);

    return 0;
}


static int
c63xx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) || I_REAL(input[1]), output);

    return 0;
}


static int
c63xx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) || I_BILL(input[1]), output);

    return 0;
}


static int
c63xx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) || I_MODE(input[1]), output);

    return 0;
}


static int
c63xx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) || I_REAL(input[1]), output);

    return 0;
}


static int
c64xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL rate;
    int status = 0;

    rate = I_BILL(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_BILL(I_BILL(input[0]) / rate, output);
    }

    return status;
}


static int
c64xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE rate;
    int status = 0;

    rate = I_MODE(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_BILL(I_BILL(input[0]) / rate, output);
    }

    return status;
}


static int
c64xx_b_r(x1f4_e4_LINE_ARGS_1)
{
    C_REAL rate;
    int status = 0;

    rate = I_REAL(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_REAL(I_BILL(input[0]) / rate, output);
    }

    return status;
}


static int
c64xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL rate;
    int status = 0;

    rate = I_BILL(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_BILL(I_MODE(input[0]) / rate, output);
    }

    return status;
}


static int
c64xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE rate;
    int status = 0;

    rate = I_MODE(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_MODE(I_MODE(input[0]) / rate, output);
    }

    return status;
}


static int
c64xx_m_r(x1f4_e4_LINE_ARGS_1)
{
    C_REAL rate;
    int status = 0;

    rate = I_REAL(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_REAL(I_MODE(input[0]) / rate, output);
    }

    return status;
}


static int
c64xx_r_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL rate;
    int status = 0;

    rate = I_BILL(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_REAL(I_REAL(input[0]) / rate, output);
    }

    return status;
}


static int
c64xx_r_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE rate;
    int status = 0;

    rate = I_MODE(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_REAL(I_REAL(input[0]) / rate, output);
    }

    return status;
}


static int
c64xx_r_r(x1f4_e4_LINE_ARGS_1)
{
    C_REAL rate;
    int status = 0;

    rate = I_REAL(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_REAL(I_REAL(input[0]) / rate, output);
    }

    return status;
}


static int
c65xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) == I_BILL(input[1]), output);

    return 0;
}


static int
c65xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) == I_MODE(input[1]), output);

    return 0;
}


static int
c65xx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) == I_REAL(input[1]), output);

    return 0;
}


static int
c65xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) == I_BILL(input[1]), output);

    return 0;
}


static int
c65xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) == I_MODE(input[1]), output);

    return 0;
}


static int
c65xx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) == I_REAL(input[1]), output);

    return 0;
}


static int
c65xx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) == I_BILL(input[1]), output);

    return 0;
}


static int
c65xx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) == I_MODE(input[1]), output);

    return 0;
}


static int
c65xx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) == I_REAL(input[1]), output);

    return 0;
}


static int
c65xx_t_t(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(!_x1f4_e4_text_diff
	   ((unsigned char *) I_TEXT(input[0]),
	    (unsigned char *) I_TEXT(input[1])), output);

    return 0;
}


static int
c66xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) << I_BILL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c66xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) << I_MODE(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c66xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) << I_BILL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c66xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) << I_MODE(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c67xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[1]) < I_BILL(input[0]), output);

    return 0;
}


static int
c67xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[1]) < I_BILL(input[0]), output);

    return 0;
}


static int
c67xx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[1]) < I_BILL(input[0]), output);

    return 0;
}


static int
c67xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[1]) < I_MODE(input[0]), output);

    return 0;
}


static int
c67xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[1]) < I_MODE(input[0]), output);

    return 0;
}


static int
c67xx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[1]) < I_MODE(input[0]), output);

    return 0;
}


static int
c67xx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[1]) < I_REAL(input[0]), output);

    return 0;
}


static int
c67xx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[1]) < I_REAL(input[0]), output);

    return 0;
}


static int
c67xx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[1]) < I_REAL(input[0]), output);

    return 0;
}


static int
c67xx_t_t(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(_x1f4_e4_text_diff
	   ((unsigned char *) I_TEXT(input[1]),
	    (unsigned char *) I_TEXT(input[0])) < 0, output);

    return 0;
}


static int
c68xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) & I_BILL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c68xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) & I_MODE(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c68xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) & I_BILL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c68xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) & I_MODE(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c69xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) ^ I_BILL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c69xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) ^ I_MODE(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c69xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) ^ I_BILL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c69xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) ^ I_MODE(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c6axx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) | I_BILL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c6axx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) | I_MODE(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c6axx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) | I_BILL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c6axx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) | I_MODE(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c6bxx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) << I_BILL(input[1]), output);

    return 0;
}


static int
c6bxx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) << I_MODE(input[1]), output);

    return 0;
}


static int
c6bxx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) << I_BILL(input[1]), output);

    return 0;
}


static int
c6bxx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) << I_MODE(input[1]), output);

    return 0;
}


static int
c6cxx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) < I_BILL(input[1]), output);

    return 0;
}


static int
c6cxx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) < I_MODE(input[1]), output);

    return 0;
}


static int
c6cxx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) < I_REAL(input[1]), output);

    return 0;
}


static int
c6cxx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) < I_BILL(input[1]), output);

    return 0;
}


static int
c6cxx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) < I_MODE(input[1]), output);

    return 0;
}


static int
c6cxx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) < I_REAL(input[1]), output);

    return 0;
}


static int
c6cxx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) < I_BILL(input[1]), output);

    return 0;
}


static int
c6cxx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) < I_MODE(input[1]), output);

    return 0;
}


static int
c6cxx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) < I_REAL(input[1]), output);

    return 0;
}


static int
c6cxx_t_t(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(_x1f4_e4_text_diff
	   ((unsigned char *) I_TEXT(input[0]),
	    (unsigned char *) I_TEXT(input[1])) < 0, output);

    return 0;
}


static int
c6dxx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) * I_BILL(input[1]), output);

    return 0;
}


static int
c6dxx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) * I_MODE(input[1]), output);

    return 0;
}


static int
c6dxx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_BILL(input[0]) * I_REAL(input[1]), output);

    return 0;
}


static int
c6dxx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_MODE(input[0]) * I_BILL(input[1]), output);

    return 0;
}


static int
c6dxx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) * I_MODE(input[1]), output);

    return 0;
}


static int
c6dxx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_MODE(input[0]) * I_REAL(input[1]), output);

    return 0;
}


static int
c6dxx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_REAL(input[0]) * I_BILL(input[1]), output);

    return 0;
}


static int
c6dxx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_REAL(input[0]) * I_MODE(input[1]), output);

    return 0;
}


static int
c6dxx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_REAL(input[0]) * I_REAL(input[1]), output);

    return 0;
}


static int
c6exx_b__(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(!I_BILL(input[0]), output);

    return 0;
}


static int
c6exx_m__(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(!I_MODE(input[0]), output);

    return 0;
}


static int
c6exx_r__(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(!I_REAL(input[0]), output);

    return 0;
}


static int
c6fxx_b__(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(~I_BILL(input[0]), output);

    return 0;
}


static int
c6fxx_m__(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(~I_MODE(input[0]), output);

    return 0;
}


static int
c70xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) + I_BILL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c70xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) + I_MODE(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c70xx_b_r(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) + I_REAL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c70xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) + I_BILL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c70xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) + I_MODE(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c70xx_m_r(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) + I_REAL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c70xx_r_b(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_REAL(input[0]) + I_BILL(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c70xx_r_m(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_REAL(input[0]) + I_MODE(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c70xx_r_r(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_REAL(input[0]) + I_REAL(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c71xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) - I_BILL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c71xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) - I_MODE(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c71xx_b_r(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) - I_REAL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c71xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) - I_BILL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c71xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) - I_MODE(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c71xx_m_r(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) - I_REAL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c71xx_r_b(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_REAL(input[0]) - I_BILL(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c71xx_r_m(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_REAL(input[0]) - I_MODE(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c71xx_r_r(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_REAL(input[0]) - I_REAL(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c72xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL rate;
    int status = 0;

    rate = I_BILL(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_BILL(I_BILL(input[0]) % rate, output);
    }

    return status;
}


static int
c72xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE rate;
    int status = 0;

    rate = I_MODE(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_BILL(I_BILL(input[0]) % rate, output);
    }

    return status;
}


static int
c72xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL rate;
    int status = 0;

    rate = I_BILL(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_BILL(I_MODE(input[0]) % rate, output);
    }

    return status;
}


static int
c72xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE rate;
    int status = 0;

    rate = I_MODE(input[1]);
    if (!rate) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	l_MODE(I_MODE(input[0]) % rate, output);
    }

    return status;
}


static int
c73xx_b__(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(-I_BILL(input[0]), output);

    return 0;
}


static int
c73xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) - I_BILL(input[1]), output);

    return 0;
}


static int
c73xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) - I_MODE(input[1]), output);

    return 0;
}


static int
c73xx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_BILL(input[0]) - I_REAL(input[1]), output);

    return 0;
}


static int
c73xx_m__(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(-I_MODE(input[0]), output);

    return 0;
}


static int
c73xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_MODE(input[0]) - I_BILL(input[1]), output);

    return 0;
}


static int
c73xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) - I_MODE(input[1]), output);

    return 0;
}


static int
c73xx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_MODE(input[0]) - I_REAL(input[1]), output);

    return 0;
}


static int
c73xx_r__(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(-I_REAL(input[0]), output);

    return 0;
}


static int
c73xx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_REAL(input[0]) - I_BILL(input[1]), output);

    return 0;
}


static int
c73xx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_REAL(input[0]) - I_MODE(input[1]), output);

    return 0;
}


static int
c73xx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_REAL(I_REAL(input[0]) - I_REAL(input[1]), output);

    return 0;
}


static int
c74xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) >> I_BILL(input[1]), output);

    return 0;
}


static int
c74xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) >> I_MODE(input[1]), output);

    return 0;
}


static int
c74xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) >> I_BILL(input[1]), output);

    return 0;
}


static int
c74xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) >> I_MODE(input[1]), output);

    return 0;
}


static int
c75xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) >> I_BILL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c75xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[0]) >> I_MODE(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c75xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) >> I_BILL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c75xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[0]) >> I_MODE(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c76xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) != I_BILL(input[1]), output);

    return 0;
}


static int
c76xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) != I_MODE(input[1]), output);

    return 0;
}


static int
c76xx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) != I_REAL(input[1]), output);

    return 0;
}


static int
c76xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) != I_BILL(input[1]), output);

    return 0;
}


static int
c76xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) != I_MODE(input[1]), output);

    return 0;
}


static int
c76xx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) != I_REAL(input[1]), output);

    return 0;
}


static int
c76xx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) != I_BILL(input[1]), output);

    return 0;
}


static int
c76xx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) != I_MODE(input[1]), output);

    return 0;
}


static int
c76xx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) != I_REAL(input[1]), output);

    return 0;
}


static int
c76xx_t_t(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(_x1f4_e4_text_diff
	   ((unsigned char *) I_TEXT(input[0]),
	    (unsigned char *) I_TEXT(input[1])), output);

    return 0;
}


static int
c77xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) & I_BILL(input[1]), output);

    return 0;
}


static int
c77xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) & I_MODE(input[1]), output);

    return 0;
}


static int
c77xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_MODE(input[0]) & I_BILL(input[1]), output);

    return 0;
}


static int
c77xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) & I_MODE(input[1]), output);

    return 0;
}


static int
c78xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) ^ I_BILL(input[1]), output);

    return 0;
}


static int
c78xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) ^ I_MODE(input[1]), output);

    return 0;
}


static int
c78xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_MODE(input[0]) ^ I_BILL(input[1]), output);

    return 0;
}


static int
c78xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) ^ I_MODE(input[1]), output);

    return 0;
}


static int
c79xx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) | I_BILL(input[1]), output);

    return 0;
}


static int
c79xx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_BILL(input[0]) | I_MODE(input[1]), output);

    return 0;
}


static int
c79xx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_BILL(I_MODE(input[0]) | I_BILL(input[1]), output);

    return 0;
}


static int
c79xx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) | I_MODE(input[1]), output);

    return 0;
}


static int
c7axx_b_b(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_BILL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c7axx_b_m(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = I_MODE(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c7axx_b_r(x1f4_e4_LINE_ARGS_1)
{
    C_BILL side;

    side = (C_BILL) I_REAL(input[1]);

    l_BILL(side, output);
    l_BILL(side, input[0]);

    return 0;
}


static int
c7axx_m_b(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_BILL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c7axx_m_m(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = I_MODE(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c7axx_m_r(x1f4_e4_LINE_ARGS_1)
{
    C_MODE side;

    side = (C_MODE) I_REAL(input[1]);

    l_MODE(side, output);
    l_MODE(side, input[0]);

    return 0;
}


static int
c7axx_r_b(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_BILL(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c7axx_r_m(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_MODE(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c7axx_r_r(x1f4_e4_LINE_ARGS_1)
{
    C_REAL side;

    side = I_REAL(input[1]);

    l_REAL(side, output);
    l_REAL(side, input[0]);

    return 0;
}


static int
c7bxx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) <= I_BILL(input[1]), output);

    return 0;
}


static int
c7bxx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) <= I_MODE(input[1]), output);

    return 0;
}


static int
c7bxx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) <= I_REAL(input[1]), output);

    return 0;
}


static int
c7bxx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) <= I_BILL(input[1]), output);

    return 0;
}


static int
c7bxx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) <= I_MODE(input[1]), output);

    return 0;
}


static int
c7bxx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) <= I_REAL(input[1]), output);

    return 0;
}


static int
c7bxx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) <= I_BILL(input[1]), output);

    return 0;
}


static int
c7bxx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) <= I_MODE(input[1]), output);

    return 0;
}


static int
c7bxx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) <= I_REAL(input[1]), output);

    return 0;
}


static int
c7bxx_t_t(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(_x1f4_e4_text_diff
	   ((unsigned char *) I_TEXT(input[0]),
	    (unsigned char *) I_TEXT(input[1])) < 1, output);

    return 0;
}


static int
c7cxx_b_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) >= I_BILL(input[1]), output);

    return 0;
}


static int
c7cxx_b_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) >= I_MODE(input[1]), output);

    return 0;
}


static int
c7cxx_b_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_BILL(input[0]) >= I_REAL(input[1]), output);

    return 0;
}


static int
c7cxx_m_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) >= I_BILL(input[1]), output);

    return 0;
}


static int
c7cxx_m_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) >= I_MODE(input[1]), output);

    return 0;
}


static int
c7cxx_m_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_MODE(input[0]) >= I_REAL(input[1]), output);

    return 0;
}


static int
c7cxx_r_b(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) >= I_BILL(input[1]), output);

    return 0;
}


static int
c7cxx_r_m(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) >= I_MODE(input[1]), output);

    return 0;
}


static int
c7cxx_r_r(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(I_REAL(input[0]) >= I_REAL(input[1]), output);

    return 0;
}


static int
c7cxx_t_t(x1f4_e4_LINE_ARGS_1)
{
    l_MODE(_x1f4_e4_text_diff
	   ((unsigned char *) I_TEXT(input[1]),
	    (unsigned char *) I_TEXT(input[0])) < 1, output);

    return 0;
}


void
x1f4_llink_operator1s(const struct e4_odbx_type *const **e4_1_arithmetics)
{
    if (link_1) {
	link_1 = 0;
    }

    *e4_1_arithmetics = _x1f4_e4_1_arithmetics;
}


void
x1f4_ilink_operator2s(const struct e4_odbx_type *const **e4_2_arithmetics)
{
    const struct e4_odbx_type *const *e4_i_arithmetics;

    x1f4_llink_operator2s(&e4_i_arithmetics);

    *e4_2_arithmetics = e4_i_arithmetics + (9 + 4) * 2;
}


void
x1f4_llink_operator2s(const struct e4_odbx_type *const **e4_2_arithmetics)
{
    if (link_2) {
	e2cxx_b_b[0].extension1 = e2cxe_b_b;
	e2cxx_b_m[0].extension1 = e2cxe_b_m;
	e2cxx_b_r[0].extension1 = e2cxe_b_r;
	e2cxx_m_b[0].extension1 = e2cxe_m_b;
	e2cxx_m_m[0].extension1 = e2cxe_m_m;
	e2cxx_m_r[0].extension1 = e2cxe_m_r;
	e2cxx_r_b[0].extension1 = e2cxe_r_b;
	e2cxx_r_m[0].extension1 = e2cxe_r_m;
	e2cxx_r_r[0].extension1 = e2cxe_r_r;
	e2exx_b_b[0].extension1 = e2exe_b_b;
	e2exx_b_m[0].extension1 = e2exe_b_m;
	e2exx_b_r[0].extension1 = e2exe_b_r;
	e2exx_m_b[0].extension1 = e2exe_m_b;
	e2exx_m_m[0].extension1 = e2exe_m_m;
	e2exx_m_r[0].extension1 = e2exe_m_r;
	e2exx_r_b[0].extension1 = e2exe_r_b;
	e2exx_r_m[0].extension1 = e2exe_r_m;
	e2exx_r_r[0].extension1 = e2exe_r_r;
	e61xx_b_b[0].extension1 = e61xe_b_b;
	e61xx_b_b[0].extension2 = rank_none;
	e61xx_b_m[0].extension1 = e61xe_b_m;
	e61xx_b_r[0].extension1 = e61xe_b_r;
	e61xx_m_b[0].extension1 = e61xe_m_b;
	e61xx_m_m[0].extension1 = e61xe_m_m;
	e61xx_m_m[0].extension2 = rank_none;
	e61xx_m_r[0].extension1 = e61xe_m_r;
	e61xx_r_b[0].extension1 = e61xe_r_b;
	e61xx_r_m[0].extension1 = e61xe_r_m;
	e61xx_r_r[0].extension1 = e61xe_r_r;
	e61xx_r_r[0].extension2 = rank_none;
	e62xx_b_b[0].extension1 = e62xe_b_b;
	e62xx_b_b[0].extension2 = e62xx_2nd;
	e62xx_b_m[0].extension1 = e62xe_b_m;
	e62xx_b_m[0].extension2 = e62xx_2nd;
	e62xx_b_r[0].extension1 = e62xe_b_r;
	e62xx_b_r[0].extension2 = e62xx_2nd;
	e62xx_m_b[0].extension1 = e62xe_m_b;
	e62xx_m_b[0].extension2 = e62xx_2nd;
	e62xx_m_m[0].extension1 = e62xe_m_m;
	e62xx_m_m[0].extension2 = e62xx_2nd;
	e62xx_m_r[0].extension1 = e62xe_m_r;
	e62xx_m_r[0].extension2 = e62xx_2nd;
	e62xx_r_b[0].extension1 = e62xe_r_b;
	e62xx_r_b[0].extension2 = e62xx_2nd;
	e62xx_r_m[0].extension1 = e62xe_r_m;
	e62xx_r_m[0].extension2 = e62xx_2nd;
	e62xx_r_r[0].extension1 = e62xe_r_r;
	e62xx_r_r[0].extension2 = e62xx_2nd;
	e63xx_b_b[0].extension1 = e63xe_b_b;
	e63xx_b_b[0].extension2 = e63xx_2nd;
	e63xx_b_m[0].extension1 = e63xe_b_m;
	e63xx_b_m[0].extension2 = e63xx_2nd;
	e63xx_b_r[0].extension1 = e63xe_b_r;
	e63xx_b_r[0].extension2 = e63xx_2nd;
	e63xx_m_b[0].extension1 = e63xe_m_b;
	e63xx_m_b[0].extension2 = e63xx_2nd;
	e63xx_m_m[0].extension1 = e63xe_m_m;
	e63xx_m_m[0].extension2 = e63xx_2nd;
	e63xx_m_r[0].extension1 = e63xe_m_r;
	e63xx_m_r[0].extension2 = e63xx_2nd;
	e63xx_r_b[0].extension1 = e63xe_r_b;
	e63xx_r_b[0].extension2 = e63xx_2nd;
	e63xx_r_m[0].extension1 = e63xe_r_m;
	e63xx_r_m[0].extension2 = e63xx_2nd;
	e63xx_r_r[0].extension1 = e63xe_r_r;
	e63xx_r_r[0].extension2 = e63xx_2nd;
	e64xx_b_b[0].extension1 = e64xe_b_b;
	e64xx_b_m[0].extension1 = e64xe_b_m;
	e64xx_b_r[0].extension1 = e64xe_b_r;
	e64xx_m_b[0].extension1 = e64xe_m_b;
	e64xx_m_m[0].extension1 = e64xe_m_m;
	e64xx_m_r[0].extension1 = e64xe_m_r;
	e64xx_r_b[0].extension1 = e64xe_r_b;
	e64xx_r_m[0].extension1 = e64xe_r_m;
	e64xx_r_r[0].extension1 = e64xe_r_r;
	e66xx_b_b[0].extension1 = e66xe_b_b;
	e66xx_b_m[0].extension1 = e66xe_b_m;
	e66xx_m_b[0].extension1 = e66xe_m_b;
	e66xx_m_m[0].extension1 = e66xe_m_m;
	e68xx_b_b[0].extension1 = e68xe_b_b;
	e68xx_b_m[0].extension1 = e68xe_b_m;
	e68xx_m_b[0].extension1 = e68xe_m_b;
	e68xx_m_m[0].extension1 = e68xe_m_m;
	e69xx_b_b[0].extension1 = e69xe_b_b;
	e69xx_b_m[0].extension1 = e69xe_b_m;
	e69xx_m_b[0].extension1 = e69xe_m_b;
	e69xx_m_m[0].extension1 = e69xe_m_m;
	e6axx_b_b[0].extension1 = e6axe_b_b;
	e6axx_b_m[0].extension1 = e6axe_b_m;
	e6axx_m_b[0].extension1 = e6axe_m_b;
	e6axx_m_m[0].extension1 = e6axe_m_m;
	e6bxx_b_b[0].extension1 = e6bxe_b_b;
	e6bxx_b_m[0].extension1 = e6bxe_b_m;
	e6bxx_m_b[0].extension1 = e6bxe_m_b;
	e6bxx_m_m[0].extension1 = e6bxe_m_m;
	e6dxx_b_b[0].extension1 = e6dxe_b_b;
	e6dxx_b_b[0].extension2 = rank_none;
	e6dxx_b_m[0].extension1 = e6dxe_b_m;
	e6dxx_b_r[0].extension1 = e6dxe_b_r;
	e6dxx_m_b[0].extension1 = e6dxe_m_b;
	e6dxx_m_m[0].extension1 = e6dxe_m_m;
	e6dxx_m_m[0].extension2 = rank_none;
	e6dxx_m_r[0].extension1 = e6dxe_m_r;
	e6dxx_r_b[0].extension1 = e6dxe_r_b;
	e6dxx_r_m[0].extension1 = e6dxe_r_m;
	e6dxx_r_r[0].extension1 = e6dxe_r_r;
	e6dxx_r_r[0].extension2 = rank_none;
	e70xx_b_b[0].extension1 = e70xe_b_b;
	e70xx_b_m[0].extension1 = e70xe_b_m;
	e70xx_b_r[0].extension1 = e70xe_b_r;
	e70xx_m_b[0].extension1 = e70xe_m_b;
	e70xx_m_m[0].extension1 = e70xe_m_m;
	e70xx_m_r[0].extension1 = e70xe_m_r;
	e70xx_r_b[0].extension1 = e70xe_r_b;
	e70xx_r_m[0].extension1 = e70xe_r_m;
	e70xx_r_r[0].extension1 = e70xe_r_r;
	e71xx_b_b[0].extension1 = e71xe_b_b;
	e71xx_b_m[0].extension1 = e71xe_b_m;
	e71xx_b_r[0].extension1 = e71xe_b_r;
	e71xx_m_b[0].extension1 = e71xe_m_b;
	e71xx_m_m[0].extension1 = e71xe_m_m;
	e71xx_m_r[0].extension1 = e71xe_m_r;
	e71xx_r_b[0].extension1 = e71xe_r_b;
	e71xx_r_m[0].extension1 = e71xe_r_m;
	e71xx_r_r[0].extension1 = e71xe_r_r;
	e73xx_b_b[0].extension1 = e73xe_b_b;
	e73xx_b_m[0].extension1 = e73xe_b_m;
	e73xx_b_r[0].extension1 = e73xe_b_r;
	e73xx_m_b[0].extension1 = e73xe_m_b;
	e73xx_m_m[0].extension1 = e73xe_m_m;
	e73xx_m_r[0].extension1 = e73xe_m_r;
	e73xx_r_b[0].extension1 = e73xe_r_b;
	e73xx_r_m[0].extension1 = e73xe_r_m;
	e73xx_r_r[0].extension1 = e73xe_r_r;
	e74xx_b_b[0].extension1 = e74xe_b_b;
	e74xx_b_m[0].extension1 = e74xe_b_m;
	e74xx_m_b[0].extension1 = e74xe_m_b;
	e74xx_m_m[0].extension1 = e74xe_m_m;
	e75xx_b_b[0].extension1 = e75xe_b_b;
	e75xx_b_m[0].extension1 = e75xe_b_m;
	e75xx_m_b[0].extension1 = e75xe_m_b;
	e75xx_m_m[0].extension1 = e75xe_m_m;
	e77xx_b_b[0].extension1 = e77xe_b_b;
	e77xx_b_b[0].extension2 = rank_none;
	e77xx_b_m[0].extension1 = e77xe_b_m;
	e77xx_m_b[0].extension1 = e77xe_m_b;
	e77xx_m_m[0].extension1 = e77xe_m_m;
	e77xx_m_m[0].extension2 = rank_none;
	e78xx_b_b[0].extension1 = e78xe_b_b;
	e78xx_b_b[0].extension2 = rank_none;
	e78xx_b_m[0].extension1 = e78xe_b_m;
	e78xx_m_b[0].extension1 = e78xe_m_b;
	e78xx_m_m[0].extension1 = e78xe_m_m;
	e78xx_m_m[0].extension2 = rank_none;
	e79xx_b_b[0].extension1 = e79xe_b_b;
	e79xx_b_b[0].extension2 = rank_none;
	e79xx_b_m[0].extension1 = e79xe_b_m;
	e79xx_m_b[0].extension1 = e79xe_m_b;
	e79xx_m_m[0].extension1 = e79xe_m_m;
	e79xx_m_m[0].extension2 = rank_none;

	link_2 = 0;
    }

    *e4_2_arithmetics = _x1f4_e4_2_arithmetics;
}
