/*
 * e2list.h
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e2list_H__
#define __LIBx1f4_e2list_H__

#include <e4line.h>

/*
 * error definitions
 */
#define X1f4_E2LIST_CALL_ERROR		-1
#define X1f4_E2LIST_FREE_ERROR		-2
#define X1f4_E2LIST_LINK_ERROR		-3
#define X1f4_E2LIST_MODE_ERROR		-4

/*
 * generation flag definitions
 */
#define X1f4_E2LIST_FLATLINE		(1L << 0)
#define X1f4_E2LIST_MISSLINK		(1L << 1)
#define X1f4_E2LIST_RESOURCE		(1L << 2)

typedef struct x1f4_e2list_type {
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } misslink_set;
    struct {
	int *class;
    } flatline_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
} x1f4_e2list_type;

extern int x1f4_deck_e2list
    (void **);
extern int x1f4_fini_e2list
    (void **, void *);
extern int x1f4_free_e2list
    (void *, void *);
extern int x1f4_init_e2list
    (void **, unsigned, struct x1f4_e2list_type *);
extern int x1f4_line_e2list
    (void **, void *);
extern int x1f4_link_e2list
    (void *, void **, unsigned);
extern int x1f4_mode_e2list
    (void *, void **, unsigned);
extern int x1f4_pick_e2list
    (void *, void *, int (*) (void *), unsigned, void **);
extern int x1f4_slip_e2list
    (void *, void *, void *, int (*) (void *));
extern int x1f4_swap_e2list
    (void *, void *);
extern int x1f4_type_e2list
    (struct x1f4_e4line_type *);

#endif				/* __LIBx1f4_e2list_H__ */
