/*
 * e2list.e.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e2list-defs.h>
#include <e2list-types.h>

int
_libx1f4i0_fine_e2list(struct e2list_type *e2list_data)
{
    int (*free) (void *, void *), status = 0;
    struct e2fine_type *e2fine_data, *e2fine_deck;
    void *data;

    data = e2list_data->link_a.data;
    free = e2list_data->link_a.free;

    e2fine_deck = e2list_data->link_i.deck;

    e2fine_data = e2list_data->link_i.fine;
    while (e2fine_data != e2fine_deck) {
	int excess;
	void *fine;

	fine = e2fine_data;
	e2fine_data = e2fine_data->e2fine_data;
	excess = free(data, fine);
	if (excess) {
	    status = FREE_ERROR;
	}
    }

    return status;
}
