/*
 * e2list.9.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e2list-inter.h>
#include <e2list-types.h>

#define __not_set_by_link__		0

#define e2list(delete) \
    ((struct e2list_type *) (delete))

int
x1f4_pick_e2list(void *e2list, void ***text, int (*miss) (void *),
		 unsigned size, void **link)
{
    int status;
    unsigned deck, flow;
    void *data;

    deck = sizeof(struct e2text_type);
    deck += (16 - (deck & 15)) & 15;

    flow = size + deck;

    status = x1f4_link_e2list(e2list, &data, flow);
    if (status) {
    } else {
	struct e2text_type *e2text_data, *list_e2text;

	e2text_data = data;

	list_e2text = e2list(e2list)->link_c.list;
	e2list(e2list)->link_c.list = e2text_data;

	e2text_data->next_e2text = list_e2text;

	e2text_data->miss = miss;

	*text = &e2text_data->text;

	if (link) {
	    *link = (void *) ((char *) e2text_data + deck);
	}

	if (__not_set_by_link__) {
	    int *class;

	    class = e2list(e2list)->link_l.class;
	    if (class) {
		*class = 1;
	    }
	}
    }

    return status;
}
