/*
 * e2list.8.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e2list-types.h>

#define e2list(delete) \
    ((struct e2list_type *) (delete))

int
x1f4_slip_e2list(void *e2list, void *data, void *text, int (*miss) (void *))
{
    int status;

    if (data) {
	struct e2text_type *e2text_data;
	unsigned deck;

	status = 0;

	deck = sizeof(struct e2text_type);
	deck += (16 - (deck & 15)) & 15;
	e2text_data = (void *) ((char *) data - deck);

	e2text_data->miss = NULL;
    } else {
	struct e2text_type *e2text_data;

	status = 1;

	e2text_data = e2list(e2list)->link_c.list;
	while (e2text_data) {
	    if (e2text_data->text == text && e2text_data->miss == miss) {
		e2text_data->miss = NULL;

		status = 0;

		if (1) {
		    break;
		}
	    } else {
		e2text_data = e2text_data->next_e2text;
	    }
	}
    }

    return status;
}
