/*
 * e2list.6.c
 * Copyright (C) 2008-2009, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e2list-defs.h>
#include <e2list-types.h>

#define e2list(delete) \
    ((struct e2list_type *) (delete))

static int link_list(void *, void **, unsigned);

static int
link_list(void *e2list, void **link, unsigned size)
{
    int status;
    unsigned deck, flow;
    void *data;

    deck = sizeof(struct e2node_type);
    deck += (16 - (deck & 15)) & 15;

    flow = size + deck;

    status = e2list(e2list)->link_a.link
	(e2list(e2list)->link_a.data, &data, flow);
    if (status) {
    } else {
	struct e2node_type *e2node_data, *list_e2node;

	e2node_data = data;

	list_e2node = e2list(e2list)->link_e.list;
	e2list(e2list)->link_e.list = e2node_data;

	e2node_data->next_e2node = list_e2node;

	e2node_data->size = size;

	*link = (void *) ((char *) e2node_data + deck);

	if (1) {
	    int *class;

	    class = e2list(e2list)->link_l.class;
	    if (class) {
		*class = 1;
	    }
	}
    }

    return status;
}


int
x1f4_link_e2list(void *e2list, void **link, unsigned size)
{
    int status;
    unsigned deck, flow, slip;

    deck = sizeof(struct e2node_type);
    deck += (16 - (deck & 15)) & 15;

    flow = size + deck;

    slip = e2list(e2list)->link_i.slip;

    if (LINK_SIZE < flow || !~slip) {
	status = link_list(e2list, link, size);
    } else {
	do {
	    struct e2node_type *e2node_data;
	    void *fine;

	    fine = e2list(e2list)->link_i.fine;

	    if (FINE_SIZE < slip + flow) {
		void *land;

		status = e2list(e2list)->link_a.link
		    (e2list(e2list)->link_a.data, &land, FINE_SIZE);
		if (status) {
		    break;
		} else {
		    slip = sizeof(struct e2fine_type);
		    slip += (16 - (slip & 15)) & 15;

		    e2list(e2list)->link_i.fine = land;

		    ((struct e2fine_type *) land)->e2fine_data = fine;

		    fine = land;
		}
	    } else {
		status = 0;
	    }

	    e2node_data = (void *) ((char *) fine + slip);

	    e2node_data->size = size;

	    *link = (char *) e2node_data + deck;

	    flow += (16 - (flow & 15)) & 15;

	    e2list(e2list)->link_i.slip = slip + flow;

	    if (1) {
		int *class;

		class = e2list(e2list)->link_l.class;
		if (class) {
		    *class = 1;
		}
	    }
	} while (0);
    }

    return status;
}
