/*
 * e2list.4.c
 * Copyright (C) 2008-2011, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e2list-types.h>

int
x1f4_swap_e2list(void *c1st, void *c2nd)
{
    struct e2list_type e2list_class, *e2list_dana, *e2list_intl;

    e2list_dana = c1st;
    e2list_intl = c2nd;

    e2list_class.link_c = e2list_dana->link_c;
    e2list_dana->link_c = e2list_intl->link_c;
    e2list_intl->link_c = e2list_class.link_c;

    e2list_class.link_e = e2list_dana->link_e;
    e2list_dana->link_e = e2list_intl->link_e;
    e2list_intl->link_e = e2list_class.link_e;

    e2list_class.link_l = e2list_dana->link_l;
    e2list_dana->link_l = e2list_intl->link_l;
    e2list_intl->link_l = e2list_class.link_l;

    if (e2list_dana->link_i.fine) {
	unsigned slip;

	e2list_class.link_i = e2list_dana->link_i;

	e2list_dana->link_i.fine = e2list_intl->link_i.fine;
	e2list_dana->link_i.hold = e2list_intl->link_i.deck;

	slip = e2list_intl->link_i.call;

	e2list_intl->link_i = e2list_class.link_i;

	e2list_intl->link_i.slip = slip;

	if (1) {
	    int *class;

	    class = e2list_class.link_l.class;
	    if (class) {
		if (e2list_class.link_e.list) {
		    *class = 1;
		} else {
		    if (e2list_class.link_c.list) {
			*class = 1;
		    } else {
			if (e2list_intl->link_i.slip
			    != e2list_intl->link_i.call) {
			    *class = 1;
			} else {
			    if (e2list_intl->link_i.fine
				!= e2list_intl->link_i.deck) {
				*class = 1;
			    } else {
				*class = 0;
			    }
			}
		    }
		}
	    }
	}
    } else {
	e2list_dana->link_i = e2list_intl->link_i;

	e2list_intl->link_i.call = e2list_intl->link_i.slip;
	e2list_intl->link_i.deck = e2list_intl->link_i.fine;
	e2list_intl->link_i.hold = e2list_intl->link_i.fine;

	e2list_dana->link_i.slip = ~0;
    }

    return 0;
}
