/*
 * e2list.2.c
 * Copyright (C) 2008-2009, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e2list-defs.h>
#include <e2list-inter.h>
#include <e2list-types.h>

#define e2line(delete) \
    ((struct e2line_type *) (delete))

int
x1f4_line_e2list(void **e2list, void *line, int fine)
{
    unsigned bits;

    bits = e2line(line)->bits;
    if (fine) {
	bits |= SCHEDULE_FINE;
    }

    return x1f4_init_e2list(e2list, bits, &e2line(line)->screen);
}
